/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseInputLatch;
import com.mathworks.widgets.desk.DTDragUtilities;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DeferredRunnable;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class DTDragDetector
extends MouseInputLatch {
    protected String fHint;
    protected WeakReference<DTFrame> fHintFrame;
    protected MouseEvent fPressedEvent;
    protected Rectangle fStartRect;
    protected boolean fIsIn;
    protected Object fLoad;
    protected Dimension fDragThreshold = DEFAULT_THRESHOLD;
    private DeferredDragStarter fDeferredDragStarter;
    static final Dimension DEFAULT_THRESHOLD = new Dimension(12, 8);

    public DTDragDetector() {
        super(null);
        this.fWrappedListener = new WrappedListener();
    }

    protected void showHint(MouseEvent mouseEvent) {
        DTFrame dTFrame;
        String string = this.getHint(mouseEvent);
        if (string != null && (dTFrame = DTFrame.getFrame(mouseEvent)) != null) {
            DTDragUtilities.showHint(dTFrame, string);
            this.fHint = string;
            this.fHintFrame = new WeakReference<DTFrame>(dTFrame);
        }
    }

    protected String getHint(MouseEvent mouseEvent) {
        Object object = this.fLoad == null ? this.getLoad(mouseEvent) : this.fLoad;
        return DTDragUtilities.getToMoveThis(object);
    }

    protected void startDrag(MouseEvent mouseEvent) {
    }

    protected void clearHint() {
        if (this.fHint != null && this.fHintFrame != null) {
            DTDragUtilities.showHint((DTFrame)this.fHintFrame.get(), null);
            this.fHint = null;
            this.fHintFrame = null;
        }
    }

    protected Object getLoad(MouseEvent mouseEvent) {
        return null;
    }

    class DeferredDragStarter
    extends DeferredRunnable {
        MouseEvent fStartingEvent;
        boolean fCanceled;

        DeferredDragStarter(MouseEvent mouseEvent) {
            Window window;
            super(4);
            this.fStartingEvent = mouseEvent;
            if (!DTDragUtilities.isDraggingWithKeys()) {
                DTDragDetector.this.clearHint();
            }
            if (GlobalCursor.get((Window)(window = SwingUtilities.windowForComponent(this.fStartingEvent.getComponent()))) == null) {
                GlobalCursor.set((Window)window, (Cursor)Cursor.getDefaultCursor());
            }
        }

        void cancel() {
            this.fCanceled = true;
        }

        @Override
        public void run() {
            if (!this.fCanceled) {
                super.run();
            }
        }

        @Override
        public void doTask() {
            DTDragDetector.this.fDeferredDragStarter = null;
            DTDragDetector.this.startDrag(this.fStartingEvent);
        }
    }

    private class WrappedListener
    extends MouseInputAdapter {
        private WrappedListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DTFrame dTFrame;
            if (mouseEvent.isPopupTrigger() || MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                DTDragDetector.this.clearHint();
                return;
            }
            DTDragDetector.this.fPressedEvent = mouseEvent;
            DTDragDetector.this.fLoad = DTDragDetector.this.getLoad(mouseEvent);
            Point point = mouseEvent.getPoint();
            DTDragDetector.this.fStartRect = new Rectangle(point.x - DTDragDetector.this.fDragThreshold.width, point.y - DTDragDetector.this.fDragThreshold.height, DTDragDetector.this.fDragThreshold.width << 1, DTDragDetector.this.fDragThreshold.height << 1);
            if (!DTDragUtilities.isDraggingWithKeys() && (dTFrame = DTFrame.getFrame(mouseEvent)) != null) {
                DTDragDetector.this.fHint = dTFrame.getDesktop().getString("status.BeginDrag");
                DTDragDetector.this.fHintFrame = new WeakReference<DTFrame>(dTFrame);
                DTDragUtilities.showHint(dTFrame, DTDragDetector.this.fHint);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Window window;
            if (mouseEvent.isPopupTrigger() || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (DTDragDetector.this.fDeferredDragStarter != null) {
                DTDragDetector.this.fDeferredDragStarter.cancel();
            }
            if (DTDragDetector.this.fStartRect == null && (window = SwingUtilities.windowForComponent(mouseEvent.getComponent())) != null) {
                GlobalCursor.clear((Window)window);
            }
            DTDragDetector.this.fDeferredDragStarter = null;
            DTDragDetector.this.clearHint();
            DTDragDetector.this.fPressedEvent = null;
            DTDragDetector.this.fStartRect = null;
            DTDragDetector.this.fLoad = null;
            if (DTDragDetector.this.fIsIn) {
                DTDragDetector.this.showHint(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            DTDragDetector.this.fIsIn = true;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) && !SwingUtilities.isRightMouseButton(mouseEvent)) {
                DTDragDetector.this.showHint(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            DTDragDetector.this.clearHint();
            DTDragDetector.this.fIsIn = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (DTDragDetector.this.fStartRect != null && !DTDragDetector.this.fStartRect.contains(mouseEvent.getPoint())) {
                DTDragDetector.this.fStartRect = null;
                DTDragDetector.this.fDeferredDragStarter = new DeferredDragStarter(mouseEvent);
                SwingUtilities.invokeLater(DTDragDetector.this.fDeferredDragStarter);
            }
        }
    }
}

