/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.datamodel;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.LineBreak;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.SyntaxTextPaneUtilities;
import com.mathworks.widgets.WidgetUtils;
import com.mathworks.widgets.datamodel.AbstractBackingStore;
import com.mathworks.widgets.datamodel.DialogProvider;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.EditorLanguageUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.PlainDocument;
import org.apache.commons.io.IOUtils;

public class TextFileBackingStore
extends AbstractBackingStore<Document> {
    private File fFile;
    private final File fDefaultDirectoryAtTimeOfCreation = TextFileBackingStore.getApplicationDefaultDirectory();
    private StorageLocation fStorageLocation;
    private String fPreferredContentType;
    private Charset fFileEncoding;
    private String fLastFileHash;
    private DefaultFileNameProvider fDefaultFileNameProvider = new EmptyDefaultFileNameProvider();
    private SaveInterceptor fSaveInterceptor = new AlwaysSaveInterceptor();
    private FileChooserSetupDelegate fFileChooserSetupDelegate = new EmptyFileChooserSetupDelegate();
    private EncodingProvider fEncodingProvider = new DefaultEncodingProvider();
    private DialogProvider fDialogProvider = new DefaultDialogProvider();
    public static final String FILE_ENCODING = "fileEncoding";
    public static final String SAVE_DIALOG_TITLE = WidgetUtils.lookup("backingStore.Save");
    public static final String SAVE_AS_DIALOG_TITLE = WidgetUtils.lookup("backingStore.SaveAs");
    public static final String BACKUP_DIALOG_TITLE = WidgetUtils.lookup("backingStore.Backup");

    private TextFileBackingStore(Charset charset) {
        this.init(null, charset);
    }

    private TextFileBackingStore(File file, Charset charset) {
        TextFileBackingStore.checkFileNotNull(file);
        TextFileBackingStore.checkFileExists(file);
        this.init(file, charset);
    }

    private void init(File file, Charset charset) {
        TextFileBackingStore.checkFileEncoding(charset);
        this.fFileEncoding = charset;
        this.doSetFile(file);
    }

    public static TextFileBackingStore createWithNoBackingFile() {
        return new TextFileBackingStore(SyntaxTextPaneUtilities.getDefaultFileEncoding());
    }

    public static TextFileBackingStore createWithNoBackingFile(Charset charset) {
        return new TextFileBackingStore(charset);
    }

    public static TextFileBackingStore createWithExistentBackingFile(File file) {
        return new TextFileBackingStore(file, SyntaxTextPaneUtilities.getDefaultFileEncoding(file));
    }

    public static TextFileBackingStore createWithExistentBackingFile(File file, Charset charset) {
        return new TextFileBackingStore(file, charset);
    }

    private boolean isLastLoadedFileContentDifferentThanOnDiskFileContent() {
        assert (this.isPersistenceLocationSet()) : "This method cannot be called before load has been called on the backing store.";
        try {
            return !FileUtils.generateFileHash((File)this.getFile()).equals(this.fLastFileHash);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static void checkFileNotNull(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null.");
        }
    }

    private static void checkFileExists(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("TextFileBackingStore cannot be created with a non-existent file.");
        }
    }

    private static void checkFileEncoding(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("File encoding cannot be null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDocumentFromFile(Document document, File file, Charset charset) throws IOException, BadLocationException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            PlainDocument plainDocument = new PlainDocument();
            DefaultEditorKit defaultEditorKit = new DefaultEditorKit();
            ((EditorKit)defaultEditorKit).read(inputStreamReader, (Document)plainDocument, 0);
            String string = plainDocument.getText(0, plainDocument.getLength());
            document.insertString(0, string, null);
            LineBreak lineBreak = string == null || string.length() == 0 ? LineBreak.getPlatformPreferred() : DocumentUtils.getLineEndingStyle(plainDocument);
            DocumentUtils.setLineEndingStyle(document, lineBreak);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)inputStreamReader);
    }

    private SaveResult saveToFile(Document document, File file, boolean bl, DialogInfoUserInteractionModel dialogInfoUserInteractionModel) throws Exception {
        boolean bl2;
        if (file == null) {
            return SaveResult.CANCELED;
        }
        boolean bl3 = this.fFile == null ? false : (bl2 = FileUtils.areFilesTheSame((File)file, (File)this.fFile) && this.fFile.exists());
        if (bl2 || this.fSaveInterceptor.saveAsAboutToHappen(this.fFile, file, dialogInfoUserInteractionModel)) {
            if (TextFileBackingStore.isReadOnly(file) && dialogInfoUserInteractionModel.areDialogsAllowed()) {
                Dialogs.Option option = this.fDialogProvider.showOverwriteSaveAsCancel(dialogInfoUserInteractionModel.getComponentForDialog(), file, dialogInfoUserInteractionModel.getTitleForDialog());
                if (option == Dialogs.Option.OVERWRITE) {
                    FileUtils.makeFileWriteableStrict((File)file);
                } else {
                    if (option == Dialogs.Option.SAVE_AS) {
                        return SaveResult.SELECT_AGAIN;
                    }
                    return SaveResult.CANCELED;
                }
            }
            if (this.writeToFile(document, file, bl, dialogInfoUserInteractionModel)) {
                if (bl && !bl2) {
                    this.setFile(file);
                }
                if (bl || bl2) {
                    this.sync();
                }
                return bl2 ? SaveResult.SAVED_TO_EXISTING_LOCATION : SaveResult.SAVED_TO_NEW_LOCATION;
            }
        }
        return SaveResult.CANCELED;
    }

    private boolean writeToFile(Document document, File file, boolean bl, AbstractBackingStore.UserInteractionModel userInteractionModel) throws IOException {
        boolean bl2 = this.fSaveInterceptor.saveAboutToHappen(file, userInteractionModel);
        if (bl2) {
            Charset charset = this.fEncodingProvider.getEncoding(this.getFileEncoding());
            FileUtils.write((Document)document, (File)file, (Charset)charset);
            if (bl) {
                this.setFileEncoding(charset);
            }
        }
        return bl2;
    }

    private static boolean isReadOnly(File file) {
        return file.exists() && !file.canWrite();
    }

    @Override
    protected void doLoad(Document document) throws IOException, BadLocationException {
        TextFileBackingStore.loadDocumentFromFile(document, this.getFile(), this.getFileEncoding());
        this.sync();
    }

    public StorageLocation getStorageLocation() {
        return this.fStorageLocation;
    }

    public String getPreferredContentType(String string) {
        return this.fPreferredContentType == null ? string : this.fPreferredContentType;
    }

    public boolean isPersistenceLocationSet() {
        return this.getFile() != null;
    }

    public boolean isReadOnly() {
        this.checkPersistenceLocationSet();
        return TextFileBackingStore.isReadOnly(this.getFile());
    }

    public boolean isOutOfSync() {
        this.checkPersistenceLocationSet();
        return this.getFile().length() > 0L && this.isLastLoadedFileContentDifferentThanOnDiskFileContent();
    }

    public void sync() {
        try {
            this.fLastFileHash = this.fFile == null ? null : FileUtils.generateFileHash((File)this.fFile);
        }
        catch (IOException iOException) {
            this.fLastFileHash = null;
        }
    }

    @Override
    protected boolean doNegotiateSave(Document document, Component component) throws Exception {
        return !this.isPersistenceLocationSet() ? this.doNegotiateSaveAs(document, component) : this.doSaveToFileAndUpdateBackingStore(document, this.getFile(), new DialogInteractionModel(component, SAVE_DIALOG_TITLE));
    }

    @Override
    protected boolean doSave(Document document) throws Exception {
        this.checkPersistenceLocationSet();
        return this.doSaveToFileAndUpdateBackingStore(document, this.getFile(), new ExceptionInteractionModel());
    }

    @Override
    protected boolean doNegotiateSaveAs(Document document, Component component) throws Exception {
        File file = this.fDialogProvider.selectFile(component, SAVE_AS_DIALOG_TITLE);
        return this.doSaveToFileAndUpdateBackingStore(document, file, new DialogInteractionModel(component, SAVE_AS_DIALOG_TITLE));
    }

    public void doSaveAs(Document document, File file) throws Exception {
        this.notifyListenersIfSaved(this.doSaveToFileAndUpdateBackingStore(document, file, new ExceptionInteractionModel()));
    }

    private boolean doSaveToFileAndUpdateBackingStore(Document document, File file, DialogInfoUserInteractionModel dialogInfoUserInteractionModel) throws Exception {
        SaveResult saveResult = this.saveToFile(document, file, true, dialogInfoUserInteractionModel);
        if (saveResult == SaveResult.SELECT_AGAIN) {
            assert (dialogInfoUserInteractionModel.areDialogsAllowed()) : "Should not have received result of 'Select File Again' if dialogs are not allowed";
            return this.doNegotiateSaveAs(document, dialogInfoUserInteractionModel.getComponentForDialog());
        }
        return saveResult != SaveResult.CANCELED;
    }

    @Override
    protected AbstractBackingStore.BackupResult doNegotiateBackup(Document document, Component component) throws Exception {
        File file = this.fDialogProvider.selectFile(component, BACKUP_DIALOG_TITLE);
        SaveResult saveResult = this.saveToFile(document, file, false, new DialogInteractionModel(component, BACKUP_DIALOG_TITLE));
        switch (saveResult) {
            case SELECT_AGAIN: {
                return this.doNegotiateBackup(document, component);
            }
            case SAVED_TO_EXISTING_LOCATION: {
                return AbstractBackingStore.BackupResult.SAVED_TO_EXISTING_LOCATION;
            }
            case SAVED_TO_NEW_LOCATION: {
                return AbstractBackingStore.BackupResult.SAVED_TO_NEW_LOCATION;
            }
        }
        return AbstractBackingStore.BackupResult.CANCELED;
    }

    public Charset getFileEncoding() {
        return this.fFileEncoding;
    }

    public void setFileEncoding(Charset charset) {
        TextFileBackingStore.checkFileEncoding(charset);
        Charset charset2 = this.fFileEncoding;
        this.fFileEncoding = charset;
        this.firePropertyChange(FILE_ENCODING, charset2, this.fFileEncoding);
    }

    public File getFile() {
        return this.fFile;
    }

    public void setFile(File file) {
        File file2 = this.fFile;
        this.doSetFile(file);
        this.firePropertyChange("backingData", file2 == null ? BACKING_DATA_EMPTY_VALUE : file2.getAbsolutePath(), this.fFile == null ? BACKING_DATA_EMPTY_VALUE : this.fFile.getAbsolutePath());
    }

    private void doSetFile(File file) {
        this.fFile = file;
        this.fStorageLocation = file == null ? new FutureFileStorageLocation() : new FileStorageLocation(this.fFile);
        this.fPreferredContentType = file == null ? this.fPreferredContentType : EditorLanguageUtils.getMimeTypeFromFilename(this.getFile().getName());
    }

    public void setDefaultFileNameProvider(DefaultFileNameProvider defaultFileNameProvider) {
        if (defaultFileNameProvider == null) {
            throw new IllegalArgumentException("DefaultFileNameProvider cannot be null.");
        }
        this.fDefaultFileNameProvider = defaultFileNameProvider;
    }

    public void setSaveInterceptor(SaveInterceptor saveInterceptor) {
        if (saveInterceptor == null) {
            throw new IllegalArgumentException("SaveInterceptor cannot be null.");
        }
        this.fSaveInterceptor = saveInterceptor;
    }

    public File getDefaultDirectoryLocationAtTimeOfCreation() {
        return this.fDefaultDirectoryAtTimeOfCreation;
    }

    public void setFileChooserSetupDelegate(FileChooserSetupDelegate fileChooserSetupDelegate) {
        if (fileChooserSetupDelegate == null) {
            throw new IllegalArgumentException("FileChooserSetupDelegate cannot be null.");
        }
        this.fFileChooserSetupDelegate = fileChooserSetupDelegate;
    }

    public void setEncodingProvider(EncodingProvider encodingProvider) {
        if (encodingProvider == null) {
            throw new IllegalArgumentException("EncodingProvider cannot be null.");
        }
        this.fEncodingProvider = encodingProvider;
    }

    public static File getApplicationDefaultDirectory() {
        String string = FactoryUtils.getDirectorySeed();
        assert (string != null) : "Default save directory cannot be null.";
        File file = new File(string);
        assert (file.isDirectory()) : "\"" + file.getAbsolutePath() + "\" is not a directory.";
        return file;
    }

    private String getLastFileHash() {
        return this.fLastFileHash;
    }

    public void setDialogProvider(DialogProvider dialogProvider) {
        this.fDialogProvider = dialogProvider;
    }

    private static class ExceptionInteractionModel
    implements DialogInfoUserInteractionModel {
        private ExceptionInteractionModel() {
        }

        @Override
        public boolean areDialogsAllowed() {
            return false;
        }

        @Override
        public void communicateError(String string, String string2) {
            throw new RuntimeException(string);
        }

        @Override
        public Component getComponentForDialog() {
            throw new UnsupportedOperationException("Method not supported for ExceptionInteractionModel");
        }

        @Override
        public String getTitleForDialog() {
            throw new UnsupportedOperationException("Method not supported for ExceptionInteractionModel");
        }
    }

    private static class DialogInteractionModel
    implements DialogInfoUserInteractionModel {
        private Component fParentComponent;
        private String fTitle;

        DialogInteractionModel(Component component, String string) {
            assert (component != null);
            assert (string != null);
            this.fParentComponent = component;
            this.fTitle = string;
        }

        @Override
        public boolean areDialogsAllowed() {
            return true;
        }

        @Override
        public void communicateError(String string, String string2) {
            MJOptionPane.showMessageDialog((Component)this.getComponentForDialog(), (Object)string, (String)string2, (int)0);
        }

        @Override
        public Component getComponentForDialog() {
            return this.fParentComponent;
        }

        @Override
        public String getTitleForDialog() {
            return this.fTitle;
        }
    }

    private static interface DialogInfoUserInteractionModel
    extends AbstractBackingStore.UserInteractionModel {
        public String getTitleForDialog();

        public Component getComponentForDialog();
    }

    private static class DefaultEncodingProvider
    implements EncodingProvider {
        private DefaultEncodingProvider() {
        }

        @Override
        public Charset getEncoding(Charset charset) {
            return charset;
        }
    }

    public static interface EncodingProvider {
        public Charset getEncoding(Charset var1);
    }

    private static class EmptyFileChooserSetupDelegate
    implements FileChooserSetupDelegate {
        private EmptyFileChooserSetupDelegate() {
        }

        @Override
        public void setupFileChooser(MJFileChooserPerPlatform mJFileChooserPerPlatform) {
        }
    }

    public static interface FileChooserSetupDelegate {
        public void setupFileChooser(MJFileChooserPerPlatform var1);
    }

    private class DefaultDialogProvider
    implements DialogProvider {
        private DefaultDialogProvider() {
        }

        @Override
        public File selectFile(Component component, String string) {
            MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
            mJFileChooserPerPlatform.setCurrentDirectory(TextFileBackingStore.this.isPersistenceLocationSet() ? TextFileBackingStore.this.getFile() : TextFileBackingStore.getApplicationDefaultDirectory());
            mJFileChooserPerPlatform.setSelectedFile(TextFileBackingStore.this.isPersistenceLocationSet() ? TextFileBackingStore.this.getFile() : new File(TextFileBackingStore.this.fDefaultFileNameProvider.getDefaultFileName()));
            TextFileBackingStore.this.fFileChooserSetupDelegate.setupFileChooser(mJFileChooserPerPlatform);
            mJFileChooserPerPlatform.setDialogTitle(string);
            mJFileChooserPerPlatform.showSaveDialog(component);
            if (mJFileChooserPerPlatform.getState() == 0) {
                return TextFileBackingStore.this.fSaveInterceptor.possiblyModifyFileToSaveAsTo(mJFileChooserPerPlatform.getSelectedFile());
            }
            return null;
        }

        @Override
        public Dialogs.Option showOverwriteSaveAsCancel(Component component, File file, String string) {
            return Dialogs.showOverwriteSaveAsCancel(component, file.getName(), string);
        }
    }

    private static class AlwaysSaveInterceptor
    implements SaveInterceptor {
        private AlwaysSaveInterceptor() {
        }

        @Override
        public boolean saveAboutToHappen(File file, AbstractBackingStore.UserInteractionModel userInteractionModel) {
            return true;
        }

        @Override
        public boolean saveAsAboutToHappen(File file, File file2, AbstractBackingStore.UserInteractionModel userInteractionModel) {
            return true;
        }

        @Override
        public File possiblyModifyFileToSaveAsTo(File file) {
            return file;
        }
    }

    public static interface SaveInterceptor {
        public boolean saveAboutToHappen(File var1, AbstractBackingStore.UserInteractionModel var2);

        public boolean saveAsAboutToHappen(File var1, File var2, AbstractBackingStore.UserInteractionModel var3);

        public File possiblyModifyFileToSaveAsTo(File var1);
    }

    private static class EmptyDefaultFileNameProvider
    implements DefaultFileNameProvider {
        private EmptyDefaultFileNameProvider() {
        }

        @Override
        public String getDefaultFileName() {
            return "";
        }
    }

    public static interface DefaultFileNameProvider {
        public String getDefaultFileName();
    }

    private static enum SaveResult {
        SAVED_TO_EXISTING_LOCATION,
        SAVED_TO_NEW_LOCATION,
        CANCELED,
        SELECT_AGAIN;

    }
}

