/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.matlab.api.editor.EditorSyntaxHighlighting;
import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.cplusplus.CAndCPlusPlusSyntaxHighlighting;
import com.mathworks.widgets.text.java.JavaSyntaxHighlighting;
import com.mathworks.widgets.text.mcode.MSyntaxFactory;
import com.mathworks.widgets.text.mcode.MSyntaxHighlighting;
import com.mathworks.widgets.text.xml.XMLSyntaxHighlighting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.plain.PlainSyntax;
import org.netbeans.modules.cnd.editor.cplusplus.CCSyntax;
import org.netbeans.modules.xml.text.syntax.XMLDefaultSyntax;

public class TokenizerFactory {
    private static final List<EditorSyntaxHighlighting> sSyntaxHighlightings = Arrays.asList(MSyntaxHighlighting.INSTANCE, JavaSyntaxHighlighting.INSTANCE, CAndCPlusPlusSyntaxHighlighting.INSTANCE, XMLSyntaxHighlighting.INSTANCE);
    private static Tokenizer sJavaTokenizer = null;
    private static Tokenizer sMatlabTokenizer = null;
    private static Tokenizer sCTokenizer = null;
    private static Tokenizer sHTMLTokenizer = null;

    private TokenizerFactory() {
    }

    public static synchronized Tokenizer getTokenizerForKitClass(Class<?> clazz) {
        Validate.notNull(clazz, (String)"'kitClass' cannot be null");
        for (EditorSyntaxHighlighting editorSyntaxHighlighting : sSyntaxHighlightings) {
            if (!editorSyntaxHighlighting.getBaseKitClass().isAssignableFrom(clazz)) continue;
            return TokenizerFactory.getTokenizer(editorSyntaxHighlighting);
        }
        return TokenizerFactory.getPlainTokenizer();
    }

    public static synchronized Tokenizer getTokenizer(EditorSyntaxHighlighting editorSyntaxHighlighting) {
        Validate.notNull((Object)editorSyntaxHighlighting, (String)"'highlighting' cannot be null");
        MWKit mWKit = (MWKit)((Object)editorSyntaxHighlighting.getLanguage().createDefaultKit());
        return new Tokenizer(editorSyntaxHighlighting.getColors(), mWKit.createSyntax(new PlainDocument()));
    }

    public static synchronized Tokenizer getJavaTokenizer() {
        if (sJavaTokenizer == null) {
            sJavaTokenizer = new Tokenizer(JavaSyntaxHighlighting.INSTANCE.getColors(), (Syntax)new JavaSyntax());
        }
        return sJavaTokenizer;
    }

    public static synchronized Tokenizer getMTokenizer() {
        if (sMatlabTokenizer == null) {
            sMatlabTokenizer = new Tokenizer(MSyntaxHighlighting.INSTANCE.getColors(), MSyntaxFactory.createCommandLineSyntax());
        }
        return sMatlabTokenizer;
    }

    public static synchronized Tokenizer getCTokenizer() {
        if (sCTokenizer == null) {
            sCTokenizer = new Tokenizer(CAndCPlusPlusSyntaxHighlighting.INSTANCE.getColors(), (Syntax)new CCSyntax());
        }
        return sCTokenizer;
    }

    public static synchronized Tokenizer getXMLTokenizer() {
        if (sHTMLTokenizer == null) {
            sHTMLTokenizer = new Tokenizer(XMLSyntaxHighlighting.INSTANCE.getColors(), (Syntax)new XMLDefaultSyntax());
        }
        return sHTMLTokenizer;
    }

    public static Tokenizer getPlainTokenizer() {
        return new Tokenizer(new ArrayList<SyntaxHighlightingColor>(), (Syntax)new PlainSyntax());
    }

    public static Color getColorFromName(String string) {
        EditorSyntaxHighlighting editorSyntaxHighlighting;
        Color color = null;
        Iterator<EditorSyntaxHighlighting> iterator = sSyntaxHighlightings.iterator();
        while (iterator.hasNext() && (color = TokenizerFactory.findColor(string, editorSyntaxHighlighting = iterator.next())) == null) {
        }
        if (color == null) {
            throw new IllegalArgumentException(string + " is not a valid color name");
        }
        return color;
    }

    private static Color findColor(String string, EditorSyntaxHighlighting editorSyntaxHighlighting) {
        for (SyntaxHighlightingColor syntaxHighlightingColor : editorSyntaxHighlighting.getColors()) {
            if (!syntaxHighlightingColor.getPreferenceKey().equals(string)) continue;
            return syntaxHighlightingColor.getCurrentColor();
        }
        return null;
    }
}

