/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.instrcreate;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.InstrumentObjectListener;
import com.mathworks.toolbox.instrument.objectbrowser.InstrumentObjectBrowserClient;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IdentifyPanel
extends JPanel
implements Runnable,
ActionListener,
MatlabListener,
InstrumentObjectListener {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.instrcreate.resources.RES_Instrcreate");
    private JButton identifyButton;
    private JComboBox commands;
    private JTextField result;
    private String identifyCommand = "*IDN?";
    private Instrument currentObject;
    private int numOfObjects;
    private Hashtable<Instrument, String> objectIdentifyCommands = new Hashtable();
    private Hashtable<Instrument, String> objectIdentification = new Hashtable();
    private Matlab matlab = new Matlab();
    private Object[] matlabArgs = new Object[4];

    public IdentifyPanel(int n, Instrument instrument) {
        this.numOfObjects = n;
        this.currentObject = instrument;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.layoutPanel();
        Instrument.addInstrumentObjectListener(this);
        if (this.numOfObjects > 0) {
            this.identifyButton.setEnabled(true);
            this.commands.setEnabled(true);
        }
        this.matlabArgs[0] = "privateInstrcreateHelper";
        this.matlabArgs[1] = "identify";
    }

    public void setup() {
        Instrument.addInstrumentObjectListener(this);
        this.numOfObjects = Instrument.getNonLockedObjects().size();
        this.updateGUIState();
        this.addScanCommands();
        this.identifyCommand = (String)this.commands.getSelectedItem();
        this.result.setText("");
    }

    public void cleanup() {
        Instrument.removeInstrumentObjectListener(this);
    }

    private void layoutPanel() {
        this.add((Component)this.createIdentifyQuestionPanel(), "North");
        this.add((Component)this.createIdentifyResultPanel(), "Center");
    }

    private JPanel createIdentifyQuestionPanel() {
        Serializable serializable;
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel.add(new JLabel(RES.getString("textfield.command"), 2));
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 0));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.identifyButton = new JButton(RES.getString("button.identify"));
        if (!PlatformInfo.isLinux()) {
            this.identifyButton.setPreferredSize(new Dimension(73, 21));
        } else {
            serializable = this.identifyButton.getPreferredSize();
            ((Dimension)serializable).width = 73;
            this.identifyButton.setPreferredSize((Dimension)serializable);
        }
        this.identifyButton.setName("Identify Button");
        jPanel3.add(this.identifyButton);
        jPanel2.add((Component)jPanel3, "East");
        this.identifyButton.addActionListener(this);
        this.identifyButton.setEnabled(false);
        serializable = new JPanel(new GridLayout(1, 1, 0, 0));
        this.commands = new JComboBox();
        this.addScanCommands();
        this.commands.setEditable(true);
        this.commands.setEnabled(false);
        this.commands.setName("Command Combobox");
        this.commands.addActionListener(this);
        this.identifyCommand = (String)this.commands.getSelectedItem();
        ((Container)serializable).add(this.commands);
        jPanel2.add((Component)serializable, "Center");
        return jPanel;
    }

    private JPanel createIdentifyResultPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel2.add(new JLabel(RES.getString("textfield.id"), 2));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.result = new JTextField();
        this.result.setName("Result TextField");
        this.result.setEditable(false);
        this.result.setBackground(jPanel3.getBackground());
        jPanel3.add(this.result);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    private void updateGUIState() {
        if (this.numOfObjects > 0) {
            this.identifyButton.setEnabled(true);
            this.commands.setEnabled(true);
        } else if (this.numOfObjects == 0) {
            this.identifyButton.setEnabled(false);
            this.commands.setEnabled(false);
            this.result.setText("");
        }
    }

    private void addScanCommands() {
        this.commands.removeAllItems();
        Vector vector = (Vector)Instrument.getScanCommands().clone();
        for (int i = 0; i < vector.size(); ++i) {
            this.commands.addItem(vector.elementAt(i));
        }
    }

    private void setTabEnabled(boolean bl) {
        this.identifyButton.setEnabled(bl);
        this.commands.setEnabled(bl);
    }

    private void storeIdentifyCommand() {
        String string = (String)this.commands.getSelectedItem();
        if (string == null) {
            return;
        }
        if (!string.equals(this.identifyCommand)) {
            this.objectIdentifyCommands.remove(this.currentObject);
            this.objectIdentifyCommands.put(this.currentObject, string);
        }
        this.identifyCommand = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JComboBox) {
            this.storeIdentifyCommand();
            return;
        }
        this.storeIdentifyCommand();
        this.result.setText("");
        this.setTabEnabled(false);
        this.matlabArgs[2] = this.currentObject;
        this.matlabArgs[3] = this.commands.getSelectedItem();
        Matlab.whenMatlabReady((Runnable)this);
    }

    @Override
    public void run() {
        try {
            this.matlab.feval("instrgate", this.matlabArgs, 1, (MatlabListener)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void matlabEvent(MatlabEvent matlabEvent) {
        int n = Matlab.getExecutionStatus((int)matlabEvent.getStatus());
        if (n != 0) {
            this.setTabEnabled(true);
            return;
        }
        Object[] objectArray = (Object[])matlabEvent.getResult();
        if (objectArray.length == 1) {
            this.result.setText((String)objectArray[0]);
        } else {
            TMStringUtil.error((String)"Identification Error", (String)((String)objectArray[1]));
        }
        this.objectIdentification.put(this.currentObject, this.result.getText());
        this.setTabEnabled(true);
    }

    public void selectedObjectUpdated(Instrument instrument, InstrumentObjectBrowserClient instrumentObjectBrowserClient) {
        if (instrument == null) {
            this.setTabEnabled(false);
        } else {
            this.setTabEnabled(true);
        }
        if (instrument != null && this.objectIdentification.containsKey(instrument)) {
            this.result.setText(this.objectIdentification.get(instrument));
        } else {
            this.result.setText("");
        }
        this.currentObject = instrument;
        if (this.currentObject == null) {
            return;
        }
        String string = this.objectIdentifyCommands.get(this.currentObject);
        if (string == null) {
            this.commands.setSelectedItem(this.identifyCommand);
        } else {
            this.commands.setSelectedItem(string);
        }
    }

    public void objectVisibilityUpdated(Instrument instrument, InstrumentObjectBrowserClient instrumentObjectBrowserClient) {
        ++this.numOfObjects;
        this.updateGUIState();
    }

    @Override
    public void instrumentObjectAdded(Instrument instrument, String string, String string2) {
        ++this.numOfObjects;
        this.updateGUIState();
    }

    @Override
    public void instrumentObjectDeleted(Instrument instrument, String string, String string2) {
        --this.numOfObjects;
        this.objectIdentifyCommands.remove(instrument);
        this.objectIdentification.remove(instrument);
        this.updateGUIState();
    }
}

