/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.icb;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.icb.ButtonPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class IJFrame
extends MJFrame {
    protected static int sLargeColumnWidth = 12;
    protected static int sSmallColumnWidth = 6;
    private static final String sSupportFunctionName = "icbgate";
    private static final String sOkCallbackCommand = "ok";
    private static final String sCancelCallbackCommand = "cancel";
    private static final String sHelpCallbackCommand = "help";
    private static final String sApplyCallbackCommand = "apply";
    protected TextChangedListener fTextListener;
    protected ActionPerformedListener fActionListener;
    protected ItemChangedListener fItemListener;
    private ButtonPanel fButtonPanel;
    private MatlabMCR fMatlabMCR = MatlabMCRFactory.getForCurrentMCR();
    private MLArrayRef fBlockHandle;
    private boolean fIsDirty;

    public IJFrame() {
        this.fTextListener = new TextChangedListener();
        this.fActionListener = new ActionPerformedListener();
        this.fItemListener = new ItemChangedListener();
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0));
        mJPanel.setBorder((Border)new TitledBorder("Description"));
        MJLabel mJLabel = new MJLabel();
        mJLabel.setText(this.makeBlockDescription());
        mJPanel.add((Component)mJLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)mJPanel, gridBagConstraints);
        mJPanel = this.makeParameterPanel();
        mJPanel.setBorder((Border)new TitledBorder("Parameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)mJPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)new MJPanel(), gridBagConstraints);
        this.fButtonPanel = new ButtonPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)((Object)this.fButtonPanel), gridBagConstraints);
        this.okButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{IJFrame.sOkCallbackCommand, IJFrame.this.fBlockHandle};
                try {
                    IJFrame.this.fMatlabMCR.feval(IJFrame.sSupportFunctionName, objectArray, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.cancelButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{IJFrame.sCancelCallbackCommand, IJFrame.this.fBlockHandle};
                try {
                    IJFrame.this.fMatlabMCR.feval(IJFrame.sSupportFunctionName, objectArray, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.helpButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{IJFrame.sHelpCallbackCommand, IJFrame.this.fBlockHandle};
                try {
                    IJFrame.this.fMatlabMCR.feval(IJFrame.sSupportFunctionName, objectArray, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.applyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = new Object[]{IJFrame.sApplyCallbackCommand, IJFrame.this.fBlockHandle};
                try {
                    IJFrame.this.fMatlabMCR.feval(IJFrame.sSupportFunctionName, objectArray, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.pack();
    }

    public void setHandle(MLArrayRef mLArrayRef) {
        this.fBlockHandle = mLArrayRef;
    }

    public void setDirty(boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new MakeDirtyRunnable(bl));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.fIsDirty = bl;
        this.applyButton().setEnabled(bl);
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    public void makeVisible() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IJFrame.this.makeVisible();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.show();
    }

    public void setParameterValues(String[] stringArray, String[] stringArray2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new SetParameterRunnable(stringArray, stringArray2));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.updateParameterValues(stringArray, stringArray2);
    }

    public abstract Object[] getParameterValues();

    public void disableComponents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IJFrame.this.disableComponents();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.internalDisableComponents();
    }

    public void enableComponents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IJFrame.this.enableComponents();
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        this.internalEnableComponents();
    }

    protected abstract void internalDisableComponents();

    protected abstract void internalEnableComponents();

    protected abstract String makeBlockDescription();

    protected abstract MJPanel makeParameterPanel();

    protected abstract void updateParameterValues(String[] var1, String[] var2);

    protected abstract void updateParameterValue(String var1, String var2);

    protected MJButton applyButton() {
        return this.fButtonPanel.applyButton();
    }

    protected MJButton cancelButton() {
        return this.fButtonPanel.cancelButton();
    }

    protected MJButton helpButton() {
        return this.fButtonPanel.helpButton();
    }

    protected MJButton okButton() {
        return this.fButtonPanel.okButton();
    }

    public static String booleanToString(boolean bl) {
        if (bl) {
            return "on";
        }
        return "off";
    }

    public class MakeDirtyRunnable
    implements Runnable {
        private boolean dirty;

        public MakeDirtyRunnable(boolean bl) {
            this.dirty = bl;
        }

        @Override
        public void run() {
            IJFrame.this.setDirty(this.dirty);
        }
    }

    public class SetParameterRunnable
    implements Runnable {
        private String[] params;
        private String[] values;

        public SetParameterRunnable(String[] stringArray, String[] stringArray2) {
            this.params = stringArray;
            this.values = stringArray2;
        }

        @Override
        public void run() {
            IJFrame.this.setParameterValues(this.params, this.values);
        }
    }

    public class ItemChangedListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            IJFrame.this.setDirty(true);
        }
    }

    public class ActionPerformedListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IJFrame.this.setDirty(true);
        }
    }

    public class TextChangedListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            IJFrame.this.setDirty(true);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            IJFrame.this.setDirty(true);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

