/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.util;

import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.toolbox.instrument.device.Device;
import com.mathworks.toolbox.instrument.device.DeviceChild;
import com.mathworks.toolbox.instrument.device.DeviceClient;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.util.PropertyUtil;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public class PropertyHelp
implements AutoConvertStringToMatlabChar {
    public static String getHelp(String string) throws TMException {
        return PropertyHelp.getPropertyHelp(string);
    }

    public static String getHelp(String string, String string2) throws TMException {
        return PropertyHelp.getPropertyHelp(string2);
    }

    public static String getHelp(DeviceClient deviceClient, String string) throws TMException {
        if (deviceClient.isMethod(string)) {
            String string2 = deviceClient.getInstrumentMethodHelp(string);
            if (string2 == null || string2.equals("")) {
                return string.toUpperCase() + "\n\n";
            }
            return PropertyHelp.autowrap(string2) + "\n\n";
        }
        if (deviceClient.isBaseProperty(string)) {
            return PropertyHelp.getPropertyHelp(string);
        }
        if (deviceClient.isGroupProperty(string.toLowerCase())) {
            String string3 = deviceClient.getInstrumentGroupHelp(string);
            if (string3 == null || string3.equals("")) {
                return PropertyHelp.getGroupHelp(string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase());
            }
            return PropertyHelp.constructHelpHOneLine(deviceClient, string, true) + PropertyHelp.autowrap(string3) + "\n\n";
        }
        String string4 = deviceClient.getInstrumentPropertyHelp(string);
        if (string4 == null) {
            return PropertyHelp.constructHelpHOneLine(deviceClient, string) + "\n\n";
        }
        return PropertyHelp.constructHelpHOneLine(deviceClient, string) + PropertyHelp.autowrap(string4) + "\n\n";
    }

    private static String constructHelpHOneLine(DeviceClient deviceClient, String string) throws TMException {
        return PropertyHelp.constructHelpHOneLine(deviceClient, string, false);
    }

    private static String constructHelpHOneLine(DeviceClient deviceClient, String string, boolean bl) throws TMException {
        PropertyInfo propertyInfo = deviceClient.getPropertyInfo(string);
        String string2 = "   " + propertyInfo.name.toUpperCase();
        if (bl) {
            return string2 + "\n\n";
        }
        String string3 = PropertyUtil.createEnumSetList(deviceClient, propertyInfo);
        if (string3.equals("")) {
            string3 = "(" + propertyInfo.type + ")";
        }
        string2 = string2 + "  " + string3;
        if (propertyInfo.readOnly.equals("always")) {
            string2 = string2 + "  (read only)";
        }
        return string2 + "\n\n";
    }

    private static String autowrap(String string) {
        String string2 = "";
        int n = string.indexOf(" ", 70);
        int n2 = string.indexOf(10);
        int n3 = Math.min(n, n2);
        if (n2 == -1) {
            n3 = n;
        } else if (n == -1) {
            n3 = n2;
        }
        while (n3 != -1) {
            string2 = string2 + "   " + string.substring(0, n3) + "\n";
            string = string.substring(n3 + 1);
            n = string.indexOf(" ", 70);
            n2 = string.indexOf(10);
            if (n == -1 && n2 != -1) {
                n3 = n2;
                continue;
            }
            if (n2 == -1) {
                n3 = n;
                continue;
            }
            if (n == -1) {
                n3 = n2;
                continue;
            }
            n3 = Math.min(n, n2);
        }
        return string2 + "   " + string;
    }

    public static String isValidPropertyName(DeviceClient deviceClient, String string) {
        try {
            Vector<String> vector = deviceClient.getAllProperties();
            int n = TMStringUtil.findPropertyCompleteName((String)string, (String[])TMStringUtil.vector2StringArray(vector));
            return vector.elementAt(n);
        }
        catch (TMException tMException) {
            return "";
        }
    }

    public static String isValidPropertyName(String string, String string2) {
        int n;
        PropertyInfo[] propertyInfoArray = null;
        if (string.equals("icdevice")) {
            propertyInfoArray = Device.getBasePropertyInfo();
        } else if (string.equals("icchannel")) {
            propertyInfoArray = DeviceChild.getBasePropertyInfo();
        } else {
            return "";
        }
        String[] stringArray = new String[propertyInfoArray.length];
        for (n = 0; n < propertyInfoArray.length; ++n) {
            stringArray[n] = propertyInfoArray[n].name;
        }
        try {
            n = TMStringUtil.findPropertyCompleteName((String)string2, (String[])stringArray);
            return stringArray[n];
        }
        catch (TMException tMException) {
            return "";
        }
    }

    public static String getPropertyHelp(String string) throws TMException {
        if ((string = string.toLowerCase()).equals("confirmationfcn")) {
            return PropertyHelp.getConfirmationFcnHelp();
        }
        if (string.equals("driverdata")) {
            return PropertyHelp.getDriverDataHelp();
        }
        if (string.equals("drivername")) {
            return PropertyHelp.getDriverNameHelp();
        }
        if (string.equals("drivertype")) {
            return PropertyHelp.getDriverTypeHelp();
        }
        if (string.equals("hwindex")) {
            return PropertyHelp.getHwIndexHelp();
        }
        if (string.equals("hwname")) {
            return PropertyHelp.getHwNameHelp();
        }
        if (string.equals("instrumentmodel")) {
            return PropertyHelp.getInstrumentModelHelp();
        }
        if (string.equals("interface")) {
            return PropertyHelp.getInterfaceHelp();
        }
        if (string.equals("logicalname")) {
            return PropertyHelp.getLogicalNameHelp();
        }
        if (string.equals("name")) {
            return PropertyHelp.getNameHelp();
        }
        if (string.equals("objectvisibility")) {
            return PropertyHelp.getObjectVisibilityHelp();
        }
        if (string.equals("parent")) {
            return PropertyHelp.getParentHelp();
        }
        if (string.equals("rsrcname")) {
            return PropertyHelp.getRsrcNameHelp();
        }
        if (string.equals("simulationmode")) {
            return PropertyHelp.getSimulationModeHelp();
        }
        if (string.equals("status")) {
            return PropertyHelp.getStatusHelp();
        }
        if (string.equals("tag")) {
            return PropertyHelp.getTagHelp();
        }
        if (string.equals("timeout")) {
            return PropertyHelp.getTimeoutHelp();
        }
        if (string.equals("type")) {
            return PropertyHelp.getTypeHelp();
        }
        if (string.equals("userdata")) {
            return PropertyHelp.getUserDataHelp();
        }
        throw new TMException("Invalid instrument control function or property: '" + string + "'.");
    }

    private static String getConfirmationFcnHelp() {
        return "   CONFIRMATIONFCN  callback\n\n   Specify the callback function to execute when a confirmation \n   event occurs.\n   \n   You configure ConfirmationFcn to execute an callback function \n   when a confirmation event occurs.\n   \n   A confirmation event is generated when the command written to the\n   instrument results in the instrument being configured to a different\n   value than it was sent.\n   \n   Note: A confirmation event can be generated only when the object is\n   connected to the instrument with CONNECT.\n   \n   See also CONNECT.\n\n";
    }

    private static String getDriverDataHelp() {
        return "   DRIVERDATA  any (read only)\n\n   DriverData stores driver specific data.\n   \n   For device objects with a DriverType of MATLAB generic,\n   DriverData contains data defiend by the driver writer and is not\n   user-accessible from the device object.\n   \n   For all other driver types, DriverData is empty. \n   \n";
    }

    private static String getDriverNameHelp() {
        return "   DRIVERNAME  string (read only)\n\n   DriverName specifies the name of the driver used to communicate \n   with the instrument.\n   \n   For device objects with a DriverType of MATLAB interface object,\n   DriverName specifies the name of the MATLAB interface object instrument\n   driver that contains the instrument commands used when communicating with\n   the instrument.\n   \n   For device objects with a DriverType of MATLAB VXIplug&play, DriverName\n   is the name of the VXIplug&play driver used to communicate with the\n   instrument. \n   \n   For device objects with a DriverType of MATLAB IVI, DriverName is the name\n   of the IVI software module used to communicate with the instrument. \n   \n   DriverName is defined at device object creation.\n   \n   See also ICDEVICE, DriverType.\n\n";
    }

    private static String getDriverTypeHelp() {
        return "   DRIVERTYPE  [ MATLAB interface object |  MATLAB VXIplug&play |  MATLAB IVI ] (read only)\n\n   DriverType specifies the type of the driver used to communicate \n   with the instrument.\n   \n   DriverType can be MATLAB interface object, MATLAB VXIplug&play, or MATLAB IVI.\n   \n   If DriverType is MATLAB interface object, a MATLAB interface object \n   is used to communicate with the instrument. \n   \n   If DriverType is MATLAB VXIplug&play, a VXIplug&play driver is used to \n   communicate with the instrument. \n   \n   If DriverType is MATLAB IVI, an IVI software module is used to communicate\n   with the instrument. \n   \n   DriverType is defined at device object creation.\n    \n   See also ICDEVICE, DriverName.\n\n";
    }

    private static String getHwIndexHelp() {
        return "   HWINDEX  double  (read only)\n\n   HwIndex indicates the hardware index of a device group object.\n   \n   Every device group object contained by a device object has an \n   associated hardware index that is used to reference that device\n   group object. For example, to configure property values for an \n   individual device group object, you must reference the group object \n   through its property name and the appropriate HwIndex value.\n   \n   HwIndex provides a convenient way to programmatically access device\n   group objects.\n   \n   See also HwName.\n\n";
    }

    private static String getHwNameHelp() {
        return "   HWNAME  string  (read only)\n\n   HwName indicates the hardware name of a device group object.\n   \n   Every device group object contained by a device object has an \n   associated hardware name that can be used to reference that \n   device group object. \n   \n   HwName provides a convenient way to programmatically access device\n   group objects.\n   \n   See also HwIndex.\n\n";
    }

    private static String getInstrumentModelHelp() {
        return "   INSTRUMENTMODEL  string  (read only)\n\n   Indicate the instrument model the object is connected to.\n   \n   For device objects with a DriverType of MATLAB interface object,\n   InstrumentModel returns the information returned by the instrument\n   identification command, e.g. *IDN?, *ID?. The instrument identification\n   command is defined by the instrument driver.\n    \n   For device objects with a DriverType of MATLAB VXIplug&play,\n   InstrumentModel always returns empty.\n   \n   For device objects with a DriverType of MATLAB IVI, InstrumentModel\n   returns a string based on the InstrumentManufacturer and InstrumentModel\n   driver properties.\n   \n   InstrumentModel will be empty until the object is connected to the\n   instrument with the CONNECT function and the property value is queried\n   with the GET function.\n   \n   See also CONNECT, GET.\n\n";
    }

    private static String getInterfaceHelp() {
        return "   INTERFACE  any  (read only)\n\n   Indicate the interface object used to communicate with the instrument.\n   \n   If DriverType is MATLAB interface object, Interface returns the \n   interface object used to communicate with the instrument.\n   \n   If DriverType is MATLAB VXIplug&play, Interface is the handle to the VISA \n   session that is used to communicate with the instrument. \n   \n   If DriverType is MATLAB IVI, and the driver is an IVI-C driver, Interface is\n   the handle to the VISA session that is used to communicate with the\n   instrument.\n   \n   If DriverType is MATLAB IVI, and the driver is an IVI-COM driver, Interface\n   is the COM interface handle used to communicate with the instrument\n   \n   Interface is defined at device object creation.\n   \n   See also ICDEVICE, DriverType, LogicalName, RsrcName.\n\n";
    }

    private static String getLogicalNameHelp() {
        return "   LOGICALNAME  string (read only)\n\n   LogicalName is an alias for the driver and interface used\n   to communicate with an instrument.\n   \n   LogicalName provides a mapping between the driver used to communicate\n   with an instrument and the description of the interface that is \n   used to communicate with an instrument. Logical Names are defined\n   in the IVI Configuration Store.\n   \n   If DriverType is MATLAB IVI and an IVI Logical Name was used to construct\n   the device object, LogicalName is the logical name used to construct the\n   device object. \n   \n   For all other DriverType values, LogicalName is empty. \n   \n   LogicalName is defined at device object creation.\n   \n   See also ICDEVICE, DriverType, Interface, RsrcName.\n\n";
    }

    private static String getNameHelp() {
        return "   NAME  string\n\n   Specify a descriptive name for the instrument object.\n   \n   You configure Name to be a descriptive name for the instrument \n   object.\n   \n   When you create an instrument object, a descriptive name is \n   automatically generated and stored in Name. However, you can\n   change the value of Name at any time.\n\n";
    }

    private static String getObjectVisibilityHelp() {
        return "   OBJECTVISIBILITY   [ {on} | off ]\n\n   Control access to an object by command-line users and GUIs.\n   \n   ObjectVisibility determines when an object is visible. ObjectVisibility \n   is useful for preventing command-line users from accidentally deleting \n   or configuring an instrument object that is being used by a GUI. \n   \n   Objects are always visible when ObjectVisibility is set to on. Setting \n   ObjectVisibility to off makes the object invisible. This may be necessary \n   from within a GUI to prevent a command-line user from accidentally deleting \n   or configuring an instrument object. When an object is not visible, it will \n   not be returned by the INSTRFIND function. By default, ObjectVisibility is \n   on. \n   \n   Objects that are hidden are still valid. If you have access to the object, \n   you can set and get its properties, and pass it to any function that operates \n   on instrument objects. \n   \n   See also INSTRFIND.\n\n";
    }

    private static String getGroupHelp(String string) {
        return "   " + string.toUpperCase() + " vector of device " + string.toLowerCase() + " objects (read only)\n\n" + "   " + string + " is a vector of all the device " + string.toLowerCase() + " objects contained by\n" + "   a device object. When a device object is created, all the available " + string.toLowerCase() + "\n" + "   objects (as defined by the instrument driver) are added.\n" + "   \n" + "   " + string + " is used to reference one or more individual " + string.toLowerCase() + " objects. To  \n" + "   reference a " + string.toLowerCase() + " object, you must know its hardware index. The hardware  \n" + "   index is given by the HwIndex property. For example, you must use " + string + "  \n" + "   with the appropriate indices when configuring " + string.toLowerCase() + " property values.\n" + "   \n" + "   See also HwIndex, HwName.\n\n";
    }

    private static String getParentHelp() {
        return "   PARENT  device object  (read only)\n\n   Parent indicates the parent (device object) of a device group object.\n   \n   The parent of a device group object is defined as the device object\n   that contains the device group object.\n   \n   You can create a copy of the device object containing a particular device \n   group object by returning the value of Parent. This copy can be treated like\n   any other device object. For example, you can configure property values, \n   connect to the instrument and so on.\n\n";
    }

    private static String getRsrcNameHelp() {
        return "   RSRCNAME string (read-only)\n\n   Indicate the resource name for a VISA instrument.\n   \n   RsrcName indicates the resource name for a VISA instrument. When you create\n   a VISA object, RsrcName is automatically assigned. \n   \n   The resource name is a symbolic name for the instrument. The value you supply\n   to VISA has the following format, where the components in brackets are optional\n   and have a default value of 0 except for port_number, which has a default\n   value of 1.\n   \n     Interface          Resource Name\n     ---------          -------------\n     VXI                VXI[chassis]::VXI_logical_address::INSTR\n     GPIB-VXI           GPIB-VXI[chassis]::VXI_logical_address::INSTR\n     GPIB               GPIB[board]::primary_address::[secondary_address]::INSTR\n     TCPIP              TCPIP[board]::remote_host::[lan_device_name]::INSTR\n     USB                USB[board]::man_id::model_code::serial_No::[interface_No]::INSTR\n     RSIB               RSIB::remote_host::INSTR\n     Serial             ASRL[port_number]::INSTR\n   \n   If you change the BoardIndex, PrimaryAddress, SecondaryAddress, ChassisIndex, \n   LANName, LogicalAddress, Port, RemoteHost, ManufacturerID, ModelCode, SerialNumber,\n   or InterfaceIndex property values, RsrcName is automatically updated to reflect\n   these changes.\n   \n   For device objects with a DriverType property value of MATLAB interface object, the \n   RsrcName property specifies the type of interface used to communicate with the \n   instrument. For example, a RsrcName of GPIB0-2 indicates that communication is \n   through a GPIB board at index 0 with an instrument at primary address 2.\n   \n   For all other device objects, RsrcName is any valid VISA resource name. Communication\n   to the instrument is done through the resource specified by RSRCNAME. \n   \n   For device objects, the RsrcName value is defined at device object creation.\n   \n   See also VISA, BoardIndex, ChassisIndex, InterfaceIndex, LANName, LogicalAddress,\n   ManufacturerID, ModelCode, Port, PrimaryAddress, RemoteHost, SecondaryAddress, \n   SerialNumber.\n\n";
    }

    private static String getSimulationModeHelp() {
        return "   SIMULATIONMODE   [ on | {off} ]\n\n   Indicate if the device object communicates with an actual instrument \n   or returns pre-recorded responses. \n   \n   Indicate if the device object communicates with an actual instrument\n   or returns pre-recorded responses. If SimulationMode is on, then the\n   device object returns pre-recorded responses. If SimulationMode is off,\n   then the device object communicates with an actual instrument. By\n   default, SimulationMode is off.\n\n";
    }

    private static String getStatusHelp() {
        return "   STATUS  [ {closed} | open ]  (read only)\n\n   Indicate if the instrument object is connected to the instrument.\n   \n   Status can be open or closed. If Status is open, the instrument object is\n   connected to the instrument. If Status is closed, the instrument object \n   is not connected to the instrument.\n   \n   Before you can write or read data, you must connect the instrument object\n   to the instrument. Interface objects are connected to the instrument with \n   the FOPEN function. Device objects are connected to the instrument with the\n   CONNECT function. You use the FCLOSE function to disconnect an interface \n   object from the instrument. You use the DISCONNECT function to disconnect\n   a device object from the instrument.\n   \n   See also CONNECT, DISCONNECT, FCLOSE, FOPEN.\n\n";
    }

    private static String getTagHelp() {
        return "   TAG  string\n\n   Specify a label to associate with an instrument object.\n   \n   You configure Tag to be a string value that uniquely identifies an instrument\n   object.\n   \n   Tag is particularly useful when constructing programs that would otherwise\n   need to define the instrument object as a global variable, or pass the object\n   as an argument between callback routines.\n   \n   You can return an instrument object with the INSTRFIND function by specifying\n   the Tag property value.\n   \n   See also INSTRFIND.\n\n";
    }

    private static String getTimeoutHelp() {
        return "   TIMEOUT  double\n\n   Specify the waiting time to complete a read or write operation.\n   \n   You configure Timeout to be the maximum time (in seconds) to wait to\n   complete a read or write operation.\n   \n   If a timeout occurs, then the read or write operation aborts. Additionally,\n   if a timeout occurs during an asynchronous read or write operation, then:\n   \n   - An error event is generated.\n   - The callback function specified for ErrorFcn is executed.\n   \n   See also ErrorFcn.\n\n";
    }

    private static String getTypeHelp() {
        return "   TYPE  string  (read only)\n\n   Indicate the instrument object type.\n\n   Type indicates the type of the object. Once the instrument object is created,\n   the value of Type is automatically defined.\n   \n   Using the INSTRFIND function and the Type value, you can quickly identify \n   instrument objects of a given type.\n   \n   See also INSTRFIND.\n\n";
    }

    private static String getUserDataHelp() {
        return "   USERDATA  any\n\n   Specify data that you want to associate with an instrument object.\n   \n   You configure UserData to store data that you want to associate with\n   an instrument object. The object does not use this data directly, but\n   you can access it using the GET function or the dot notation.\n   \n   See also GET.\n\n";
    }
}

