/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool.table;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTextField;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDToolbarButton;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.table.MIDTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class MIDTablePanel
extends MJPanel
implements ListSelectionListener,
ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    public static final int kAdd = 1;
    public static final int kDelete = 2;
    public static final int kMoveUpRow = 3;
    public static final int kMoveDownRow = 4;
    protected static final ResourceBundle fResourceBundle = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.device.guiutil.midtool.table.resources.RES_MIDTABLE");
    protected MIDTable fTable;
    protected JLabel fEntryTextLabel;
    protected JTextComponent fEntryText;
    protected JButton fAddButton;
    protected JButton fDeleteButton;
    protected JPanel fToolBar;
    protected MIDToolbarButton fMoveUpButton;
    protected MIDToolbarButton fMoveDownButton;
    protected MIDToolbarButton fAppendButton;
    protected static ImageIcon sDeleteIcon;
    protected static ImageIcon sUpArrowIcon;
    protected static ImageIcon sDownArrowIcon;
    protected static ImageIcon sAppendIcon;
    protected Vector<String> fEntryHistory;
    protected Vector<ActionListener> fDelegates = new Vector();

    public MIDTablePanel(MIDTable mIDTable, String string) {
        this.fEntryHistory = new Vector();
        this.fTable = mIDTable;
        this.layoutPanel(string);
        this.fTable.getSelectionModel().addListSelectionListener(this);
    }

    protected void layoutPanel(String string) {
        this.setLayout(new BorderLayout(0, 0));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(0, 0));
        this.add((Component)mJPanel, "Center");
        if (string != null) {
            this.setBorder(BorderFactory.createTitledBorder(string));
            mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        }
        JComponent jComponent = this.layoutAddPanel();
        mJPanel.add((Component)jComponent, (Object)"North");
        jComponent = this.layoutTablePanel();
        mJPanel.add((Component)jComponent, (Object)"Center");
    }

    protected JPanel layoutTablePanel() {
        JScrollPane jScrollPane = new JScrollPane(this.fTable);
        jScrollPane.setPreferredSize(new Dimension(20, 20));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected JComponent layoutAddPanel() {
        this.createToolBarButtons();
        this.fToolBar = new MJPanel();
        this.fToolBar.setLayout(new BoxLayout(this.fToolBar, 0));
        this.fToolBar.add((Component)((Object)this.fAppendButton));
        this.fToolBar.add((Component)((Object)this.fMoveUpButton));
        this.fToolBar.add((Component)((Object)this.fMoveDownButton));
        this.fEntryTextLabel = new MJLabel("Entry:");
        this.fToolBar.add((Component)this.fEntryTextLabel, "West");
        this.fToolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        this.fEntryText = new MIDTextField();
        this.fEntryText.getDocument().addDocumentListener(this);
        ((MIDTextField)((Object)this.fEntryText)).setActionCommand(Integer.toString(1));
        ((MIDTextField)((Object)this.fEntryText)).addActionListener(this);
        this.fToolBar.add(this.fEntryText);
        this.fToolBar.add(Box.createRigidArea(new Dimension(5, 0)));
        this.fAddButton = new MJButton("Add");
        this.fAddButton.setEnabled(false);
        this.fAddButton.setActionCommand(Integer.toString(1));
        this.fAddButton.addActionListener(this);
        this.fToolBar.add(this.fAddButton);
        this.fToolBar.add(Box.createRigidArea(new Dimension(5, this.fAddButton.getHeight() + 30)));
        this.fDeleteButton = new MJButton("Remove");
        this.fDeleteButton.setEnabled(false);
        this.fDeleteButton.setActionCommand(Integer.toString(2));
        this.fDeleteButton.addActionListener(this);
        this.fToolBar.add(this.fDeleteButton);
        return this.fToolBar;
    }

    protected void createToolBarButtons() {
        this.fAppendButton = new MIDToolbarButton();
        this.fAppendButton.setIcon(sAppendIcon);
        this.fAppendButton.setEnabled(false);
        this.fAppendButton.setActionCommand(Integer.toString(1));
        this.fAppendButton.addActionListener(this);
        this.fAppendButton.setVisible(false);
        this.fMoveUpButton = new MIDToolbarButton();
        this.fMoveUpButton.setIcon(sUpArrowIcon);
        this.fMoveUpButton.setEnabled(false);
        this.fMoveUpButton.setActionCommand(Integer.toString(3));
        this.fMoveUpButton.addActionListener(this);
        this.fMoveUpButton.setToolTipText(fResourceBundle.getString("TablePanel.MoveUp"));
        this.fMoveDownButton = new MIDToolbarButton();
        this.fMoveDownButton.setIcon(sDownArrowIcon);
        this.fMoveDownButton.setEnabled(false);
        this.fMoveDownButton.setActionCommand(Integer.toString(4));
        this.fMoveDownButton.addActionListener(this);
        this.fMoveDownButton.setToolTipText(fResourceBundle.getString("TablePanel.MoveDown"));
    }

    public MIDTable getTable() {
        return this.fTable;
    }

    public void setAllowsAddEntry(boolean bl) {
        this.fEntryTextLabel.setVisible(bl);
        this.fEntryText.setVisible(bl);
        this.fAddButton.setVisible(bl);
    }

    public void setAllowsDeleteEntry(boolean bl) {
        this.fDeleteButton.setVisible(bl);
    }

    public void setAllowsMoveEntry(boolean bl) {
        this.fMoveUpButton.setVisible(bl);
        this.fMoveDownButton.setVisible(bl);
    }

    public void setEntryLabelText(String string) {
        this.fEntryTextLabel.setText(string);
    }

    public void setEntryText(String string) {
        this.fEntryText.setText(string);
    }

    public String getEntryText() {
        return this.fEntryText.getText();
    }

    public JComponent getEntryTextComponent() {
        return this.fEntryText;
    }

    protected boolean entryAdded(String string) {
        if (string.length() > 0) {
            if (this.fEntryHistory.contains(string)) {
                return false;
            }
            this.fEntryHistory.add(this.getEntryText());
            if (this.fEntryHistory.size() > 12) {
                this.fEntryHistory.removeElementAt(0);
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateButtonState();
        }
    }

    public void updateButtonState() {
        ListSelectionModel listSelectionModel = this.fTable.getSelectionModel();
        boolean bl = !listSelectionModel.isSelectionEmpty();
        int n = this.fTable.getSelectedRowCount();
        this.fDeleteButton.setEnabled(bl);
        if (bl && n == 1) {
            int n2 = listSelectionModel.getLeadSelectionIndex();
            this.fMoveDownButton.setEnabled(n2 < this.fTable.getRowCount() - 1);
            this.fMoveUpButton.setEnabled(n2 > 0);
        } else {
            this.fMoveDownButton.setEnabled(false);
            this.fMoveUpButton.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.fAddButton.setEnabled(this.fEntryText.getText().length() > 0);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.fAddButton.setEnabled(this.fEntryText.getText().length() > 0);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.fAddButton.setEnabled(this.fEntryText.getText().length() > 0);
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.fDelegates.contains(actionListener)) {
            this.fDelegates.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fDelegates.remove(actionListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.fDelegates.size(); ++i) {
            this.fDelegates.get(i).actionPerformed(actionEvent);
        }
        String string = actionEvent.getActionCommand();
        if (Integer.decode(string) == 1) {
            String string2 = this.getEntryText();
            this.entryAdded(string2);
        }
    }

    static {
        try {
            Class<MIDTool> clazz = MIDTool.class;
            sDeleteIcon = new ImageIcon(clazz.getResource("resources/delete.gif"));
            sUpArrowIcon = new ImageIcon(clazz.getResource("resources/move_up.gif"));
            sDownArrowIcon = new ImageIcon(clazz.getResource("resources/move_down.gif"));
            sAppendIcon = new ImageIcon(clazz.getResource("resources/add_row.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

