/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class DriverDataType
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] sShortTypeDesc = new String[]{"Double", "String", "Boolean", "Any"};
    private static final String[] sShortConsDesc = new String[]{"Bounded", "Enumeration", "None"};
    private int fDataType;
    private int fConstraintType;
    private double fRangeMin;
    private double fRangeMax;
    private Vector<Comparable<?>> fDoubleEnums;
    private Vector<Comparable<?>> fStringEnumKeys;
    private Vector<Comparable<?>> fStringEnumVals;
    private String fDependentPropertyName;
    private String fDependentPropertyValue;
    private DriverProperty fParent;
    private Vector<DriverModelListener> fChangeListeners = new Vector();

    public DriverDataType() {
        this(0, 2);
    }

    public DriverDataType(PropertyConstraint propertyConstraint) {
        this.initializeWithPropertyConstraint(propertyConstraint);
    }

    public DriverDataType(int n, int n2) {
        this.initialize(n, n2);
    }

    public String toString() {
        return this.getDataTypeString();
    }

    public void setParentProperty(DriverProperty driverProperty) {
        this.fParent = driverProperty;
    }

    public DriverProperty getParentProperty() {
        return this.fParent;
    }

    public void setDataType(int n) {
        if (n != this.fDataType) {
            this.fDataType = n;
            if (n == 2) {
                this.setConstraintType(2);
            }
            if (n == 3) {
                this.setConstraintType(2);
            }
            this.fireDataTypeChangedEvent();
        }
    }

    public void setDataType(String string) {
        if (string.equalsIgnoreCase("boolean")) {
            this.setDataType(2);
        } else if (string.equalsIgnoreCase("double")) {
            this.setDataType(0);
        } else if (string.equalsIgnoreCase("string")) {
            this.setDataType(1);
        } else if (string.equalsIgnoreCase("any")) {
            this.setDataType(3);
        }
    }

    public int getDataType() {
        return this.fDataType;
    }

    public void setConstraintType(int n) {
        if (n != this.fConstraintType) {
            this.fConstraintType = n;
            this.fireDataTypeChangedEvent();
        }
    }

    public void setConstraintType(String string) {
        if (string.equalsIgnoreCase("none")) {
            this.setConstraintType(2);
        } else if (string.equalsIgnoreCase("bounded")) {
            this.setConstraintType(0);
        } else if (string.equalsIgnoreCase("enumeration")) {
            this.setConstraintType(1);
        }
    }

    public int getConstraintType() {
        return this.fConstraintType;
    }

    public void setRangeMin(double d) {
        if (this.fRangeMin != d) {
            this.fRangeMin = d;
            this.fireDataTypeChangedEvent();
        }
    }

    public double getRangeMin() {
        return this.fRangeMin;
    }

    public void setRangeMax(double d) {
        if (this.fRangeMax != d) {
            this.fRangeMax = d;
            this.fireDataTypeChangedEvent();
        }
    }

    public double getRangeMax() {
        return this.fRangeMax;
    }

    public void setRange(double d, double d2) {
        if (this.fRangeMin != d || this.fRangeMax != d2) {
            this.fRangeMin = d;
            this.fRangeMax = d2;
            this.fireDataTypeChangedEvent();
        }
    }

    private void setDoubleEnums(Vector<Comparable<?>> vector) {
        this.fDoubleEnums = vector == null ? new Vector() : vector;
    }

    public void setDoubleEnum(Double d, int n) {
        if (!d.equals(this.fDoubleEnums.get(n))) {
            this.fDoubleEnums.setElementAt(d, n);
            this.fireDataTypeChangedEvent();
        }
    }

    public Double getDoubleEnum(int n) {
        return (Double)this.fDoubleEnums.get(n);
    }

    public void addDoubleEnum(Double d) {
        this.fDoubleEnums.add(d);
        this.fireDataTypeChangedEvent();
    }

    public void removeDoubleEnum(int n) {
        this.fDoubleEnums.removeElementAt(n);
        this.fireDataTypeChangedEvent();
    }

    public int getDoubleEnumCount() {
        return this.fDoubleEnums.size();
    }

    private void setStringEnumKeys(Vector<Comparable<?>> vector) {
        this.fStringEnumKeys = vector == null ? new Vector() : vector;
    }

    public void setStringEnumKey(String string, int n) {
        if (!string.equals(this.fStringEnumKeys.get(n))) {
            this.fStringEnumKeys.setElementAt((Comparable<?>)((Object)string), n);
            this.fireDataTypeChangedEvent();
        }
    }

    public String getStringEnumKey(int n) {
        return (String)((Object)this.fStringEnumKeys.get(n));
    }

    public void addStringEnumKey(String string) {
        this.fStringEnumKeys.add((Comparable<?>)((Object)string));
        this.fireDataTypeChangedEvent();
    }

    public void removeStringEnumKey(int n) {
        this.fStringEnumKeys.removeElementAt(n);
        this.fireDataTypeChangedEvent();
    }

    public int getStringEnumKeyCount() {
        return this.fStringEnumKeys.size();
    }

    private void setStringEnumVals(Vector<Comparable<?>> vector) {
        this.fStringEnumVals = vector == null ? new Vector() : vector;
    }

    public void setStringEnumVal(String string, int n) {
        if (!string.equals(this.fStringEnumVals.get(n))) {
            this.fStringEnumVals.setElementAt((Comparable<?>)((Object)string), n);
            this.fireDataTypeChangedEvent();
        }
    }

    public String getStringEnumVal(int n) {
        return (String)((Object)this.fStringEnumVals.get(n));
    }

    public void addStringEnumVal(String string) {
        this.fStringEnumVals.add((Comparable<?>)((Object)string));
        this.fireDataTypeChangedEvent();
    }

    public void removeStringEnumVal(int n) {
        this.fStringEnumVals.removeElementAt(n);
        this.fireDataTypeChangedEvent();
    }

    public int getStringEnumValCount() {
        return this.fStringEnumVals.size();
    }

    public void setDependentPropertyName(String string) {
        if (!string.equals(this.fDependentPropertyName)) {
            this.fDependentPropertyName = string;
            this.fireDataTypeChangedEvent();
        }
    }

    public String getDependentPropertyName() {
        return this.fDependentPropertyName;
    }

    public void setDependentPropertyValue(String string) {
        if (!string.equals(this.fDependentPropertyValue)) {
            this.fDependentPropertyValue = string;
            this.fireDataTypeChangedEvent();
        }
    }

    public String getDependentPropertyValue() {
        return this.fDependentPropertyValue;
    }

    public String getDataTypeString() {
        return sShortTypeDesc[this.getDataType()];
    }

    public String getConstraintString() {
        return sShortConsDesc[this.getConstraintType()];
    }

    public Object clone() {
        int n;
        DriverDataType driverDataType = new DriverDataType(this.getDataType(), this.getConstraintType());
        driverDataType.setRange(this.getRangeMin(), this.getRangeMax());
        driverDataType.setDependentPropertyName(new String(this.getDependentPropertyName()));
        driverDataType.setDependentPropertyValue(new String(this.getDependentPropertyValue()));
        Vector<Comparable<Object>> vector = new Vector();
        for (n = 0; n < this.fDoubleEnums.size(); ++n) {
            vector.add(this.fDoubleEnums.get(n));
        }
        driverDataType.setDoubleEnums(vector);
        vector = new Vector();
        for (n = 0; n < this.fStringEnumKeys.size(); ++n) {
            vector.add((Comparable<Object>)((Object)new String((String)((Object)this.fStringEnumKeys.get(n)))));
        }
        driverDataType.setStringEnumKeys(vector);
        vector = new Vector();
        for (n = 0; n < this.fStringEnumVals.size(); ++n) {
            vector.add((Comparable<Object>)((Object)new String((String)((Object)this.fStringEnumVals.get(n)))));
        }
        driverDataType.setStringEnumVals(vector);
        return driverDataType;
    }

    private void initialize(int n, int n2) {
        this.fDataType = n;
        if (this.fDataType == 4) {
            this.fDataType = 3;
        }
        this.fConstraintType = n2;
        this.fRangeMin = 0.0;
        this.fRangeMax = 0.0;
        this.fDoubleEnums = new Vector();
        this.fStringEnumKeys = new Vector();
        this.fStringEnumVals = new Vector();
        this.fDependentPropertyName = "";
        this.fDependentPropertyValue = "";
        this.fParent = null;
    }

    private void initializeWithPropertyConstraint(PropertyConstraint propertyConstraint) {
        this.initialize(propertyConstraint.getType(), propertyConstraint.getConstraint());
        if (propertyConstraint.getType() == 2) {
            this.fConstraintType = 2;
        }
        if (propertyConstraint.getType() == 3) {
            this.fConstraintType = 2;
        }
        this.setDependentPropertyName(new String(propertyConstraint.getDependentPropertyName()));
        this.setDependentPropertyValue(new String(propertyConstraint.getDependentPropertyValue()));
        if (this.fDataType == 1) {
            if (this.fConstraintType == 1) {
                String[] stringArray = (String[])propertyConstraint.getConstraintValues();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.fStringEnumKeys.add((Comparable<?>)((Object)new String(stringArray[i])));
                    this.fStringEnumVals.add((Comparable<?>)((Object)new String((String)propertyConstraint.getValidValue(stringArray[i]))));
                }
            }
        } else if (this.fDataType == 0) {
            if (this.fConstraintType == 1) {
                Double[] doubleArray = (Double[])propertyConstraint.getConstraintValues();
                for (int i = 0; i < doubleArray.length; ++i) {
                    this.fDoubleEnums.add(doubleArray[i]);
                }
            } else if (this.fConstraintType == 0) {
                Double[] doubleArray = (Double[])propertyConstraint.getConstraintValues();
                this.setRange(doubleArray[0], doubleArray[1]);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.fDataType);
        objectOutputStream.writeInt(this.fConstraintType);
        objectOutputStream.writeDouble(this.fRangeMin);
        objectOutputStream.writeDouble(this.fRangeMax);
        objectOutputStream.writeObject(this.fDoubleEnums);
        objectOutputStream.writeObject(this.fStringEnumKeys);
        objectOutputStream.writeObject(this.fStringEnumVals);
        objectOutputStream.writeUTF(this.fDependentPropertyName);
        objectOutputStream.writeUTF(this.fDependentPropertyValue);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fDataType = objectInputStream.readInt();
        this.fConstraintType = objectInputStream.readInt();
        this.fRangeMin = objectInputStream.readDouble();
        this.fRangeMax = objectInputStream.readDouble();
        this.fDoubleEnums = (Vector)objectInputStream.readObject();
        this.fStringEnumKeys = (Vector)objectInputStream.readObject();
        this.fStringEnumVals = (Vector)objectInputStream.readObject();
        this.fDependentPropertyName = objectInputStream.readUTF();
        this.fDependentPropertyValue = objectInputStream.readUTF();
    }

    public void addDriverModelListener(DriverModelListener driverModelListener) {
        if (!this.fChangeListeners.contains(driverModelListener)) {
            this.fChangeListeners.add(driverModelListener);
        }
    }

    public void removeDriverModelListener(DriverModelListener driverModelListener) {
        this.fChangeListeners.remove(driverModelListener);
    }

    private void fireDataTypeChangedEvent() {
        DriverModelEvent driverModelEvent = new DriverModelEvent(this, 9, null, 0);
        for (int i = 0; i < this.fChangeListeners.size(); ++i) {
            this.fChangeListeners.get(i).driverStateChanged(driverModelEvent);
        }
    }
}

