/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtest;

import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.MIDTestToolClient;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.StepListTransferHandler;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.TreeTransferHandler;
import com.mathworks.toolbox.instrument.device.guiutil.midtest.panel.OutputPanel;
import com.mathworks.toolbox.testmeas.browser.Browser;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserDecoration;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeDetail;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.DetailView;
import com.mathworks.toolbox.testmeas.browser.TreeView;
import com.mathworks.toolbox.testmeas.browser.TreeViewEditorListener;
import com.mathworks.widgets.Dialogs;
import com.mathworks.widgets.desk.DTFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public class MIDTestTool
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener,
Runnable {
    private static Font FONT = new Font("Sanserif", 1, 11);
    private static final int SETTINGS = 0;
    private static final int OUTPUT_WINDOW = 1;
    public static final String ACTION = "ACTION";
    private static final int ADD = 0;
    private static final int STEP = 1;
    private static final int TREE = 2;
    private Browser browser;
    private MIDTestToolClient client;
    private BrowserTreeDetail btd;
    private TreeView treeView;
    private JSplitPane treeViewpanel;
    private JLabel stepsLabel;
    private JList stepsListBox;
    private JButton addButton;
    private JTabbedPane tabbedPane;
    private OutputPanel outputWindow;
    private BrowserDecoration detailPanelDecoration;
    private String createEmptyName = "";
    private String testToLoad = "";
    private static MIDTestTool tool = null;

    public static MIDTestTool getInstance() {
        if (tool == null) {
            tool = new MIDTestTool();
        }
        return tool;
    }

    private MIDTestTool() {
        this.layoutPanel();
        this.createEmptyName = "";
        tool = this;
    }

    public void loadTest(String string, boolean bl) {
        this.createEmptyName = string;
        this.layoutPanel();
        if (!bl) {
            this.client.loadTest(string);
            this.createEmptyName = "";
        }
        tool = this;
    }

    public void loadTest(String string) {
        this.testToLoad = string;
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        if (!new File(this.testToLoad).exists()) {
            this.client.newTest();
            this.createEmptyName = this.testToLoad;
        } else {
            this.client.loadTest(this.testToLoad);
            this.createEmptyName = "";
        }
        tool = this;
    }

    private void layoutPanel() {
        this.browser = new Browser("MATLAB Instrument Driver Testing Tool");
        this.browser.setBrowserLayout(1);
        this.client = new MIDTestToolClient();
        this.btd = this.browser.addClients((BrowserClient)this.client, "Test Explorer", null, 1, this.client.getRoot(), true);
        this.btd.okToHiliteTreeView(false);
        this.btd.okToUpdateDecorationDP(false);
        this.browser.addToolbar(true);
        this.browser.addToolbarAndButtons(false);
        this.browser.addMenubar(true);
        this.browser.addMenubarAndMenus(false);
        this.browser.addStatusbar(true);
        this.browser.setConfigurationFileName("midtesttool.cfg");
        this.browser.layoutBrowser();
        this.updateTreeView();
        this.updateDetailView();
        this.browser.setBrowserSize(770, 555);
        this.client.setMIDTester(this);
        this.detailPanelDecoration = this.btd.getDecorationOnDetailPanel();
    }

    private void updateTreeView() {
        BrowserDecoration browserDecoration = this.btd.getTreeViewBrowserDecoration();
        this.treeView = this.browser.getCurrentTreeView();
        this.treeView.putClientProperty((Object)ACTION, (Object)new Integer(2));
        JScrollPane jScrollPane = new JScrollPane((Component)this.treeView);
        this.treeView.setDragEnabled(true);
        this.treeView.setTransferHandler((TransferHandler)new TreeTransferHandler(this));
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)browserDecoration, "North");
        JPanel jPanel2 = this.layoutStepsPanel();
        this.treeViewpanel = new JSplitPane(0, jPanel, jPanel2);
        JSplitPane jSplitPane = this.browser.getOuterPane();
        jSplitPane.setLeftComponent(this.treeViewpanel);
    }

    private JPanel layoutStepsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.stepsLabel = new JLabel("Test Steps", 2);
        this.stepsLabel.setEnabled(false);
        this.stepsLabel.setFont(FONT);
        this.stepsLabel.setForeground(Color.GRAY);
        jPanel.add((Component)this.stepsLabel, "North");
        this.stepsListBox = new JList<String>(MIDTestToolClient.STEP_NAMES);
        this.stepsListBox.setSelectionMode(0);
        this.stepsListBox.setSelectedIndex(0);
        this.stepsListBox.setCellRenderer(new StepListBoxRenderer());
        this.stepsListBox.setEnabled(false);
        this.stepsListBox.putClientProperty(ACTION, new Integer(1));
        this.stepsListBox.setName("Test Steps Listbox");
        this.stepsListBox.setDragEnabled(true);
        this.stepsListBox.setTransferHandler(new StepListTransferHandler());
        JScrollPane jScrollPane = new JScrollPane(this.stepsListBox);
        jScrollPane.setPreferredSize(new Dimension(50, 100));
        jPanel.add((Component)jScrollPane, "Center");
        this.addButton = new JButton("Add");
        this.addButton.setEnabled(false);
        this.addButton.putClientProperty(ACTION, new Integer(0));
        this.addButton.addActionListener(this);
        this.addButton.setName("Add test steps Button");
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        jPanel2.add(this.addButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void updateDetailView() {
        DetailView detailView = this.browser.getCurrentDetailView();
        detailView.setPreferredSize(new Dimension(250, 400));
        this.outputWindow = new OutputPanel();
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(3);
        JScrollPane jScrollPane = new JScrollPane((Component)detailView);
        jScrollPane.setPreferredSize(new Dimension(250, 400));
        jScrollPane.setBorder(null);
        this.tabbedPane.addTab("Settings", jScrollPane);
        this.tabbedPane.addTab("Output Window", this.outputWindow);
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setName("Detail View Tabbed Pane");
        jPanel.add((Component)this.tabbedPane, "Center");
        JSplitPane jSplitPane = this.browser.getHelpPane();
        jSplitPane.setLeftComponent(jPanel);
        this.browser.setDetailPanel(jPanel);
    }

    public void addToFrame() {
        this.browser.addToFrame();
        this.browser.getFrame().removeWindowListener((WindowListener)this.browser);
        this.browser.getFrame().addWindowListener((WindowListener)this.client);
        MJStatusBar mJStatusBar = this.browser.getStatusbar();
        mJStatusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.treeViewpanel.setDividerLocation(329);
        this.treeView.addTreeViewEditorListener((TreeViewEditorListener)this.client);
        this.detailPanelDecoration.setText("Unnamed Test");
        if (!this.createEmptyName.equals("")) {
            this.client.createEmptyTest(this.createEmptyName);
        }
    }

    public void updateLocation() {
        this.treeViewpanel.setDividerLocation(329);
        this.browser.updateScrollPaneLocations();
    }

    public void makeVisible() {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MIDTestTool.this.makeVisible();
                }
            });
            return;
        }
        this.addToFrame();
        this.updateLocation();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.addStep();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        switch (this.tabbedPane.getSelectedIndex()) {
            case 0: {
                BrowserTreeNode browserTreeNode = this.client.getSelectedNode();
                this.detailPanelDecoration.setText(this.client.getBrowserDecorationLabel(browserTreeNode), browserTreeNode.getIcon());
                break;
            }
            case 1: {
                this.detailPanelDecoration.setText("Output Window");
            }
        }
    }

    public void setBrowserDecorationText(String string, ImageIcon imageIcon) {
        this.detailPanelDecoration.setText(string, imageIcon);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        this.addStep();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        JComponent jComponent = (JComponent)keyEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 1: {
                if (keyEvent.getKeyCode() != 10) break;
                this.addStep();
                break;
            }
            case 2: {
                if (keyEvent.getKeyCode() != 127) break;
                TreePath treePath = this.treeView.getSelectionPath();
                this.client.removeStep((BrowserTreeNode)treePath.getLastPathComponent());
            }
        }
    }

    protected void addStep() {
        this.client.addStep(this.stepsListBox.getSelectedIndex());
        if (this.client.getRoot().getChildCount() == 1) {
            this.treeView.expandPath(new TreePath(this.client.getRoot().getPath()));
        }
    }

    protected void addStep(int n) {
        this.client.addStep(this.stepsListBox.getSelectedIndex(), n);
        if (this.client.getRoot().getChildCount() == 1) {
            this.treeView.expandPath(new TreePath(this.client.getRoot().getPath()));
        }
    }

    protected void moveStep(BrowserTreeNode browserTreeNode, int n) {
        this.client.moveStep(browserTreeNode, n);
    }

    public void enableStepPanel(boolean bl) {
        this.addButton.setEnabled(bl);
        this.stepsLabel.setEnabled(bl);
        this.stepsListBox.setEnabled(bl);
        if (bl) {
            this.stepsListBox.addMouseListener(this);
            this.stepsListBox.addKeyListener(this);
            this.treeView.addKeyListener((KeyListener)this);
        } else {
            this.stepsListBox.removeMouseListener(this);
            this.stepsListBox.removeKeyListener(this);
            this.treeView.removeKeyListener((KeyListener)this);
        }
    }

    public void showOutputWindow() {
        this.tabbedPane.setSelectedIndex(1);
    }

    public void showSettingsTab() {
        this.tabbedPane.setSelectedIndex(0);
    }

    public void expandAll(BrowserTreeNode browserTreeNode) {
        this.treeView.expandNode(browserTreeNode);
    }

    public int[] getTreeSelectionRows() {
        return this.treeView.getSelectionRows();
    }

    public int getTreeRowCount() {
        return this.treeView.getRowCount();
    }

    public TreePath getSelectedTreePath() {
        return this.treeView.getSelectionPath();
    }

    public int getSelectedTreePathIndex() {
        return this.treeView.getRowForPath(this.getSelectedTreePath()) - 1;
    }

    public void editNode(BrowserTreeNode browserTreeNode) {
        this.treeView.startEditingAtPath(new TreePath(browserTreeNode.getPath()));
    }

    public void reset() {
        this.stepsListBox.setSelectedIndex(0);
        this.enableStepPanel(false);
    }

    protected void closeWindow() {
        this.outputWindow.cleanup();
        this.treeView.removeTreeViewEditorListener((TreeViewEditorListener)this.client);
        this.browser.closeBrowserWindow();
        tool = null;
    }

    public Component getHtmlComponent() {
        return this.outputWindow.getHtmlComponent();
    }

    public void clearOutput() {
        this.outputWindow.clearOutput();
    }

    public boolean hasOutputText() {
        return this.outputWindow.hasOutputText();
    }

    public void printOutput() {
        this.outputWindow.print();
    }

    public void saveOutput() {
        this.outputWindow.save(this.client.getBrowserFrame());
    }

    public String getOutputVerbosity() {
        return this.outputWindow.getOutputVerbosity();
    }

    public void setOutputVerbosity(String string) {
        this.outputWindow.setOutputVerbosity(string);
    }

    public boolean reportWarnings() {
        return this.outputWindow.reportWarnings();
    }

    public boolean isDirty() {
        return this.outputWindow.isDirty();
    }

    public void resetDirtyFlag() {
        this.outputWindow.resetDirtyFlag();
    }

    public static boolean createTestNotFoundDialog(String string) {
        String string2 = "Test " + string + " does not exist.  Do you want to create it?";
        String string3 = "MATLAB Instrument Driver Testing Tool";
        String string4 = Instrument.getPreferenceFile().read("TestToolCreateTestsDontExist");
        DTFrame dTFrame = MLDesktop.getInstance().getMainFrame();
        int n = Boolean.valueOf(string4) != false ? 0 : 1;
        boolean bl = 0 == Dialogs.showOptionalConfirmDialog((Component)dTFrame, (Object)string2, (String)string3, (int)0, (int)3, (String)"InstrumentControl_MIDTEST_DNE_Prompt", (int)n, (boolean)true);
        Instrument.getPreferenceFile().update("TestToolCreateTestsDontExist", Boolean.valueOf(bl).toString());
        return bl;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class StepListBoxRenderer
    extends DefaultListCellRenderer {
        public static final long serialVersionUID = 0L;

        StepListBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            this.setIcon(MIDTestToolClient.STEP_ICONS[n]);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            return this;
        }
    }
}

