/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml.property;

import com.mathworks.beans.EnumPair;
import com.mathworks.jmi.AutoConvertStringToMatlabChar;
import com.mathworks.jmi.MatlabStructure;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.instrument.device.PropertyInfo;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.drivers.xml.XMLDriver;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.BooleanProperty;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.DoubleBoundedProperty;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.DoubleEnumProperty;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.DoubleProperty;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.ObjectProperty;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyConstraint;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.StringEnumProperty;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.StringProperty;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public class PropertyDefinition
extends PropertyInfo
implements MatlabStructure,
AutoConvertStringToMatlabChar {
    protected static final String[] TYPES = new String[]{"double", "string", "boolean", "double&string", "object"};
    protected static final String[] CONSTRAINTS = new String[]{"bounded", "enum", "none", "bounded&enum"};
    public static final int DOUBLE = 0;
    public static final int STRING = 1;
    public static final int BOOLEAN = 2;
    public static final int DOUBLESTRING = 3;
    public static final int OBJECT = 4;
    public static final int BOUNDED = 0;
    public static final int ENUM = 1;
    public static final int NONE = 2;
    public static final int BOUNDEDENUM = 3;
    public String capabilityGroup;
    public String configureCommand = "";
    public String queryCommand = "";
    public String description;
    public String location = "parent";
    public PropertyConstraint[] constraints;
    public Object currentValue;
    public Object[] currentValueArray = null;
    private String typeOfProperty = "InstrumentCommand";
    private boolean isMCode = false;
    private String setMCode;
    private String getMCode;
    private boolean isGroup = false;

    public PropertyDefinition(String string, String string2) {
        super.setName(string);
        this.capabilityGroup = string2;
        this.interfaceSpecific = 1;
    }

    public void setIsGroupProperty(boolean bl) {
        this.isGroup = bl;
    }

    public boolean isGroupProperty() {
        return this.isGroup;
    }

    public void setCapabilityGroup(String string) {
        this.capabilityGroup = string;
    }

    public void setTypeOfProperty(String string) {
        this.typeOfProperty = string;
        this.isMCode = this.typeOfProperty.toLowerCase().equals("mcode");
    }

    public String getTypeOfProperty() {
        return this.typeOfProperty;
    }

    public boolean isPropertyTypeMCode() {
        return this.isMCode;
    }

    public void setSetMCodeToEvaluate(String string) {
        this.setMCode = string;
    }

    public String getSetMCodeToEvaluate() {
        return this.setMCode;
    }

    public void setGetMCodeToEvaluate(String string) {
        this.getMCode = string;
    }

    public String getGetMCodeToEvaluate() {
        return this.getMCode;
    }

    public int getType() {
        if (this.containsMultipleConstraints()) {
            return 3;
        }
        if (this.constraints == null) {
            return 4;
        }
        return this.constraints[0].getType();
    }

    public void setCurrentValue(Object object) {
        this.currentValue = object;
    }

    public void setCurrentValue(Object object, int n) {
        this.currentValue = object;
        if (this.currentValueArray == null) {
            this.currentValueArray = new Object[n + 1];
        } else if (this.currentValueArray.length <= n) {
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(this.currentValueArray, 0, objectArray, 0, this.currentValueArray.length);
            this.currentValueArray = objectArray;
        }
        this.currentValueArray[n] = object;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public Object getDisplayValue(XMLDriver xMLDriver, String string, int n) {
        if (this.currentValueArray != null && this.currentValueArray.length > n) {
            this.currentValue = this.currentValueArray[n];
        } else {
            this.setCurrentValue(this.getOutputValue((String)this.getDefaultValue()));
            this.currentValue = this.getOutputValue((String)this.getDefaultValue());
        }
        return this.getDisplayValue(xMLDriver, string);
    }

    public Object getDisplayValue(XMLDriver xMLDriver, String string) {
        if (this.isEnumAndValueAttribute()) {
            try {
                if (!(this.currentValue instanceof String)) {
                    return this.currentValue;
                }
                String string2 = ((String)this.currentValue).toLowerCase();
                Object[] objectArray = this.getValidRange(xMLDriver, string);
                if (string2.equals("min")) {
                    this.currentValue = objectArray[0];
                    return objectArray[0];
                }
                if (string2.equals("max")) {
                    this.currentValue = objectArray[1];
                    return objectArray[1];
                }
                this.currentValue = this.getOutputValue(string2);
            }
            catch (Exception exception) {
                return this.currentValue;
            }
        } else if (this.currentValue instanceof String) {
            this.currentValue = this.getOutputValue((String)this.currentValue);
        }
        return this.currentValue;
    }

    public Object getOutputValue(String string) {
        try {
            switch (this.getType()) {
                case 0: {
                    return new Double(string);
                }
                case 3: {
                    return this.getOutputValueForMultipleConstraintsProperty(string);
                }
                case 1: {
                    return this.constraints[0].getEnum(string);
                }
                case 2: {
                    return this.constraints[0].getEnum(string);
                }
                case 4: {
                    return this.constraints[0].getValidValue(string);
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    private Object getOutputValueForMultipleConstraintsProperty(String string) {
        try {
            Double d = new Double(string);
            if (d != null) {
                return d;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        block7: for (int i = 0; i < this.constraints.length; ++i) {
            PropertyConstraint propertyConstraint = this.constraints[i];
            switch (propertyConstraint.getType()) {
                case 1: {
                    String string2 = propertyConstraint.getEnum(string);
                    if (string2 == null) continue block7;
                    return string2;
                }
                case 2: {
                    if (!propertyConstraint.isValidValue(string)) continue block7;
                    return propertyConstraint.getEnum(string);
                }
                case 4: {
                    if (!propertyConstraint.isValidValue(string)) continue block7;
                    return propertyConstraint.getValidValue(string);
                }
            }
        }
        return string;
    }

    public int getConstraint() {
        if (this.isEnumAndValueAttribute()) {
            return 3;
        }
        if (this.constraints == null) {
            return 2;
        }
        return this.constraints[0].getConstraint();
    }

    public void setConfigureCommand(String string) {
        this.configureCommand = string;
        if (this.queryCommand.equals("")) {
            this.queryCommand = this.configureCommand + "?";
            this.queryCommand = TMStringUtil.strrep((String)this.queryCommand, (String)" %s", (String)"");
            this.queryCommand = TMStringUtil.strrep((String)this.queryCommand, (String)"%s", (String)"");
        }
    }

    public String getConfigureCommand() {
        return this.configureCommand;
    }

    public void setQueryCommand(String string) {
        this.queryCommand = string;
    }

    public String getQueryCommand() {
        return this.queryCommand;
    }

    public void setDefaultValue(String string) {
        super.setDefaultValue(string);
    }

    public Object getDriverDefinedDefalutValue() {
        return this.defaultValue;
    }

    @Override
    public Object getDefaultValue() {
        Object object = this.defaultValue;
        if (object != null && this.isDefaultValueValid(object)) {
            return object;
        }
        if (this.constraints == null || this.constraints.length == 0) {
            return null;
        }
        return this.constraints[0].getDefaultValue();
    }

    public boolean isDefaultValueValid(Object object) {
        if (this.constraints == null) {
            return true;
        }
        boolean bl = false;
        for (int i = 0; i < this.constraints.length; ++i) {
            PropertyConstraint propertyConstraint = this.constraints[i];
            bl = propertyConstraint.isValidValue(object);
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getLocation() {
        return this.location;
    }

    public Object[] getValidRange(XMLDriver xMLDriver, String string) {
        if (this.getConstraint() != 0 && this.getConstraint() != 3) {
            return null;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            PropertyConstraint propertyConstraint = this.constraints[i];
            if (propertyConstraint.getType() != 0 || propertyConstraint.getConstraint() != 0) continue;
            if (propertyConstraint.isDependent()) {
                String string2;
                String string3 = propertyConstraint.getDependentPropertyName();
                if (!xMLDriver.isValidConstraint(string3, string2 = this.getDependentPropertyLocation(propertyConstraint, xMLDriver), propertyConstraint.getDependentPropertyValue())) continue;
                return propertyConstraint.getConstraintValues();
            }
            return propertyConstraint.getConstraintValues();
        }
        return null;
    }

    public boolean isValidValue(Object object, String string, XMLDriver xMLDriver) {
        PropertyConstraint propertyConstraint;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < this.constraints.length; ++n) {
            propertyConstraint = this.constraints[n];
            if (propertyConstraint.isDependent() && (bl2 = xMLDriver.isValidConstraint(propertyConstraint.getDependentPropertyName(), this.getDependentPropertyLocation(propertyConstraint, xMLDriver), propertyConstraint.getDependentPropertyValue()))) {
                bl = propertyConstraint.isValidValue(object);
            }
            if (bl) {
                return bl;
            }
            if (bl2) break;
        }
        for (n = 0; n < this.constraints.length; ++n) {
            propertyConstraint = this.constraints[n];
            if (!propertyConstraint.isDependent()) {
                bl = propertyConstraint.isValidValue(object);
            }
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    public Object getValidValue(Object object) {
        for (int i = 0; i < this.constraints.length; ++i) {
            PropertyConstraint propertyConstraint = this.constraints[i];
            if (!propertyConstraint.isValidValue(object)) continue;
            return propertyConstraint.getValidValue(object);
        }
        return object;
    }

    private String getDependentPropertyLocation(PropertyConstraint propertyConstraint, XMLDriver xMLDriver) {
        String string = propertyConstraint.getDependentPropertyLocation();
        if (!string.equals("")) {
            return string;
        }
        string = xMLDriver.findLocationOfProperty(propertyConstraint.getDependentPropertyName());
        propertyConstraint.setDependentPropertyLocation(string);
        return string;
    }

    public PropertyConstraint createConstraint(String string, String string2) {
        if (this.constraints == null) {
            return this.createConstraint(string, string2, 0);
        }
        return this.createConstraint(string, string2, this.constraints.length);
    }

    public PropertyConstraint createConstraint(String string, String string2, int n) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        PropertyConstraint propertyConstraint = null;
        if (string.equals("string")) {
            propertyConstraint = string2.equals("enum") ? new StringEnumProperty() : new StringProperty();
        } else if (string.equals("double")) {
            propertyConstraint = string2.equals("enum") ? new DoubleEnumProperty() : (string2.equals("bounded") ? new DoubleBoundedProperty() : new DoubleProperty());
        } else if (string.equals("boolean")) {
            propertyConstraint = new BooleanProperty();
        } else if (string.equals("object")) {
            propertyConstraint = new ObjectProperty();
        }
        this.insertConstraint(propertyConstraint, n);
        return propertyConstraint;
    }

    private void insertConstraint(PropertyConstraint propertyConstraint, int n) {
        int n2;
        int n3 = n + 1;
        int n4 = 1;
        if (this.constraints != null) {
            n4 = this.constraints.length + 1;
        }
        PropertyConstraint[] propertyConstraintArray = new PropertyConstraint[n4];
        for (n2 = 0; n2 < n; ++n2) {
            propertyConstraintArray[n2] = this.constraints[n2];
        }
        propertyConstraintArray[n] = propertyConstraint;
        n2 = 0;
        for (int i = n3; i < n4; ++i) {
            propertyConstraintArray[i] = this.constraints[n + ++n2 - 1];
        }
        this.constraints = null;
        this.constraints = propertyConstraintArray;
    }

    public void removeConstraint(PropertyConstraint propertyConstraint) {
        if (this.constraints == null) {
            return;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            if (this.constraints[i] != propertyConstraint) continue;
            this.removeConstraint(i);
            return;
        }
    }

    public void removeConstraint(int n) {
        int n2;
        int n3 = this.constraints.length - 1;
        PropertyConstraint[] propertyConstraintArray = new PropertyConstraint[n3];
        for (n2 = 0; n2 < n; ++n2) {
            propertyConstraintArray[n2] = this.constraints[n2];
        }
        for (n2 = n; n2 < n3; ++n2) {
            propertyConstraintArray[n2] = this.constraints[n2 + 1];
        }
        this.constraints = null;
        this.constraints = propertyConstraintArray;
    }

    public EnumPair[] getEnumPair() {
        if (this.constraints == null) {
            return null;
        }
        for (int i = 0; i < this.constraints.length; ++i) {
            switch (this.constraints[i].getType()) {
                case 1: {
                    if (this.constraints[i].getConstraint() == 1) {
                        return this.constraints[i].getEnumPair();
                    }
                    return null;
                }
                case 2: {
                    return this.constraints[i].getEnumPair();
                }
            }
        }
        return null;
    }

    public boolean isEnumAndValueAttribute() {
        if (this.constraints == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        block5: for (int i = 0; i < this.constraints.length; ++i) {
            switch (this.constraints[i].getType()) {
                case 1: {
                    if (this.constraints[i].getConstraint() != 1) continue block5;
                    bl = true;
                    continue block5;
                }
                case 2: {
                    bl = true;
                    continue block5;
                }
                case 0: {
                    bl2 = true;
                }
            }
        }
        return bl2 && bl;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWriteable() {
        return !this.readOnly.equals("always");
    }

    public boolean isDeprecated() {
        return false;
    }

    public String getPropertyType() {
        switch (this.getType()) {
            case 0: {
                return "double";
            }
            case 2: {
                return "java.lang.String";
            }
            case 1: {
                return "java.lang.String";
            }
            case 3: {
                return "java.lang.Object";
            }
            case 4: {
                return "java.lang.Object";
            }
        }
        return "java.lang.Object";
    }

    public void definePropInfoFields() {
        super.setType(TYPES[this.getPropInfoType()]);
        super.setConstraint(CONSTRAINTS[this.getPropInfoConstraint()]);
    }

    private int getPropInfoType() {
        if (this.isEnumAndValueAttribute()) {
            return 3;
        }
        if (this.constraints == null) {
            return 0;
        }
        int n = this.constraints[0].getType();
        if (n == 2) {
            return 1;
        }
        return n;
    }

    private int getPropInfoConstraint() {
        if (this.isEnumAndValueAttribute()) {
            return 3;
        }
        if (this.constraints == null) {
            return 2;
        }
        if (this.constraints[0].getType() == 2) {
            return 1;
        }
        return this.constraints[0].getConstraint();
    }

    public void setRawPropertyConstraints(PropertyConstraint[] propertyConstraintArray) {
        this.constraints = propertyConstraintArray;
    }

    public PropertyConstraint[] getRawPropertyConstraint() {
        return this.constraints;
    }

    public int getNumberOfEnums() {
        int n = 0;
        for (int i = 0; i < this.constraints.length; ++i) {
            if (!(this.constraints[i] instanceof StringEnumProperty)) continue;
            n += this.constraints[i].getConstraintValues().length;
        }
        return n;
    }

    public PropertyConstraint[] getValidConstraints(Parser parser) {
        if (this.constraints == null || this.constraints.length == 0) {
            return null;
        }
        Vector<PropertyConstraint> vector = new Vector<PropertyConstraint>();
        for (int i = 0; i < this.constraints.length; ++i) {
            PropertyConstraint propertyConstraint = this.constraints[i];
            if (!propertyConstraint.isDependent()) {
                vector.addElement(propertyConstraint);
                continue;
            }
            String string = propertyConstraint.getDependentPropertyName();
            String string2 = this.getDependentPropertyLocation(propertyConstraint, parser);
            String string3 = propertyConstraint.getDependentPropertyValue();
            PropertyDefinition propertyDefinition = (PropertyDefinition)parser.getPropertyInformation(string, string2);
            if (propertyDefinition != null && propertyDefinition.getCurrentValue().equals(propertyDefinition.getOutputValue(string3))) {
                vector.addElement(propertyConstraint);
                continue;
            }
            if (propertyDefinition != null) continue;
            MJOptionPane.showMessageDialog(null, (Object)("The dependent property " + string + " was not found while saving the " + this.name + " property in the " + this.location + " group."), (String)"Property Constraints", (int)0);
        }
        PropertyConstraint[] propertyConstraintArray = new PropertyConstraint[vector.size()];
        int n = 0;
        while (vector.size() > 0) {
            propertyConstraintArray[n++] = (PropertyConstraint)vector.elementAt(0);
            vector.removeElementAt(0);
        }
        return propertyConstraintArray;
    }

    private String getDependentPropertyLocation(PropertyConstraint propertyConstraint, Parser parser) {
        String string = propertyConstraint.getDependentPropertyLocation();
        if (!string.equals("")) {
            return string;
        }
        string = parser.findLocationOfProperty(propertyConstraint.getDependentPropertyName());
        propertyConstraint.setDependentPropertyLocation(string);
        return string;
    }

    public void configurePropInfo(XMLDriver xMLDriver) {
        super.setType(TYPES[this.getPropInfoType(xMLDriver)]);
        super.setConstraint(CONSTRAINTS[this.getPropInfoConstraint(xMLDriver)]);
        super.setConstraintValue(this.getPropInfoConstraintValues(xMLDriver));
        super.setDefaultValue(this.getDefaultValue());
    }

    public boolean containsMultipleConstraints(XMLDriver xMLDriver) {
        PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
        if (propertyConstraintArray == null || propertyConstraintArray.length == 0) {
            return false;
        }
        return propertyConstraintArray.length > 1;
    }

    public boolean containsMultipleConstraints() {
        if (this.constraints == null) {
            return false;
        }
        return this.constraints.length > 1;
    }

    public boolean isCompoundProperty(XMLDriver xMLDriver) {
        int n;
        PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
        if (propertyConstraintArray == null || propertyConstraintArray.length <= 1) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        block6: for (n = 0; n < propertyConstraintArray.length; ++n) {
            switch (propertyConstraintArray[n].getType()) {
                case 1: {
                    if (propertyConstraintArray[n].getConstraint() == 1) {
                        bl2 = true;
                        continue block6;
                    }
                    bl = true;
                    continue block6;
                }
                case 2: {
                    bl2 = true;
                    continue block6;
                }
                case 0: {
                    if (propertyConstraintArray[n].getConstraint() == 0) {
                        ++n2;
                    }
                    bl3 = true;
                }
                case 4: {
                    bl4 = true;
                }
            }
        }
        n = 0;
        if (bl2) {
            ++n;
        }
        if (bl) {
            ++n;
        }
        if (bl3) {
            ++n;
        }
        if (bl4) {
            ++n;
        }
        if (n >= 2) {
            return true;
        }
        return n2 >= 2;
    }

    public Object[] getCompoundConstraints(XMLDriver xMLDriver) {
        int n;
        Object[] objectArray;
        PropertyConstraint propertyConstraint;
        int n2;
        PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
        Vector<PropertyConstraint> vector = new Vector<PropertyConstraint>();
        Vector<PropertyConstraint> vector2 = new Vector<PropertyConstraint>();
        Vector<PropertyConstraint> vector3 = new Vector<PropertyConstraint>();
        Vector<PropertyConstraint> vector4 = new Vector<PropertyConstraint>();
        block6: for (int i = 0; i < propertyConstraintArray.length; ++i) {
            switch (propertyConstraintArray[i].getType()) {
                case 1: {
                    if (propertyConstraintArray[i].getConstraint() == 1) {
                        vector2.addElement(propertyConstraintArray[i]);
                        continue block6;
                    }
                    vector.addElement(propertyConstraintArray[i]);
                    continue block6;
                }
                case 2: {
                    vector2.addElement(propertyConstraintArray[i]);
                    continue block6;
                }
                case 0: {
                    vector3.addElement(propertyConstraintArray[i]);
                    continue block6;
                }
                case 4: {
                    vector4.addElement(propertyConstraintArray[i]);
                }
            }
        }
        Vector<Object> vector5 = new Vector<Object>();
        boolean bl = false;
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            propertyConstraint = (PropertyConstraint)vector3.elementAt(n2);
            if (propertyConstraint.getConstraint() == 0) {
                vector5.addElement(propertyConstraint.getConstraintValues());
                continue;
            }
            if (propertyConstraint.getConstraint() == 1) {
                objectArray = propertyConstraint.getConstraintValues();
                for (n = 0; n < objectArray.length; ++n) {
                    vector5.addElement(objectArray[n]);
                }
                continue;
            }
            bl = true;
            break;
        }
        if (bl) {
            vector5.removeAllElements();
            vector5.add("All doubles");
        }
        if (vector.size() > 0) {
            vector5.addElement("All strings");
        }
        if (vector.size() == 0) {
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                propertyConstraint = (PropertyConstraint)vector2.elementAt(n2);
                objectArray = propertyConstraint.getConstraintValues();
                for (n = 0; n < objectArray.length; ++n) {
                    vector5.addElement(objectArray[n]);
                }
            }
        }
        if (vector4.size() > 0) {
            vector5.addElement("All objects");
        }
        Object[] objectArray2 = new Object[vector5.size()];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = vector5.elementAt(i);
        }
        return objectArray2;
    }

    public int getPropInfoType(XMLDriver xMLDriver) {
        if (this.isCompoundProperty(xMLDriver)) {
            return 3;
        }
        PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
        if (propertyConstraintArray == null || propertyConstraintArray.length == 0) {
            return 0;
        }
        int n = propertyConstraintArray[0].getType();
        if (n == 2) {
            return 1;
        }
        return n;
    }

    public int getPropInfoConstraint(XMLDriver xMLDriver) {
        if (!this.isCompoundProperty(xMLDriver)) {
            PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
            if (propertyConstraintArray == null || propertyConstraintArray.length == 0) {
                return 2;
            }
            return propertyConstraintArray[0].getConstraint();
        }
        Object[] objectArray = this.getCompoundConstraints(xMLDriver);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i].equals("All strings")) {
                bl2 = true;
                continue;
            }
            if (objectArray[i].equals("All doubles")) {
                bl = true;
                continue;
            }
            if (objectArray[i] instanceof String || objectArray[i] instanceof Double) {
                bl3 = true;
                continue;
            }
            if (!(objectArray[i] instanceof Object[])) continue;
            bl4 = true;
        }
        if (bl && bl2) {
            return 2;
        }
        if (bl && bl3) {
            return 1;
        }
        if (bl4 && bl3) {
            return 3;
        }
        if (bl2 && bl3) {
            return 1;
        }
        if (bl4 && bl2) {
            return 0;
        }
        if (bl4) {
            return 0;
        }
        if (bl3) {
            return 1;
        }
        return 2;
    }

    public Object[] getPropInfoConstraintValues(XMLDriver xMLDriver) {
        if (!this.containsMultipleConstraints(xMLDriver)) {
            PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
            if (propertyConstraintArray == null || propertyConstraintArray.length == 0) {
                return null;
            }
            return propertyConstraintArray[0].getConstraintValues();
        }
        Object[] objectArray = this.getCompoundConstraints(xMLDriver);
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object.equals("All strings") || object.equals("All doubles")) continue;
            vector.addElement(object);
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray2 = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray2[i] = vector.elementAt(i);
        }
        return objectArray2;
    }

    public String getSetList(XMLDriver xMLDriver) {
        String string;
        PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
        if (propertyConstraintArray == null || propertyConstraintArray.length == 0) {
            return "";
        }
        String string2 = "";
        int n = 0;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            if (propertyConstraintArray[i].getConstraint() == 1) {
                vector.addElement(propertyConstraintArray[i].getSetList());
                continue;
            }
            String string3 = propertyConstraintArray[i].getSetList();
            if (string3.equals("")) continue;
            ++n;
            string2 = string2 + propertyConstraintArray[i].getSetList() + " -or- ";
        }
        if (n > 0) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        if ((string = this.combineEnumsForSetList(vector)).length() == 0) {
            string2 = this.addCurlyBracesAroundDefaultValue(string2);
            return string2;
        }
        if (string2.equals("")) {
            string = this.addCurlyBracesAroundDefaultValue(string);
            return string;
        }
        string2 = string + " -or- " + string2;
        string2 = this.addCurlyBracesAroundDefaultValue(string2);
        return string2;
    }

    private String addCurlyBracesAroundDefaultValue(String string) {
        String string2 = this.getDefaultValue().toString();
        int n = string.indexOf(string2 + " ");
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(string2 + " to");
        if (n2 == n) {
            return string;
        }
        n2 = string.indexOf("to " + string2);
        if (n2 != -1 && n2 + 3 == n) {
            return string;
        }
        if (TMStringUtil.isOnlyWhiteSpace((String)string2)) {
            return string;
        }
        string = TMStringUtil.strrep((String)string, (String)(" " + string2 + " "), (String)(" {" + string2 + "} "));
        return string;
    }

    public String getErrorMessage(XMLDriver xMLDriver) {
        String string = "Invalid value for " + this.name;
        string = string + "\n" + this.getSetError(xMLDriver);
        return string;
    }

    public String getSetError(XMLDriver xMLDriver) {
        String string;
        PropertyConstraint[] propertyConstraintArray = this.getValidConstraints(xMLDriver);
        if (propertyConstraintArray == null || propertyConstraintArray.length == 0) {
            return "";
        }
        String string2 = "";
        int n = 0;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < propertyConstraintArray.length; ++i) {
            if (propertyConstraintArray[i].getConstraint() == 1) {
                vector.addElement(propertyConstraintArray[i].getSetError());
                continue;
            }
            String string3 = propertyConstraintArray[i].getSetError();
            if (string3.equals("")) continue;
            ++n;
            string2 = string2 + propertyConstraintArray[i].getSetError() + " or ";
        }
        if (n > 0) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        if ((string = this.combineEnumsForSetError(vector)).length() == 0) {
            return "Valid values: " + string2 + ".";
        }
        if (string2.equals("")) {
            return "Valid values: " + string + ".";
        }
        return "Valid values: " + string + " or " + string2 + ".";
    }

    private String combineEnumsForSetList(Vector<String> vector) {
        if (vector.size() == 0) {
            return "";
        }
        if (vector.size() == 1) {
            return vector.elementAt(0);
        }
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.elementAt(i);
            string = string + string2.substring(1, string2.length() - 1) + "|";
        }
        return "[" + string.substring(0, string.length() - 1) + "]";
    }

    private String combineEnumsForSetError(Vector<String> vector) {
        if (vector.size() == 0) {
            return "";
        }
        if (vector.size() == 1) {
            return vector.elementAt(0);
        }
        String string = "";
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = vector.elementAt(i);
            string = string + string2 + ", ";
        }
        return string.substring(0, string.length() - 2);
    }

    public PropertyConstraint[] getValidConstraints(XMLDriver xMLDriver) {
        if (this.constraints == null || this.constraints.length == 0) {
            return null;
        }
        Vector<PropertyConstraint> vector = new Vector<PropertyConstraint>();
        for (int i = 0; i < this.constraints.length; ++i) {
            PropertyConstraint propertyConstraint = this.constraints[i];
            if (!propertyConstraint.isDependent()) {
                vector.addElement(propertyConstraint);
                continue;
            }
            boolean bl = xMLDriver.isValidConstraint(propertyConstraint.getDependentPropertyName(), this.getDependentPropertyLocation(propertyConstraint, xMLDriver), propertyConstraint.getDependentPropertyValue());
            if (!bl) continue;
            vector.addElement(propertyConstraint);
        }
        PropertyConstraint[] propertyConstraintArray = new PropertyConstraint[vector.size()];
        int n = 0;
        while (vector.size() > 0) {
            propertyConstraintArray[n++] = (PropertyConstraint)vector.elementAt(0);
            vector.removeElementAt(0);
        }
        return propertyConstraintArray;
    }
}

