/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.browser.objects.TCPIPObject;
import com.mathworks.toolbox.instrument.browser.objects.UDPObject;
import com.mathworks.toolbox.instrument.guiutil.MatrixTableModel;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.guiutil.RangeTextField;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public class NetworkPage
extends InstrumentControlBrowserPage
implements ActionListener,
KeyListener {
    static final long serialVersionUID = 0L;
    public static final int TCPIP = 0;
    public static final int UDP = 1;
    public static final String[] TYPES = new String[]{"TCPIP", "UDP"};
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int IDENTIFY = 2;
    private static final int OK = 3;
    private static final int CLOSE = 4;
    private String[] headings = new String[]{"Address", "Port", "Identification", "Date Added On"};
    private Object[][] data;
    private InstrumentControlBrowser browser;
    private String[] path = new String[]{"Instrument Control Toolbox", "Hardware", ""};
    private MatrixTableModel tableModel;
    private DefaultSortableTable table;
    private JButton identifyButton;
    private JButton removeButton;
    private JButton addButton;
    private JButton okDialog;
    private JButton addDialog;
    private JButton closeDialog;
    private JTextField address;
    private RangeTextField port;
    private JTextField oldAddress;
    private RangeTextField oldPort;
    private boolean disableOnStart = false;
    private boolean enableOnFinish = false;
    private Object[] matlabArgs;
    private int type;
    private String protocolType;
    private MJDialog dialog;
    private IdentifyNetworkRunnable identifyNetworkRunnable = null;

    public NetworkPage(int n, InstrumentControlBrowser instrumentControlBrowser) {
        this.type = n;
        this.protocolType = TYPES[this.type];
        this.browser = instrumentControlBrowser;
        this.path[2] = this.protocolType;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel();
        this.matlabArgs = new Object[3];
        this.matlabArgs[0] = "privateBrowserHelper";
        this.matlabArgs[1] = "identify" + this.protocolType + "Instruments";
        this.cleanup();
    }

    @Override
    public void setup() {
        this.identifyButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.port.addKeyListener((KeyListener)this);
    }

    @Override
    public void cleanup() {
        this.identifyButton.removeActionListener(this);
        this.removeButton.removeActionListener(this);
        this.addButton.removeActionListener(this);
        this.port.removeKeyListener((KeyListener)this);
    }

    @Override
    public void dispose() {
        this.cleanup();
        this.data = null;
        this.headings = null;
        this.path = null;
    }

    public void cleanupDialog() {
        this.closeDialog.removeActionListener(this);
        this.addDialog.removeActionListener(this);
        this.okDialog.removeActionListener(this);
        this.port.removeKeyListener((KeyListener)this);
        this.address = this.oldAddress;
        this.port = this.oldPort;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        if (this.data == null) {
            return;
        }
        for (int i = 0; i < this.data.length; ++i) {
            Element element2 = browserConfigFileWriter.addNode(element, "Instrument");
            element2.setAttribute("Type", this.protocolType);
            element2.setAttribute("Address", (String)this.data[i][0]);
            element2.setAttribute("Port", (String)this.data[i][1]);
            element2.setAttribute("Identification", (String)this.data[i][2]);
            element2.setAttribute("LastScanDate", (String)this.data[i][3]);
        }
    }

    public void load(String string, String string2, Element element) {
        String string3 = element.getAttribute("Address");
        String string4 = element.getAttribute("Port");
        this.addToTableData(string3, string4, string, string2);
        String string5 = this.getNodeName(string3, string4);
        this.createNode(string5, string3, string4, string, string2);
        this.updateButtonState();
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add(jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(6, 0));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Add new " + this.protocolType + " instrument"));
        jPanel2 = this.createAddBox(jPanel2);
        Object[] objectArray = new Object[]{"Add", new Integer(0)};
        jPanel2.add((Component)this.createButtonPanel(objectArray), "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.setBorder(BorderFactory.createTitledBorder("Available " + this.protocolType + " instruments"));
        this.add(jPanel3, "Center");
        this.tableModel = new MatrixTableModel(this.headings);
        this.table = new DefaultSortableTable((TableModel)this.tableModel);
        this.table.setName("Network Table");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(200);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        jScrollPane.setPreferredSize(new Dimension(50, 50));
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel3.add((Component)jPanel4, "Center");
        Object[] objectArray2 = new Object[]{"Identify", new Integer(2), "Remove", new Integer(1)};
        jPanel3.add((Component)this.createButtonPanel(objectArray2), "South");
        this.updateButtonState();
    }

    private JPanel createAddBox(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        if (this.type == 1) {
            jPanel2.add(new JLabel("Address (optional):"));
        } else {
            jPanel2.add(new JLabel("Address:"));
        }
        jPanel2.add(new JLabel("Port (optional):"));
        jPanel.add((Component)jPanel2, "West");
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 0, 2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.address = new JTextField();
        this.port = new RangeTextField("Port", 1.0, 65535.0, "");
        this.port.setOKToBeEmpty(true);
        this.port.addKeyListener((KeyListener)this);
        this.address.setName("Address Textfield");
        this.port.setName("Port Textfield");
        jPanel3.add(this.address);
        jPanel3.add((Component)this.port);
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private JPanel createButtonPanel(Object[] objectArray) {
        JPanel jPanel = new JPanel(new FlowLayout(2, 3, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, objectArray.length / 2, 5, 0));
        for (int i = 0; i < objectArray.length; i += 2) {
            JButton jButton = new JButton((String)objectArray[i]);
            jButton.addActionListener(this);
            jButton.putClientProperty("ACTION", objectArray[i + 1]);
            jButton.setName(jButton.getText() + " Button");
            if (jButton.getText().equals("Identify")) {
                this.identifyButton = jButton;
            } else if (jButton.getText().equals("Remove")) {
                this.removeButton = jButton;
            } else if (jButton.getText().equals("Add")) {
                this.addButton = jButton;
            }
            jPanel2.add(jButton);
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    public void showAddBox(MJFrame mJFrame) {
        int n;
        this.browser.postStatusBarUpdateEvent("Adding new " + this.protocolType + " instrument");
        this.dialog = new MJDialog((Frame)mJFrame, "Add new " + this.protocolType + " instrument", true);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout(6, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.oldAddress = this.address;
        this.oldPort = this.port;
        jPanel2 = this.createAddBox(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 3, 5));
        JPanel jPanel4 = new JPanel(new GridLayout(1, 3, 5, 0));
        this.okDialog = new JButton("OK");
        this.okDialog.addActionListener(this);
        this.okDialog.putClientProperty("ACTION", new Integer(3));
        this.okDialog.setName("OKButton");
        this.addDialog = new JButton("Add");
        this.addDialog.addActionListener(this);
        this.addDialog.putClientProperty("ACTION", new Integer(0));
        this.addDialog.setName("AddButton");
        this.closeDialog = new JButton("Close");
        this.closeDialog.addActionListener(this);
        this.closeDialog.putClientProperty("ACTION", new Integer(4));
        this.closeDialog.setName("CloseButton");
        jPanel4.add(this.okDialog);
        jPanel4.add(this.addDialog);
        jPanel4.add(this.closeDialog);
        jPanel3.add(jPanel4);
        jPanel2.add((Component)jPanel3, "South");
        jPanel.add((Component)jPanel2, "North");
        this.dialog.getContentPane().add(jPanel);
        this.dialog.setSize(300, 119);
        this.dialog.setResizable(false);
        Rectangle rectangle = mJFrame.getBounds();
        int n2 = rectangle.x + rectangle.width / 2 - 100;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = rectangle.y + rectangle.height / 2 - 75) < 0) {
            n = 0;
        }
        this.dialog.setLocation(n2, n);
        this.dialog.show();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JComponent)actionEvent.getSource()).getClientProperty("ACTION");
        switch (n) {
            case 0: {
                this.addRow();
                this.updateButtonState();
                break;
            }
            case 1: {
                this.removeFromTableData();
                this.updateButtonState();
                break;
            }
            case 2: {
                this.identify();
                break;
            }
            case 3: {
                if (!this.isAdded()) {
                    this.addRow();
                }
            }
            case 4: {
                this.browser.postStatusBarUpdateEvent("Ready");
                this.cleanupDialog();
                this.dialog.dispose();
                this.updateButtonState();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (!this.port.isValidValue()) {
                this.port.error();
                return;
            }
            this.addButton.doClick();
        }
    }

    private void updateButtonState() {
        int n = this.tableModel.getRowCount();
        if (n == 0) {
            this.removeButton.setEnabled(false);
            this.identifyButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.identifyButton.setEnabled(true);
        }
    }

    public boolean okToIdentify() {
        return this.data != null;
    }

    public void identify() {
        this.identify(true, true);
    }

    public void identify(boolean bl, boolean bl2) {
        this.disableOnStart = bl;
        this.enableOnFinish = bl2;
        if (this.data == null) {
            if (this.enableOnFinish) {
                this.browser.postBlockEventsEvent(false);
            }
            this.browser.postRefreshFinishedEvent();
            return;
        }
        String[] stringArray = new String[this.data.length * 2];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            stringArray[n++] = (String)this.data[i][0];
            stringArray[n++] = (String)this.data[i][1];
        }
        this.matlabArgs[2] = stringArray;
        this.getGUIReadyForMATLABCall();
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        this.identify(bl, bl2);
    }

    public void getGUIReadyForMATLABCall() {
        if (this.disableOnStart) {
            this.browser.postBlockEventsEvent(true);
        }
        this.browser.postStatusBarUpdateEvent("Identifying " + TYPES[this.type] + " instruments");
        Instrument.enableInstrumentObjectEvents(false);
        if (this.identifyNetworkRunnable == null) {
            this.identifyNetworkRunnable = new IdentifyNetworkRunnable();
        }
        Matlab.whenMatlabReady((Runnable)this.identifyNetworkRunnable);
    }

    private void updateNode(String string, String string2, String string3) {
        BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string);
        CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
        BrowserObject browserObject = communicationInfo.getBrowserObject();
        browserObject.setIdentification(string2);
        browserObject.setScanDate(string3);
        browserTreeNode.setName(string + this.defineNodeIDString(string2));
    }

    private void createNode(String string, String string2, String string3, String string4, String string5) {
        String string6 = this.defineNodeIDString(string4);
        BrowserTreeNode browserTreeNode = new BrowserTreeNode(string + string6, (BrowserClient)this.browser);
        browserTreeNode.setType(4);
        BrowserObject browserObject = this.createBrowserObject(string2, string3, string4, string5);
        CommunicationPage communicationPage = CommunicationPage.getInstance(this.browser);
        CommunicationInfo communicationInfo = new CommunicationInfo(browserObject);
        this.browser.addToCommunicationInfoStore(communicationInfo);
        browserObject.setPanel(communicationPage);
        browserTreeNode.setPanel((JPanel)((Object)communicationPage));
        browserTreeNode.setUserData((Object)communicationInfo);
        this.browser.addNode(string, this.path, browserTreeNode);
        switch (this.type) {
            case 0: {
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\tcpip_instrument.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "tcpip_config");
                break;
            }
            case 1: {
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\udp_instrument.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "udp_comm");
            }
        }
    }

    private String defineNodeIDString(String string) {
        String string2 = string;
        string2 = string2.equals("No instrument was identified") ? "" : " (" + string2 + ")";
        return string2;
    }

    private BrowserObject createBrowserObject(String string, String string2, String string3, String string4) {
        switch (this.type) {
            case 0: {
                return new TCPIPObject(string, string2, string3, string4);
            }
            case 1: {
                return new UDPObject(string, string2, string3, string4);
            }
        }
        return null;
    }

    private String getNodeName(String string, String string2) {
        String string3 = string;
        if (!string2.equals("")) {
            string3 = string3 + ":" + string2;
        }
        if (string3.equals("")) {
            return "udp";
        }
        return string3;
    }

    private boolean isAdded() {
        if (this.data == null) {
            return false;
        }
        String string = this.address.getText();
        String string2 = this.port.getText();
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.data[i][0].equals(string) || !this.data[i][1].equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void addRow() {
        if (this.address.getText().equals("") && this.type == 0) {
            TMStringUtil.error((MJFrame)this.browser.getBrowserFrame(), (String)"Add Error", (String)"The Address must be specified.");
            return;
        }
        if (this.isAdded()) {
            TMStringUtil.warn((MJFrame)this.browser.getBrowserFrame(), (String)"Duplicate Warning", (String)"The specified Address and Port have already been added.");
            return;
        }
        this.addToTableData();
        String string = this.getNodeName(this.address.getText(), this.port.getText());
        this.createNode(string, this.address.getText(), this.port.getText(), "No instrument was identified", TMStringUtil.getDate());
    }

    private void updateTableData(Object object) {
        if (this.data == null) {
            return;
        }
        String[] stringArray = (String[])object;
        String string = TMStringUtil.getDate();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][2] = stringArray[i];
            this.data[i][3] = string;
            this.updateNode(this.getNodeName((String)this.data[i][0], (String)this.data[i][1]), stringArray[i], string);
        }
        if (this.tableModel != null) {
            this.tableModel.setData(this.data);
        }
    }

    private void addToTableData() {
        this.addToTableData(this.address.getText(), this.port.getText(), "No instrument was identified", TMStringUtil.getDate());
    }

    private void addToTableData(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        this.tableModel.append(objectArray);
        this.data = this.tableModel.getData();
    }

    private void removeFromTableData() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            TMStringUtil.error((MJFrame)this.browser.getBrowserFrame(), (String)"Remove Error", (String)"To remove a row from the table, the row must be selected.");
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            try {
                String string = this.getNodeName((String)this.data[nArray[i]][0], (String)this.data[nArray[i]][1]);
                String string2 = this.defineNodeIDString((String)this.data[nArray[i]][2]);
                BrowserTreeNode browserTreeNode = this.browser.getNode(this.path, string);
                this.browser.removeBrowserObjectFromCommunicationInfoStore((CommunicationInfo)browserTreeNode.getUserData());
                this.browser.removeNode(string + string2, this.path);
                this.tableModel.remove(nArray[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.table.getSelectionModel().clearSelection();
        this.data = this.tableModel.getData();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public class IdentifyNetworkRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", NetworkPage.this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Instrument.enableInstrumentObjectEvents(true);
            if (matlabEvent.getStatus() == 0) {
                Object object = matlabEvent.getResult();
                NetworkPage.this.updateTableData(object);
            }
            NetworkPage.this.browser.postStatusBarUpdateEvent("Ready");
            if (NetworkPage.this.enableOnFinish) {
                NetworkPage.this.browser.postBlockEventsEvent(false);
            }
            NetworkPage.this.browser.postRefreshFinishedEvent();
        }
    }
}

