/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.hardware;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.toolbox.instrument.BluetoothDiscovery;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowserPage;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationInfo;
import com.mathworks.toolbox.instrument.browser.interfaceobj.CommunicationPage;
import com.mathworks.toolbox.instrument.browser.objects.BluetoothObject;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.instrument.guiutil.MatrixTableModel;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public class BluetoothHardwarePage
extends InstrumentControlBrowserPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String[] fHeadings = new String[]{"Device", "Identification"};
    private Object[][] fData;
    private DefaultSortableTable fTable;
    private MatrixTableModel fTableModel;
    private JButton fScanButton;
    private JLabel fLastScanDateLabel;
    private String fInitialDate;
    private InstrumentControlBrowser fBrowser;
    private String[] fPath = new String[]{"Instrument Control Toolbox", "Hardware", "Bluetooth"};
    private Object[] fMatlabArgs;
    private Vector<BrowserTreeNode> fCurrentNodes = new Vector();
    private Vector<BrowserTreeNode> fLastNodes = new Vector();
    private boolean fDisableonStart = false;
    private boolean fEnableOnFinish = false;
    protected static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.browser.resources.RES_BROWSER");

    public BluetoothHardwarePage(InstrumentControlBrowser instrumentControlBrowser) {
        this.fBrowser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.layoutPanel();
        this.fMatlabArgs = new Object[2];
        this.fMatlabArgs[0] = "privateBrowserHelper";
        this.fMatlabArgs[1] = "identifyBluetooth";
        this.cleanup();
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel, "Center");
        this.fTableModel = new MatrixTableModel(this.fHeadings);
        this.fTableModel.setData(this.fData);
        this.fTable = new DefaultSortableTable((TableModel)this.fTableModel);
        this.fTable.setName("Bluetooth Hardware Table");
        this.fTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.fTable.getColumnModel().getColumn(1).setPreferredWidth(1000);
        JTableHeader jTableHeader = this.fTable.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this.fTable);
        jPanel.add((Component)jScrollPane, "Center");
        jScrollPane.setPreferredSize(new Dimension(50, 50));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        this.fInitialDate = TMStringUtil.getDate();
        this.fLastScanDateLabel = new JLabel("Last scan date: " + this.fInitialDate);
        jPanel2.add((Component)this.fLastScanDateLabel, "West");
        jPanel2.add((Component)this.createButtonPanel(), "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        this.fScanButton = new JButton("Scan");
        this.fScanButton.addActionListener(this);
        this.fScanButton.setName("Bluetooth Scan Button");
        jPanel2.add(this.fScanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void setup() {
        this.fScanButton.addActionListener(this);
    }

    @Override
    public void cleanup() {
        this.fScanButton.removeActionListener(this);
    }

    @Override
    public void dispose() {
        this.cleanup();
        this.fHeadings = null;
        this.fData = null;
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        if (this.fData == null) {
            return;
        }
        if (this.fData[0][0] == "") {
            return;
        }
        String string = this.fLastScanDateLabel.getText();
        for (int i = 0; i < this.fData.length; ++i) {
            String string2 = (String)this.fData[i][1];
            if (string2 == null) continue;
            Element element2 = browserConfigFileWriter.addNode(element, "Instrument");
            element2.setAttribute("Type", "Bluetooth");
            element2.setAttribute("LastScanDate", string);
            element2.setAttribute("Identification", (String)this.fData[i][1]);
            element2.setAttribute("Device", (String)this.fData[i][0]);
        }
    }

    public void load(String string, String string2, Element element) {
        if (!InstrumentControlBrowser.bluetoothSupportInTMTOOL) {
            return;
        }
        this.fLastScanDateLabel.setText(string2);
        int n = string2.indexOf(": ");
        string2 = string2.substring(n + 2);
        String string3 = element.getAttribute("Device");
        Object[] objectArray = new Object[]{string3, string};
        this.fTableModel.append(objectArray);
        this.fData = this.fTableModel.getData();
        BrowserTreeNode browserTreeNode = this.createNode(string3, string, string2, this.fData.length - 1);
        this.fLastNodes.add(browserTreeNode);
    }

    public void addInitialNodes(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            BrowserTreeNode browserTreeNode = this.createNode(stringArray[i], "No instrument was identified", this.fInitialDate, i);
            this.fLastNodes.add(browserTreeNode);
        }
        this.initTableData(stringArray);
    }

    private void initTableData(String[] stringArray) {
        this.fData = null;
        if (stringArray == null) {
            return;
        }
        this.fData = new Object[stringArray.length][this.fHeadings.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fData[i][0] = stringArray[i];
            this.fData[i][1] = "No instrument was identified";
        }
        if (this.fTableModel != null) {
            this.fTableModel.setData(this.fData);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fDisableonStart = true;
        this.fEnableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    public void scanForAll() {
        this.fDisableonStart = true;
        this.fEnableOnFinish = true;
        this.getGUIReadyForMATLABCall();
    }

    @Override
    public void scanForAll(boolean bl, boolean bl2) {
        this.fDisableonStart = bl;
        this.fEnableOnFinish = bl2;
        this.getGUIReadyForMATLABCall();
    }

    public void getGUIReadyForMATLABCall() {
        this.fScanButton.setEnabled(false);
        if (this.fDisableonStart) {
            this.fBrowser.postBlockEventsEvent(true);
        }
        this.fBrowser.postStatusBarUpdateEvent("Scanning for Bluetooth devices");
        Instrument.enableInstrumentObjectEvents(false);
        SwingUtilities.invokeLater(new BTDiscoveryThread());
    }

    private void updateTableData(String[] stringArray) {
        String string = TMStringUtil.getDate();
        this.fLastScanDateLabel.setText("Last scan date: " + string);
        String[] stringArray2 = stringArray;
        int n = 0;
        if (stringArray2 != null) {
            n = stringArray2.length;
        }
        this.fData = new Object[n / 2][this.fHeadings.length];
        if (this.fData.length == 0) {
            this.fData = new Object[1][this.fHeadings.length];
            this.fData[0][0] = "";
            this.fData[0][1] = "No Bluetooth devices were found";
        } else {
            for (int i = 0; i < this.fData.length; ++i) {
                this.fData[i][0] = stringArray2[2 * i];
                this.fData[i][1] = stringArray2[2 * i + 1];
                BrowserTreeNode browserTreeNode = this.createNode((String)this.fData[i][0], (String)this.fData[i][1], string, i);
                this.fCurrentNodes.add(browserTreeNode);
            }
        }
        if (this.fTableModel != null) {
            this.fTableModel.setData(this.fData);
        }
        this.cleanupNodes();
    }

    private BrowserTreeNode createNode(String string, String string2, String string3, int n) {
        String string4 = this.defineNodeIDString(string2);
        BrowserTreeNode browserTreeNode = this.fBrowser.getNode(this.fPath, string);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string + string4, (BrowserClient)this.fBrowser);
            browserTreeNode.setType(4);
            browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\bluetooth_instrument.html");
            browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "bluetooth_config");
            BluetoothObject bluetoothObject = new BluetoothObject(string, string2, string3);
            CommunicationPage communicationPage = CommunicationPage.getInstance(this.fBrowser);
            CommunicationInfo communicationInfo = new CommunicationInfo(bluetoothObject);
            this.fBrowser.addToCommunicationInfoStore(communicationInfo);
            bluetoothObject.setPanel(communicationPage);
            browserTreeNode.setPanel((JPanel)((Object)communicationPage));
            browserTreeNode.setUserData((Object)communicationInfo);
            this.fBrowser.addNode(string, this.fPath, browserTreeNode);
        } else {
            CommunicationInfo communicationInfo = (CommunicationInfo)browserTreeNode.getUserData();
            BrowserObject browserObject = communicationInfo.getBrowserObject();
            browserObject.setIdentification(string2);
            browserObject.setScanDate(string3);
            browserTreeNode.setName(string + string4);
        }
        return browserTreeNode;
    }

    private String defineNodeIDString(String string) {
        return "";
    }

    private void cleanupNodes() {
        for (int i = 0; i < this.fLastNodes.size(); ++i) {
            if (this.fCurrentNodes.contains(this.fLastNodes.elementAt(i))) continue;
            BrowserTreeNode browserTreeNode = this.fLastNodes.elementAt(i);
            this.fBrowser.removeNode(browserTreeNode.getName(), this.fPath, browserTreeNode.getUserData());
            this.fBrowser.removeBrowserObjectFromCommunicationInfoStore((CommunicationInfo)browserTreeNode.getUserData());
        }
        this.fLastNodes = this.fCurrentNodes;
        this.fCurrentNodes = null;
        this.fCurrentNodes = new Vector();
    }

    private class BTDiscoveryThread
    implements Runnable {
        private BTDiscoveryThread() {
        }

        @Override
        public void run() {
            String[] stringArray = BluetoothDiscovery.getRemoteDevicesAndServices();
            BluetoothHardwarePage.this.updateTableData(stringArray);
            BluetoothHardwarePage.this.fBrowser.postStatusBarUpdateEvent("");
            BluetoothHardwarePage.this.fBrowser.postBlockEventsEvent(false);
            BluetoothHardwarePage.this.fScanButton.setEnabled(true);
            BluetoothHardwarePage.this.fBrowser.postRefreshFinishedEvent();
            Instrument.enableInstrumentObjectEvents(true);
        }
    }
}

