/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.browser.driver.DriverPageInfo;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.guiutil.panels.DeviceDriverHelper;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.File;
import java.util.Vector;

public class MLDriverPageInfo
extends DriverPageInfo {
    private Parser parser = null;
    private DeviceDriverHelper helper;
    private long driverLastModified = -1L;

    public MLDriverPageInfo(String string, String string2, int n) {
        super(string, string2, n);
    }

    public boolean isValid() {
        if (this.nameWithPath == null) {
            return false;
        }
        File file = new File(this.nameWithPath);
        if (!file.exists()) {
            return false;
        }
        return this.getParser();
    }

    public void setup(MJFrame mJFrame) {
        if (this.driverLastModified == -1L) {
            this.driverLastModified = new File(this.nameWithPath).lastModified();
            this.getParser();
            return;
        }
        long l = new File(this.nameWithPath).lastModified();
        if (l == this.driverLastModified) {
            this.getParser();
            return;
        }
        int n = TMStringUtil.confirm((MJFrame)mJFrame, (String)"Update MATLAB Instrument Driver", (String)"The driver has been modified. Would you like to reload the driver?");
        this.driverLastModified = l;
        if (n == 1) {
            return;
        }
        if (this.parser != null) {
            this.parser.dispose();
            this.parser = null;
            this.helper = null;
        }
        this.getParser();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.parser != null) {
            this.parser.dispose();
            this.helper = null;
            this.parser = null;
        }
    }

    public boolean getParser() {
        if (this.parser != null) {
            return true;
        }
        try {
            this.parser = new Parser(this.nameWithPath);
            this.parser.parse();
            this.helper = new DeviceDriverHelper(this.parser);
        }
        catch (Exception exception) {
            if (this.parser != null) {
                this.parser = null;
            }
            return false;
        }
        return true;
    }

    @Override
    public int getMatlabDriverType() {
        this.getParser();
        return this.parser.getDriverTypeId();
    }

    public String getManufacturer() {
        this.getParser();
        return this.parser.getInstrumentManufacturer();
    }

    public String getModel() {
        this.getParser();
        return this.parser.getInstrumentModel();
    }

    public String getInstrumentVersion() {
        this.getParser();
        return this.parser.getInstrumentVersion();
    }

    public String getInstrumentType() {
        this.getParser();
        return this.parser.getInstrumentType();
    }

    public String getMLDriverType() {
        this.getParser();
        return this.parser.getDriverType();
    }

    public Vector<String> getProperties() {
        this.getParser();
        return this.helper.getPropertyListData();
    }

    public Vector<String> getFunctions() {
        this.getParser();
        return this.helper.getFunctionListData();
    }

    public String getPropertyHelp(int n) {
        this.getParser();
        return this.helper.getPropertyHelp(this.helper.getSelectedPropertyGroup(n), n);
    }

    public String getFunctionHelp(int n) {
        this.getParser();
        return this.helper.getFunctionHelp(this.helper.getSelectedFunctionGroup(n), n);
    }
}

