/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.driver;

import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.browser.driver.IVIListSelector;
import com.mathworks.toolbox.instrument.browser.driver.IVITab;
import com.mathworks.toolbox.instrument.browser.driver.IVITabListener;
import com.mathworks.toolbox.testmeas.guiutil.EditTextFieldTableCellEditor;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class IVIDriverSessionTab
extends IVITab
implements KeyListener,
FocusListener,
ItemListener,
IVITabListener {
    private static final long serialVersionUID = 1L;
    private static final int NAME = 0;
    private static final int DESCRIPTION = 1;
    private static final int SOFTWARE_MODULE = 2;
    private static final int HARDWARE_ASSET = 3;
    private static final int DRIVER_SETUP = 4;
    private static final int CACHE = 5;
    private static final int INTERCHANGE_CHECK = 6;
    private static final int QUERY_STATUS = 7;
    private static final int RANGE_CHECK = 8;
    private static final int RECORD_COERCIONS = 9;
    private static final int SIMULATE = 10;
    private static final int VIRTUAL_NAMES = 11;
    private IVIListSelector listSelector;
    private JTextField name;
    private JTextArea description;
    private JComboBox softwareModule;
    private JComboBox hardwareAsset;
    private JTextField driverSetup;
    private JCheckBox cache;
    private JCheckBox interchangeCheck;
    private JCheckBox queryStatus;
    private JCheckBox rangeCheck;
    private JCheckBox recordCoercions;
    private JCheckBox simulate;
    protected String[] columnNames = new String[]{"Physical Name", "Virtual Name"};
    protected Object[][] data;
    private VirtualNamesTableModel model;
    private VirtualNamesTable table;
    private Hashtable<String, DriverSessionObj> sessions;
    private Hashtable<String, Object> drivers;
    private String selectedItem = "";
    private String originalName = "";
    private boolean isDirty = false;

    public IVIDriverSessionTab() {
        this.layoutPanel();
    }

    protected void setup(String[] stringArray, String[] stringArray2) {
        DriverSessionObj driverSessionObj;
        int n;
        this.softwareModule.removeAllItems();
        this.softwareModule.addItem("<unset>");
        for (n = 0; n < stringArray.length; ++n) {
            this.softwareModule.addItem(stringArray[n]);
        }
        this.hardwareAsset.removeAllItems();
        this.hardwareAsset.addItem("<unset>");
        for (n = 0; n < stringArray2.length; ++n) {
            this.hardwareAsset.addItem(stringArray2[n]);
        }
        if (this.sessions != null && (driverSessionObj = this.sessions.get(this.selectedItem)) != null) {
            this.softwareModule.setSelectedItem(driverSessionObj.getSoftwareModule());
            this.hardwareAsset.setSelectedItem(driverSessionObj.getHardwareAsset());
        }
        this.selectSessionReferences(this.listSelector.getSelectedItem());
        this.softwareModule.addItemListener(this);
    }

    public void updateTable() {
        this.updateTable(this.selectedItem);
    }

    private void updateTable(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (!this.sessions.containsKey(string)) {
            this.addToTable(string);
            return;
        }
        DriverSessionObj driverSessionObj = this.sessions.get(string);
        driverSessionObj.setDescription(this.description.getText());
        driverSessionObj.setDriverSetup(this.driverSetup.getText());
        if (this.softwareModule.getSelectedIndex() > 0) {
            driverSessionObj.setSoftwareModule((String)this.softwareModule.getSelectedItem());
        } else {
            driverSessionObj.setSoftwareModule("");
        }
        if (this.hardwareAsset.getSelectedIndex() > 0) {
            driverSessionObj.setHardwareAsset((String)this.hardwareAsset.getSelectedItem());
        } else {
            driverSessionObj.setHardwareAsset("");
        }
        driverSessionObj.setVirtualNames(this.getVirtualNamesTableStringArray());
        driverSessionObj.configState(this.cache.isSelected(), this.interchangeCheck.isSelected(), this.queryStatus.isSelected(), this.rangeCheck.isSelected(), this.recordCoercions.isSelected(), this.simulate.isSelected());
        this.sessions.put(string, driverSessionObj);
    }

    private void addToTable(String string) {
        DriverSessionObj driverSessionObj = new DriverSessionObj(string, this.description.getText(), this.driverSetup.getText());
        if (this.softwareModule.getSelectedIndex() > 0) {
            driverSessionObj.setSoftwareModule((String)this.softwareModule.getSelectedItem());
        } else {
            driverSessionObj.setSoftwareModule("");
        }
        if (this.hardwareAsset.getSelectedIndex() > 0) {
            driverSessionObj.setHardwareAsset((String)this.hardwareAsset.getSelectedItem());
        } else {
            driverSessionObj.setHardwareAsset("");
        }
        driverSessionObj.setVirtualNames(this.getVirtualNamesTableStringArray());
        driverSessionObj.configState(this.cache.isSelected(), this.queryStatus.isSelected(), this.recordCoercions.isSelected(), this.interchangeCheck.isSelected(), this.rangeCheck.isSelected(), this.simulate.isSelected());
        this.sessions.put(string, driverSessionObj);
        this.isDirty = true;
    }

    private void removeFromTable(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.sessions.remove(string);
        this.isDirty = true;
    }

    public boolean isTabDirty() {
        return this.isDirty;
    }

    public void resetIsDirtyFlag() {
        this.isDirty = false;
    }

    private void layoutPanel() {
        JPanel jPanel = this.createComponentPanel();
        JPanel jPanel2 = this.createCheckBoxPanel();
        JPanel jPanel3 = this.add(jPanel, jPanel2, 8);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, "North");
        this.listSelector = new IVIListSelector(this);
        this.add((Component)this.listSelector, "West");
        this.add((Component)jPanel4, "Center");
        this.setComponentsEnabled(false);
    }

    private JPanel createComponentPanel() {
        this.name = new JTextField();
        this.description = new JTextArea();
        this.softwareModule = new JComboBox();
        this.hardwareAsset = new JComboBox();
        this.driverSetup = new JTextField();
        JScrollPane jScrollPane = this.configureTextArea(this.description);
        this.description.setFont(this.name.getFont());
        this.name.addKeyListener(this);
        this.name.addFocusListener(this);
        this.name.setEnabled(false);
        JPanel jPanel = this.add(new JLabel("Name:"), this.name, 2);
        JPanel jPanel2 = this.add(new JLabel("Description:"), jScrollPane, 2);
        JPanel jPanel3 = this.add(new JLabel("Software module:"), this.softwareModule, 2);
        JPanel jPanel4 = this.add(new JLabel("Hardware asset:"), this.hardwareAsset, 2);
        JPanel jPanel5 = this.add(new JLabel("Driver setup:"), this.driverSetup, 2);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2, 2, 0));
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        this.createVirtualNameTable();
        JScrollPane jScrollPane2 = new JScrollPane((Component)((Object)this.table));
        jScrollPane2.setPreferredSize(new Dimension(10, 105));
        JPanel jPanel7 = this.add(jPanel, jPanel2, 4);
        JPanel jPanel8 = this.add(jPanel7, jPanel5, 4);
        JPanel jPanel9 = this.add(jPanel8, jPanel6, 4);
        JPanel jPanel10 = this.add(jPanel9, jScrollPane2, 4);
        return jPanel10;
    }

    private void createVirtualNameTable() {
        this.model = new VirtualNamesTableModel();
        this.table = new VirtualNamesTable(this.model);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
    }

    private JPanel createCheckBoxPanel() {
        this.cache = new JCheckBox("Cache");
        this.interchangeCheck = new JCheckBox("Interchange check");
        this.queryStatus = new JCheckBox("Query instrument status");
        this.rangeCheck = new JCheckBox("Range check");
        this.recordCoercions = new JCheckBox("Record coercions");
        this.simulate = new JCheckBox("Simulate");
        this.cache.setBorder(null);
        this.interchangeCheck.setBorder(null);
        this.queryStatus.setBorder(null);
        this.rangeCheck.setBorder(null);
        this.recordCoercions.setBorder(null);
        this.simulate.setBorder(null);
        JPanel jPanel = new JPanel(new GridLayout(3, 2, 0, 5));
        jPanel.add(this.cache);
        jPanel.add(this.interchangeCheck);
        jPanel.add(this.queryStatus);
        jPanel.add(this.rangeCheck);
        jPanel.add(this.recordCoercions);
        jPanel.add(this.simulate);
        return jPanel;
    }

    private void clearVirtualNamesTable() {
        this.data = null;
        this.model.fireTableDataChanged();
    }

    private void updateVirtualNamesTableBasedOnDriver() {
        if (this.softwareModule.getItemCount() < 1) {
            this.clearVirtualNamesTable();
            return;
        }
        String[] stringArray = (String[])this.drivers.get(this.softwareModule.getSelectedItem());
        if (stringArray == null) {
            this.clearVirtualNamesTable();
            return;
        }
        this.data = null;
        this.data = new Object[stringArray.length][2];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][0] = stringArray[i];
            this.data[i][1] = "";
        }
        this.model.fireTableDataChanged();
    }

    private void updateVirtualNamesTable(String[] stringArray) {
        this.data = null;
        if (stringArray == null) {
            return;
        }
        this.data = new Object[stringArray.length / 2][2];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][0] = stringArray[n++];
            this.data[i][1] = stringArray[n++];
        }
        this.model.fireTableDataChanged();
    }

    private String[] getVirtualNamesTableStringArray() {
        if (this.data == null) {
            return null;
        }
        String[] stringArray = new String[this.data.length * 2];
        int n = 0;
        for (int i = 0; i < this.data.length; ++i) {
            stringArray[n++] = (String)this.data[i][0];
            stringArray[n++] = (String)this.data[i][1];
        }
        return stringArray;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        this.updateVirtualNamesTableBasedOnDriver();
    }

    @Override
    public void itemChangedEvent(String string) {
        this.updateTable();
        this.name.setText(string);
        if (this.sessions == null || !this.sessions.containsKey(string)) {
            this.description.setText("");
            this.driverSetup.setText("");
            if (this.softwareModule.getItemCount() > 0) {
                this.softwareModule.setSelectedIndex(0);
            }
            if (this.hardwareAsset.getItemCount() > 0) {
                this.hardwareAsset.setSelectedIndex(0);
            }
            this.cache.setSelected(false);
            this.queryStatus.setSelected(false);
            this.interchangeCheck.setSelected(false);
            this.recordCoercions.setSelected(false);
            this.rangeCheck.setSelected(false);
            this.simulate.setSelected(false);
            this.updateVirtualNamesTableBasedOnDriver();
        } else {
            DriverSessionObj driverSessionObj = this.sessions.get(string);
            this.description.setText(driverSessionObj.getDescription());
            this.driverSetup.setText(driverSessionObj.getDriverSetup());
            this.configureSoftwareModule(driverSessionObj.getSoftwareModule());
            this.configureHardwareAsset(driverSessionObj.getHardwareAsset());
            this.cache.setSelected(driverSessionObj.getCacheValue());
            this.queryStatus.setSelected(driverSessionObj.getQueryValue());
            this.recordCoercions.setSelected(driverSessionObj.getRecordValue());
            this.interchangeCheck.setSelected(driverSessionObj.getInterchangeCheckValue());
            this.rangeCheck.setSelected(driverSessionObj.getRangeCheckValue());
            this.simulate.setSelected(driverSessionObj.getSimulateValue());
            this.updateVirtualNamesTable(driverSessionObj.getVirtualNames());
        }
        this.selectedItem = string;
        this.originalName = string;
    }

    private void selectSessionReferences(String string) {
        if (this.sessions == null || !this.sessions.containsKey(string)) {
            this.softwareModule.setSelectedIndex(0);
            this.hardwareAsset.setSelectedIndex(0);
        } else {
            DriverSessionObj driverSessionObj = this.sessions.get(string);
            this.configureSoftwareModule(driverSessionObj.getSoftwareModule());
            this.configureHardwareAsset(driverSessionObj.getHardwareAsset());
        }
    }

    private void configureSoftwareModule(String string) {
        try {
            if (string.length() == 0) {
                this.softwareModule.setSelectedItem("<unset>");
            } else {
                this.softwareModule.setSelectedItem(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void configureHardwareAsset(String string) {
        try {
            if (string.length() == 0) {
                this.hardwareAsset.setSelectedItem("<unset>");
            } else {
                this.hardwareAsset.setSelectedItem(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.listSelector.updateSelectedItemText(this.name.getText());
        this.removeFromTable(this.selectedItem);
        this.postNameChangedEvent("DriverSession", this.selectedItem, this.name.getText());
        this.selectedItem = this.name.getText();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.listSelector.getItemCount() == 0) {
            return;
        }
        if (this.listSelector.containsDuplicate(this.name.getText())) {
            TMStringUtil.error((MJFrame)this.getParentFrame(), (String)"Invalid Name", (String)"Duplicate names are not allowed.");
            this.name.setText(this.originalName);
            this.listSelector.updateSelectedItemText(this.name.getText());
            this.postNameChangedEvent("DriverSession", this.selectedItem, this.name.getText());
            this.selectedItem = this.name.getText();
            return;
        }
        if (!this.name.getText().equals("")) {
            return;
        }
        TMStringUtil.error((MJFrame)this.getParentFrame(), (String)"Invalid Name", (String)"The Name field cannot be empty.");
        this.name.setText(this.originalName);
        this.keyReleased(null);
    }

    public void setComponentsEnabled(boolean bl) {
        this.name.setEnabled(bl);
        this.description.setEnabled(bl);
        this.softwareModule.setEnabled(bl);
        this.hardwareAsset.setEnabled(bl);
        this.driverSetup.setEnabled(bl);
        this.cache.setEnabled(bl);
        this.interchangeCheck.setEnabled(bl);
        this.queryStatus.setEnabled(bl);
        this.rangeCheck.setEnabled(bl);
        this.recordCoercions.setEnabled(bl);
        this.simulate.setEnabled(bl);
        this.table.setEnabled(bl);
    }

    @Override
    public void addItem(String string) {
        if (this.listSelector.getItemCount() == 1) {
            this.setComponentsEnabled(true);
        }
    }

    @Override
    public void removeItem(String string) {
        this.removeFromTable(string);
        this.selectedItem = "";
        if (this.listSelector.getItemCount() == 1) {
            this.setComponentsEnabled(false);
        }
    }

    @Override
    public void nameChanged(String string, String string2, String string3) {
        if (!string.equals("HardwareAsset")) {
            return;
        }
        Enumeration<String> enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement();
            DriverSessionObj driverSessionObj = this.sessions.get(string4);
            if (!driverSessionObj.getHardwareAsset().equals(string2)) continue;
            driverSessionObj.setHardwareAsset(string3);
        }
    }

    protected String[] getAllItems() {
        return this.listSelector.getAllItems();
    }

    public void removeAllElements() {
        this.listSelector.removeAllElements();
        this.setComponentsEnabled(false);
        this.listSelector.enableButtons(false);
    }

    public void updateForNewDriver(Object[] objectArray) {
        this.parse(objectArray);
        this.isDirty = false;
    }

    private void parse(Object[] objectArray) {
        this.sessions = new Hashtable();
        this.drivers = new Hashtable();
        this.listSelector.enableButtons(true);
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = (Object[])objectArray[i];
            String string = (String)objectArray2[0];
            if (objectArray2.length == 2) {
                this.drivers.put(string, objectArray2[1]);
                continue;
            }
            DriverSessionObj driverSessionObj = new DriverSessionObj(string, (String)objectArray2[1], (String)objectArray2[4]);
            driverSessionObj.setHardwareAsset((String)objectArray2[3]);
            driverSessionObj.setSoftwareModule((String)objectArray2[2]);
            driverSessionObj.setVirtualNames((String[])objectArray2[11]);
            driverSessionObj.configState(this.obj2bool(objectArray2[5]), this.obj2bool(objectArray2[6]), this.obj2bool(objectArray2[7]), this.obj2bool(objectArray2[8]), this.obj2bool(objectArray2[9]), this.obj2bool(objectArray2[10]));
            this.sessions.put(string, driverSessionObj);
            this.listSelector.addElement(string);
        }
        if (this.sessions.size() > 0) {
            this.listSelector.setSelectedIndex(0);
            this.setComponentsEnabled(true);
        } else {
            this.setComponentsEnabled(false);
        }
    }

    private boolean obj2bool(Object object) {
        boolean[] blArray = (boolean[])object;
        return blArray[0];
    }

    public Hashtable<String, DriverSessionObj> getInfo() {
        return this.sessions;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    public class VirtualNamesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return IVIDriverSessionTab.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (IVIDriverSessionTab.this.data == null) {
                return 0;
            }
            return IVIDriverSessionTab.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return IVIDriverSessionTab.this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return IVIDriverSessionTab.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            IVIDriverSessionTab.this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }
    }

    public class VirtualNamesTable
    extends DefaultSortableTable {
        private static final long serialVersionUID = 1L;

        public VirtualNamesTable(TableModel tableModel) {
            super(tableModel);
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == IVIDriverSessionTab.this.columnNames.length - 1) {
                EditTextFieldTableCellEditor editTextFieldTableCellEditor = new EditTextFieldTableCellEditor((AbstractTableModel)IVIDriverSessionTab.this.model, new JTextField(), n, n2);
                return editTextFieldTableCellEditor;
            }
            return super.getCellEditor(n, n2);
        }
    }

    public class DriverSessionObj {
        private String name = "";
        private String description = "";
        private String driverSetup = "";
        private String hardware = "";
        private String software = "";
        private String[] virtualNames = null;
        private boolean cacheValue = false;
        private boolean queryValue = false;
        private boolean recordValue = false;
        private boolean interchangeCheckValue = false;
        private boolean rangeCheckValue = false;
        private boolean simulateValue = false;

        public DriverSessionObj(String string, String string2, String string3) {
            this.name = string;
            this.description = string2;
            this.driverSetup = string3;
        }

        public void setName(String string) {
            if (!this.name.equals(string)) {
                IVIDriverSessionTab.this.isDirty = true;
            }
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String string) {
            if (!this.description.equals(string)) {
                IVIDriverSessionTab.this.isDirty = true;
            }
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDriverSetup(String string) {
            if (!this.driverSetup.equals(string)) {
                IVIDriverSessionTab.this.isDirty = true;
            }
            this.driverSetup = string;
        }

        public String getDriverSetup() {
            return this.driverSetup;
        }

        public void setHardwareAsset(String string) {
            if (!this.hardware.equals(string)) {
                IVIDriverSessionTab.this.isDirty = true;
            }
            this.hardware = string;
        }

        public String getHardwareAsset() {
            return this.hardware;
        }

        public void setSoftwareModule(String string) {
            if (!this.software.equals(string)) {
                IVIDriverSessionTab.this.isDirty = true;
            }
            this.software = string;
        }

        public String getSoftwareModule() {
            return this.software;
        }

        public void setVirtualNames(String[] stringArray) {
            if (this.virtualNames == null && stringArray != null) {
                IVIDriverSessionTab.this.isDirty = true;
            } else if (this.virtualNames != null && stringArray == null) {
                IVIDriverSessionTab.this.isDirty = true;
            } else if (this.virtualNames == null && stringArray == null) {
                IVIDriverSessionTab.this.isDirty = false;
            } else if (stringArray.length != this.virtualNames.length) {
                IVIDriverSessionTab.this.isDirty = true;
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(this.virtualNames[i])) continue;
                    IVIDriverSessionTab.this.isDirty = true;
                }
            }
            this.virtualNames = stringArray;
        }

        public String[] getVirtualNames() {
            return this.virtualNames;
        }

        public void configState(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            if (this.cacheValue != bl || this.queryValue != bl3 || this.recordValue != bl5 || this.interchangeCheckValue != bl2 || this.rangeCheckValue != bl4 || this.simulateValue != bl6) {
                IVIDriverSessionTab.this.isDirty = true;
            }
            this.cacheValue = bl;
            this.interchangeCheckValue = bl2;
            this.queryValue = bl3;
            this.rangeCheckValue = bl4;
            this.recordValue = bl5;
            this.simulateValue = bl6;
        }

        public boolean getCacheValue() {
            return this.cacheValue;
        }

        public boolean getQueryValue() {
            return this.queryValue;
        }

        public boolean getRecordValue() {
            return this.recordValue;
        }

        public boolean getInterchangeCheckValue() {
            return this.interchangeCheckValue;
        }

        public boolean getRangeCheckValue() {
            return this.rangeCheckValue;
        }

        public boolean getSimulateValue() {
            return this.simulateValue;
        }
    }
}

