/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.deviceobj;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceMCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectCommunicationTable;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPage;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPageInfo;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectResultsExporter;
import com.mathworks.toolbox.instrument.browser.deviceobj.PropertyChangedCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.PropertyQueriedCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.ResultsMCode;
import com.mathworks.toolbox.instrument.device.guiutil.panels.PropertyPanel;
import com.mathworks.toolbox.instrument.device.guiutil.panels.PropertyPanelListener;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DeviceObjectConfigurePage
extends JPanel
implements ActionListener,
PropertyPanelListener {
    private static final long serialVersionUID = 1L;
    private static final String ACTION = "ACTION";
    private static final int EXPORT = 0;
    private PropertyPanel propertyPanel;
    private JEditorPane outputWindow;
    private JButton export;
    private DeviceObjectCommunicationTable table;
    private Object[] tableRow = new Object[4];
    private PropertyQueriedCode getMCode = null;
    private DeviceObjectPage parent = null;
    private GetCommandRunnable getCommandRunnable = null;
    private SetCommandRunnable setCommandRunnable = null;
    private ICDevice deviceObject = null;

    public DeviceObjectConfigurePage(DeviceObjectPage deviceObjectPage, DeviceObjectCommunicationTable deviceObjectCommunicationTable) {
        this.parent = deviceObjectPage;
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.table = deviceObjectCommunicationTable;
        this.layoutPanel();
    }

    public void dispose() {
    }

    public void update(DeviceObjectPageInfo deviceObjectPageInfo) {
        this.deviceObject = deviceObjectPageInfo.getObject();
        this.propertyPanel.update(this.deviceObject, deviceObjectPageInfo.getParser(), deviceObjectPageInfo.getDeviceDriverHelper());
        this.propertyPanel.setProperty(deviceObjectPageInfo.getProperty());
        this.propertyPanel.setObject(deviceObjectPageInfo.getPropertyObject());
        this.propertyPanel.setSelectedValueIndex(deviceObjectPageInfo.getSelectedValueIndex());
        this.propertyPanel.setConstraintValues(deviceObjectPageInfo.getConstraintValues());
        this.outputWindow.setText(deviceObjectPageInfo.getPropertyResponse());
        this.export.setEnabled(deviceObjectPageInfo.getPropertyOutputAvailable());
        PropertyPanel.addPropertyPanelListener(this);
    }

    public void cleanup(DeviceObjectPageInfo deviceObjectPageInfo) {
        if (deviceObjectPageInfo != null) {
            try {
                deviceObjectPageInfo.setDeviceDriverHelper(this.propertyPanel.getDeviceDriverHelper());
                deviceObjectPageInfo.setProperty(this.propertyPanel.getProperty());
                deviceObjectPageInfo.setPropertyObject(this.propertyPanel.getObject());
                deviceObjectPageInfo.setSelectedValueIndex(this.propertyPanel.getSelectedValueIndex());
                deviceObjectPageInfo.setConstraintValues(this.propertyPanel.getConstraintValues());
                deviceObjectPageInfo.setPropertyResponse(this.outputWindow.getText());
                deviceObjectPageInfo.setPropertyOutputAvailable(this.export.isEnabled());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.propertyPanel.cleanup();
        PropertyPanel.removePropertyPanelListener(this);
    }

    public void addTable() {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].equals(this.table)) continue;
            return;
        }
        this.add((Component)this.table, "Center");
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 4));
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel.add(this.createConfigurePanel());
        jPanel.add(this.createResponsePanel());
        this.add((Component)jPanel, "North");
    }

    private JPanel createConfigurePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Select an instrument property"));
        this.propertyPanel = new PropertyPanel();
        jPanel.add((Component)this.propertyPanel, "Center");
        return jPanel;
    }

    private JPanel createResponsePanel() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 70));
        jPanel.setBorder(BorderFactory.createTitledBorder("Response"));
        this.outputWindow = new JEditorPane();
        this.outputWindow.setEditorKit(this.outputWindow.getEditorKitForContentType("text/html"));
        this.outputWindow.setText("<html></html>");
        this.outputWindow.setBorder(BorderFactory.createLoweredBevelBorder());
        this.outputWindow.setName("Output window");
        JScrollPane jScrollPane = new JScrollPane(this.outputWindow);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.add((Component)jScrollPane, "Center");
        this.export = new JButton("Export...");
        this.export.setName("Export Button");
        this.export.setEnabled(false);
        this.export.putClientProperty(ACTION, new Integer(0));
        this.export.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel2.add(this.export);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty(ACTION);
        switch (n) {
            case 0: {
                ResultsMCode[] resultsMCodeArray = new ResultsMCode[]{this.getMCode};
                MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent(this);
                new DeviceObjectResultsExporter(resultsMCodeArray).showAsDialog(mJFrame);
            }
        }
    }

    @Override
    public void propertyGet(String string, String string2) {
        this.clearResponseWindow();
        String string3 = this.propertyPanel.getGetCode();
        this.getMCode = new PropertyQueriedCode(string3, string, string2, this.deviceObject.getStatus() == 1);
        if (this.getCommandRunnable == null) {
            this.getCommandRunnable = new GetCommandRunnable();
        }
        this.getCommandRunnable.setObject(this.deviceObject);
        this.getCommandRunnable.setCode(this.getMCode.getCode());
        this.getCommandRunnable.setOutputArguments("get" + (DeviceMCode.getCount - 1));
        this.getCommandRunnable.setPropertyQueriedCode(this.getMCode);
        this.tableRow[0] = "get";
        this.tableRow[1] = string2;
        this.tableRow[2] = "'" + string + "'";
        this.tableRow[3] = "get" + (DeviceMCode.getCount - 1);
        this.table.appendData(this.tableRow, this.getMCode);
        this.parent.postBlockEventsEvent(true);
        Matlab.whenMatlabReady((Runnable)this.getCommandRunnable);
    }

    @Override
    public void propertySet(String string, String string2) {
        this.clearResponseWindow();
        this.export.setEnabled(false);
        String string3 = this.propertyPanel.getSetCode();
        String string4 = this.propertyPanel.getValueToSet();
        PropertyChangedCode propertyChangedCode = new PropertyChangedCode(string3, this.deviceObject.getStatus() == 1);
        if (this.setCommandRunnable == null) {
            this.setCommandRunnable = new SetCommandRunnable();
        }
        this.setCommandRunnable.setObject(this.deviceObject);
        this.setCommandRunnable.setCode(propertyChangedCode.getCode());
        this.tableRow[0] = "set";
        this.tableRow[1] = string2;
        this.tableRow[2] = "'" + string + "', " + string4;
        this.tableRow[3] = "";
        this.table.appendData(this.tableRow, propertyChangedCode);
        this.parent.postBlockEventsEvent(true);
        Matlab.whenMatlabReady((Runnable)this.setCommandRunnable);
    }

    private void clearResponseWindow() {
        this.outputWindow.setText("<html></html>");
    }

    protected JPanel add(JPanel jPanel, JPanel jPanel2, int n) {
        JPanel jPanel3 = new JPanel(new BorderLayout(0, n));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "Center");
        return jPanel3;
    }

    public class SetCommandRunnable
    implements Runnable,
    MatlabListener {
        private Object[] args = new Object[]{"privateBrowserHelper", "setFunction", "", ""};
        private Matlab matlab = new Matlab();

        public void setObject(ICDevice iCDevice) {
            this.args[2] = iCDevice.getMATLABObject();
        }

        public void setCode(String string) {
            this.args[3] = string;
        }

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.args, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Object[] objectArray = (Object[])matlabEvent.getResult();
            String string = (String)objectArray[0];
            DeviceObjectConfigurePage.this.outputWindow.setText("<html>" + string + "</html>");
            DeviceObjectConfigurePage.this.parent.postBlockEventsEvent(false);
        }
    }

    public class GetCommandRunnable
    implements Runnable,
    MatlabListener {
        private Object[] args = new Object[]{"privateBrowserHelper", "getFunction", "", "", ""};
        private Matlab matlab = new Matlab();
        private PropertyQueriedCode getCode;

        public void setObject(ICDevice iCDevice) {
            this.args[2] = iCDevice.getMATLABObject();
        }

        public void setCode(String string) {
            this.args[3] = string;
        }

        public void setOutputArguments(String string) {
            this.args[4] = string;
        }

        public void setPropertyQueriedCode(PropertyQueriedCode propertyQueriedCode) {
            this.getCode = propertyQueriedCode;
        }

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.args, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            Object[] objectArray = (Object[])matlabEvent.getResult();
            String string = (String)objectArray[0];
            String string2 = (String)objectArray[1];
            DeviceObjectConfigurePage.this.outputWindow.setText("<html>" + string + "</html>");
            if (string2.equals("yes")) {
                DeviceObjectConfigurePage.this.export.setEnabled(true);
                this.getCode.setVariables(objectArray[2]);
                this.getCode.setVariableNames((String)objectArray[3]);
            } else {
                DeviceObjectConfigurePage.this.export.setEnabled(false);
                this.getCode.setVariables(null);
            }
            DeviceObjectConfigurePage.this.parent.postBlockEventsEvent(false);
        }
    }
}

