/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.toolbox.instrument.browser.HelpPanel;
import com.mathworks.toolbox.instrument.browser.ICTDTMultipleClientFrame;
import com.mathworks.toolbox.instrument.browser.ICTDesktopToolbar;
import com.mathworks.toolbox.instrument.browser.ICTDetailviewPanel;
import com.mathworks.toolbox.instrument.browser.ICTTreeviewPanel;
import com.mathworks.toolbox.instrument.guiutil.ToolboxDemoRunnable;
import com.mathworks.toolbox.instrument.guiutil.ToolboxHelpRunnable;
import com.mathworks.toolbox.testmeas.guiutil.AboutWindow;
import com.mathworks.toolbox.testmeas.util.Print;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTLayoutLibrary;
import com.mathworks.widgets.desk.DTMenu;
import com.mathworks.widgets.desk.DTMenuBar;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTToolBar;
import com.mathworks.widgets.desk.DTWindowActivator;
import com.mathworks.widgets.desk.DTWindowRegistry;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ICTBrowserDesktop
extends Desktop {
    public static final String ACTION = "ACTION";
    private static final int SHOW_HARDWARE = 2;
    private static final int SHOW_INSTRUMENT_OBJECT = 3;
    private static final int SHOW_INSTRUMENT_DRIVER = 4;
    private boolean showHardware = true;
    private boolean showInstrumentObjects = true;
    private boolean showInstrumentDrivers = true;
    public static ResourceBundle sBrowserResources = ResourceBundle.getBundle("com.mathworks.toolbox.instrument.browser.resources.RES_DESKTOP");
    private static ICTBrowserDesktop sInstance;
    private Action fDesktopHelpAction = new DesktopHelpAction();
    private Action fDemosAction = new DemosAction();
    private Action fICTHelpAction = new ICTHelpAction();
    private Action fAboutAction = new AboutAction();
    public Action fPrintAction = new PrintAction();
    private Action fPrintDetailViewAction = new PrintDetailViewAction();
    private Action fCollapsAllAction = new CollapseAllAction();
    private Action fExpandAllAction = new ExpandAllAction();
    public Action fScanHWAction = new ScanAllHardware();
    private ICTDTMultipleClientFrame dtframe = null;
    private JMenu fileMenu = null;
    private JMenu viewMenu = null;
    private JMenu extraToolsMenu = null;
    private JMenu dynamicFileMenu = null;
    public boolean isClientsReady = false;

    private ICTBrowserDesktop() {
        super(sBrowserResources.getString("Desktop.Title"), false);
    }

    public static synchronized void openDesktop() {
        if (sInstance == null || !sInstance.hasMainFrame()) {
            boolean bl;
            boolean bl2 = bl = sInstance != null;
            if (!bl) {
                sInstance = new ICTBrowserDesktop();
            }
            DTWindowRegistry.getInstance().addActivator((DTWindowActivator)sInstance);
            ICTBrowserDesktop.getInstance().initMainFrame(false, true);
            ICTBrowserDesktop.getInstance().initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) {
        ICTDetailviewPanel.getInstance().updateTitle("Instrument Control Toolbox");
        this.showClient((Component)((Object)ICTDetailviewPanel.getInstance()), null, false);
        this.setClientSelected((Component)((Object)ICTTreeviewPanel.getInstance()), true);
        super.close(bl);
        DTWindowRegistry.getInstance().removeActivator((DTWindowActivator)this);
        try {
            ICTTreeviewPanel.cleanup();
        }
        catch (Exception exception) {
            System.out.println(sBrowserResources.getString("Desktop.SaveError"));
        }
        ICTDetailviewPanel.cleanup();
        HelpPanel.cleanup();
        Class<ICTBrowserDesktop> clazz = ICTBrowserDesktop.class;
        synchronized (ICTBrowserDesktop.class) {
            sInstance = null;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this.fPrintDetailViewAction = null;
            this.fICTHelpAction = null;
            this.fAboutAction = null;
            this.fPrintAction = null;
            this.fCollapsAllAction = null;
            this.fExpandAllAction = null;
            this.fScanHWAction = null;
            return;
        }
    }

    protected DTToolBar createToolBar(DTFrame dTFrame) {
        ICTDesktopToolbar iCTDesktopToolbar = new ICTDesktopToolbar(this, dTFrame);
        iCTDesktopToolbar.setName("ICTTreeViewTB");
        return iCTDesktopToolbar;
    }

    protected DTMenuBar createMenuBar(DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
        return new ICTBrowserMenuBar(this, dTFrame, dTClient, dTGroup);
    }

    protected DTMultipleClientFrame createMainFrame() {
        this.dtframe = new ICTDTMultipleClientFrame(this, this.fDTName, null, null, true);
        return this.dtframe;
    }

    public void updateMenubar() {
        this.dtframe.refreshMenubar();
    }

    protected boolean restoreLayout(InputStream inputStream) throws IOException {
        boolean bl = super.restoreLayout(inputStream);
        if (ICTTreeviewPanel.getInstance().isTwoPanelNodeSelected()) {
            ICTBrowserDesktop.getInstance().hideClient((Component)((Object)ICTDetailviewPanel.getInstance()));
        }
        return bl;
    }

    public void initialize() {
        this.hideClient((Component)((Object)ICTDetailviewPanel.getInstance()));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ICTBrowserDesktop.this.isClientsReady = true;
                ICTBrowserDesktop.this.dtframe.refreshMenubar();
            }
        });
    }

    public static synchronized ICTBrowserDesktop getInstance() {
        if (sInstance == null) {
            sInstance = new ICTBrowserDesktop();
        }
        return sInstance;
    }

    public static synchronized boolean hasInstance() {
        return sInstance != null;
    }

    public synchronized void enableGlassPane(boolean bl) {
        if (bl) {
            GlobalCursor.setWait((Window)this.getMainFrame());
        } else {
            GlobalCursor.clear((Window)this.getMainFrame());
        }
    }

    protected DTLayoutLibrary getLayoutLibrary() {
        boolean bl = this.fLayoutLibrary == null;
        DTLayoutLibrary dTLayoutLibrary = super.getLayoutLibrary();
        if (bl) {
            dTLayoutLibrary.addFactoryLayout(sBrowserResources.getString("Desktop.InitialLayout"), ICTBrowserDesktop.class.getResource("resources/InitialLayout.xml"));
        }
        return dTLayoutLibrary;
    }

    public void setDefaultDesktop() {
        URL uRL = ICTBrowserDesktop.class.getResource("resources/InitialLayout.xml");
        if (uRL == null) {
            this.addClient((Component)((Object)ICTDetailviewPanel.getInstance()), sBrowserResources.getString("InstrumentDetailviewPanel.title"));
            this.addClient((Component)((Object)ICTTreeviewPanel.getInstance()), sBrowserResources.getString("InstrumentTreeviewPanel.title"));
            this.addClient((Component)((Object)HelpPanel.getInstance()), sBrowserResources.getString("HelpPanel.title"));
        } else {
            try {
                InputStream inputStream = uRL.openStream();
                this.restoreLayout(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                System.out.println(sBrowserResources.getString("Desktop.InitialLayoutError"));
            }
        }
    }

    private class AboutAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public AboutAction() {
            super(sBrowserResources.getString("Desktop.Menu.Help.About"));
            this.setComponentName("About");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new AboutWindow(1, (MJFrame)ICTBrowserDesktop.getInstance().getMainFrame());
        }
    }

    private class ICTHelpAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public ICTHelpAction() {
            super(sBrowserResources.getString("Desktop.Menu.Help.ToolboxHelp"));
            this.setComponentName("ToolboxHelp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolboxHelpRunnable toolboxHelpRunnable = new ToolboxHelpRunnable();
            Matlab.whenMatlabReady((Runnable)toolboxHelpRunnable);
        }
    }

    private class PrintDetailViewAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public PrintDetailViewAction() {
            super(sBrowserResources.getString("Desktop.Menu.File.PrintDetailView"));
            this.setComponentName("DesktopHelp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Print print = new Print((Component)ICTBrowserDesktop.getInstance().getMainFrame());
            print.setComponentToPrint((Component)((Object)ICTDetailviewPanel.getInstance()));
            print.print();
        }
    }

    private class PrintAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public PrintAction() {
            super(sBrowserResources.getString("Desktop.Menu.File.Print"));
            this.setComponentName("DesktopHelp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Print print = new Print((Component)ICTBrowserDesktop.getInstance().getMainFrame());
            print.print();
        }
    }

    private class DesktopHelpAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public DesktopHelpAction() {
            super(sBrowserResources.getString("Desktop.Menu.Help.DesktopHelp"));
            this.setComponentName("DesktopHelp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("help");
        }
    }

    private class ScanAllHardware
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public ScanAllHardware() {
            super(sBrowserResources.getString("Desktop.Menu.Tools.ScanAllHardware"));
            this.setComponentName("Tools");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ICTTreeviewPanel.getInstance().refresh();
        }
    }

    private class CollapseAllAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public CollapseAllAction() {
            super(sBrowserResources.getString("Desktop.Menu.View.CollapseAll"));
            this.setComponentName("View");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ICTTreeviewPanel.getInstance().collapseTree();
        }
    }

    private class ExpandAllAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public ExpandAllAction() {
            super(sBrowserResources.getString("Desktop.Menu.View.ExpandAll"));
            this.setComponentName("View");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ICTTreeviewPanel.getInstance().expandTree();
        }
    }

    private class DemosAction
    extends MJAbstractAction {
        private static final long serialVersionUID = 1L;

        public DemosAction() {
            super(sBrowserResources.getString("Desktop.Menu.Help.Demos"));
            this.setComponentName("Demos");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToolboxDemoRunnable toolboxDemoRunnable = new ToolboxDemoRunnable();
            Matlab.whenMatlabReady((Runnable)toolboxDemoRunnable);
        }
    }

    private class ICTBrowserMenuBar
    extends DTMenuBar
    implements MenuListener,
    ActionListener {
        private static final long serialVersionUID = 1L;

        public ICTBrowserMenuBar(Desktop desktop, DTFrame dTFrame, DTClient dTClient, DTGroup dTGroup) {
            super(desktop, dTFrame, dTClient, dTGroup);
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (((JMenu)menuEvent.getSource()).getText().equalsIgnoreCase("File")) {
                ICTTreeviewPanel.getInstance().updateMenuItems((MJMenu)menuEvent.getSource());
            }
            if (((JMenu)menuEvent.getSource()).getText().equalsIgnoreCase("View")) {
                this.updateViewMenuItems();
            }
        }

        private void updateViewMenuItems() {
            JMenu jMenu = (JMenu)ICTBrowserDesktop.getInstance().viewMenu.getMenuComponent(2);
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenu.getMenuComponent(0);
            jCheckBoxMenuItem.setSelected(ICTBrowserDesktop.this.showHardware);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)jMenu.getMenuComponent(1);
            jCheckBoxMenuItem2.setSelected(ICTBrowserDesktop.this.showInstrumentObjects);
            JCheckBoxMenuItem jCheckBoxMenuItem3 = (JCheckBoxMenuItem)jMenu.getMenuComponent(2);
            jCheckBoxMenuItem3.setSelected(ICTBrowserDesktop.this.showInstrumentDrivers);
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ICTTreeviewPanel.getInstance().processEvent(actionEvent);
            JComponent jComponent = (JComponent)actionEvent.getSource();
            int n = (Integer)jComponent.getClientProperty(ICTBrowserDesktop.ACTION);
            switch (n) {
                case 2: {
                    ICTBrowserDesktop.this.showHardware = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                    break;
                }
                case 3: {
                    ICTBrowserDesktop.this.showInstrumentObjects = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                    break;
                }
                case 4: {
                    ICTBrowserDesktop.this.showInstrumentDrivers = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                }
            }
        }

        protected void populate() {
            ICTBrowserDesktop.this.fileMenu = this.createFileMenu();
            ICTBrowserDesktop.this.fileMenu.addMenuListener(this);
            this.add(ICTBrowserDesktop.this.fileMenu);
            ICTBrowserDesktop.this.viewMenu = this.createViewMenu();
            ICTBrowserDesktop.this.viewMenu.addMenuListener(this);
            this.add(ICTBrowserDesktop.this.viewMenu);
            this.add(this.createToolsMenu());
            if (this.fFrame.isMainFrame() || this.fDesktop.hasMainFrame()) {
                this.add((JMenu)this.fFrame.getDesktopMenu());
            }
            this.add((JMenu)this.fFrame.getWindowMenu());
            this.add((JMenu)((Object)new HelpMenu()));
        }

        protected JMenu createFileMenu() {
            DTMenu dTMenu = new DTMenu(Desktop.getString(null, (String)"menu.File"));
            DTMenuMergeTag.FILE.setTag((JMenuItem)dTMenu);
            if (ICTBrowserDesktop.this.isClientsReady) {
                ICTBrowserDesktop.this.dynamicFileMenu = ICTTreeviewPanel.getInstance().getDynamicFileMenu();
                this.appendNodeMenuItems((JMenu)dTMenu, ICTBrowserDesktop.this.dynamicFileMenu);
            }
            dTMenu.add(ICTBrowserDesktop.this.fPrintAction);
            dTMenu.add(ICTBrowserDesktop.this.fPrintDetailViewAction);
            dTMenu.addSeparator();
            dTMenu.add(this.fExitAction);
            return dTMenu;
        }

        private void appendNodeMenuItems(JMenu jMenu, JMenu jMenu2) {
            if (jMenu2 == null) {
                return;
            }
            for (int i = jMenu2.getItemCount() - 1; i >= 0; --i) {
                JMenuItem jMenuItem = jMenu2.getItem(i);
                if (jMenuItem != null) {
                    jMenu.insert(jMenuItem, 0);
                    continue;
                }
                jMenu.insertSeparator(0);
            }
        }

        private JMenu createViewMenu() {
            DTMenu dTMenu = new DTMenu("View");
            dTMenu.add(ICTBrowserDesktop.this.fCollapsAllAction);
            dTMenu.add(ICTBrowserDesktop.this.fExpandAllAction);
            JMenu jMenu = new JMenu("Instrument Control Toolbox");
            dTMenu.add((JMenuItem)jMenu);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Hardware", true);
            jCheckBoxMenuItem.putClientProperty(ICTBrowserDesktop.ACTION, new Integer(2));
            jCheckBoxMenuItem.addActionListener(this);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Instrument Objects", true);
            jCheckBoxMenuItem2.putClientProperty(ICTBrowserDesktop.ACTION, new Integer(3));
            jCheckBoxMenuItem2.addActionListener(this);
            JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem("Instrument Drivers", true);
            jCheckBoxMenuItem3.putClientProperty(ICTBrowserDesktop.ACTION, new Integer(4));
            jCheckBoxMenuItem3.addActionListener(this);
            jMenu.add(jCheckBoxMenuItem);
            jMenu.add(jCheckBoxMenuItem2);
            jMenu.add(jCheckBoxMenuItem3);
            return dTMenu;
        }

        private JMenu createToolsMenu() {
            DTMenu dTMenu = new DTMenu("Tools");
            dTMenu.add(ICTBrowserDesktop.this.fScanHWAction);
            if (ICTBrowserDesktop.this.isClientsReady) {
                ICTBrowserDesktop.this.extraToolsMenu = ICTTreeviewPanel.getInstance().getToolsMenu();
                this.appendNodeMenuItems((JMenu)dTMenu, ICTBrowserDesktop.this.extraToolsMenu);
            }
            return dTMenu;
        }

        private class HelpMenu
        extends DTMenu {
            private static final long serialVersionUID = 1L;

            HelpMenu() {
                super(sBrowserResources.getString("Desktop.Menu.Help"));
                DTMenuMergeTag.HELP.setTag((JMenuItem)((Object)this));
            }

            protected void populate() {
                this.add(ICTBrowserDesktop.this.fICTHelpAction);
                this.addSeparator();
                this.add(ICTBrowserDesktop.this.fAboutAction);
            }
        }
    }
}

