/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.toolbox.instrument.browser.InstrumentControlBrowser;
import com.mathworks.toolbox.instrument.browser.TablePage;
import com.mathworks.toolbox.instrument.browser.driver.DriverPageInfo;
import com.mathworks.toolbox.instrument.browser.driver.MLDriverPage;
import com.mathworks.toolbox.instrument.browser.driver.MLDriverPageInfo;
import com.mathworks.toolbox.instrument.browser.driver.VXIPnPDriverPage;
import com.mathworks.toolbox.instrument.browser.driver.VXIPnPDriverPageInfo;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.guiutil.NewObjectDialog;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserConfigFileWriter;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.Collator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import org.w3c.dom.Element;

public class DriverTablePage
extends TablePage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int ALL = 0;
    public static final int MATLAB = 1;
    public static final int VXIPNP = 2;
    private static final String ALL_LABEL = "MATLAB instrument drivers must be on the MATLAB path to be located during an instrument driver scan.";
    private static final String MATLAB_LABEL = "MATLAB instrument drivers must be on the MATLAB path to be located during an instrument driver scan.";
    private static final String VXIPNP_LABEL = "";
    private static final String[] LABELS = new String[]{"MATLAB instrument drivers must be on the MATLAB path to be located during an instrument driver scan.", "MATLAB instrument drivers must be on the MATLAB path to be located during an instrument driver scan.", ""};
    private static final String[] ALL_HEADINGS = new String[]{"Driver Name", "Driver Type", "Driver Path"};
    private static final String[] MATLAB_HEADINGS = new String[]{"Driver Name", "MATLAB Instrument Driver Type", "Driver Path"};
    private static final String[] VXIPNP_HEADINGS = new String[]{"Driver Name", "Driver Path"};
    private static final String[][] HEADINGS = new String[][]{ALL_HEADINGS, MATLAB_HEADINGS, VXIPNP_HEADINGS};
    private static final String[] ALL_PATH = new String[]{"Instrument Control Toolbox", "Instrument Drivers"};
    private static final String[] MATLAB_PATH = new String[]{"Instrument Control Toolbox", "Instrument Drivers", "MATLAB Instrument Drivers"};
    private static final String[] VXIPNP_PATH = new String[]{"Instrument Control Toolbox", "Instrument Drivers", "VXIplug&&play Drivers"};
    private static final String[][] PATHS = new String[][]{ALL_PATH, MATLAB_PATH, VXIPNP_PATH};
    private static final int[] ALL_WIDTH = new int[]{250, 250, 500};
    private static final int[] MATLAB_WIDTH = new int[]{250, 250, 500};
    private static final int[] VXIPNP_WIDTH = new int[]{250, 500};
    private static final int[][] WIDTHS = new int[][]{ALL_WIDTH, MATLAB_WIDTH, VXIPNP_WIDTH};
    private static final String[] MATLAB_ACTION = new String[]{"find_drivers", "find_MATLAB_drivers", "find_vxipnp_drivers"};
    private static final String[] MATLAB_MSG = new String[]{"Scanning for instrument drivers", "Scanning for MATLAB instrument drivers", "Scanning for VXIplug&play drivers"};
    private static final String ACTION = "ACTION";
    private static final int SCAN = 0;
    private static final int EDIT = 1;
    private int type = -1;
    private MJMultilineLabel infoLabel;
    private JScrollPane scrollPane;
    private String[] headings = ALL_HEADINGS;
    private Object[][] data;
    private Object[][] all_drivers = null;
    private Object[][] matlab_drivers = null;
    private Object[][] vxipnp_drivers = null;
    private JButton scanButton;
    private JButton editButton;
    private JLabel lastScanDate;
    private String lastScanTime = "";
    private String[] scan_dates = new String[]{"", "", ""};
    private Collator collator = null;
    private Vector<BrowserTreeNode> currentNodes = new Vector();
    private MLDriverPage matlabDriverPage = null;
    private VXIPnPDriverPage vxipnpDriverPage = null;
    private ScanDriverRunnable scanDriverRunnable = null;
    private InstrumentControlBrowser browser;

    public DriverTablePage(InstrumentControlBrowser instrumentControlBrowser) {
        this.browser = instrumentControlBrowser;
        this.setLayout(new BorderLayout(0, 0));
        this.layoutPanel();
        this.scan(0);
    }

    @Override
    public void update(BrowserTreeNode browserTreeNode) {
        super.setup();
        this.type = (Integer)browserTreeNode.getUserData();
        if (this.scrollPane.getViewport().getView() == null) {
            this.scrollPane.getViewport().setView((Component)table);
        }
        this.infoLabel.setText(LABELS[this.type]);
        this.infoLabel.setCaretPosition(0);
        this.headings = HEADINGS[this.type];
        this.configureTable(this.headings, WIDTHS[this.type]);
        this.updateTableData();
        this.updateButtonState();
        this.updateScanLabel();
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public void dispose() {
        this.cleanup();
        super.dispose();
    }

    public void save(BrowserConfigFileWriter browserConfigFileWriter, Element element) {
        Element element2;
        int n;
        Element element3 = browserConfigFileWriter.addNode(element, "Driver");
        element3.setAttribute("DriverType", "All");
        element3.setAttribute("Date", this.scan_dates[0]);
        if (this.matlab_drivers != null) {
            for (n = 0; n < this.matlab_drivers.length; ++n) {
                element2 = browserConfigFileWriter.addNode(element, "Driver");
                element2.setAttribute("DriverType", "MATLAB");
                element2.setAttribute("Name", (String)this.matlab_drivers[n][0]);
                element2.setAttribute("Type", (String)this.matlab_drivers[n][1]);
                element2.setAttribute("Path", (String)this.matlab_drivers[n][2]);
                element2.setAttribute("Date", this.scan_dates[1]);
            }
        }
        if (this.vxipnp_drivers != null) {
            for (n = 0; n < this.vxipnp_drivers.length; ++n) {
                element2 = browserConfigFileWriter.addNode(element, "Driver");
                element2.setAttribute("DriverType", "vxipnp");
                element2.setAttribute("Name", (String)this.vxipnp_drivers[n][0]);
                element2.setAttribute("Path", (String)this.vxipnp_drivers[n][1]);
                element2.setAttribute("Date", this.scan_dates[2]);
            }
        }
    }

    public void load(Element element) {
        String string = element.getAttribute("DriverType");
        String string2 = element.getAttribute("Date");
        if (string.equals("All")) {
            this.scan_dates[0] = string2;
            return;
        }
        String string3 = element.getAttribute("Name");
        String string4 = element.getAttribute("Path");
        if (string.equals("MATLAB")) {
            String string5 = element.getAttribute("Type");
            Object[] objectArray = new Object[]{string3, string5, string4};
            this.matlab_drivers = this.appendData(this.matlab_drivers, objectArray);
            this.scan_dates[1] = string2;
        } else if (string.equals("vxipnp")) {
            Object[] objectArray = new Object[]{string3, string4};
            this.vxipnp_drivers = this.appendData(this.vxipnp_drivers, objectArray);
            this.scan_dates[2] = string2;
        }
        this.createDriverData();
    }

    public void finishLoad() {
        if (this.matlab_drivers != null) {
            this.addNodes(this.matlab_drivers, 0, 2, 1, PATHS[1]);
        }
        if (this.vxipnp_drivers != null) {
            this.addNodes(this.vxipnp_drivers, 0, 1, 2, PATHS[2]);
        }
    }

    private void layoutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 10, 0, 10));
        this.add(jPanel, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.infoLabel = new MJMultilineLabel();
        jPanel2.add((Component)this.infoLabel, "Center");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        this.lastScanDate = new JLabel("Last scan date:");
        jPanel3.add((Component)this.lastScanDate, "West");
        jPanel3.add((Component)this.createButtonPanel(), "Center");
        jPanel.add((Component)jPanel3, "South");
        JTableHeader jTableHeader = table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.scrollPane = new JScrollPane((Component)table);
        jPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.setPreferredSize(new Dimension(200, 50));
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3, 5, 0));
        this.scanButton = new JButton("Scan");
        this.scanButton.putClientProperty(ACTION, new Integer(0));
        this.scanButton.addActionListener(this);
        this.scanButton.setName("Scan Driver Button");
        this.editButton = new JButton("Edit...");
        this.editButton.putClientProperty(ACTION, new Integer(1));
        this.editButton.addActionListener(this);
        this.editButton.setName("Edit Driver Button");
        jPanel2.add(this.editButton);
        jPanel2.add(this.scanButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void updateButtonState() {
        if (this.type == 1) {
            this.editButton.setVisible(true);
        } else {
            this.editButton.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = (Integer)((JButton)actionEvent.getSource()).getClientProperty(ACTION);
        switch (n) {
            case 0: {
                this.scan();
                break;
            }
            case 1: {
                int n2 = table.getSelectedRow();
                if (n2 == -1) {
                    TMStringUtil.error((MJFrame)((MJFrame)SwingUtilities.windowForComponent((Component)((Object)this))), (String)"Edit Error", (String)"To edit a driver, the driver must be selected in the table.");
                    return;
                }
                String string = (String)this.data[n2][0];
                String string2 = (String)this.data[n2][2];
                MIDTool.openDocument(string2 + File.separator + string);
            }
        }
    }

    public void scan() {
        this.scan(this.type);
    }

    public void scan(int n) {
        int n2 = n;
        this.lastScanTime = TMStringUtil.getDate();
        this.updateScanTime();
        this.browser.postStatusBarUpdateEvent(MATLAB_MSG[n2]);
        this.browser.postBlockEventsEvent(true);
        if (this.scanDriverRunnable == null) {
            this.scanDriverRunnable = new ScanDriverRunnable();
        }
        this.scanDriverRunnable.configureScanParameters(MATLAB_ACTION[n2]);
        Matlab.whenMatlabReady((Runnable)this.scanDriverRunnable);
    }

    private void updateScanTime() {
        switch (this.type) {
            case 0: {
                this.scan_dates[1] = this.lastScanTime;
                this.scan_dates[2] = this.lastScanTime;
                this.scan_dates[0] = this.lastScanTime;
                break;
            }
            case 1: {
                this.scan_dates[1] = this.lastScanTime;
                this.scan_dates[0] = this.lastScanTime;
                break;
            }
            case 2: {
                this.scan_dates[2] = this.lastScanTime;
                this.scan_dates[0] = this.lastScanTime;
            }
        }
    }

    private void updateScanLabel() {
        this.lastScanDate.setText("Last scan date: " + this.scan_dates[this.type]);
    }

    public void assignData(String[] stringArray) {
        switch (this.type) {
            case 1: {
                this.matlab_drivers = null;
                this.matlab_drivers = this.convertData(stringArray, MATLAB_HEADINGS.length, 0, 2, 1);
                break;
            }
            case 2: {
                this.vxipnp_drivers = null;
                this.vxipnp_drivers = this.convertData(stringArray, VXIPNP_HEADINGS.length, 0, 1, 2);
            }
        }
        this.createDriverData();
        this.updateTableData();
        this.updateScanLabel();
    }

    public void assignData(Object[] objectArray) {
        this.matlab_drivers = this.convertData((String[])objectArray[0], MATLAB_HEADINGS.length, 0, 2, 1);
        this.vxipnp_drivers = this.convertData((String[])objectArray[1], VXIPNP_HEADINGS.length, 0, 1, 2);
        this.createDriverData();
        this.updateTableData();
        this.updateScanLabel();
    }

    private Object[][] convertData(String[] stringArray, int n, int n2, int n3, int n4) {
        String[] stringArray2 = PATHS[n4];
        Object[][] objectArray = new Object[stringArray.length / n][n];
        int n5 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < n; ++j) {
                objectArray[i][j] = stringArray[n5++];
            }
        }
        this.addNodes(objectArray, n2, n3, n4, stringArray2);
        return objectArray;
    }

    private void createDriverData() {
        int n;
        this.all_drivers = null;
        int n2 = 0;
        if (this.matlab_drivers != null) {
            n2 += this.matlab_drivers.length;
        }
        if (this.vxipnp_drivers != null) {
            n2 += this.vxipnp_drivers.length;
        }
        this.all_drivers = new Object[n2][ALL_HEADINGS.length];
        int n3 = 0;
        if (this.matlab_drivers != null) {
            for (n = 0; n < this.matlab_drivers.length; ++n) {
                this.all_drivers[n3][0] = this.matlab_drivers[n][0];
                this.all_drivers[n3][1] = "MATLAB Instrument";
                this.all_drivers[n3++][2] = this.matlab_drivers[n][2];
            }
            NewObjectDialog.updateDriversForLayout(this.matlab_drivers);
        }
        if (this.vxipnp_drivers != null) {
            for (n = 0; n < this.vxipnp_drivers.length; ++n) {
                this.all_drivers[n3][0] = this.vxipnp_drivers[n][0];
                this.all_drivers[n3][1] = "VXIplug&play";
                this.all_drivers[n3++][2] = this.vxipnp_drivers[n][1];
            }
        }
    }

    private void updateTableData() {
        this.data = null;
        switch (this.type) {
            case 0: {
                this.data = this.all_drivers;
                break;
            }
            case 1: {
                this.data = this.matlab_drivers;
                break;
            }
            case 2: {
                this.data = this.vxipnp_drivers;
            }
        }
        if (tableModel != null) {
            tableModel.setData(this.data);
            this.setUserData(null);
        }
    }

    private void addNodes(Object[][] objectArray, int n, int n2, int n3, String[] stringArray) {
        this.cleanupNodes(this.currentNodes, stringArray);
        this.currentNodes.removeAllElements();
        if (objectArray == null) {
            this.currentNodes = new Vector();
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.currentNodes.add(this.createNode(objectArray, (String)objectArray[i][n], (String)objectArray[i][n2], stringArray, n3, i));
        }
    }

    private BrowserTreeNode createNode(Object[][] objectArray, String string, String string2, String[] stringArray, int n, int n2) {
        BrowserTreeNode browserTreeNode = this.browser.getNode(stringArray, string2 + File.separator + string);
        if (browserTreeNode == null) {
            browserTreeNode = new BrowserTreeNode(string, (BrowserClient)this.browser);
            this.configurePage(browserTreeNode, string, string2, n);
            this.browser.addNode(string2 + File.separator + string, stringArray, browserTreeNode, this.findLocation(objectArray, string, n2));
        }
        return browserTreeNode;
    }

    private void configurePage(BrowserTreeNode browserTreeNode, String string, String string2, int n) {
        switch (n) {
            case 1: {
                if (this.matlabDriverPage == null) {
                    this.matlabDriverPage = new MLDriverPage();
                }
                browserTreeNode.setPanel((JPanel)((Object)this.matlabDriverPage));
                browserTreeNode.setUserData((Object)new MLDriverPageInfo(string, string2, n));
                browserTreeNode.setType(14);
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\driver_matlab_case.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "matlab_driver_comm");
                break;
            }
            case 2: {
                if (this.vxipnpDriverPage == null) {
                    this.vxipnpDriverPage = new VXIPnPDriverPage();
                }
                browserTreeNode.setPanel((JPanel)((Object)this.vxipnpDriverPage));
                browserTreeNode.setUserData((Object)new VXIPnPDriverPageInfo(string, string2, n));
                browserTreeNode.setType(15);
                browserTreeNode.setHelpDirectoryAndPage("instrument", "tmtool_csh\\driver_vxipnp_case.html");
                browserTreeNode.setHelpMapAndAnchorTag(MLHelpServices.getDocRoot() + "/toolbox/instrument/instrument.map", "vxi_pnp_comm");
            }
        }
    }

    private int findLocation(Object[][] objectArray, String string, int n) {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        for (int i = 0; i < n; ++i) {
            if (this.collator.compare(objectArray[i][0], (Object)string) <= 0) continue;
            return i;
        }
        return n;
    }

    private void cleanupNodes(Vector<BrowserTreeNode> vector, String[] stringArray) {
        for (int i = 0; i < vector.size(); ++i) {
            BrowserTreeNode browserTreeNode = vector.elementAt(i);
            this.browser.removeNode(browserTreeNode.getName(), stringArray);
            DriverPageInfo driverPageInfo = (DriverPageInfo)browserTreeNode.getUserData();
            driverPageInfo.dispose();
            this.browser.removeNode(driverPageInfo.getDriverNameWithPath(), stringArray);
        }
    }

    public class ScanDriverRunnable
    implements Runnable,
    MatlabListener {
        private Matlab matlab = new Matlab();
        private Object[] matlabArgs = new Object[]{"privateBrowserHelper", "find_drivers"};

        public void configureScanParameters(String string) {
            this.matlabArgs[1] = string;
        }

        @Override
        public void run() {
            try {
                this.matlab.feval("instrgate", this.matlabArgs, 1, (MatlabListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getStatus() == 0) {
                try {
                    if (!this.matlabArgs[1].equals("find_drivers")) {
                        String[] stringArray = (String[])matlabEvent.getResult();
                        DriverTablePage.this.assignData(stringArray);
                    } else {
                        Object[] objectArray = (Object[])matlabEvent.getResult();
                        DriverTablePage.this.assignData(objectArray);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DriverTablePage.this.browser.postStatusBarUpdateEvent(DriverTablePage.VXIPNP_LABEL);
            DriverTablePage.this.browser.postBlockEventsEvent(false);
        }
    }
}

