/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument;

import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.Poller;
import com.mathworks.toolbox.instrument.events.ICEvent;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.Vector;

public abstract class InstrumentWriter
extends Instrument {
    protected Vector<Object> outputBufferData = new Vector();
    protected int writeTransferMode = 0;

    @Override
    public void dispose() throws TMException {
        super.dispose();
        this.outputBufferData.removeAllElements();
        this.outputBufferData = null;
    }

    public final void setBytesToOutput(int n) throws TMException {
        InstrumentWriter.displayError(this.createReadOnlyPropertyError("BytesToOutput"));
    }

    public final int getBytesToOutput() {
        return this.bytesToOutput;
    }

    @Override
    public final void setOutputBufferSize(int n) throws TMException {
        if (this.status == 1) {
            throw new TMException("OutputBufferSize cannot be set while OBJ is open.");
        }
        if (n < 1) {
            throw new TMException("OutputBufferSize must be greater than or equal to 1.");
        }
        this.outputBufferSize = n;
        this.bytesToOutput = 0;
    }

    @Override
    public final int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    protected synchronized void putDataInOutputVector(Object object, int n, int n2) throws Exception {
        this.outputBufferData.addElement(new Double(n));
        this.outputBufferData.addElement(new Integer(n2));
        this.outputBufferData.addElement(object);
        this.bytesToOutput += n * DATASIZE[n2];
        if (this.supportsAsynchronousOperations()) {
            Poller.wakeUpTimer();
        }
    }

    protected synchronized boolean dataAvailableOutputVector() throws Exception {
        return !this.outputBufferData.isEmpty();
    }

    protected synchronized double getDoubleFromOutputVector() {
        return (Double)this.outputBufferData.elementAt(0);
    }

    protected synchronized int getIntFromOutputVector() {
        return (Integer)this.outputBufferData.elementAt(1);
    }

    protected synchronized Object getObjectFromOutputVector() {
        Object object = this.outputBufferData.elementAt(2);
        this.flushOutputVector();
        return object;
    }

    protected synchronized void flushOutputVector() {
        this.outputBufferData.removeAllElements();
        this.bytesToOutput = 0;
    }

    @Override
    public final void flushoutput() throws TMException {
        if (!this.isvalid()) {
            InstrumentWriter.displayError("Instrument object OBJ is an invalid object.");
        }
        int n = this.bytesToOutput;
        this.flushOutputVector();
        this.hardwareFlushOutput();
        this.transferStatus = 0;
        if (n > 0 && !this.outputEmptyFcn.equals(ACTION) && this.writeTransferMode == 1) {
            this.eventTime = Calendar.getInstance();
            this.executeEvent(4, "OutputEmpty", this.eventTime, new ICEvent("OutputEmpty", InstrumentWriter.constructClockVector(this.eventTime)));
        }
        this.bytesToOutput = 0;
    }

    public final void fprintf(Object[] objectArray, int n) throws Exception {
        this.verifyObjectState();
        if (this.supportsAsynchronousOperations()) {
            Poller.wakeUpTimer();
        }
        if (objectArray == null) {
            return;
        }
        this.verifyWriteOperation(n);
        this.fprintfHelper(this.getAsciiMessage(objectArray), n);
    }

    public final void fprintf(String string, int n) throws Exception {
        this.verifyObjectState();
        if (this.supportsAsynchronousOperations()) {
            Poller.wakeUpTimer();
        }
        if (string == null) {
            return;
        }
        this.verifyWriteOperation(n);
        this.fprintfHelper(this.getAsciiMessage(string), n);
    }

    private void fprintfHelper(String string, int n) throws TMException {
        int n2 = string.length();
        if (n2 > this.outputBufferSize - this.bytesToOutput) {
            throw new TMException("The number of bytes written must be less than or equal to OutputBufferSize-BytesToOutput.");
        }
        if (n2 == 0) {
            return;
        }
        if (n == 1) {
            this.updateWriteTransferStatus(true);
        }
        Object[] objectArray = null;
        objectArray = this.writeAscii(string, n);
        this.valuesSent += (long)((Integer)objectArray[1]).intValue();
        this.writeRawDataToFile(string, ">");
        String string2 = (String)objectArray[2];
        if (!string2.equals("")) {
            throw new TMException(string2);
        }
    }

    public final void fwrite(Object object, int n, int n2, int n3, int n4) throws Exception {
        Object[] objectArray;
        Object object2;
        this.verifyObjectState();
        if (this.supportsAsynchronousOperations()) {
            Poller.wakeUpTimer();
        }
        if (n == 0) {
            return;
        }
        try {
            this.verifyWriteOperation(n3);
        }
        catch (TMException tMException) {
            throw new TMException(tMException.getMessage());
        }
        if (DATASIZE[n2] * n > this.outputBufferSize - this.bytesToOutput) {
            throw new TMException("The number of bytes written must be less than or equal to OutputBufferSize-BytesToOutput.");
        }
        if (n3 == 1) {
            this.updateWriteTransferStatus(true);
        }
        if (object instanceof Long[]) {
            object2 = new int[n];
            for (int i = 0; i < n; ++i) {
                object2[i] = ((Long[])object)[i].intValue();
            }
            objectArray = this.writeBinary(object2, n, n2, n3);
            this.valuesSent += (long)((Integer)objectArray[0]).intValue();
            this.writeRawDataToFile(object2, n, n2, ">", "", n4);
        } else {
            objectArray = this.writeBinary(object, n, n2, n3);
            this.valuesSent += (long)((Integer)objectArray[0]).intValue();
            this.writeRawDataToFile(object, n, n2, ">", "", n4);
        }
        object2 = (String)objectArray[1];
        if (!((String)object2).equals("")) {
            throw new TMException((String)object2);
        }
        objectArray = null;
    }

    public final void binblockwrite(Object object, int n, int n2, int n3, Object[] objectArray) throws Exception {
        Object[] objectArray2;
        this.verifyObjectState();
        if (n == 0) {
            return;
        }
        try {
            this.verifyWriteOperation(0);
        }
        catch (TMException tMException) {
            InstrumentWriter.displayError(tMException.getMessage());
        }
        int n4 = DATASIZE[n2] * n;
        String string = "#" + Integer.toString(n4).length() + n4;
        byte[] byArray = string.getBytes("UTF-8");
        String string2 = "";
        if (objectArray != null) {
            string2 = this.getAsciiMessage(objectArray);
        }
        byte[] byArray2 = string2.getBytes("UTF-8");
        int n5 = string2.length();
        if (DATASIZE[n2] * n + string.length() + n5 > this.outputBufferSize - this.bytesToOutput) {
            throw new TMException("The number of bytes written must be less than or equal to OutputBufferSize-BytesToOutput.");
        }
        String string3 = "";
        ByteBuffer byteBuffer = ByteBuffer.allocate(DATASIZE[n2] * n + string.length() + n5);
        if (this.byteOrder == 0) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        byteBuffer.clear();
        if (!string2.equals("")) {
            byteBuffer.put(byArray2);
            this.writeRawDataToFile(string2, ">");
        }
        byteBuffer.put(byArray);
        switch (n2) {
            case 0: 
            case 5: {
                if (object instanceof Byte) {
                    byteBuffer.put((Byte)object);
                    break;
                }
                byteBuffer.put((byte[])object);
                break;
            }
            case 1: {
                if (object instanceof Short) {
                    byteBuffer.putShort((Short)object);
                    break;
                }
                objectArray2 = (short[])object;
                for (int i = 0; i < n; ++i) {
                    byteBuffer.putShort(objectArray2[i]);
                }
                break;
            }
            case 2: {
                if (object instanceof Integer) {
                    byteBuffer.putInt((Integer)object);
                    break;
                }
                objectArray2 = (int[])object;
                for (int i = 0; i < n; ++i) {
                    byteBuffer.putInt(objectArray2[i]);
                }
                break;
            }
            case 3: {
                if (object instanceof Float) {
                    byteBuffer.putFloat(((Float)object).floatValue());
                    break;
                }
                objectArray2 = (float[])object;
                for (int i = 0; i < n; ++i) {
                    byteBuffer.putFloat(Float.valueOf(objectArray2[i]).floatValue());
                }
                break;
            }
            case 4: {
                if (object instanceof Double) {
                    byteBuffer.putDouble((Double)object);
                    break;
                }
                objectArray2 = (double[])object;
                for (int i = 0; i < n; ++i) {
                    byteBuffer.putDouble(objectArray2[i]);
                }
                break;
            }
            default: {
                throw new TMException("Invalid FORMAT specified.");
            }
        }
        objectArray2 = this.writeBinary(byteBuffer.array(), byteBuffer.position(), 0, 0);
        this.valuesSent += (long)(((Integer)objectArray2[0] - byArray.length) / DATASIZE[n2] + byArray.length);
        this.writeRawDataToFile(object, n, n2, ">", "", n3);
        string3 = (String)objectArray2[1];
        if (!string3.equals("")) {
            InstrumentWriter.displayError(string3);
        }
    }

    protected Object[] writeAscii(String string, int n) throws TMException {
        this.writeTransferMode = n;
        switch (n) {
            case 1: {
                return this.writeAsciiAsync(string);
            }
            case 0: {
                return this.writeAsciiSync(string);
            }
        }
        throw new TMException("Invalid TransferMode specified.");
    }

    protected Object[] writeAsciiAsync(String string) throws TMException {
        byte[] byArray = string.getBytes();
        try {
            this.putDataInOutputVector(byArray, byArray.length, 0);
        }
        catch (Exception exception) {
            this.flushOutputVector();
            this.hardwareFlushOutput();
            this.transferStatus = 0;
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{string, new Integer(0), ""};
        return objectArray;
    }

    protected Object[] writeAsciiSync(String string) throws TMException {
        Object[] objectArray = new Object[3];
        int n = this.writeAsciiToHardware(string);
        if (n < this.getSuccessValue()) {
            objectArray[0] = "";
            objectArray[1] = INTEGER_ZERO;
            objectArray[2] = this.getErrorMessageFromHardware(n);
        } else {
            objectArray[0] = string;
            objectArray[1] = new Integer(n);
            objectArray[2] = "";
        }
        return objectArray;
    }

    protected String getAsciiMessage(Object[] objectArray, int n, int n2) {
        String string = "";
        block4: for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof String) {
                string = string + (String)objectArray[i];
                continue;
            }
            if (objectArray[i] instanceof Character) {
                string = string + (Character)objectArray[i];
                continue;
            }
            switch (n) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 3: {
                    string = string + new Character((char)n2);
                }
            }
        }
        return string;
    }

    protected String getAsciiMessage(String string, int n, int n2) {
        switch (n) {
            case 0: 
            case 1: {
                string = TMStringUtil.strrep((String)string, (String)"\n", (String)"");
                return TMStringUtil.strrep((String)string, (String)"\\n", (String)"");
            }
            case 2: 
            case 3: {
                String string2 = new Character((char)n2).toString();
                string = TMStringUtil.strrep((String)string, (String)"\n", (String)string2);
                return TMStringUtil.strrep((String)string, (String)"\\n", (String)string2);
            }
        }
        return string;
    }

    protected String getAsciiMessage(Object[] objectArray, String string) {
        String string2 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = objectArray[i] instanceof String ? string2 + (String)objectArray[i] : (objectArray[i] instanceof Character ? string2 + (Character)objectArray[i] : string2 + string);
        }
        return string2;
    }

    protected String getAsciiMessage(String string, String string2) {
        string = TMStringUtil.strrep((String)string, (String)"\n", (String)string2);
        return TMStringUtil.strrep((String)string, (String)"\\n", (String)string2);
    }

    protected Object[] writeBinary(Object object, int n, int n2, int n3) throws Exception {
        this.writeTransferMode = n3;
        switch (n3) {
            case 1: {
                return this.writeBinaryAsync(object, n, n2);
            }
            case 0: {
                return this.writeBinarySync(object, n, n2);
            }
        }
        throw new TMException("Invalid TransferMode specified.");
    }

    protected Object[] writeBinaryAsync(Object object, int n, int n2) throws TMException {
        try {
            this.putDataInOutputVector(object, n, n2);
        }
        catch (Exception exception) {
            this.flushOutputVector();
            this.hardwareFlushOutput();
            this.transferStatus = 0;
            this.executeErrorEvent(Calendar.getInstance(), "Error occurred while writing data to the output buffer.");
        }
        Object[] objectArray = new Object[]{INTEGER_ZERO, ""};
        return objectArray;
    }

    protected Object[] writeBinarySync(Object object, int n, int n2) throws Exception {
        int n3 = this.writeBinaryToHardware(object, n, n2);
        Object[] objectArray = new Object[2];
        if (n3 < this.getSuccessValue()) {
            objectArray[0] = INTEGER_ZERO;
            objectArray[1] = this.getErrorMessageFromHardware(n3);
        } else {
            objectArray[0] = new Integer(n3);
            objectArray[1] = "";
        }
        return objectArray;
    }

    protected abstract void verifyWriteOperation(int var1) throws TMException;

    protected abstract void hardwareFlushOutput() throws TMException;

    protected abstract void updateWriteTransferStatus(boolean var1);

    protected abstract String getAsciiMessage(Object[] var1) throws TMException;

    protected abstract String getAsciiMessage(String var1) throws TMException;

    protected abstract int writeAsciiToHardware(String var1) throws TMException;

    protected abstract int writeBinaryToHardware(Object var1, int var2, int var3) throws Exception;

    protected abstract boolean supportsAsynchronousOperations();
}

