/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.HGPrintOutputHelper;
import com.mathworks.hg.util.HGRasterOutputHelper;
import com.mathworks.hg.util.HGVectorOutputHelper;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperInstantiationException;
import java.util.HashMap;

public class OutputHelperCreator {
    private static String[] sVectorTypes;
    private static String[] sPrinterTypes;
    private static String[] sRasterTypes;
    private static HashMap sTypeMaps;

    public void OutputHelperCreator() {
    }

    public OutputHelper create(String string, MPrintJob mPrintJob) throws OutputHelperInstantiationException {
        OutputHelper outputHelper = null;
        switch (this.lookupCreatorType(string)) {
            case PRINTER: {
                outputHelper = new HGPrintOutputHelper(mPrintJob);
                break;
            }
            case RASTER: {
                outputHelper = new HGRasterOutputHelper(mPrintJob);
                break;
            }
            case VECTOR: {
                outputHelper = new HGVectorOutputHelper(mPrintJob);
                break;
            }
        }
        if (outputHelper == null) {
            throw new OutputHelperInstantiationException("");
        }
        return outputHelper;
    }

    protected OutputHelperType lookupCreatorType(String string) {
        OutputHelperType outputHelperType = (OutputHelperType)((Object)sTypeMaps.get(string));
        if (outputHelperType == null) {
            outputHelperType = OutputHelperType.INVALID;
        }
        return outputHelperType;
    }

    static {
        int n;
        sVectorTypes = new String[]{"meta", "eps", "eps2", "epsc", "eps2c", "ps", "ps2", "psc", "ps2c", "pdfwrite", "svg"};
        sPrinterTypes = new String[]{"prn"};
        sRasterTypes = new String[]{"raster@toolbox"};
        sTypeMaps = new HashMap();
        for (n = 0; n < sVectorTypes.length; ++n) {
            sTypeMaps.put(sVectorTypes[n], OutputHelperType.VECTOR);
        }
        for (n = 0; n < sPrinterTypes.length; ++n) {
            sTypeMaps.put(sPrinterTypes[n], OutputHelperType.PRINTER);
        }
        for (n = 0; n < sRasterTypes.length; ++n) {
            sTypeMaps.put(sRasterTypes[n], OutputHelperType.RASTER);
        }
    }

    public static enum OutputHelperType {
        INVALID,
        PRINTER,
        RASTER,
        VECTOR;

    }
}

