/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelperInstantiationException;
import com.mathworks.hg.util.OutputHelperProcessingException;
import java.awt.Container;
import java.awt.JobAttributes;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public abstract class OutputHelper {
    private static double sJ2d_dpi = 72.0;

    public static double getJAVA2D_DPI() {
        return sJ2d_dpi;
    }

    public OutputHelper(MPrintJob mPrintJob) throws OutputHelperInstantiationException {
    }

    public abstract void open() throws OutputHelperProcessingException;

    public void beginPage() throws OutputHelperProcessingException {
    }

    public abstract void generateOutput(FigurePanelContainer var1) throws OutputHelperProcessingException;

    public void endPage() throws OutputHelperProcessingException {
    }

    public abstract void close() throws OutputHelperProcessingException;

    public boolean supportsGettingCDataFromBufferedImage() {
        return false;
    }

    public BufferedImage getBufferedImage() throws OutputHelperProcessingException {
        return null;
    }

    public boolean supportsMultiplePages() {
        return false;
    }

    public boolean supportsGettingDataForClipboard() {
        return false;
    }

    public ByteArrayOutputStream getDataForClipboard() throws OutputHelperProcessingException {
        return null;
    }

    public void release() throws OutputHelperProcessingException {
    }

    public void validateContainerState(Container container) throws OutputHelperProcessingException {
        if (!container.isDisplayable()) {
            throw new OutputHelperProcessingException("Target container is not displayable. Perhaps the figure was not made visible?");
        }
    }

    static {
        JobAttributes jobAttributes = new JobAttributes();
        jobAttributes.setDialog(JobAttributes.DialogType.NONE);
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(null, "", jobAttributes, null);
        if (printJob != null) {
            sJ2d_dpi = printJob.getPageResolution();
        }
    }
}

