/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.uij.ColorMap;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ColormapPaint
implements Paint {
    private Point2D fV0;
    private Point2D fV1;
    private Point2D fV2;
    private float fI0;
    private float fI1;
    private float fI2;
    private float fQ0;
    private float fQ1;
    private float fQ2;
    private ColorMap fColormap = null;
    private boolean fOpaque = true;
    private boolean fIsLine;

    public ColormapPaint(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, ColorMap colorMap) {
        this.fV0 = new Point2D.Float(f, f2);
        this.fV1 = new Point2D.Float(f5, f6);
        this.fV2 = new Point2D.Float(f9, f10);
        this.fI0 = f3 * f4;
        this.fI1 = f7 * f8;
        this.fI2 = f11 * f12;
        this.fQ0 = f4;
        this.fQ1 = f8;
        this.fQ2 = f12;
        this.fColormap = colorMap;
        this.fIsLine = false;
        this.checkTransparency();
    }

    public ColormapPaint(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, ColorMap colorMap) {
        this.fV0 = new Point2D.Float(f, f2);
        this.fV1 = new Point2D.Float(f5, f6);
        this.fI0 = f3 * f4;
        this.fI1 = f7 * f8;
        this.fQ0 = f4;
        this.fQ1 = f8;
        this.fColormap = colorMap;
        this.fIsLine = true;
        this.checkTransparency();
    }

    private void checkTransparency() {
        this.fOpaque = this.fColormap.isTransparent();
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.fIsLine) {
            Point2D point2D = affineTransform.transform(this.fV0, null);
            Point2D point2D2 = affineTransform.transform(this.fV1, null);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            double d5 = (double)this.fI0 * (double)this.fColormap.getLength();
            double d6 = (double)this.fI1 * (double)this.fColormap.getLength();
            double d7 = this.fQ0;
            double d8 = this.fQ1;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
            if (d13 != 0.0) {
                d13 = 1.0 / d13;
                d9 = (d6 - d5) * (d3 - d) * d13;
                d10 = (d6 - d5) * (d4 - d2) * d13;
                d11 = (d8 - d7) * (d3 - d) * d13;
                d12 = (d8 - d7) * (d4 - d2) * d13;
            }
            return new ColormapPaintContext(colorModel, d, d2, d5, d7, d9, d10, d11, d12, this.fColormap);
        }
        Point2D point2D = affineTransform.transform(this.fV0, null);
        Point2D point2D3 = affineTransform.transform(this.fV1, null);
        Point2D point2D4 = affineTransform.transform(this.fV2, null);
        double d = point2D.getX();
        double d14 = point2D.getY();
        double d15 = point2D3.getX();
        double d16 = point2D3.getY();
        double d17 = point2D4.getX();
        double d18 = point2D4.getY();
        double d19 = (double)this.fI0 * (double)this.fColormap.getLength();
        double d20 = (double)this.fI1 * (double)this.fColormap.getLength();
        double d21 = (double)this.fI2 * (double)this.fColormap.getLength();
        double d22 = this.fQ0;
        double d23 = this.fQ1;
        double d24 = this.fQ2;
        double d25 = 0.0;
        double d26 = 0.0;
        double d27 = 0.0;
        double d28 = 0.0;
        double d29 = d * (d18 - d16) + d15 * (d14 - d18) + d17 * (d16 - d14);
        if (d29 != 0.0) {
            d29 = 1.0 / d29;
            d25 = (d19 * (d18 - d16) + d20 * (d14 - d18) + d21 * (d16 - d14)) * d29;
            d26 = -(d19 * (d17 - d15) + d20 * (d - d17) + d21 * (d15 - d)) * d29;
            d27 = (d22 * (d18 - d16) + d23 * (d14 - d18) + d24 * (d16 - d14)) * d29;
            d28 = -(d22 * (d17 - d15) + d23 * (d - d17) + d24 * (d15 - d)) * d29;
        }
        return new ColormapPaintContext(colorModel, d, d14, d19, d22, d25, d26, d27, d28, this.fColormap);
    }

    @Override
    public int getTransparency() {
        return this.fOpaque ? 1 : 3;
    }

    private class ColormapPaintContext
    implements PaintContext {
        private ColorModel fColorModel;
        private double fX;
        private double fY;
        private double fI;
        private double fQ;
        private double f_dIdX;
        private double f_dIdY;
        private double f_dQdX;
        private double f_dQdY;
        private ColorMap fColormap = null;

        public ColormapPaintContext(ColorModel colorModel, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, ColorMap colorMap) {
            this.fColorModel = colorModel;
            this.fX = d;
            this.fY = d2;
            this.fI = d3;
            this.fQ = d4;
            this.f_dIdX = d5;
            this.f_dIdY = d6;
            this.f_dQdX = d7;
            this.f_dQdY = d8;
            this.fColormap = colorMap;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            double d = (double)n - this.fX;
            double d2 = (double)n2 - this.fY;
            double d3 = this.fI + d * this.f_dIdX + d2 * this.f_dIdY;
            double d4 = this.fQ + d * this.f_dQdX + d2 * this.f_dQdY;
            for (int i = 0; i < n4; ++i) {
                double d5 = d3;
                double d6 = d4;
                for (int j = 0; j < n3; ++j) {
                    int n5 = (int)Math.floor(d5 / d6);
                    int[] nArray = this.fColormap.getIntArrayColor(n5);
                    writableRaster.setPixel(j, i, nArray);
                    d5 += this.f_dIdX;
                    d6 += this.f_dQdX;
                }
                d3 += this.f_dIdY;
                d4 += this.f_dQdY;
            }
            return writableRaster;
        }
    }
}

