/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.linestyleeditor;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideButton;
import com.mathworks.hg.types.LineSpec;
import com.mathworks.hg.types.Resources;
import com.mathworks.hg.types.linestyleeditor.FaderFactory;
import com.mathworks.hg.types.linestyleeditor.IFader;
import com.mathworks.hg.types.linestyleeditor.LineStyleEditorTestFrame;
import com.mathworks.hg.types.linestyleeditor.LineStyleTable;
import com.mathworks.hg.types.linestyleeditor.LineStyleTableModel;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.DebugUtils;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.util.EmptyIcon;
import com.mathworks.widgets.util.GUIUtils;
import com.mathworks.widgets.util.Gbc;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class LineStyleEditorDialog
extends JDialog {
    private int result = 2;
    private final List<LineSpec> dataModel;
    private JButton okButton;
    private final Action helpAction;
    private final LineStyleTable lineStylesTable;
    private final LineStyleTableModel tableModel;
    private static final ResourceBundle resBundle;
    private final WindowListener winListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            LineStyleEditorDialog.this.result = -1;
            LineStyleEditorDialog.this.customDispose();
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            LineStyleEditorDialog.this.okButton.requestFocusInWindow();
        }
    };
    private final Action okAction = new AbstractAction(){
        private final String okString = GUIUtils.getStandardDialogString((GUIUtils.DialogStringType)GUIUtils.DialogStringType.OK_BUTTON);
        {
            this.putValue("Name", this.okString);
            this.putValue("ShortDescription", this.okString);
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/check2_16x16.png"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LineStyleEditorDialog.this.lineStylesTable.isEditing()) {
                LineStyleEditorDialog.this.lineStylesTable.getCellEditor().stopCellEditing();
            }
            LineStyleEditorDialog.this.result = 0;
            LineStyleEditorDialog.this.customDispose();
        }
    };
    private final Action cancelAction = new AbstractAction(){
        private final String cancelString = GUIUtils.getStandardDialogString((GUIUtils.DialogStringType)GUIUtils.DialogStringType.CANCEL_BUTTON);
        {
            this.putValue("Name", this.cancelString);
            this.putValue("ShortDescription", this.cancelString);
            this.putValue("SmallIcon", new EmptyIcon(16, 16));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LineStyleEditorDialog.this.result = 2;
            LineStyleEditorDialog.this.customDispose();
        }
    };
    private final Action addStyleAction = new AbstractAction(){
        {
            this.putValue("Name", resBundle.getString("button.addstyle.name"));
            this.putValue("ShortDescription", resBundle.getString("button.addstyle.name"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/add16x16.png"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LineStyleEditorDialog.this.lineStylesTable.isEditing()) {
                LineStyleEditorDialog.this.lineStylesTable.getCellEditor().stopCellEditing();
            }
            LineStyleEditorDialog.this.dataModel.add(new LineSpec());
            LineStyleEditorDialog.this.tableModel.fireTableRowsInserted(LineStyleEditorDialog.this.dataModel.size() - 1, LineStyleEditorDialog.this.dataModel.size() - 1);
            LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().setSelectionInterval(LineStyleEditorDialog.this.dataModel.size() - 1, LineStyleEditorDialog.this.dataModel.size() - 1);
        }
    };
    private final Action removeStyleAction = new AbstractAction(){
        {
            this.putValue("Name", resBundle.getString("button.removestyle.name"));
            this.putValue("ShortDescription", resBundle.getString("button.removestyle.shortdescription"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/delete16x16.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (LineStyleEditorDialog.this.lineStylesTable.isEditing()) {
                LineStyleEditorDialog.this.lineStylesTable.getCellEditor().stopCellEditing();
            }
            assert (LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getSelectionMode() == 0 || LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getSelectionMode() == 1);
            int n2 = LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getMinSelectionIndex();
            int n3 = LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getMaxSelectionIndex();
            assert (n2 != -1);
            assert (n3 != -1);
            int n4 = LineStyleEditorDialog.this.lineStylesTable.getSelectedRowCount();
            if (n4 == LineStyleEditorDialog.this.dataModel.size()) {
                int n5 = n2 = n4 > 1 ? 1 : n2;
            }
            assert (n2 < LineStyleEditorDialog.this.dataModel.size()) : "Selected index=" + n2;
            assert (n3 < LineStyleEditorDialog.this.dataModel.size()) : "Selected index=" + n3;
            for (n = n3; n >= n2; --n) {
                LineStyleEditorDialog.this.dataModel.remove(n);
            }
            LineStyleEditorDialog.this.tableModel.fireTableRowsDeleted(n2, n3);
            if (!LineStyleEditorDialog.this.dataModel.isEmpty()) {
                n = n2 < LineStyleEditorDialog.this.dataModel.size() ? n2 : LineStyleEditorDialog.this.dataModel.size() - 1;
                LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    };
    private final Action upAction = new AbstractAction(){
        {
            this.putValue("Name", resBundle.getString("button.moveup.name"));
            this.putValue("ShortDescription", resBundle.getString("button.moveup.shortdescription"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/arrow_up_green16x16.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getMinSelectionIndex();
            assert (n != -1);
            assert (n < LineStyleEditorDialog.this.dataModel.size()) : "Selected index=" + n;
            if (n > 0) {
                if (LineStyleEditorDialog.this.lineStylesTable.isEditing()) {
                    LineStyleEditorDialog.this.lineStylesTable.getCellEditor().stopCellEditing();
                }
                int n2 = n;
                int n3 = n2 - 1;
                Collections.swap(LineStyleEditorDialog.this.dataModel, n2, n3);
                LineStyleEditorDialog.this.tableModel.fireTableRowsUpdated(n2, n3);
                LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().setSelectionInterval(n3, n3);
            }
        }
    };
    private final Action downAction = new AbstractAction(){
        {
            this.putValue("Name", resBundle.getString("button.movedown.name"));
            this.putValue("ShortDescription", resBundle.getString("button.movedown.shortdescription"));
            this.putValue("SmallIcon", IconsFactory.getImageIcon(Resources.class, (String)"resources/arrow_down_green16x16.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getMinSelectionIndex();
            assert (n != -1);
            assert (n < LineStyleEditorDialog.this.dataModel.size()) : "Selected index=" + n;
            if (n <= LineStyleEditorDialog.this.dataModel.size() - 2) {
                if (LineStyleEditorDialog.this.lineStylesTable.isEditing()) {
                    LineStyleEditorDialog.this.lineStylesTable.getCellEditor().stopCellEditing();
                }
                int n2 = n;
                int n3 = n2 + 1;
                Collections.swap(LineStyleEditorDialog.this.dataModel, n2, n3);
                LineStyleEditorDialog.this.tableModel.fireTableRowsUpdated(n2, n3);
                LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().setSelectionInterval(n3, n3);
            }
        }
    };
    private final ListSelectionListener tableSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = LineStyleEditorDialog.this.lineStylesTable.getSelectedRowCount();
            if (n > 0) {
                if (LineStyleEditorDialog.this.dataModel.size() > 1) {
                    LineStyleEditorDialog.this.removeStyleAction.setEnabled(true);
                    if (LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getMinSelectionIndex() > 0 && n == 1) {
                        LineStyleEditorDialog.this.upAction.setEnabled(true);
                    } else {
                        LineStyleEditorDialog.this.upAction.setEnabled(false);
                    }
                    if (LineStyleEditorDialog.this.lineStylesTable.getSelectionModel().getMinSelectionIndex() != LineStyleEditorDialog.this.dataModel.size() - 1 && n == 1) {
                        LineStyleEditorDialog.this.downAction.setEnabled(true);
                    } else {
                        LineStyleEditorDialog.this.downAction.setEnabled(false);
                    }
                } else {
                    LineStyleEditorDialog.this.removeStyleAction.setEnabled(false);
                    LineStyleEditorDialog.this.upAction.setEnabled(false);
                    LineStyleEditorDialog.this.downAction.setEnabled(false);
                }
            } else {
                LineStyleEditorDialog.this.removeStyleAction.setEnabled(false);
                LineStyleEditorDialog.this.upAction.setEnabled(false);
                LineStyleEditorDialog.this.downAction.setEnabled(false);
            }
        }
    };

    LineStyleEditorDialog(Frame frame, String string, Dialog.ModalityType modalityType, Action action, List<LineSpec> list) {
        super((Window)frame, string, modalityType);
        if (list == null) {
            throw new IllegalArgumentException("Data model must not be null.");
        }
        this.dataModel = list;
        this.helpAction = action;
        this.tableModel = new LineStyleTableModel(list);
        this.lineStylesTable = new LineStyleTable(this.tableModel);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = this.createLineStylesPanel();
        jPanel.add((Component)jPanel2, "Center");
        this.getContentPane().add(jPanel);
        this.setResizable(true);
        this.addWindowListener(this.winListener);
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(500, 500));
        this.installKeyBindings();
        this.getRootPane().setDefaultButton(this.okButton);
        this.setName("linestyleeditor.dialog");
    }

    public static LineStyleEditorDialog newInstance(Frame frame, String string, Dialog.ModalityType modalityType, Action action, List<LineSpec> list) {
        assert (SwingUtilities.isEventDispatchThread());
        if (modalityType == null) {
            throw new IllegalArgumentException("Argument modalityType must not be null");
        }
        LineStyleEditorDialog lineStyleEditorDialog = null;
        lineStyleEditorDialog = Toolkit.getDefaultToolkit().isModalityTypeSupported(modalityType) ? new LineStyleEditorDialog(frame, string, modalityType, action, list) : new LineStyleEditorDialog(frame, string, Dialog.ModalityType.APPLICATION_MODAL, action, list);
        lineStyleEditorDialog.lineStylesTable.getSelectionModel().addListSelectionListener(lineStyleEditorDialog.tableSelectionListener);
        return lineStyleEditorDialog;
    }

    public int getResult() {
        return this.result;
    }

    private JPanel createLineStylesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = this.helpAction != null ? 7 : 6;
        Insets insets = new Insets(5, 10, 5, 10);
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.lineStylesTable));
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)jScrollPane, new Gbc(0, 0, 1, n + 1).setFill(1).setWeight(100.0, 100.0));
        this.okButton = this.createButton(this.okAction);
        this.okButton.setName("linestyleeditor.ok");
        JButton jButton = this.createButton(this.cancelAction);
        jButton.setName("linestyleeditor.cancel");
        JButton jButton2 = this.createButton(this.addStyleAction);
        jButton2.setName("linestyleeditor.addstyle");
        JButton jButton3 = this.createButton(this.removeStyleAction);
        jButton3.setName("linestyleeditor.removestyle");
        JButton jButton4 = this.createButton(this.upAction);
        jButton4.setName("linestyleeditor.moveup");
        JButton jButton5 = this.createButton(this.downAction);
        jButton5.setName("linestyleeditor.movedown");
        jPanel.add((Component)this.okButton, new Gbc(1, 0).setFill(2).setInsets(new Insets(15, insets.left, insets.bottom, insets.right)));
        Insets insets2 = new Insets(insets.top, insets.left, 30, insets.right);
        if (this.helpAction != null) {
            jPanel.add((Component)jButton, new Gbc(1, -1).setFill(2).setInsets(insets));
            JButton jButton6 = this.createButton(this.helpAction);
            jButton6.setName("linestyleeditor.help");
            jPanel.add((Component)jButton6, new Gbc(1, -1).setFill(2).setInsets(insets2));
        } else {
            jPanel.add((Component)jButton, new Gbc(1, -1).setFill(2).setInsets(insets2));
        }
        jPanel.add((Component)jButton2, new Gbc(1, -1).setFill(2).setInsets(insets));
        jPanel.add((Component)jButton3, new Gbc(1, -1).setFill(2).setInsets(insets));
        jPanel.add((Component)jButton4, new Gbc(1, -1).setFill(2).setInsets(insets));
        jPanel.add((Component)jButton5, new Gbc(1, -1).setFill(2).setInsets(insets));
        return jPanel;
    }

    private JButton createButton(Action action) {
        JideButton jideButton = new JideButton();
        jideButton.setButtonStyle(1);
        jideButton.setHorizontalAlignment(2);
        jideButton.setAction(action);
        return jideButton;
    }

    private void installKeyBindings() {
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        String string = "LineStyleEditorDialog.key.escape";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(keyStroke, string);
        actionMap.put(string, this.cancelAction);
        String string2 = "LineStyleEditorDialog.key.f1";
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(112, 0);
        inputMap.put(keyStroke2, string2);
        actionMap.put(string2, this.helpAction);
        String string3 = "LineStyleEditorDialog.key.del";
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(127, 0);
        inputMap.put(keyStroke3, string3);
        actionMap.put(string3, this.removeStyleAction);
        String string4 = "LineStyleEditorDialog.key.ins";
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(155, 0);
        inputMap.put(keyStroke4, string4);
        actionMap.put(string4, this.addStyleAction);
        String string5 = "LineStyleEditorDialog.key.up";
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(keyStroke5, string5);
        actionMap.put(string5, this.upAction);
        String string6 = "LineStyleEditorDialog.key.down";
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke6, string6);
        actionMap.put(string6, this.downAction);
    }

    private void customDispose() {
        IFader iFader = FaderFactory.newOutFader(this, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LineStyleEditorDialog.this.dispose();
            }
        });
        iFader.start();
    }

    public static void main(String[] stringArray) {
        LineStyleEditorDialog.doShow(null);
    }

    public static void showInMatlab() {
        Desktop desktop = MatlabDesktopServices.getDesktop();
        assert (desktop != null);
        LineStyleEditorDialog.doShow((JFrame)desktop.getMainFrame());
    }

    private static void doShow(final JFrame jFrame) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineStyleEditorDialog.setLookAndFeel();
                LineStyleEditorTestFrame lineStyleEditorTestFrame = new LineStyleEditorTestFrame(jFrame);
                lineStyleEditorTestFrame.setSize(300, 400);
                if (jFrame != null) {
                    lineStyleEditorTestFrame.setLocationRelativeTo(jFrame);
                    lineStyleEditorTestFrame.setDefaultCloseOperation(2);
                } else {
                    lineStyleEditorTestFrame.setDefaultCloseOperation(3);
                }
                lineStyleEditorTestFrame.setVisible(true);
            }
        });
    }

    private static void setLookAndFeel() {
        MJUtilities.initJIDE();
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        LookAndFeelFactory.installJideExtension((int)0);
    }

    static {
        ResourceBundle resourceBundle;
        block3: {
            resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("com.mathworks.hg.types.resources.RES_Types");
            }
            catch (MissingResourceException missingResourceException) {
                if ($assertionsDisabled || DebugUtils.outputException((Throwable)missingResourceException)) break block3;
                throw new AssertionError();
            }
        }
        assert (resourceBundle != null);
        resBundle = resourceBundle;
    }
}

