/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.borders;

import com.mathworks.hg.peer.ui.borders.BorderWithThickness;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class EtchedBorderWithThickness
implements Border,
BorderWithThickness {
    private final int fBorderThickness;
    private final int fEtchType;
    private final Color fShadowColor;
    private final Color fHighlightColor;

    public EtchedBorderWithThickness(int n, Color color, Color color2, int n2) {
        this.fEtchType = n;
        this.fShadowColor = color2;
        this.fHighlightColor = color;
        this.fBorderThickness = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create();
        if (graphics2 != null) {
            try {
                graphics2.translate(n, n2);
                this.paintEtching(graphics2, n3, n4, this.fEtchType);
                graphics2.translate(-n, -n2);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets();
    }

    Insets getBorderInsets() {
        return new Insets(this.fBorderThickness, this.fBorderThickness, this.fBorderThickness, this.fBorderThickness);
    }

    void paintEtching(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.fBorderThickness / 2;
        Color color = n3 == 1 ? this.fShadowColor : this.fHighlightColor;
        graphics.setColor(color);
        int[] nArray = new int[]{0, n4, n4, 0, 0};
        int[] nArray2 = new int[]{0, 0, n2 - n4, n2, 0};
        graphics.fillPolygon(nArray, nArray2, 5);
        int[] nArray3 = new int[]{0, n, n - n4, 0, 0};
        int[] nArray4 = new int[]{0, 0, n4, n4, 0};
        graphics.fillPolygon(nArray3, nArray4, 5);
        Color color2 = n3 == 1 ? this.fHighlightColor : this.fShadowColor;
        graphics.setColor(color2);
        int[] nArray5 = new int[]{n, n - n4, n - n4, n, n};
        int[] nArray6 = new int[]{0, n4, n2, n2, 0};
        graphics.fillPolygon(nArray5, nArray6, 5);
        int[] nArray7 = new int[]{n4, n, n, 0, n4};
        int[] nArray8 = new int[]{n2 - n4, n2 - n4, n2, n2, n2 - n4};
        graphics.fillPolygon(nArray7, nArray8, 5);
        int[] nArray9 = new int[]{n4, this.fBorderThickness, this.fBorderThickness, n4, n4};
        int[] nArray10 = new int[]{n4, n4, n2 - this.fBorderThickness, n2 - n4, n4};
        graphics.fillPolygon(nArray9, nArray10, 5);
        int[] nArray11 = new int[]{n4, n - n4, n - this.fBorderThickness, n4, n4};
        int[] nArray12 = new int[]{n4, n4, this.fBorderThickness, this.fBorderThickness, n4};
        graphics.fillPolygon(nArray11, nArray12, 5);
        graphics.setColor(color);
        int[] nArray13 = new int[]{n - this.fBorderThickness, n - n4, n - n4, n - this.fBorderThickness, n - this.fBorderThickness};
        int[] nArray14 = new int[]{this.fBorderThickness, n4, n2 - n4, n2 - n4, this.fBorderThickness};
        graphics.fillPolygon(nArray13, nArray14, 5);
        int[] nArray15 = new int[]{n - n4, n - n4, n4, this.fBorderThickness, n - n4};
        int[] nArray16 = new int[]{n2 - this.fBorderThickness, n2 - n4, n2 - n4, n2 - this.fBorderThickness, n2 - this.fBorderThickness};
        graphics.fillPolygon(nArray15, nArray16, 5);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public int getThickness() {
        return this.fBorderThickness;
    }

    public int getfEtchType() {
        return this.fEtchType;
    }
}

