/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.borders;

import com.mathworks.hg.peer.ui.borders.BorderFactory;
import com.mathworks.hg.peer.ui.borders.BorderStateObject;
import com.mathworks.hg.peer.ui.borders.TitledBorder;
import com.mathworks.hg.peer.ui.borders.TitledBorderOwner;
import java.awt.Color;
import java.awt.Font;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class DefaultTitledBorderOwner
implements TitledBorderOwner {
    private static final int EMPTY_BORDER = 0;
    private static final int ETCHED_IN_BORDER = 1;
    private static final int ETCHED_OUT_BORDER = 2;
    private static final int BEVELED_IN_BORDER = 3;
    private static final int BEVELED_OUT_BORDER = 4;
    private static final int LINE_BORDER = 5;
    private static final int LEFT_TOP_TITLE = 0;
    private static final int CENTER_TOP_TITLE = 1;
    private static final int RIGHT_TOP_TITLE = 2;
    private static final int LEFT_BOTTOM_TITLE = 3;
    private static final int CENTER_BOTTOM_TITLE = 4;
    private static final int RIGHT_BOTTOM_TITLE = 5;
    private TitledBorder fTitledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());

    @Override
    public Border createBorder(BorderStateObject borderStateObject) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call createBorder from event dispatch thread");
        }
        assert (!this.isTitledBorderNull());
        String string = this.fTitledBorder.getTitle();
        Color color = this.fTitledBorder.getTitleColor();
        Font font = this.fTitledBorder.getTitleFont();
        int n = this.getTitlePositionOnBorder();
        Border border = null;
        int n2 = borderStateObject.fBorderType;
        switch (n2) {
            case 0: {
                border = BorderFactory.createEmptyBorder();
                break;
            }
            case 1: 
            case 2: {
                int n3 = n2 == 1 ? 1 : 0;
                border = BorderFactory.createEtchedBorderWithThickness(n3, borderStateObject.fHighlightColor, borderStateObject.fShadowColor, borderStateObject.fBorderWidth);
                break;
            }
            case 3: 
            case 4: {
                int n4 = n2 == 3 ? 1 : 0;
                border = BorderFactory.createBevelBorderWithThickness(n4, borderStateObject.fHighlightColor, borderStateObject.fShadowColor, borderStateObject.fBorderWidth);
                break;
            }
            case 5: {
                border = BorderFactory.createLineBorderWithThickness(borderStateObject.fHighlightColor, borderStateObject.fBorderWidth);
            }
        }
        this.fTitledBorder = BorderFactory.createTitledBorder(border);
        this.setTitleOnBorder(string);
        this.setFontOnBorder(font);
        this.setForegroundColorOnBorder(color);
        this.setTitlePositionOnBorder(n);
        return this.fTitledBorder;
    }

    @Override
    public void setForegroundColorOnBorder(Color color) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call setForegroundColorOnBorder from event dispatch thread");
        }
        assert (!this.isTitledBorderNull());
        this.fTitledBorder.setTitleColor(color);
    }

    @Override
    public boolean isTitledBorderNull() {
        return this.fTitledBorder == null;
    }

    @Override
    public void setTitleOnBorder(String string) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call setTitleOnBorder from event dispatch thread");
        }
        assert (!this.isTitledBorderNull());
        this.fTitledBorder.setTitle(string);
    }

    @Override
    public void setTitlePositionOnBorder(int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call setTitlePositionOnBorder from event dispatch thread");
        }
        assert (!this.isTitledBorderNull());
        int n2 = 1;
        int n3 = 2;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            case 3: {
                n3 = 5;
                break;
            }
            case 4: {
                n2 = 2;
                n3 = 5;
                break;
            }
            case 5: {
                n2 = 3;
                n3 = 5;
            }
        }
        this.fTitledBorder.setTitlePosition(n3);
        this.fTitledBorder.setTitleJustification(n2);
    }

    private int getTitlePositionOnBorder() throws Error {
        int n = this.fTitledBorder.getTitlePosition();
        int n2 = this.fTitledBorder.getTitleJustification();
        if (n == 2 && n2 == 3) {
            return 2;
        }
        if (n == 2 && n2 == 1) {
            return 0;
        }
        if (n == 5 && n2 == 3) {
            return 5;
        }
        if (n == 5 && n2 == 1) {
            return 3;
        }
        if (n == 2 && n2 == 2) {
            return 1;
        }
        if (n == 5 && n2 == 2) {
            return 4;
        }
        return 0;
    }

    @Override
    public void setFontOnBorder(Font font) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call setFontOnBorder from event dispatch thread");
        }
        assert (!this.isTitledBorderNull());
        this.fTitledBorder.setTitleFont(font);
    }
}

