/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import com.mathworks.hg.peer.UIControlMouseNotification;
import com.mathworks.hg.peer.UIControlMouseWheelNotification;
import com.mathworks.hg.peer.ui.FigureUIChild;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class DefaultFigureUIChildImpl
implements HGPeerQueueUser,
FigureUIChild {
    protected Component fComponent;
    protected UIComponentParentWithLayout fCompParent;
    private static final int sFirstMethodIndex = 0;
    protected static final int sAddFigureChild = 0;
    protected static final int sRemoveFigureChild = 1;
    protected static final int sSetVisible = 4;
    protected static final int sLastMethodIndex = 4;
    private static final String[] sLogMessages = new String[]{"addFigureChild", "removetFigureChildUnits", "setFigureChildPosition", "setFigureChildVisible"};

    public DefaultFigureUIChildImpl(Component component) {
        this.fComponent = component;
    }

    @Override
    public void addComponent(final UIComponentParentWithLayout uIComponentParentWithLayout, final int n) {
        if (this.doPreAdd(uIComponentParentWithLayout, n)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 0, 0, false){

                @Override
                public void run() {
                    uIComponentParentWithLayout.doAddPreOperation();
                    DefaultFigureUIChildImpl.this.doAdd(uIComponentParentWithLayout, n);
                    uIComponentParentWithLayout.doAddPostOperation();
                }
            });
        }
    }

    protected boolean doPreAdd(UIComponentParentWithLayout uIComponentParentWithLayout, int n) {
        this.addLogMessage(0);
        boolean bl = false;
        if (uIComponentParentWithLayout != null) {
            bl = true;
        }
        return bl;
    }

    protected void doAdd(UIComponentParentWithLayout uIComponentParentWithLayout, int n) {
        this.fCompParent = uIComponentParentWithLayout;
        uIComponentParentWithLayout.addUIcontrol(this.fComponent, n);
    }

    @Override
    public void removeComponent(final UIComponentParentWithLayout uIComponentParentWithLayout) {
        if (this.doPreRemove(uIComponentParentWithLayout)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 1, 1, false){

                @Override
                public void run() {
                    uIComponentParentWithLayout.doRemovePreOperation();
                    DefaultFigureUIChildImpl.this.doRemove(uIComponentParentWithLayout);
                    uIComponentParentWithLayout.doRemovePostOperation();
                }
            });
        }
    }

    protected boolean doPreRemove(UIComponentParentWithLayout uIComponentParentWithLayout) {
        this.addLogMessage(1);
        boolean bl = true;
        return bl;
    }

    protected void doRemove(UIComponentParentWithLayout uIComponentParentWithLayout) {
        if (uIComponentParentWithLayout != null) {
            uIComponentParentWithLayout.removeUIcontrol(this.fComponent);
        }
        this.fCompParent = null;
    }

    protected Component getFigureComponent() {
        if (this.fComponent == null) {
            throw new Error("Figure component handle not set.");
        }
        return this.fComponent;
    }

    @Override
    public void doSetPosition(double d, double d2, double d3, double d4) {
        Container container;
        if (this.fComponent != null && (container = this.fComponent.getParent()) != null) {
            double d5 = d;
            double d6 = d2 - d4;
            this.fComponent.setBounds((int)d5, (int)d6, (int)d3, (int)d4);
        }
    }

    public void setVisible(String string) {
        if (string.equals("on")) {
            this.setVisible(true);
            return;
        }
        if (string.equals("off")) {
            this.setVisible(false);
            return;
        }
        throw new Error("Invalid value for Visible - expected 'on' or 'off'");
    }

    @Override
    public void setVisible(final boolean bl) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 4, 7){

            @Override
            public void run() {
                DefaultFigureUIChildImpl.this.doSetVisible(bl);
            }
        });
    }

    @Override
    public void doSetVisible(boolean bl) {
        this.getFigureComponent().setVisible(bl);
    }

    @Override
    public boolean isVisible() {
        return this.getFigureComponent().isVisible();
    }

    @Override
    public UIComponentParentWithLayout getComponentParent() {
        return this.fCompParent;
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this.fCompParent;
    }

    @Override
    public int getUserLastMethodID() {
        return DefaultFigureUIChildImpl.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 4) {
            string = sLogMessages[n - 0];
        }
        return string;
    }

    protected static int getLastMethodIndex() {
        return 4;
    }

    @Override
    public void addLogMessage(int n) {
        if (DebugUtilities.isDebugOptions() && n <= this.getUserLastMethodID()) {
            DebugUtilities.logMessage(32, this.getClass().getName() + "." + this.getUserMethodDescription(n), this);
        }
    }

    public void addLogMessage(int n, String string) {
        if (DebugUtilities.isDebugOptions()) {
            DebugUtilities.logMessage(n, string, this);
        }
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (null != this.fCompParent) {
            this.fCompParent.handleNotification(new UIControlMouseNotification(mouseEvent, bl));
        }
    }

    @Override
    public void handleMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (null != this.fCompParent) {
            this.fCompParent.handleNotification(new UIControlMouseWheelNotification(mouseWheelEvent));
        }
    }

    @Override
    public void manageFocusRequest() {
    }
}

