/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureChild;
import com.mathworks.hg.peer.UITreeNode;
import com.mathworks.hg.peer.UITreePeerRenderer;
import com.mathworks.hg.peer.UicontrolMouseWheelListener;
import com.mathworks.hg.peer.event.NodeDroppedEvent;
import com.mathworks.hg.peer.event.NodeDroppedListener;
import com.mathworks.hg.peer.event.NodeExpandedEvent;
import com.mathworks.hg.peer.event.NodeExpandedListener;
import com.mathworks.hg.peer.event.NodeSelectedEvent;
import com.mathworks.hg.peer.event.NodeSelectedListener;
import com.mathworks.hg.peer.event.UITreeDropListener;
import com.mathworks.hg.peer.utils.UIMJTree;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UITreePeer
extends FigureChild {
    private UIMJTree fuitree;
    private UITreeNode froot;
    private DefaultTreeModel fuitreemodel;
    private MJScrollPane fscp;
    private EventListenerList listenerList = new EventListenerList();

    public UITreePeer() {
        super(20.0, 20.0, 75.0, 75.0);
        this.init();
    }

    private final void init() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fuitree = new UIMJTree();
                UITreePeer.this.fuitree.addTreeSelectionListener(new SelectionListener());
                ExpansionListener expansionListener = new ExpansionListener();
                UITreePeer.this.fuitree.addTreeExpansionListener(expansionListener);
                UITreePeer.this.fuitree.addTreeWillExpandListener(expansionListener);
                UITreePeer.this.fuitree.setCellRenderer(new UITreePeerRenderer());
                UITreePeer.this.fuitree.setEditable(false);
                UITreePeer.this.setMultipleSelectionEnabled(false);
                UITreePeer.this.fuitree.setDropTarget(new DropTarget((Component)((Object)UITreePeer.this.fuitree), new UITreeDropListener(UITreePeer.this)));
                UITreePeer.this.fscp = new MJScrollPane((Component)((Object)UITreePeer.this.fuitree));
                UITreePeer.this.fscp.addMouseWheelListener((MouseWheelListener)new UicontrolMouseWheelListener(UITreePeer.this.getUIComponentParent()));
                UITreePeer.this.setFigureComponent((Component)UITreePeer.this.fscp);
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable), (boolean)false);
    }

    public UITreeNode setRoot(Object object, String string) {
        return this.setRoot(new UITreeNode(object, string));
    }

    public UITreeNode setRoot(UITreeNode uITreeNode) {
        this.froot = uITreeNode;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.setModel(new DefaultTreeModel(UITreePeer.this.froot, true));
            }
        };
        SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter(runnable), (boolean)false);
        return this.froot;
    }

    public UITreeNode getRoot() {
        return this.froot;
    }

    public void add(UITreeNode uITreeNode, UITreeNode uITreeNode2) {
        if (null == uITreeNode || null == uITreeNode2) {
            return;
        }
        uITreeNode.add(uITreeNode2);
    }

    public void add(UITreeNode uITreeNode, UITreeNode[] uITreeNodeArray) {
        if (null == uITreeNode || null == uITreeNodeArray) {
            return;
        }
        int n = uITreeNodeArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            uITreeNode.add(uITreeNodeArray[i]);
            nArray[i] = uITreeNode.getChildCount() - 1;
        }
        if (n > 0) {
            this.nodesWereAdded(uITreeNode, nArray);
        }
    }

    public void remove(UITreeNode uITreeNode) {
        if (null == uITreeNode) {
            return;
        }
        UITreeNode uITreeNode2 = (UITreeNode)uITreeNode.getParent();
        this.remove(uITreeNode2, uITreeNode);
    }

    public void remove(UITreeNode uITreeNode, UITreeNode uITreeNode2) {
        if (null == uITreeNode || null == uITreeNode2) {
            return;
        }
        uITreeNode.remove(uITreeNode2);
    }

    public void removeAllChildren(UITreeNode uITreeNode) {
        if (null == uITreeNode) {
            return;
        }
        int n = uITreeNode.getChildCount();
        uITreeNode.removeAllChildren();
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            this.nodesWereRemoved(uITreeNode, nArray);
        }
    }

    public void insert(UITreeNode uITreeNode, UITreeNode uITreeNode2, int n) {
        if (null == uITreeNode || null == uITreeNode2) {
            return;
        }
        uITreeNode.insert(uITreeNode2, n);
    }

    public void expand(final UITreeNode uITreeNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = new TreePath(uITreeNode.getPath());
                UITreePeer.this.fuitree.expandPath(treePath);
            }
        });
    }

    public void collapse(final UITreeNode uITreeNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = new TreePath(uITreeNode.getPath());
                UITreePeer.this.fuitree.collapsePath(treePath);
            }
        });
    }

    public void setLoaded(UITreeNode uITreeNode, boolean bl) {
        uITreeNode.setLoaded(bl);
        if (!bl) {
            this.collapse(uITreeNode);
            this.removeAllChildren(uITreeNode);
        }
    }

    public boolean isLoaded(UITreeNode uITreeNode) {
        return uITreeNode.isLoaded();
    }

    public UITreeNode[] getSelectedNodes() {
        TreePath[] treePathArray = this.fuitree.getSelectionPaths();
        int n = this.fuitree.getSelectionCount();
        if (n == 0) {
            return null;
        }
        UITreeNode[] uITreeNodeArray = new UITreeNode[n];
        for (int i = 0; i < n; ++i) {
            uITreeNodeArray[i] = (UITreeNode)treePathArray[i].getLastPathComponent();
        }
        return uITreeNodeArray;
    }

    public void setSelectedNode(final UITreeNode uITreeNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == uITreeNode) {
                    UITreePeer.this.fuitree.clearSelection();
                    return;
                }
                TreePath treePath = new TreePath(uITreeNode.getPath());
                UITreePeer.this.fuitree.setSelectionPath(treePath);
            }
        });
    }

    public void setSelectedNodes(final UITreeNode[] uITreeNodeArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null == uITreeNodeArray || uITreeNodeArray.length == 0) {
                    UITreePeer.this.fuitree.clearSelection();
                    return;
                }
                int n = uITreeNodeArray.length;
                TreePath[] treePathArray = new TreePath[n];
                for (int i = 0; i < n; ++i) {
                    treePathArray[i] = new TreePath(uITreeNodeArray[i].getPath());
                }
                UITreePeer.this.fuitree.setSelectionPaths(treePathArray);
            }
        });
    }

    public UIMJTree getTree() {
        return this.fuitree;
    }

    public MJScrollPane getScrollPane() {
        return this.fscp;
    }

    public void repaint() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fscp.repaint();
            }
        });
    }

    public void setModel(DefaultTreeModel defaultTreeModel) {
        this.fuitreemodel = defaultTreeModel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fuitreemodel.asksAllowsChildren();
                UITreePeer.this.fuitree.setModel(UITreePeer.this.fuitreemodel);
                UITreePeer.this.fuitree.collapseRow(0);
            }
        });
    }

    public TreeModel getModel() {
        return this.fuitreemodel;
    }

    public boolean isMultipleSelectionEnabled() {
        return this.fuitree.getSelectionModel().getSelectionMode() != 1;
    }

    public void setMultipleSelectionEnabled(boolean bl) {
        if (bl) {
            this.fuitree.getSelectionModel().setSelectionMode(4);
        } else {
            this.fuitree.getSelectionModel().setSelectionMode(1);
        }
    }

    public boolean isDndEnabled() {
        return this.fuitree.getDragEnabled();
    }

    public void setDndEnabled(boolean bl) {
        this.fuitree.setDragEnabled(bl);
    }

    public void nodesWereAdded(final UITreeNode uITreeNode, final int[] nArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fuitreemodel.nodesWereInserted(uITreeNode, nArray);
            }
        });
    }

    public void nodesWereRemoved(final UITreeNode uITreeNode, final int[] nArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fuitreemodel.nodesWereRemoved(uITreeNode, nArray, null);
            }
        });
    }

    public void nodesWereRemoved(final UITreeNode uITreeNode, final int[] nArray, Object[] objectArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fuitreemodel.nodesWereRemoved(uITreeNode, nArray, null);
            }
        });
    }

    public void nodeStructureChangeCompleted(final UITreeNode uITreeNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fuitreemodel.nodeStructureChanged(uITreeNode);
            }
        });
    }

    public void reloadNode(final UITreeNode uITreeNode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UITreePeer.this.fuitreemodel.reload(uITreeNode);
            }
        });
    }

    public synchronized void removeTreeSelectionListener(NodeSelectedListener nodeSelectedListener) {
        this.listenerList.remove(NodeSelectedListener.class, nodeSelectedListener);
    }

    public synchronized void addTreeSelectionListener(NodeSelectedListener nodeSelectedListener) {
        this.listenerList.add(NodeSelectedListener.class, nodeSelectedListener);
    }

    protected void fireNodeSelected(NodeSelectedEvent nodeSelectedEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(NodeSelectedListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((NodeSelectedListener)eventListenerArray[i]).nodeSelected(nodeSelectedEvent);
        }
    }

    public synchronized void addTreeExpansionListener(NodeExpandedListener nodeExpandedListener) {
        this.listenerList.add(NodeExpandedListener.class, nodeExpandedListener);
    }

    public synchronized void removeTreeExpansionListener(NodeExpandedListener nodeExpandedListener) {
        this.listenerList.remove(NodeExpandedListener.class, nodeExpandedListener);
    }

    protected void fireTreeWillExpand(NodeExpandedEvent nodeExpandedEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(NodeExpandedListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((NodeExpandedListener)eventListenerArray[i]).nodeWillExpand(nodeExpandedEvent);
        }
    }

    protected void fireTreeExpanded(NodeExpandedEvent nodeExpandedEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(NodeExpandedListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((NodeExpandedListener)eventListenerArray[i]).nodeExpanded(nodeExpandedEvent);
        }
    }

    protected void fireTreeWillCollapse(NodeExpandedEvent nodeExpandedEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(NodeExpandedListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((NodeExpandedListener)eventListenerArray[i]).nodeWillCollapse(nodeExpandedEvent);
        }
    }

    protected void fireTreeCollapsed(NodeExpandedEvent nodeExpandedEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(NodeExpandedListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((NodeExpandedListener)eventListenerArray[i]).nodeCollapsed(nodeExpandedEvent);
        }
    }

    public synchronized void addTreeDndListener(NodeDroppedListener nodeDroppedListener) {
        this.listenerList.add(NodeDroppedListener.class, nodeDroppedListener);
    }

    public synchronized void removeTreeDndListener(NodeDroppedListener nodeDroppedListener) {
        this.listenerList.remove(NodeDroppedListener.class, nodeDroppedListener);
    }

    public void fireNodeDropped(NodeDroppedEvent nodeDroppedEvent) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(NodeDroppedListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((NodeDroppedListener)eventListenerArray[i]).nodeDropped(nodeDroppedEvent);
        }
    }

    private class ExpansionListener
    implements TreeExpansionListener,
    TreeWillExpandListener {
        private ExpansionListener() {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            try {
                UITreePeer.this.fireTreeWillExpand(new NodeExpandedEvent(treeExpansionEvent.getPath().getLastPathComponent()));
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("NULL Pointer");
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            try {
                UITreePeer.this.fireTreeExpanded(new NodeExpandedEvent(treeExpansionEvent.getPath().getLastPathComponent()));
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("NULL Pointer");
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            try {
                UITreePeer.this.fireTreeWillCollapse(new NodeExpandedEvent(treeExpansionEvent.getPath().getLastPathComponent()));
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("NULL Pointer");
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            try {
                UITreePeer.this.fireTreeCollapsed(new NodeExpandedEvent(treeExpansionEvent.getPath().getLastPathComponent()));
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("NULL Pointer");
            }
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            try {
                UITreePeer.this.fireNodeSelected(new NodeSelectedEvent(treeSelectionEvent.getPath().getLastPathComponent()));
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("NULL Pointer");
            }
        }
    }
}

