/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureChild;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.UIComponentParent;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerReplaceRunnable;
import com.mathworks.hg.util.HGUtils;
import java.awt.Component;
import java.awt.Container;

public class UIComponentManager
implements HGPeerQueueUser,
FigureValidator {
    private Container fComponentContainer;
    private UIComponentParent fCompParent;
    private static final int sFirstMethodIndex = 0;
    protected static final int sAddComponent = 0;
    protected static final int sRemoveComponent = 1;
    private static final int sLastMethodIndex = 1;
    private static final String[] sLogMessages = new String[]{"addComponent", "removeComponent"};

    public UIComponentManager(UIComponentParent uIComponentParent) {
        this.fCompParent = uIComponentParent;
    }

    void setComponentContainer(Container container) {
        this.fComponentContainer = container;
    }

    void addUIcontrol(final Component component, final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                assert (UIComponentManager.this.fComponentContainer != null);
                int n2 = Math.min(UIComponentManager.this.fComponentContainer.getComponentCount(), n);
                UIComponentManager.this.fComponentContainer.add(component, null, n2);
            }
        };
        FigurePeer.runOnEDT(runnable);
    }

    void removeUIcontrol(final Component component) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (UIComponentManager.this.fComponentContainer != null) {
                    UIComponentManager.this.fComponentContainer.remove(component);
                    if (UIComponentManager.this.fComponentContainer.isLightweight()) {
                        UIComponentManager.this.fComponentContainer.repaint();
                    }
                }
            }
        };
        FigurePeer.runOnEDT(runnable);
    }

    void replaceUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer, AbstractUicontrolPeer abstractUicontrolPeer2) {
        if (this.doPreReplaceUIcontrol(abstractUicontrolPeer, abstractUicontrolPeer2)) {
            HGUtils.invokeLater(new HGPeerReplaceRunnable(abstractUicontrolPeer, abstractUicontrolPeer2, 0, 6, true){

                @Override
                public void run() {
                    UIComponentManager.this.doReplaceUIcontrol((AbstractUicontrolPeer)this.getSourcePeer(), (AbstractUicontrolPeer)this.getTargetPeer());
                }
            });
        }
    }

    private boolean doPreReplaceUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer, AbstractUicontrolPeer abstractUicontrolPeer2) {
        boolean bl = true;
        int n = -1;
        if (null != abstractUicontrolPeer) {
            abstractUicontrolPeer.doPreRemoveControl();
            n = abstractUicontrolPeer.getCachedControlStackIndex();
        }
        if (null != abstractUicontrolPeer2) {
            abstractUicontrolPeer2.doPreAddControl(this.fCompParent, n);
        }
        return bl;
    }

    protected void doReplaceUIcontrol(AbstractUicontrolPeer abstractUicontrolPeer, AbstractUicontrolPeer abstractUicontrolPeer2) {
        int n = 0;
        if (null != abstractUicontrolPeer) {
            n = abstractUicontrolPeer.getControlStackIndex();
            abstractUicontrolPeer.doRemoveControl();
        }
        if (null != abstractUicontrolPeer2) {
            abstractUicontrolPeer2.doAddControl(this.fCompParent, n);
        }
    }

    FigureChild addchild(Component component) {
        DebugUtilities.logMessage(32, "FigurePeer.add(Component)", this);
        return this.addchild(new FigureChild(component));
    }

    FigureChild addchild(FigureChild figureChild) {
        DebugUtilities.logMessage(32, "FigurePeer.add(FigureChild)", this);
        figureChild.add(this.fCompParent, this.fComponentContainer);
        return figureChild;
    }

    void removechild(FigureChild figureChild) {
        DebugUtilities.logMessage(32, "FigurePeer.remove(FigureChild)", this);
        figureChild.remove(this.fCompParent, this.fComponentContainer);
    }

    @Override
    public int getUserLastMethodID() {
        return 1;
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 1) {
            string = sLogMessages[n - 0];
        }
        return string;
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this;
    }

    @Override
    public void validateFigure() {
        if (this.fComponentContainer == null) {
            return;
        }
        Container container = this.fComponentContainer;
        Container container2 = this.fComponentContainer.getParent();
        while (container2 != null) {
            container = container2;
            container2 = container.getParent();
        }
        assert (container != null);
        container.validate();
    }
}

