/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractFigureFrameProxy;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureDTClientEventNotification;
import com.mathworks.hg.peer.FigureDTClientListener;
import com.mathworks.hg.peer.FigureJavaEventNotification;
import com.mathworks.hg.peer.FigureMenuBarNotification;
import com.mathworks.hg.peer.FigureMoveResizeNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.FigurePanelProxyNotification;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class FigureClientProxy
implements FigureNotificationHandler {
    private static ImageIcon sIcon = null;
    private String fGroupName;
    private Desktop fDesktop;
    private AbstractFigureFrameProxy fFrameProxy;
    private String fTitle;
    private boolean fLastDocked = false;
    private boolean fJustOpened = false;
    private DTLocation fLastUndockedLocation = DTLocation.createExternal((int)0, (int)0, (int)0, (int)0);
    private DTLocation fLastDockedLocation = DTLocation.createInternal((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
    private boolean fMenubarVisible = false;
    private FigureDTClientBase fClient;
    private boolean fLightWeight = false;
    private boolean fShowTopSeparator = true;
    private FigureDTClientListener fFigureDTClientListener;
    private ClientProxyNotificationHandler fNotificationHandler;
    private Container fContentContainer;
    private boolean fCloseRequestEnabled;
    private Object fCloseTransaction = null;
    private MJPanel fContentPane = null;
    private Point fLastGroupContainerLocation = null;

    public FigureClientProxy(Desktop desktop, String string, boolean bl, String string2) {
        this.fDesktop = desktop != null ? desktop : FigureClientProxy.getMatlabDesktop();
        this.fGroupName = string;
        this.fTitle = string2;
        this.fLightWeight = bl;
        this.fNotificationHandler = new ClientProxyNotificationHandler();
        this.fFigureDTClientListener = new FigureDTClientListener();
        this.fFigureDTClientListener.setNotificationSuccessor(this);
    }

    public void doInitialize() {
        this.fClient = new FigureDTClientBase(this.fLightWeight);
        this.fContentPane = new MJPanel((LayoutManager)new BorderLayout());
        this.setName("fClientProxy");
        this.setClientGroup(this.fGroupName);
        this.setClientIcon(FigureClientProxy.getClientIcon());
        this.showClientTopSeparator(true);
        if (this.fDesktop != null) {
            this.registerWithDesktop();
            this.fClient.setClientDockable(this.fDesktop.hasMainFrame());
            this.addClientListener((DTClientListener)this.fFigureDTClientListener);
            this.fClient.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    FigureClientProxy.this.handleNotification(new FigureJavaEventNotification(focusEvent));
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    FigureClientProxy.this.handleNotification(new FigureJavaEventNotification(focusEvent));
                }
            });
        }
        this.fClient.setLayout(new BorderLayout(0, 0));
        this.fClient.add((Component)this.fContentPane, "Center");
    }

    public void setFigureFrame(AbstractFigureFrameProxy abstractFigureFrameProxy) {
        this.fFrameProxy = abstractFigureFrameProxy;
        if (this.fFrameProxy != null) {
            this.fFrameProxy.setNotificationSuccessor(this);
        }
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        this.fNotificationHandler.handleNotification(figureNotification);
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    private static Desktop getMatlabDesktop() {
        return MatlabDesktopServices.getDesktop();
    }

    public boolean registerWithDesktop() {
        return this.registerWithDesktop(false, this.getLastUndockedLocation());
    }

    public boolean registerWithDesktop(boolean bl, DTLocation dTLocation) {
        boolean bl2 = false;
        if (this.fDesktop != null) {
            if (!this.fDesktop.hasClient((Component)((Object)this.fClient))) {
                this.fDesktop.addClient((Component)((Object)this.fClient), this.fTitle, bl, dTLocation, bl);
            }
            bl2 = true;
        }
        return bl2;
    }

    public void hideClient() {
        if (this.fDesktop != null) {
            if (this.isClientDocked()) {
                this.fLastDockedLocation = this.getClientLocation();
                assert (this.fLastDockedLocation.isDocked());
            }
            this.fDesktop.hideClient((Component)((Object)this.fClient));
        }
    }

    public void showClient(boolean bl) {
        DTLocation dTLocation = bl ? this.getLastDockedLocation() : this.getLastUndockedLocation();
        this.showClient(dTLocation);
    }

    private void showClient(DTLocation dTLocation) {
        if (this.fDesktop != null) {
            this.fDesktop.showClient((Component)((Object)this.fClient), dTLocation, true);
        }
    }

    public void showClientHidden() {
        if (this.fDesktop != null) {
            DTLocation dTLocation = this.fDesktop.getClientLocation((Component)((Object)this.fClient));
            if (dTLocation != null && !dTLocation.isDocked()) {
                this.setLastUndockedLocation(dTLocation);
            }
            this.fDesktop.showClientHidden((Component)((Object)this.fClient), this.getLastUndockedLocation(), true);
        }
    }

    public void closeClient() {
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient))) {
            this.fDesktop.closeClient((Component)((Object)this.fClient));
        }
    }

    public void toFront() {
        if (this.fDesktop != null) {
            this.fDesktop.setClientSelected((Component)((Object)this.fClient), true);
        }
    }

    public boolean isSelected() {
        if (this.fDesktop != null) {
            return this.fDesktop.isClientSelected((Component)((Object)this.fClient));
        }
        return false;
    }

    Container getMDIContainer() {
        return this.fDesktop == null ? null : this.fDesktop.getGroupContainer(this.getGroupName());
    }

    public boolean isDockedInMDIRegion() {
        return this.getMDIContainer() != null;
    }

    private void addClientListener(DTClientListener dTClientListener) {
        if (this.fDesktop != null) {
            this.fDesktop.addClientListener((Component)((Object)this.fClient), dTClientListener);
        }
    }

    private void removeClientListener(DTClientListener dTClientListener) {
        if (this.fDesktop != null) {
            this.fDesktop.removeClientListener((Component)((Object)this.fClient), dTClientListener);
        }
    }

    public Point getLocation() {
        Rectangle rectangle = this.isClientDocked() ? this.getClientRectangle() : this.getCachedClientRectangle();
        return rectangle.getLocation();
    }

    private DTLocation getClientLocation() {
        return this.fDesktop == null ? null : this.fDesktop.getClientLocation((Component)((Object)this.fClient));
    }

    private void setClientLocation(DTLocation dTLocation) {
        if (this.fDesktop != null) {
            if (dTLocation != null) {
                assert (!dTLocation.isDocked());
                this.setLastUndockedLocation(dTLocation);
            }
            this.fDesktop.setClientLocation((Component)((Object)this.fClient), dTLocation);
        }
    }

    public boolean isClientMaximized() {
        DTLocation dTLocation = this.getClientLocation();
        if (dTLocation == null) {
            dTLocation = this.getLastUndockedLocation();
        }
        return dTLocation.isMaximized();
    }

    public Rectangle getCachedClientRectangle() {
        return this.getLastUndockedLocation().getFrameBounds();
    }

    void setCachedClientRectangle(Rectangle rectangle) {
        this.setLastUndockedLocation(DTLocation.createExternal((int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height));
    }

    public Rectangle getClientRectangle() {
        DTLocation dTLocation = this.getClientLocation();
        if (dTLocation == null) {
            dTLocation = this.getLastUndockedLocation();
        }
        return dTLocation.getFrameBounds();
    }

    void setClientRectangle(Rectangle rectangle) {
        assert (rectangle != null);
        assert (!this.isClientDocked());
        this.setClientLocation(DTLocation.createExternal((int)rectangle.x, (int)rectangle.y, (int)rectangle.width, (int)rectangle.height));
    }

    public void setClientWindowStyle(boolean bl, boolean bl2) {
        assert (!bl || !bl2);
        if (this.fFrameProxy == null) {
            throw new RuntimeException("Figure client has no frame.");
        }
        if (!this.isClientDocked() && !bl) {
            if (bl2 != this.fFrameProxy.isModal()) {
                this.fFrameProxy.setModal(bl2);
            }
        } else if (this.fDesktop != null) {
            this.fFrameProxy.setModal(bl2);
            this.fDesktop.setClientDocked((Component)((Object)this.fClient), bl);
        }
    }

    public boolean isShowing() {
        if (this.fDesktop != null) {
            return this.fDesktop.isClientShowing((Component)((Object)this.fClient));
        }
        return false;
    }

    public boolean isHidden() {
        if (this.fDesktop != null) {
            return this.fDesktop.isClientHidden((Component)((Object)this.fClient));
        }
        return false;
    }

    public Dimension getContainerSize() {
        Container container;
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient)) && (container = this.fDesktop.getGroupContainer(this.getGroupName())) != null) {
            Dimension dimension = container.getSize();
            Insets insets = this.fDesktop.getGroupContainerInsets(this.getGroupName());
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            return dimension;
        }
        return null;
    }

    public Insets getDockedClientInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient))) {
            insets = this.fDesktop.getInternalFrameInsets((Component)((Object)this.fClient));
        }
        return insets;
    }

    private void updateLastGroupContainerLocation() {
        Container container;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fDesktop != null && (container = this.fDesktop.getGroupContainer(this.getGroupName())) != null) {
            this.fLastGroupContainerLocation = new Point(0, 0);
            SwingUtilities.convertPointToScreen(this.fLastGroupContainerLocation, container);
            DTLocation dTLocation = this.getClientLocation();
            boolean bl = false;
            if (dTLocation != null) {
                boolean bl2 = bl = this.getClientLocation().getTile() != Integer.MIN_VALUE;
            }
            if (bl) {
                this.fLastGroupContainerLocation = SwingUtilities.convertPoint((Component)((Object)this.fClient), this.fLastGroupContainerLocation, container);
                this.fLastGroupContainerLocation.y -= this.getDockedClientInsets().top;
            }
        }
    }

    public Point getContainerLocation() {
        if (this.fDesktop != null && this.fDesktop.hasClient((Component)((Object)this.fClient)) && this.fLastGroupContainerLocation != null) {
            Point point = new Point(this.fLastGroupContainerLocation);
            Insets insets = this.fDesktop.getGroupContainerInsets(this.getGroupName());
            if (insets != null) {
                point.translate(insets.left, insets.top);
            }
            return point;
        }
        return null;
    }

    private void setDesktop(Desktop desktop, DTLocation dTLocation, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call setDesktop from the EDT");
        }
        if (this.fDesktop == desktop) {
            // empty if block
        }
        if (null != this.fDesktop) {
            this.fDesktop.removeClientListener((Component)((Object)this.fClient), (DTClientListener)this.fFigureDTClientListener);
            if (this.fDesktop.hasClient((Component)((Object)this.fClient))) {
                this.fDesktop.removeClient((Component)((Object)this.fClient));
            }
            this.fDesktop = null;
        }
        if (null != desktop) {
            this.fDesktop = desktop;
            this.registerWithDesktop(bl, dTLocation);
            this.fDesktop.addClientListener((Component)((Object)this.fClient), (DTClientListener)this.fFigureDTClientListener);
        }
    }

    public void setGroupName(Desktop desktop, String string, boolean bl) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call setGroupName from the EDT");
        }
        this.fGroupName = string;
        DTLocation dTLocation = this.fDesktop.getClientLocation((Component)((Object)this.fClient));
        if (dTLocation == null) {
            dTLocation = this.getLastUndockedLocation();
        }
        this.setDesktop(null, null, bl);
        this.setClientGroup(this.fGroupName);
        this.setDesktop(desktop, dTLocation, bl);
    }

    public void setGroupName(String string, boolean bl) {
        this.setGroupName(this.fDesktop, string, bl);
    }

    public String getGroupName() {
        return this.fGroupName;
    }

    public Desktop getDesktop() {
        return this.fDesktop;
    }

    public static ImageIcon getClientIcon() {
        if (null == sIcon) {
            String string = "resources/matlabicon_figure48.gif";
            sIcon = new ImageIcon(FigurePeer.class.getResource(string));
        }
        return sIcon;
    }

    public void setClientIcon(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = null == imageIcon ? FigureClientProxy.getClientIcon() : imageIcon;
        this.fClient.setClientIcon(imageIcon2);
    }

    public JPanel getContentPane() {
        return this.fContentPane;
    }

    public void setClientToolBars(Vector<JToolBar> vector) {
        assert (vector != null);
        if (vector != null) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.fFrameProxy == null) {
                throw new RuntimeException("Figure client has no frame.");
            }
            int n = vector.size();
            MJToolBar[] mJToolBarArray = new MJToolBar[n];
            vector.toArray(mJToolBarArray);
            this.fClient.setClientToolBars((JToolBar[])mJToolBarArray);
            if (n > 0) {
                this.fFrameProxy.fireToolbarPreferredHeight((JToolBar[])mJToolBarArray, this.fShowTopSeparator);
            } else {
                this.fFrameProxy.fireToolbarContainerEvent(0);
            }
        }
    }

    public void setClientMenuBar(JMenuBar jMenuBar) {
        if (null == jMenuBar) {
            this.fMenubarVisible = false;
        } else {
            this.fClient.setClientDontMergeMenu(true);
            this.fMenubarVisible = true;
        }
        this.fClient.setClientMenuBar(jMenuBar);
    }

    public void setClientTitle(String string) {
        this.fTitle = string;
        this.fClient.setClientTitle(string);
    }

    public void setClientGroup(String string) {
        this.fClient.setClientGroup(string);
    }

    public void setClientDockable(boolean bl) {
        this.fClient.setClientDockable(bl);
    }

    public void showClientTopSeparator(boolean bl) {
        this.fClient.showClientTopSeparator(bl);
    }

    public void vetoClientClose() {
        if (null != this.fCloseTransaction) {
            Object object = this.fCloseTransaction;
            this.fCloseTransaction = null;
            this.fClient.vetoClientClose(object);
        }
    }

    public void approveClientClose() {
        if (null != this.fCloseTransaction) {
            Object object = this.fCloseTransaction;
            this.fCloseTransaction = null;
            this.fClient.approveClientClose(object);
        }
    }

    private void deferClientClose(Object object) {
        this.fCloseTransaction = object;
        this.fClient.deferClientClose();
    }

    private boolean isCloseRequestEnabled() {
        return this.fCloseRequestEnabled;
    }

    public void setCloseRequestEnabled(boolean bl) {
        this.fCloseRequestEnabled = bl;
    }

    public DTClientBase getClient() {
        return this.fClient;
    }

    public void setName(String string) {
        this.fClient.setName(string);
    }

    public Window getWindow() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this.fClient));
    }

    public void setCursor(Cursor cursor) {
        this.fClient.setCursor(cursor);
    }

    public void dispose() {
        this.fFrameProxy = null;
        this.fContentContainer = null;
        this.setNotificationSuccessor(null);
        this.removeClientListener((DTClientListener)this.fFigureDTClientListener);
    }

    public boolean isClientDocked() {
        if (this.fDesktop != null) {
            DTLocation dTLocation = this.getClientLocation();
            if (dTLocation == null) {
                return false;
            }
            return this.fDesktop.isClientDocked((Component)((Object)this.fClient));
        }
        return false;
    }

    public void validateFigure() {
        DTFrame dTFrame;
        if (this.isShowing() && this.fDesktop != null && (dTFrame = this.fDesktop.getContainingFrame((Component)((Object)this.fClient))) != null) {
            dTFrame.getRootPane().validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DTLocation getLastUndockedLocation() {
        DTLocation dTLocation = null;
        FigureClientProxy figureClientProxy = this;
        synchronized (figureClientProxy) {
            dTLocation = DTLocation.clone((DTLocation)this.fLastUndockedLocation);
        }
        assert (dTLocation != null);
        return dTLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastUndockedLocation(DTLocation dTLocation) {
        assert (dTLocation != null);
        FigureClientProxy figureClientProxy = this;
        synchronized (figureClientProxy) {
            this.fLastUndockedLocation = DTLocation.clone((DTLocation)dTLocation);
        }
        this.fLastDocked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DTLocation getLastDockedLocation() {
        DTLocation dTLocation = null;
        FigureClientProxy figureClientProxy = this;
        synchronized (figureClientProxy) {
            dTLocation = DTLocation.clone((DTLocation)this.fLastDockedLocation);
        }
        assert (dTLocation != null);
        return dTLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastDockedLocation(DTLocation dTLocation) {
        assert (dTLocation != null);
        assert (dTLocation.isDocked());
        FigureClientProxy figureClientProxy = this;
        synchronized (figureClientProxy) {
            this.fLastDockedLocation = DTLocation.clone((DTLocation)dTLocation);
        }
        this.fLastDocked = true;
    }

    private class FigureDTClientBase
    extends DTClientBase {
        public FigureDTClientBase(boolean bl) {
            this.initialize(bl);
        }

        protected DTSingleClientFrame createFrame(Desktop desktop, String string) {
            if (FigureClientProxy.this.fFrameProxy == null) {
                throw new RuntimeException("Figure client has no frame.");
            }
            return FigureClientProxy.this.fFrameProxy.createFigurePeerFrame(desktop, string, FigureClientProxy.this.isHidden());
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Dimension dimension2 = FigureClientProxy.this.fContentPane.getPreferredSize();
            if (dimension.width > dimension2.width) {
                dimension.width = dimension2.width;
            }
            return dimension;
        }

        private void initialize(boolean bl) {
            this.setMultipleInstances(true);
            this.setDontReopen(true);
            this.setHeavyweight(!bl);
            this.setStatusBar(DTClientProperty.NULL_STATUS_BAR);
            this.setDontMergeMenu(true);
            this.setOfferToolBarToggles(false);
            this.setDebuggerToFront(true);
            this.setUndockedBounding(DTProperty.Bounding.NONE);
            this.setAllowForcedClose(false);
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    FigureJavaEventNotification figureJavaEventNotification = new FigureJavaEventNotification(mouseWheelEvent);
                    FigureClientProxy.this.fNotificationHandler.handleNotification(figureJavaEventNotification);
                }
            });
        }

        public void setClientDockable(boolean bl) {
            this.setDockable(bl);
        }

        public void setClientIcon(Icon icon) {
            this.setIcon(icon);
        }

        public void setClientToolBars(JToolBar[] jToolBarArray) {
            this.setToolBars(jToolBarArray);
        }

        public void setClientMenuBar(JMenuBar jMenuBar) {
            this.setMenuBar(jMenuBar);
        }

        public void setClientDontMergeMenu(boolean bl) {
            this.setDontMergeMenu(bl);
        }

        public void setClientTitle(String string) {
            this.setTitle(string);
        }

        public void setClientGroup(String string) {
            this.setGroup(string);
        }

        public void showClientTopSeparator(boolean bl) {
            FigureClientProxy.this.fShowTopSeparator = bl;
            this.setWantTopSeparator(bl);
        }

        public void approveClientClose(Object object) {
            this.approveClose(object);
        }

        public void vetoClientClose(Object object) {
            this.vetoClose(object);
        }

        public void deferClientClose() {
            this.deferClose();
        }
    }

    private class ClientProxyNotificationHandler
    extends FigureNotificationHandlerImpl {
        private ClientProxyNotificationHandler() {
        }

        @Override
        public void handleNotification(FigureNotification figureNotification) {
            if (figureNotification instanceof FigureMenuBarNotification) {
                this.handleMenuBarNotification((FigureMenuBarNotification)figureNotification);
                return;
            }
            if (figureNotification instanceof FigureDTClientEventNotification) {
                this.handleDTClientEventNotification((FigureDTClientEventNotification)figureNotification);
                return;
            }
            if (figureNotification instanceof FigureJavaEventNotification) {
                this.handleJavaEventNotification((FigureJavaEventNotification)figureNotification);
                return;
            }
            if (figureNotification instanceof FigurePanelProxyNotification && figureNotification.getType() == 1) {
                JPanel jPanel = FigureClientProxy.this.getContentPane();
                Container container = ((FigurePanelProxyNotification)figureNotification).getContainer();
                if (FigureClientProxy.this.fContentContainer != container) {
                    if (FigureClientProxy.this.fContentContainer != null) {
                        jPanel.remove(FigureClientProxy.this.fContentContainer);
                    }
                    FigureClientProxy.this.fContentContainer = container;
                    FigureClientProxy.this.getContentPane().add((Component)FigureClientProxy.this.fContentContainer, "Center");
                    FigureClientProxy.this.getContentPane().validate();
                }
            }
            super.handleNotification(figureNotification);
        }

        private void handleMenuBarNotification(FigureMenuBarNotification figureMenuBarNotification) {
            switch (figureMenuBarNotification.getType()) {
                case 2: {
                    FigureClientProxy.this.setClientMenuBar((JMenuBar)figureMenuBarNotification.getMenuBar());
                    return;
                }
                case 3: {
                    FigureClientProxy.this.setClientMenuBar(null);
                    return;
                }
                case 4: {
                    if (FigureClientProxy.this.fMenubarVisible) break;
                    figureMenuBarNotification = new FigureMenuBarNotification(1, 0, null);
                    break;
                }
            }
            super.handleNotification(figureMenuBarNotification);
        }

        private void handleDTClientEventNotification(FigureDTClientEventNotification figureDTClientEventNotification) {
            DTClientEvent dTClientEvent = figureDTClientEventNotification.getEvent();
            FigureJavaEventNotification figureJavaEventNotification = null;
            switch (dTClientEvent.getType()) {
                case 2: {
                    if (!FigureClientProxy.this.isClientDocked()) break;
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 205);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 12: {
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 201);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 11: {
                    if (!FigureClientProxy.this.isCloseRequestEnabled()) break;
                    DebugUtilities.logMessage(1024, "FigureClientProxy.DTClientEvent.CLOSING closeRequest is enabled", this);
                    FigureClientProxy.this.deferClientClose(dTClientEvent.getData());
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 201);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 3: {
                    if (!FigureClientProxy.this.isClientDocked()) break;
                    ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 206);
                    figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    break;
                }
                case 10: {
                    if (FigureClientProxy.this.isClientDocked()) {
                        ComponentEvent componentEvent = new ComponentEvent(dTClientEvent.getClient(), 200);
                        figureJavaEventNotification = new FigureJavaEventNotification(componentEvent);
                    }
                    FigureClientProxy.this.fJustOpened = true;
                    break;
                }
                case 8: 
                case 9: {
                    Object object;
                    boolean bl;
                    DTLocation dTLocation = (DTLocation)dTClientEvent.getData();
                    assert (dTLocation != null);
                    boolean bl2 = bl = dTClientEvent.getType() == 8;
                    if (FigureClientProxy.this.isClientDocked()) {
                        FigureClientProxy.this.updateLastGroupContainerLocation();
                        if (bl && ((object = FigureClientProxy.this.getLastDockedLocation()).getFrameWidth() != dTLocation.getFrameWidth() || object.getFrameHeight() != dTLocation.getFrameHeight() || !FigureClientProxy.this.fLastDocked)) {
                            bl = false;
                        }
                        FigureClientProxy.this.setLastDockedLocation(dTLocation);
                    } else {
                        if (bl && (FigureClientProxy.this.fLastDocked || FigureClientProxy.this.fJustOpened)) {
                            bl = false;
                        }
                        FigureClientProxy.this.setLastUndockedLocation(dTLocation);
                    }
                    FigureClientProxy.this.fJustOpened = false;
                    if (dTLocation.getFrameWidth() <= 0 && dTLocation.getFrameHeight() <= 0) break;
                    object = new FigureMoveResizeNotification(bl);
                    FigureClientProxy.this.fNotificationHandler.handleNotification((FigureNotification)object);
                    break;
                }
                default: {
                    super.handleNotification(figureDTClientEventNotification);
                }
            }
            super.handleNotification(figureJavaEventNotification);
        }

        private void handleJavaEventNotification(FigureJavaEventNotification figureJavaEventNotification) {
            AWTEvent aWTEvent = figureJavaEventNotification.getEvent();
            if (aWTEvent instanceof KeyEvent) {
                if (((KeyEvent)aWTEvent).getKeyCode() != 9) {
                    FigureClientProxy.this.fClient.dispatchEvent(aWTEvent);
                }
            } else if (aWTEvent instanceof WindowEvent && aWTEvent.getID() == 206 && FigureClientProxy.this.isClientDocked()) {
                return;
            }
            super.handleNotification(figureJavaEventNotification);
        }
    }
}

