/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.CDataGrabber;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.ImageUtil;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

public class FBOGrabber
implements CDataGrabber {
    private final JavaSceneServerPeerInterface fJavaSceneServerPeer;
    private int fFboId;
    private int fTextureId;
    private int fDepthId;
    private boolean fGrabCData;
    private int fWidth;
    private int fHeight;
    private int fGLFormat;

    public FBOGrabber(JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        this.fJavaSceneServerPeer = javaSceneServerPeerInterface;
        this.fFboId = 0;
        this.fTextureId = 0;
        this.fDepthId = 0;
        this.fGrabCData = false;
        this.fWidth = 0;
        this.fHeight = 0;
    }

    @Override
    public void setGrabCData(boolean bl, GL gL) {
        this.fGrabCData = bl;
    }

    @Override
    public boolean getGrabCData() {
        return this.fGrabCData;
    }

    private void noFBOError(GL gL) throws JavaSceneServerPeer.HGGLException {
        this.releaseCDataGrabberData(gL);
        throw new JavaSceneServerPeer.HGGLException("JSSP_NOFBO: No FrameBuffer support");
    }

    private void fboSizeError(GL gL, int n) throws JavaSceneServerPeer.HGGLException {
        String string = "";
        if (this.fJavaSceneServerPeer.getOpenGLPrintResolution() > 0) {
            double d = Math.max(this.fWidth, this.fHeight);
            int n2 = (int)((double)this.fJavaSceneServerPeer.getOpenGLPrintResolution() * ((double)n / d));
            string = " Consider specifying a resolution of no more than " + n2 + ".";
        }
        this.releaseCDataGrabberData(gL);
        throw new JavaSceneServerPeer.HGGLException("JSSP_FBOSIZE: The requested width or height is too large. Neither can be larger than " + n + " pixels." + string);
    }

    @Override
    public boolean setupCDataGrabber(GL gL, int n, int n2) throws JavaSceneServerPeer.HGGLException {
        if (!gL.isExtensionAvailable("GL_EXT_framebuffer_object")) {
            this.noFBOError(gL);
        }
        this.fGLFormat = 6407;
        this.fWidth = n;
        this.fHeight = n2;
        int[] nArray = new int[1];
        gL.glGetIntegerv(34024, IntBuffer.wrap(nArray));
        if (nArray[0] == 0) {
            this.noFBOError(gL);
        }
        if (this.fWidth > nArray[0] || this.fHeight > nArray[0]) {
            this.fboSizeError(gL, nArray[0]);
        }
        int[] nArray2 = new int[1];
        gL.glGetIntegerv(3379, IntBuffer.wrap(nArray2));
        if (this.fWidth > nArray2[0] || this.fHeight > nArray2[0]) {
            this.fboSizeError(gL, nArray2[0]);
        }
        int[] nArray3 = new int[1];
        gL.glGenFramebuffersEXT(1, nArray3, 0);
        this.fFboId = nArray3[0];
        gL.glBindFramebufferEXT(36160, this.fFboId);
        int[] nArray4 = new int[1];
        gL.glGenRenderbuffersEXT(1, nArray4, 0);
        this.fDepthId = nArray4[0];
        gL.glBindRenderbufferEXT(36161, this.fDepthId);
        gL.glRenderbufferStorageEXT(36161, 33191, this.fWidth, this.fHeight);
        gL.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.fDepthId);
        int[] nArray5 = new int[1];
        gL.glGenTextures(1, nArray5, 0);
        this.fTextureId = nArray5[0];
        gL.glBindTexture(34037, this.fTextureId);
        gL.glTexImage2D(34037, 0, this.fGLFormat, this.fWidth, this.fHeight, 0, this.fGLFormat, 5121, null);
        int n3 = gL.glGetError();
        if (n3 != 0) {
            this.fJavaSceneServerPeer.reportError("MATLAB:HG:Java:CreateTextureFailed", "Framebuffer initialization error! Texture did not get created (" + n3 + ")");
            this.releaseCDataGrabberData(gL);
            return false;
        }
        int n4 = 9729;
        gL.glTexParameteri(34037, 10241, n4);
        gL.glTexParameteri(34037, 10240, n4);
        gL.glFramebufferTexture2DEXT(36160, 36064, 34037, this.fTextureId, 0);
        gL.glDrawBuffer(36064);
        int n5 = gL.glCheckFramebufferStatusEXT(36160);
        boolean bl = false;
        String string = "";
        String string2 = "";
        switch (n5) {
            case 0: 
            case 36053: {
                bl = true;
                break;
            }
            case 36054: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO incomplete attachment. " + n5, this);
                break;
            }
            case 36055: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO missing attachment. " + n5, this);
                break;
            }
            case 36056: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO creation failed. " + n5, this);
                break;
            }
            case 36057: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO incomplete dimensions. " + n5, this);
                break;
            }
            case 36058: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO incomplete formats. " + n5, this);
                break;
            }
            case 36059: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO incomplete drawbuffer. " + n5, this);
                break;
            }
            case 36060: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO incomplete readbuffer. " + n5, this);
                break;
            }
            case 36061: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO unsupported configuration. " + n5, this);
                string = "JSSP_FBOCONFIGURATION: ";
                string2 = "Problem obtaining FBO. Please try again after closing other OpenGL applications.";
                break;
            }
            default: {
                DebugUtilities.logMessage(16, "setupCDataGrabber:FBO unknown initialization error. " + n5, this);
            }
        }
        if (!bl) {
            if (string.isEmpty()) {
                string = "JSSP_FBOSETUP: ";
                string2 = "Problem initializing FBO.";
            }
            this.releaseCDataGrabberData(gL);
            throw new JavaSceneServerPeer.HGGLException(string.concat(string2));
        }
        return bl;
    }

    @Override
    public void stopGrabbingCData(GL gL) {
        gL.glBindFramebufferEXT(36160, 0);
        this.releaseCDataGrabberData(gL);
    }

    private void releaseCDataGrabberData(GL gL) {
        int[] nArray;
        if (this.fTextureId != 0) {
            nArray = new int[]{this.fTextureId};
            gL.glDeleteTextures(1, nArray, 0);
            this.fTextureId = 0;
        }
        if (this.fDepthId != 0) {
            nArray = new int[]{this.fDepthId};
            gL.glDeleteRenderbuffersEXT(1, nArray, 0);
            this.fDepthId = 0;
        }
        if (this.fFboId != 0) {
            nArray = new int[]{this.fFboId};
            gL.glDeleteFramebuffersEXT(1, nArray, 0);
            this.fFboId = 0;
        }
        this.fGrabCData = false;
    }

    @Override
    public BufferedImage doGrabBufferedImage(GLAutoDrawable gLAutoDrawable) {
        int n;
        Buffer buffer;
        int n2;
        int n3 = 1;
        switch (this.fGLFormat) {
            case 6408: {
                n3 = 4;
                break;
            }
            case 6407: {
                n3 = 3;
            }
        }
        boolean bl = false;
        int[] nArray = null;
        byte[] byArray = null;
        if (bl) {
            n2 = 5124;
            nArray = new int[this.fWidth * this.fHeight * n3];
            buffer = IntBuffer.wrap(nArray);
        } else {
            n2 = 5121;
            byArray = new byte[this.fWidth * this.fHeight * n3];
            buffer = ByteBuffer.wrap(byArray);
        }
        buffer.rewind();
        GL gL = gLAutoDrawable.getGL();
        gL.glFinish();
        gL.glPixelStorei(3333, 1);
        gL.glGetTexImage(34037, 0, this.fGLFormat, n2, buffer);
        int n4 = 2;
        int n5 = 0;
        do {
            if ((n = gL.glGetError()) == 0) continue;
            ++n5;
            this.fJavaSceneServerPeer.reportError("MATLAB:HG:Java:GrabCData:GLGetCData", "OpenGL error (" + n + ") reading cdata from context.");
        } while (n != 0 && n5 < n4);
        assert (n5 < n4) : "GLErrorCount >= " + n4 + " - returning NULL image";
        BufferedImage bufferedImage = null;
        if (n5 < n4) {
            buffer.rewind();
            int[] nArray2 = new int[this.fWidth * this.fHeight];
            int n6 = 0;
            int n7 = this.fHeight - 1;
            while (n7 >= 0) {
                int n8 = n6 * this.fWidth;
                for (int i = 0; i < this.fWidth; ++i) {
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13 = this.fWidth * n7 * n3 + i * n3;
                    if (n2 == 5121) {
                        n12 = byArray[n13++] & 0xFF;
                        n11 = byArray[n13++] & 0xFF;
                        n10 = byArray[n13++] & 0xFF;
                        n9 = 0;
                        if (this.fGLFormat == 6408) {
                            n9 = byArray[n13] & 0xFF;
                        }
                    } else {
                        n12 = (nArray[n13++] & 0xFF000000) >>> 24;
                        n11 = (nArray[n13++] & 0xFF0000) >>> 16;
                        n10 = (nArray[n13++] & 0xFF00) >>> 8;
                        n9 = 0;
                        if (this.fGLFormat == 6408) {
                            n9 = nArray[n13] & 0xFF;
                        }
                    }
                    nArray2[n8++] = n9 << 24 | n12 << 16 | n11 << 8 | n10;
                }
                --n7;
                ++n6;
            }
            bufferedImage = ImageUtil.makeImage(this.fWidth, this.fHeight, nArray2, this.fGLFormat == 6408);
            assert (bufferedImage != null) : "NULL ImageData from ImageUtil.makeImage";
        }
        if (bufferedImage == null) {
            this.fJavaSceneServerPeer.reportError("MATLAB:HG:Java:GrabCData:NoImage", "Image data (cdataImage) is null");
        }
        return bufferedImage;
    }
}

