/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.domviewer;

import ice.pilots.domviewer.JavaPilot;
import ice.pilots.domviewer.MyNodeInfo;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.storm.Viewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLCollection;

public class DOMWindow
extends JPanel
implements TreeSelectionListener {
    JavaPilot the_pilot = null;
    JTree my_tree = null;
    JEditorPane view_area = null;
    URL loc = null;
    DefaultMutableTreeNode top = null;

    public DOMWindow(JavaPilot javaPilot) {
        super(new BorderLayout());
        this.the_pilot = javaPilot;
        this.top = new DefaultMutableTreeNode("The DOM Tree");
        this.my_tree = new JTree(this.top);
        this.my_tree.getSelectionModel().setSelectionMode(1);
        this.my_tree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.my_tree);
        this.view_area = new JEditorPane();
        this.view_area.setEditable(false);
        this.view_area.setContentType("text/html");
        JScrollPane jScrollPane2 = new JScrollPane(this.view_area);
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setTopComponent(jScrollPane);
        jSplitPane.setBottomComponent(jScrollPane2);
        Dimension dimension = new Dimension(100, 50);
        jScrollPane2.setMinimumSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setPreferredSize(new Dimension(600, 400));
        this.add((Component)jSplitPane, "Center");
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.my_tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode == this.top) {
            Viewport viewport = this.the_pilot.get_other_view();
            String string = null;
            String string2 = null;
            if (viewport != null) {
                string = viewport.getLocation();
                string2 = viewport.getBaseUrl();
            }
            this.view_area.setText("<b>Location:</b> " + string + "<br>" + "<b>Base:</b> " + string2 + "<br>");
        } else {
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof MyNodeInfo) {
                MyNodeInfo myNodeInfo = (MyNodeInfo)object;
                if (myNodeInfo.node instanceof Node) {
                    this.displayNode((Node)myNodeInfo.node);
                }
            }
        }
    }

    String getAttrInfo(Node node) {
        String string;
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        int n = namedNodeMap.getLength();
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<b>Attributes:</b><br>");
        int n2 = 0;
        while (n2 < n) {
            node2 = namedNodeMap.item(n2);
            if (node2 != null && (string = node2.getNodeName()) != null) {
                stringBuffer.append("&nbsp;&nbsp;&nbsp; ");
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                stringBuffer.append("\"" + node2.getNodeValue() + "\"");
                stringBuffer.append(" {" + node2.getNamespaceURI() + "}");
                stringBuffer.append("<br>");
            }
            ++n2;
        }
        if (node instanceof DElement && (string = (node2 = (DElement)node).getStyle().getCssText()) != null && string.length() != 0) {
            stringBuffer.append("<b>Style:</b><br><pre>");
            stringBuffer.append(node2.getStyle().getCssText());
            stringBuffer.append("</pre>");
        }
        return stringBuffer.toString();
    }

    String getTypeAsText(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "ELEMENT_NODE";
                break;
            }
            case 2: {
                string = "ATTRIBUTE_NODE";
                break;
            }
            case 3: {
                string = "TEXT_NODE";
                break;
            }
            case 4: {
                string = "CDATA_SECTION_NODE";
                break;
            }
            case 5: {
                string = "ENTITY_REFERENCE_NODE";
                break;
            }
            case 6: {
                string = "ENTITY_NODE";
                break;
            }
            case 7: {
                string = "PROCESSING_INSTRUCTION_NODE";
                break;
            }
            case 8: {
                string = "COMMENT_NODE";
                break;
            }
            case 9: {
                string = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                string = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 11: {
                string = "DOCUMENT_FRAGMENT_NODE";
                break;
            }
            case 12: {
                string = "NOTATION_NODE";
                break;
            }
        }
        return string;
    }

    String getNameOfNode(Node node) {
        String string = "";
        if (node instanceof DElement && ((DElement)node).getSynthetic()) {
            string = "[*] ";
        }
        string = string + node.getNodeName();
        return string;
    }

    String getDispLine(String string, Object object) {
        return "<b>" + string + ":</b> " + object + "<br>\n";
    }

    void displayNode(Node node) {
        String string = this.getNameOfNode(node);
        String string2 = node.getNamespaceURI();
        short s = node.getNodeType();
        String string3 = node.getNodeValue();
        String string4 = this.getAttrInfo(node);
        String string5 = "";
        if (string != null) {
            string5 = string5 + this.getDispLine("Name", string);
        }
        string5 = string5 + this.getDispLine("nsURI", string2);
        if (s > 0) {
            string5 = string5 + this.getDispLine("Type", this.getTypeAsText(s));
        }
        if (string3 != null) {
            string5 = string5 + this.getDispLine("Value", string3);
        }
        if (string4 != null) {
            string5 = string5 + string4;
        }
        this.view_area.setText(string5);
    }

    void addNodes(Node node, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new MyNodeInfo(node2, this.getNameOfNode(node2)));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.addNodes(node2, defaultMutableTreeNode2);
                ++n;
            }
        }
    }

    void addImages(Node node) {
        HTMLCollection hTMLCollection;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Images");
        Document document = node.getOwnerDocument();
        if (document instanceof DDocument && (hTMLCollection = ((DDocument)document).getImages()) != null) {
            int n = 0;
            while (n < hTMLCollection.getLength()) {
                Node node2 = hTMLCollection.item(n);
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new MyNodeInfo(node2, this.getNameOfNode(node2))));
                this.top.add(defaultMutableTreeNode);
                ++n;
            }
        }
    }

    void addForms(Node node) {
        HTMLCollection hTMLCollection;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Forms");
        boolean bl = true;
        Document document = node.getOwnerDocument();
        if (document instanceof DDocument && (hTMLCollection = ((DDocument)document).getForms()) != null) {
            int n = 0;
            while (n < hTMLCollection.getLength()) {
                Node node2 = hTMLCollection.item(n);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new MyNodeInfo(node2, this.getNameOfNode(node2)));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                bl = false;
                this.addNodes(node2, defaultMutableTreeNode2);
                ++n;
            }
        }
        if (!bl) {
            this.top.add(defaultMutableTreeNode);
        }
    }

    void addTags(Node node, String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string + "s");
        boolean bl = true;
        Document document = node.getOwnerDocument();
        if (document instanceof DDocument) {
            DDocument dDocument = (DDocument)document;
            NodeList nodeList = dDocument.getElementsByTagName(string);
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new MyNodeInfo(node2, this.getNameOfNode(node2)));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                bl = false;
                this.addNodes(node2, defaultMutableTreeNode2);
                ++n;
            }
        }
        if (!bl) {
            this.top.add(defaultMutableTreeNode);
        }
    }

    void createNodes() {
        Element element;
        if (this.the_pilot != null && this.the_pilot instanceof JavaPilot && (element = this.the_pilot.getRootNode()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new MyNodeInfo(element, this.getNameOfNode(element)));
            this.addNodes(element, defaultMutableTreeNode);
            this.top.add(defaultMutableTreeNode);
            this.addImages(element);
            this.addForms(element);
            this.addTags(element, "IFRAME");
            this.addTags(element, "SCRIPT");
            this.repaint();
        }
    }
}

