/*
 * Decompiled with CFR 0.152.
 */
package ice.dom.html;

import ice.dom.html.DefaultHTMLElement;
import ice.pilots.html4.DDocument;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class TableCellElement
extends DefaultHTMLElement
implements HTMLTableCellElement {
    public TableCellElement(DDocument dDocument, int n) {
        super(dDocument, n);
    }

    public String getAbbr() {
        return this.getAttribute(1);
    }

    public void setAbbr(String string) {
        this.setAttribute(1, string);
    }

    public String getAxis() {
        return this.getAttribute(10);
    }

    public void setAxis(String string) {
        this.setAttribute(10, string);
    }

    public int getColSpan() {
        return DefaultHTMLElement.parseAttribute(this, 29, 1, 1, Integer.MAX_VALUE);
    }

    public void setColSpan(int n) {
        this.setAttribute(29, Integer.toString(n));
    }

    public int getRowSpan() {
        return DefaultHTMLElement.parseAttribute(this, 93, 1, 1, Integer.MAX_VALUE);
    }

    public void setRowSpan(int n) {
        this.setAttribute(93, Integer.toString(n));
    }

    public String getHeaders() {
        return this.getAttribute(44);
    }

    public void setHeaders(String string) {
        this.setAttribute(44, string);
    }

    public boolean getNoWrap() {
        return this.getAttribute(67) != null;
    }

    public void setNoWrap(boolean bl) {
        this.setAttribute(67, bl ? "noWrap" : null);
    }

    public String getScope() {
        return this.getAttribute(96);
    }

    public void setScope(String string) {
        this.setAttribute(96, string);
    }

    public int getCellIndex() {
        Node node = this.getParentNode();
        if (node instanceof HTMLTableRowElement) {
            HTMLCollection hTMLCollection = ((HTMLTableRowElement)node).getCells();
            int n = 0;
            while (n < hTMLCollection.getLength()) {
                if (hTMLCollection.item(n) == this) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public Object getDynamicValue(String string, DynEnv dynEnv) {
        int n = TableCellElement.equals(string);
        if (n < 0) {
            return dynEnv.wrapMethod((DynamicObject)this, string);
        }
        if (n > 0) {
            return this.OEAB(n, dynEnv);
        }
        return super.getDynamicValue(string, dynEnv);
    }

    public int setDynamicValue(String string, Object object, DynEnv dynEnv) {
        int n = TableCellElement.equals(string);
        if (n < 0) {
            return 2;
        }
        if (n > 0) {
            return this.charAt(n, object, dynEnv);
        }
        return super.setDynamicValue(string, object, dynEnv);
    }

    private Object OEAB(int n, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                return this.getAbbr();
            }
            case 2: {
                return this.getAxis();
            }
            case 3: {
                return dynEnv.wrapInt(this.getCellIndex());
            }
            case 4: {
                return dynEnv.wrapInt(this.getColSpan());
            }
            case 5: {
                return this.getHeaders();
            }
            case 6: {
                return dynEnv.wrapBoolean(this.getNoWrap());
            }
            case 7: {
                return dynEnv.wrapInt(this.getRowSpan());
            }
            case 8: {
                return this.getScope();
            }
        }
        return null;
    }

    private int charAt(int n, Object object, DynEnv dynEnv) {
        switch (n) {
            case 1: {
                this.setAbbr(dynEnv.toStr(object));
                return 1;
            }
            case 2: {
                this.setAxis(dynEnv.toStr(object));
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                this.setColSpan(dynEnv.toInt(object));
                return 1;
            }
            case 5: {
                this.setHeaders(dynEnv.toStr(object));
                return 1;
            }
            case 6: {
                this.setNoWrap(dynEnv.toBoolean(object));
                return 1;
            }
            case 7: {
                this.setRowSpan(dynEnv.toInt(object));
                return 1;
            }
            case 8: {
                this.setScope(dynEnv.toStr(object));
                return 1;
            }
        }
        return 2;
    }

    private static int equals(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                char c = string.charAt(1);
                if (c == 'b') {
                    string2 = "abbr";
                    n = 1;
                    break;
                }
                if (c != 'x') break;
                string2 = "axis";
                n = 2;
                break;
            }
            case 5: {
                string2 = "scope";
                n = 8;
                break;
            }
            case 6: {
                string2 = "noWrap";
                n = 6;
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "colSpan";
                    n = 4;
                    break;
                }
                if (c == 'h') {
                    string2 = "headers";
                    n = 5;
                    break;
                }
                if (c != 'r') break;
                string2 = "rowSpan";
                n = 7;
                break;
            }
            case 9: {
                string2 = "cellIndex";
                n = 3;
            }
        }
        if (string2 != null && (string2 == string || string2.equals(string))) {
            return n;
        }
        return 0;
    }
}

