/*
 * Decompiled with CFR 0.152.
 */
package ice.util.io;

import ice.util.Defs;
import java.io.IOException;
import java.io.InputStream;

public class LazyCachedInputStream
extends InputStream {
    private byte[] OEAB;
    private boolean arraycopy;
    private InputStream available;
    private int close = -1;
    private byte[] max = new byte[Defs.sysPropertyInt("ice.net.readBufferSize", 4096)];

    public LazyCachedInputStream(InputStream inputStream) throws IllegalArgumentException {
        this(inputStream, 4096);
    }

    public LazyCachedInputStream(InputStream inputStream, int n) throws IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("initialCacheSize < 0");
        }
        this.available = inputStream;
        this.OEAB = new byte[n];
    }

    public int available() throws IOException {
        if (this.arraycopy) {
            throw new IOException("stream is closed");
        }
        int n = this.close + 1;
        if (this.available != null) {
            n += this.available.available();
        }
        return n;
    }

    public void close() throws IOException {
        if (!this.arraycopy) {
            try {
                if (this.available != null) {
                    this.available.close();
                }
                Object var2_1 = null;
                this.available = null;
                this.OEAB = null;
                this.close = -1;
                this.arraycopy = true;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.available = null;
                this.OEAB = null;
                this.close = -1;
                this.arraycopy = true;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        return this.read(this.close + 1);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(this.close + 1, byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.read(this.close + 1, byArray, n, n2);
    }

    public int read(int n) throws IndexOutOfBoundsException, IOException {
        if (this.arraycopy) {
            throw new IOException("read error: stream is closed");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n > this.close) {
            if (this.arraycopy(n) == -1 || n > this.close) {
                return -1;
            }
            return this.available(this.OEAB[n]);
        }
        return this.available(this.OEAB[n]);
    }

    public int read(int n, byte[] byArray) throws IllegalArgumentException, IndexOutOfBoundsException, IOException {
        return this.read(n, byArray, 0, byArray.length);
    }

    public int read(int n, byte[] byArray, int n2, int n3) throws IllegalArgumentException, IndexOutOfBoundsException, IOException {
        if (this.arraycopy) {
            throw new IOException("read error: stream is closed");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (n + n3 - 1 > this.close && this.arraycopy(n + n3 - 1) == -1 && n > this.close) {
            return -1;
        }
        int n4 = Math.min(n3, this.close - n + 1);
        System.arraycopy(this.OEAB, n, byArray, n2, n4);
        return n4;
    }

    private void OEAB(int n) {
        int n2 = this.OEAB.length;
        if (n > n2) {
            byte[] byArray = this.OEAB;
            this.OEAB = new byte[Math.max(n2 * 3 / 2 + 1, n)];
            System.arraycopy(byArray, 0, this.OEAB, 0, this.close + 1);
        }
    }

    private int arraycopy(int n) throws IOException {
        if (this.available == null) {
            return -1;
        }
        int n2 = 0;
        if (this.close != n) {
            int n3 = this.available.read(this.max, 0, this.max.length);
            if (n3 == -1) {
                this.available.close();
                this.available = null;
                return -1;
            }
            if (n3 != 0) {
                this.OEAB(this.close + 1 + n3);
                System.arraycopy(this.max, 0, this.OEAB, this.close + 1, n3);
                this.close += n3;
                n2 += n3;
            }
            while (n > this.close) {
                n3 = this.available.read(this.max, 0, this.max.length);
                if (n3 == -1) {
                    this.available.close();
                    this.available = null;
                    return n2;
                }
                if (n3 == 0) continue;
                this.OEAB(this.close + 1 + n3);
                System.arraycopy(this.max, 0, this.OEAB, this.close + 1, n3);
                this.close += n3;
                n2 += n3;
            }
        }
        return n2;
    }

    private int available(byte n) {
        return n >= 0 ? n : 256 + n;
    }
}

