/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.CorruptedStoreException;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.norm.StoreException;
import com.sun.jini.norm.lookup.SubStore;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.system.FileSystem;
import com.sun.jini.thread.ReadersWriter;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.ConfigurationException;

class PersistentStore {
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private ReliableLog log;
    private final ReadersWriter mutatorLock = new ReadersWriter();
    private static final ThreadLocal lockState = new ThreadLocal();
    private static final Long zero = new Long(0L);
    private final File storeLocation;
    private final LogHandler logHandler;
    private final NormServerBaseImpl server;
    private int updateCount;
    private List subStores = new LinkedList();

    PersistentStore(String string, LogHandler logHandler, NormServerBaseImpl normServerBaseImpl) throws StoreException {
        this.logHandler = logHandler;
        this.server = normServerBaseImpl;
        if (string == null) {
            this.storeLocation = null;
        } else {
            this.storeLocation = new File(string);
            try {
                this.log = new ReliableLog(this.storeLocation.getCanonicalPath(), logHandler);
            }
            catch (IOException iOException) {
                throw new CorruptedStoreException("Failure creating reliable log", iOException);
            }
            try {
                this.log.recover();
            }
            catch (IOException iOException) {
                throw new CorruptedStoreException("Failure recovering reliable log", iOException);
            }
        }
    }

    void destroy() throws IOException {
        Iterator iterator = this.subStores.iterator();
        while (iterator.hasNext()) {
            SubStore subStore = (SubStore)iterator.next();
            subStore.prepareDestroy();
        }
        if (this.log != null) {
            this.log.deletePersistentStore();
            FileSystem.destroy(this.storeLocation, true);
        }
    }

    void addSubStore(SubStore subStore) throws StoreException {
        try {
            if (this.log == null) {
                subStore.setDirectory(null);
            } else {
                String string = subStore.subDirectory();
                if (string == null) {
                    subStore.setDirectory(this.storeLocation);
                } else {
                    subStore.setDirectory(new File(this.storeLocation, string));
                }
            }
            this.subStores.add(subStore);
        }
        catch (IOException iOException) {
            throw new StoreException("Failure adding substore " + subStore, iOException);
        }
        catch (ConfigurationException configurationException) {
            throw new StoreException("Failure adding substore " + subStore, configurationException);
        }
    }

    void acquireMutatorLock() {
        long l;
        Long l2 = (Long)lockState.get();
        if (l2 == null) {
            l2 = zero;
        }
        if ((l = l2.longValue()) == 0L) {
            this.mutatorLock.readLock();
        }
        lockState.set(new Long(l + 1L));
    }

    void releaseMutatorLock() {
        long l;
        Long l2 = (Long)lockState.get();
        if (l2 == null) {
            l2 = zero;
        }
        if ((l = l2.longValue()) == 0L) {
            return;
        }
        if (l == 1L) {
            this.mutatorLock.readUnlock();
            l2 = zero;
        } else {
            l2 = new Long(l - 1L);
        }
        lockState.set(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object object) {
        if (this.log == null) {
            return;
        }
        Long l = (Long)lockState.get();
        if (l == null || l == 0L) {
            throw new IllegalStateException("PersistentStore.update:Must acquire mutator lock before calling update()");
        }
        PersistentStore persistentStore = this;
        synchronized (persistentStore) {
            try {
                this.log.update(object, true);
                ++this.updateCount;
                this.server.updatePerformed(this.updateCount);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "IOException while updating log", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.mutatorLock.writeLock();
            this.updateCount = 0;
            this.log.snapshot();
            Object var2_1 = null;
            this.mutatorLock.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mutatorLock.writeUnlock();
            throw throwable;
        }
    }
}

