/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppFileDetailPanel;
import com.mathworks.appmanagement.AppManagementApiBuilder;
import com.mathworks.appmanagement.AppMetadata;
import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.util.Converter;
import java.io.IOException;
import java.util.ResourceBundle;

public final class AppFileInfoProvider
implements FileInfoProvider,
ActionProvider {
    private static FileDecoration<AppExtraInfo> sExtraInfoDecoration = new FileDecoration("app-extra-info");

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && fileSystemEntry.getLocation().toString().endsWith(".mlappinstall");
    }

    public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
        fileDecorators.set(CoreFileDecoration.TYPE_NAME, (Object)this.getResourceBundle().getString("cfb.typename"));
        fileDecorators.set(CoreFileDecoration.ICON, (Object)IconEnumerationUtils.getIcon((String)"filetype_mlappinstall"));
        fileDecorators.set(sExtraInfoDecoration, AppExtraInfo.class, new Object[]{fileSystemEntry});
        fileDecorators.set(CoreFileDecoration.DETAIL_PANEL, AppFileDetailPanel.class, new Object[]{fileSystemEntry});
        fileDecorators.set(CoreFileDecoration.DESCRIPTION, sExtraInfoDecoration, (Converter)new Converter<AppExtraInfo, String>(){

            public String convert(AppExtraInfo appExtraInfo) {
                return appExtraInfo.getSummary();
            }
        });
    }

    private ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("com.mathworks.appmanagement.resources.RES_Appmanagement");
    }

    public void configureActions(ActionRegistry actionRegistry) {
        ActionConfiguration actionConfiguration = actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT);
        actionConfiguration.setEnabled(ActionConfiguration.NEVER);
        actionConfiguration.setVisibleOnContextMenu(ActionConfiguration.NEVER);
        ActionConfiguration actionConfiguration2 = actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB);
        actionConfiguration2.setEnabled(ActionConfiguration.NEVER);
        actionConfiguration2.setVisibleOnContextMenu(ActionConfiguration.NEVER);
        ActionConfiguration actionConfiguration3 = actionRegistry.getAction(CoreActionID.IMPORT_DATA);
        actionConfiguration3.setEnabled(ActionConfiguration.NEVER);
        actionConfiguration3.setVisibleOnContextMenu(ActionConfiguration.NEVER);
        StatusRunnable<ActionInput> statusRunnable = new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    try {
                        FileSystemEntry fileSystemEntry2 = MLFileSystemUtils.getMatlabAccessibleEntry((FileSystemEntry)fileSystemEntry);
                        AppManagementApiBuilder.getAppManagementApi().install(fileSystemEntry2.getLocation().toString());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                return Status.COMPLETED;
            }
        };
        ActionConfiguration actionConfiguration4 = actionRegistry.getAction(CoreActionID.OPEN);
        actionConfiguration4.setLabel(this.getResourceBundle().getString("context.install"));
        actionConfiguration4.setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)statusRunnable);
    }

    public static class AppExtraInfo {
        private AppMetadata fData;

        public AppExtraInfo(FileSystemEntry fileSystemEntry) {
            try {
                this.fData = AppManagementApiBuilder.getAppManagementApi().getAppMetadata(fileSystemEntry.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String getSummary() {
            if (this.fData != null) {
                return this.fData.getSummary();
            }
            return "";
        }
    }
}

