/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPMessagePanel;
import com.mathworks.widgets.text.mcode.MEditorUI;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerLayer;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.EditorUI;

class SyntaxPreviewPane
extends SyntaxTextPane {
    SyntaxPreviewPane(String string, String string2) {
        this.setName(string);
        this.getAccessibleContext().setAccessibleName(string2);
        this.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new PreviewKitClass()));
        this.setContentType(MLanguage.INSTANCE.getMimeType());
        this.setHighlightCaretRow(false, false);
        this.enableDelimiterMatchForArrows(false, false);
        this.setEditable(false);
        this.setContextMenuEnabled(false, false);
        Font font = FontPrefs.getCodeFont();
        font = font.deriveFont(font.getStyle(), Math.min(font.getSize(), 14));
        this.setFont(font, false);
        this.setSyntaxHighlightingEnabled(MLanguage.INSTANCE, true);
        this.setTextColor(ColorPrefs.getTextColor(), false);
        this.setBackgroundColor(ColorPrefs.getBackgroundColor(), false);
        this.setFocusable(false);
        this.setShowLineNumbers(false, false);
        this.getCaret().setSelectionVisible(false);
        this.getCaret().setVisible(false);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    private static class PreviewKitClass
    extends MKit {
        private PreviewKitClass() {
        }

        public String getContentType() {
            return MLanguage.INSTANCE.getMimeType();
        }

        protected boolean isFollowingMLintPreference() {
            return true;
        }

        protected EditorUI createEditorUI() {
            return new PreviewEditorUI();
        }

        private static class PreviewEditorUI
        extends MEditorUI {
            private ChangeListener fMLintListener;

            PreviewEditorUI() {
                CodeAnalyzerLayer codeAnalyzerLayer = CodeAnalyzerUtils.getCodeAnalyzerLayer((EditorUI)this);
                codeAnalyzerLayer.setFollowingMLintPreference(true);
                this.fMLintListener = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        PreviewEditorUI.this.ensureRightMessagesShown();
                    }
                };
                MLintPrefsUtils.addConfigurationListener((ChangeListener)this.fMLintListener);
            }

            public void cleanup() {
                super.cleanup();
                MLintPrefsUtils.removeConfigurationListener((ChangeListener)this.fMLintListener);
            }

            protected void installUI(JTextComponent jTextComponent) {
                super.installUI(jTextComponent);
                this.ensureRightMessagesShown();
            }

            protected STPMessagePanel createMessagePanel(STPBaseInterface sTPBaseInterface) {
                return new STPMessagePanel(sTPBaseInterface, false);
            }

            private void ensureRightMessagesShown() {
                CodeAnalyzerLayer codeAnalyzerLayer = CodeAnalyzerUtils.getCodeAnalyzerLayer((EditorUI)this);
                if (codeAnalyzerLayer.isEnabled()) {
                    MLintConfiguration mLintConfiguration = MLintPrefsUtils.getActiveConfiguration();
                    MLintConfiguration mLintConfiguration2 = mLintConfiguration.copy();
                    mLintConfiguration2.enableMessage("NOPRT", 2, false);
                    mLintConfiguration2.enableMessage("NASGU", 2, false);
                    codeAnalyzerLayer.setConfiguration(mLintConfiguration2);
                }
            }

            public List<? extends EditorMessage> getEditorMessagesAtPosition(int n, int n2) {
                return Collections.emptyList();
            }
        }
    }
}

