/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.beans.editors.MWPropertyEditorUtils;
import com.mathworks.beans.editors.ValueValidityEvent;
import com.mathworks.beans.editors.ValueValidityListener;
import com.mathworks.beans.editors.ValueValiditySource;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.Action;

public class PropertyDialog
extends MJPanel
implements ValueValidityListener {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.inspector.resources.RES_PropView");
    private static final int DONE = 0;
    private static final int OK = 1;
    private static final int CANCEL = 2;
    private PropertyCell fOwner;
    private Component fEditorComponent;
    private MJDialog fDialog;
    private MJButton fOKButton;

    PropertyDialog(String string, PropertyCell propertyCell, Component component, Frame frame) {
        Dimension dimension;
        this.fOwner = propertyCell;
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Dialog", 0, 10));
        this.fEditorComponent = component;
        this.add("Center", this.fEditorComponent);
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new FlowLayout(2));
        PropertyEditor propertyEditor = propertyCell.getEditor();
        this.fOKButton = this.buildCommandButton(sRes.getString("propertydialog.ok"), 1, "OK");
        if (MWPropertyEditorUtils.canApply((PropertyEditor)propertyEditor)) {
            if (PlatformInfo.getAppearance() == 0) {
                mJPanel.add((Component)this.buildCommandButton(sRes.getString("propertydialog.cancel"), 2, "Cancel"));
                mJPanel.add((Component)this.fOKButton);
            } else {
                mJPanel.add((Component)this.fOKButton);
                mJPanel.add((Component)this.buildCommandButton(sRes.getString("propertydialog.cancel"), 2, "Cancel"));
            }
        } else {
            mJPanel.add((Component)this.buildCommandButton(sRes.getString("propertydialog.done"), 0, "Done"));
        }
        this.add("South", (Component)mJPanel);
        if (string == null) {
            string = propertyCell.getEditor().getClass().getName();
        }
        this.fDialog = new MJDialog(frame, string, true);
        this.fDialog.setName("PropertyDialog");
        this.fDialog.getRootPane().setDefaultButton(null);
        this.fDialog.setResizable(false);
        this.fDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PropertyDialog.this.closeWindow();
            }
        });
        this.fDialog.add((Component)((Object)this), (Object)"Center");
        if (PlatformInfo.getPlatform() == 2) {
            dimension = this.getPreferredSize();
            Insets insets = frame != null ? frame.getInsets() : new Insets(0, 0, 0, 0);
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            this.fDialog.setSize(dimension);
        } else {
            this.fDialog.pack();
        }
        if (this.fEditorComponent instanceof ValueValiditySource) {
            dimension = (ValueValiditySource)this.fEditorComponent;
            dimension.addValueValidityListener(this);
            this.setValueValid(dimension.isValueValid());
        }
        this.centerDialog();
        this.fDialog.setVisible(true);
    }

    private void setValueValid(boolean bl) {
        this.fOKButton.setEnabled(bl);
    }

    public void valueValidityChanged(ValueValidityEvent valueValidityEvent) {
        if (valueValidityEvent.getSource() == this.fEditorComponent) {
            this.setValueValid(valueValidityEvent.isValueValid());
        }
    }

    private void centerDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fDialog.getSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        this.fDialog.setLocation(n, n2);
    }

    private MJButton buildCommandButton(String string, final int n, String string2) {
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyDialog.this.doCommand(n);
            }
        });
        mJButton.setName(string2 + "Button");
        return mJButton;
    }

    private void doCommand(int n) {
        PropertyEditor propertyEditor;
        if (n == 1 && MWPropertyEditorUtils.canApply((PropertyEditor)(propertyEditor = this.fOwner.getEditor()))) {
            MWPropertyEditorUtils.apply((PropertyEditor)propertyEditor);
        }
        this.closeWindow();
        this.fOwner.updateComponent_EventThread();
    }

    private void closeWindow() {
        if (this.fEditorComponent instanceof ValueValiditySource) {
            ((ValueValiditySource)this.fEditorComponent).removeValueValidityListener((ValueValidityListener)this);
        }
        if (this.fOwner != null) {
            this.fOwner.customEditorClosed();
        }
        this.fDialog.dispose();
    }
}

