/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Property;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlwidgets.inspector.AutopilotPropertyValue;
import com.mathworks.mlwidgets.inspector.IPropertyTreeTableNode;
import com.mathworks.mlwidgets.inspector.JidePropertyTableModel;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyItemNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

final class JidePropertyItem
extends Property {
    private final PropertyCell fCell;
    private final PropertyItemNode fItemNode;
    private final boolean fHasChildren;
    private final List fChildrenList;
    private volatile boolean fHasLoadedChildren = false;
    private final JidePropertyTableModel fModel;
    private final Object internalPropertyLock = new Object();

    JidePropertyItem(PropertyItemNode propertyItemNode, JidePropertyTableModel jidePropertyTableModel) {
        super(propertyItemNode != null ? propertyItemNode.getName() : "");
        if (propertyItemNode == null) {
            throw new IllegalArgumentException("Argument itemNode must not be null.");
        }
        if (jidePropertyTableModel == null) {
            throw new IllegalArgumentException("Argument model must not be null.");
        }
        this.fModel = jidePropertyTableModel;
        this.fItemNode = propertyItemNode;
        this.fCell = this.fItemNode.getPropertyCell();
        this.fHasChildren = this.fCell.hasChildren();
        String string = propertyItemNode.getGroupName();
        if (string != null && string.length() > 1) {
            this.setCategory(string);
        }
        this.setIndentNonCategoryRow(true);
        this.fChildrenList = Collections.synchronizedList(new ArrayList());
    }

    PropertyItemNode getItemNode() {
        return this.fItemNode;
    }

    public boolean hasChildren() {
        return this.fHasChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasQueriedChildren() {
        Object object = this.internalPropertyLock;
        synchronized (object) {
            return this.fHasLoadedChildren;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHasQueriedChildren(boolean bl) {
        Object object = this.internalPropertyLock;
        synchronized (object) {
            this.fHasLoadedChildren = bl;
        }
    }

    void loadChildren_MatlabThread() {
        if (this.hasQueriedChildren()) {
            return;
        }
        assert (NativeMatlab.nativeIsMatlabThread());
        this.setHasQueriedChildren(true);
        this.fItemNode.loadChildrenMatlabThread();
        this.loadChildrenFromItemNode_MatlabThread();
    }

    private void loadChildrenFromItemNode_MatlabThread() {
        assert (this.fItemNode.hasQueriedChildren());
        IPropertyTreeTableNode[] iPropertyTreeTableNodeArray = this.fItemNode.getChildren();
        if (iPropertyTreeTableNodeArray != null) {
            for (int i = 0; i < iPropertyTreeTableNodeArray.length; ++i) {
                if (!(iPropertyTreeTableNodeArray[i] instanceof PropertyItemNode)) continue;
                PropertyItemNode propertyItemNode = (PropertyItemNode)iPropertyTreeTableNodeArray[i];
                JidePropertyItem jidePropertyItem = new JidePropertyItem(propertyItemNode, this.fModel);
                jidePropertyItem.setParent((Expandable)this);
                this.fChildrenList.add(jidePropertyItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildren() {
        assert (this.fChildrenList != null);
        Object object = this.internalPropertyLock;
        synchronized (object) {
            if (this.hasChildren() && !this.hasQueriedChildren()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<Void>(){

                            public void callOnEdt(Void void_, boolean bl) {
                                if (!bl) {
                                    return;
                                }
                                assert (JidePropertyItem.this.fModel != null);
                                JidePropertyItem.this.fModel.refresh();
                            }

                            public Void call() throws Exception {
                                if (!JidePropertyItem.this.hasQueriedChildren()) {
                                    JidePropertyItem.this.loadChildren_MatlabThread();
                                }
                                return null;
                            }
                        });
                    }
                });
            }
        }
        return this.fChildrenList;
    }

    public TableCellRenderer getTableCellRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JComponent jComponent = JidePropertyItem.this.fItemNode.getRendererComponent();
                return jComponent;
            }
        };
    }

    public CellEditor getCellEditor() {
        return new DefaultCellEditor(new JCheckBox("ignore")){

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return JidePropertyItem.this.fItemNode.getEditorComponent();
            }
        };
    }

    public void setValue(Object object) {
    }

    public Object getValue() {
        return null;
    }

    public boolean hasValue() {
        return false;
    }

    public String getValueAsText() {
        if (this.fItemNode != null) {
            return this.fItemNode.getValueAsText();
        }
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isLeaf() {
        if (this.fItemNode != null) {
            return this.fItemNode.isLeaf();
        }
        return true;
    }

    AutopilotPropertyValue getAutopilotAccesssor() {
        AutopilotValue autopilotValue = new AutopilotValue(this);
        return autopilotValue;
    }

    private class AutopilotValue
    implements AutopilotPropertyValue {
        private final JidePropertyItem fItem;

        private AutopilotValue(JidePropertyItem jidePropertyItem2) {
            this.fItem = jidePropertyItem2;
        }

        @Override
        public String getValueAsText() {
            return this.fItem.getValueAsText();
        }

        @Override
        public boolean isEditable() {
            return JidePropertyItem.this.fCell.isEditable();
        }

        @Override
        public boolean isLeaf() {
            return this.fItem.isLeaf();
        }

        @Override
        public boolean isExpanded() {
            return this.fItem.isExpanded();
        }
    }
}

