/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.jidesoft.icons.IconsFactory;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.mdt.MatlabCallable;
import com.mathworks.jmi.mdt.MatlabEventQueue;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.TopicMapLocator;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.util.DebugUtils;
import com.mathworks.widgets.util.GUIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class HelpAction
extends AbstractAction {
    private volatile String mapID;
    private final boolean showInHelpBrowser;
    private volatile Component owner;
    private volatile Dimension helpWinSize;
    private static final ResourceBundle resBundle;
    private volatile String errMsg;
    private static volatile boolean debug;

    public static void enableDebugging(boolean bl) {
        debug = bl;
    }

    public HelpAction(Object object, String string, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("Argument obj must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Argument topic must not be null");
        }
        Object object2 = null;
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            assert (objectArray.length > 0);
            object2 = objectArray[0];
        } else {
            object2 = object;
        }
        this.showInHelpBrowser = bl;
        this.putValue("Name", GUIUtils.getStandardDialogString((GUIUtils.DialogStringType)GUIUtils.DialogStringType.HELP_BUTTON));
        this.putValue("ShortDescription", resBundle.getString("helpaction.nohelp"));
        this.putValue("SmallIcon", IconsFactory.getImageIcon(InspectorUIResources.class, (String)"resources/help16x16.png"));
        this.setEnabled(false);
        this.init(object2, string);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("mapID", (Object)this.mapID).append("showInHelpBrowser", this.showInHelpBrowser).append("isEnabled", this.isEnabled()).append("errMsg", (Object)this.errMsg).append("shortDescription", this.getValue("ShortDescription")).toString();
    }

    public void setOwner(Component component) {
        this.owner = component;
    }

    public void setContextHelpWindowSize(int n, int n2) {
        this.helpWinSize = new Dimension(Math.abs(n), Math.abs(n2));
    }

    private void init(final Object object, final String string) {
        if (!Matlab.isMatlabAvailable()) {
            assert (DebugUtils.warning((String)"MATLAB is not running"));
            return;
        }
        if (DebugUtils.areAssertionsEnabled()) {
            boolean bl = false;
            String string2 = MLHelpServices.getDocRoot();
            if (string2 != null) {
                bl = MLHelpServices.setDocRoot((String)string2);
            }
            if (!bl) {
                this.errMsg = "docroot is not set, make sure to set it by clicking menu Start->Internal Tools->Set docroot->Promoted doc";
                return;
            }
        }
        MatlabEventQueue.invoke((MatlabCallable)new MatlabCallable<String>(){

            public void callOnEdt(String string3, boolean bl) {
                if (!bl || string3 == null) {
                    return;
                }
                if (StringUtils.isBlank((String)string3)) {
                    if (debug) assert (DebugUtils.warning((String)"Invalid empty cass name"));
                    return;
                }
                String string2 = TopicMapLocator.getMapPath(string3);
                if (StringUtils.isBlank((String)string2)) {
                    if (debug) assert (DebugUtils.warning((String)("Empty map path for class " + string3 + ". Make sure to set your docroot")));
                    return;
                }
                CSHelpTopicMap cSHelpTopicMap = new CSHelpTopicMap(string2);
                if (!cSHelpTopicMap.exists()) {
                    if (debug) assert (DebugUtils.warning((String)("Topic map does not exist for map path " + string2)));
                    return;
                }
                HelpAction.this.mapID = cSHelpTopicMap.mapID(string);
                if (StringUtils.isBlank((String)HelpAction.this.mapID)) {
                    if (debug) assert (DebugUtils.warning((String)("Path map corresponding to " + string + " does not exist")));
                    return;
                }
                HelpAction.this.putValue("ShortDescription", GUIUtils.getStandardDialogString((GUIUtils.DialogStringType)GUIUtils.DialogStringType.HELP_BUTTON));
                HelpAction.this.setEnabled(true);
            }

            public String call() throws Exception {
                try {
                    Object object2 = MatlabMCR.mtFeval((String)"matlab.ui.internal.getClassName", (Object[])new Object[]{object}, (int)1);
                    if (object2 == null) {
                        assert (DebugUtils.warning((String)"Call to matlab.ui.internal.getClassName() failed to return a valid class name"));
                        return null;
                    }
                    assert (object2 instanceof String) : object2.getClass().getName();
                    return (String)object2;
                }
                catch (Exception exception) {
                    assert (DebugUtils.outputException((Throwable)exception));
                    return null;
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        assert (this.mapID != null);
        if (!this.showInHelpBrowser) {
            Dimension dimension = this.helpWinSize != null ? this.helpWinSize : this.owner.getSize();
            MLHelpServices.cshSetSize((int)dimension.width, (int)dimension.height);
            if (this.owner != null) {
                Point point = this.calculateScreenLocation();
                if (point != null) {
                    MLHelpServices.cshSetLocation((int)point.x, (int)point.y);
                }
                MLHelpServices.cshDisplayFile((Object)this.owner, (String)this.mapID);
            } else {
                MLHelpServices.cshDisplayFile((String)this.mapID);
            }
        } else {
            MLHelpServices.setCurrentLocation((String)this.mapID);
        }
    }

    private Point calculateScreenLocation() {
        Object object;
        if (this.owner == null) {
            return null;
        }
        Rectangle rectangle = new Rectangle();
        for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            object = graphicsDevice.getConfigurations();
            int n = ((GraphicsConfiguration[])object).length;
            for (int i = 0; i < n; ++i) {
                GraphicsConfiguration graphicsConfiguration = object[i];
                rectangle = rectangle.union(graphicsConfiguration.getBounds());
            }
        }
        Point point = this.owner.getLocationOnScreen();
        Dimension dimension = this.owner.getSize();
        double d = Math.max(0.0, rectangle.getMaxX() - (point.getX() + dimension.getWidth()));
        Object object2 = object = this.helpWinSize != null ? this.helpWinSize : this.owner.getSize();
        assert (object != null);
        if (this.helpWinSize.getWidth() < d) {
            return new Point(this.owner.getX() + this.owner.getWidth(), this.owner.getY());
        }
        return new Point(this.owner.getX() - this.helpWinSize.width, this.owner.getY());
    }

    static {
        ResourceBundle resourceBundle;
        block3: {
            debug = false;
            resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("com.mathworks.mlwidgets.inspector.resources.RES_PropView");
            }
            catch (MissingResourceException missingResourceException) {
                if ($assertionsDisabled || DebugUtils.outputException((Throwable)missingResourceException)) break block3;
                throw new AssertionError();
            }
        }
        assert (resourceBundle != null);
        resBundle = resourceBundle;
    }
}

