/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.SearchField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;

public class SuggestionProvider {
    private static final Pattern FIND_LAST_WORD_PATTERN = Pattern.compile("^(.*\\s+)(\\w+)$");
    private IndexReader fReader;
    private SearchField fField;

    public SuggestionProvider(IndexReader indexReader, SearchField searchField) {
        this.fReader = indexReader;
        this.fField = searchField;
    }

    private IndexReader getIndexReader() {
        return this.fReader;
    }

    public Collection<String> getSuggestions(String string, int n) {
        try {
            string = string.trim();
            Matcher matcher = FIND_LAST_WORD_PATTERN.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                return this.getSuggestionsForLastWord(string2, string3, n);
            }
            return this.getSuggestionsForSingleWord(string, n);
        }
        catch (IOException iOException) {
            return Collections.emptyList();
        }
    }

    private Collection<String> getSuggestionsForSingleWord(String string, int n) throws IOException {
        Collection<Term> collection = this.getSuggestedTerms(string, n);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Term term : collection) {
            arrayList.add(term.text());
        }
        return arrayList;
    }

    private Collection<String> getSuggestionsForLastWord(String string, String string2, int n) throws IOException {
        String[] stringArray = string.split("\\s+");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        SortedMap<Integer, TermDocs> sortedMap = this.getFullWordTermDocs(stringArray);
        if (sortedMap.firstKey() == 0) {
            return Collections.emptyList();
        }
        Collection<TermDocs> collection = sortedMap.values();
        Collection<Term> collection2 = this.getSuggestedTerms(string2, Integer.MAX_VALUE);
        SuggestionsMap suggestionsMap = new SuggestionsMap(n);
        for (Term term : collection2) {
            if (hashSet.contains(term.text())) continue;
            int n2 = SuggestionProvider.intersectTermDocs(collection, this.getIndexReader().termDocs(term));
            if (n2 > 0) {
                String string3 = string + term.text();
                suggestionsMap.add(new Suggestion(string3, n2), string3);
            }
            collection = this.getFullWordTermDocs(stringArray).values();
        }
        return suggestionsMap.values();
    }

    private SortedMap<Integer, TermDocs> getFullWordTermDocs(String[] stringArray) throws IOException {
        TreeMap<Integer, TermDocs> treeMap = new TreeMap<Integer, TermDocs>();
        IndexReader indexReader = this.getIndexReader();
        for (String string : stringArray) {
            Term term = new Term(this.fField.getFieldName(), string);
            treeMap.put(indexReader.docFreq(term), indexReader.termDocs(term));
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Term> getSuggestedTerms(String string, int n) throws IOException {
        SuggestionsMap suggestionsMap = new SuggestionsMap(n);
        TermEnum termEnum = this.getIndexReader().terms(new Term(this.fField.getFieldName(), string));
        try {
            Term term = termEnum.term();
            while (SuggestionProvider.shouldAcceptTerm(term, string)) {
                Suggestion suggestion = new Suggestion(term.text(), this.getIndexReader().docFreq(term));
                suggestionsMap.add(suggestion, term);
                term = SuggestionProvider.getNextTerm(termEnum);
            }
        }
        finally {
            termEnum.close();
        }
        return suggestionsMap.values();
    }

    private static boolean shouldAcceptTerm(Term term, String string) {
        return term != null && term.text().startsWith(string);
    }

    private static Term getNextTerm(TermEnum termEnum) throws IOException {
        return termEnum.next() ? termEnum.term() : null;
    }

    private static int intersectTermDocs(Collection<TermDocs> collection, TermDocs termDocs) throws IOException {
        ArrayList<TermDocs> arrayList = new ArrayList<TermDocs>(collection);
        arrayList.add(termDocs);
        int n = 0;
        int n2 = SuggestionProvider.getNextCommonTermDoc(arrayList, 0);
        while (n2 > -1) {
            ++n;
            n2 = SuggestionProvider.getNextCommonTermDoc(arrayList, n2 + 1);
        }
        return n;
    }

    private static int getNextCommonTermDoc(Iterable<TermDocs> iterable, int n) throws IOException {
        int n2 = SuggestionProvider.getInitialMatchCandidate(iterable, n);
        boolean bl = false;
        while (!bl) {
            bl = true;
            Iterator<TermDocs> iterator = iterable.iterator();
            while (iterator.hasNext() && bl) {
                TermDocs termDocs = iterator.next();
                int n3 = termDocs.doc();
                if (n3 >= n2) continue;
                if (termDocs.skipTo(n2)) {
                    int n4 = termDocs.doc();
                    bl = n4 == n2;
                    n2 = n4;
                    continue;
                }
                return -1;
            }
        }
        return n2;
    }

    private static int getInitialMatchCandidate(Iterable<TermDocs> iterable, int n) throws IOException {
        int n2 = n;
        for (TermDocs termDocs : iterable) {
            termDocs.next();
            int n3 = termDocs.doc();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private static class Suggestion
    implements Comparable<Suggestion> {
        private final String iText;
        private final int iNumDocs;

        private Suggestion(String string, int n) {
            this.iText = string;
            this.iNumDocs = n;
        }

        private String getText() {
            return this.iText;
        }

        private int getNumDocs() {
            return this.iNumDocs;
        }

        @Override
        public int compareTo(Suggestion suggestion) {
            if (this.getNumDocs() == suggestion.getNumDocs()) {
                return this.getText().compareTo(suggestion.getText());
            }
            return this.getNumDocs() < suggestion.getNumDocs() ? 1 : -1;
        }
    }

    private static class SuggestionsMap<E> {
        private final int iMaxSize;
        private final SortedMap<Suggestion, E> iMap = new TreeMap<Suggestion, E>();

        private SuggestionsMap(int n) {
            this.iMaxSize = n;
        }

        private void add(Suggestion suggestion, E e) {
            this.iMap.put(suggestion, e);
            if (this.iMap.size() > this.iMaxSize) {
                this.iMap.remove(this.iMap.lastKey());
            }
        }

        private Collection<E> values() {
            return this.iMap.values();
        }
    }
}

