/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.ContainerHelpTreeItem;
import com.mathworks.mlwidgets.help.ContentsDataEvent;
import com.mathworks.mlwidgets.help.ContentsDataHolder;
import com.mathworks.mlwidgets.help.ContentsDataListener;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.DemosDataListener;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpDataObserver;
import com.mathworks.mlwidgets.help.HelpDataWorker;
import com.mathworks.mlwidgets.help.HelpDataWorkerStrategy;
import com.mathworks.mlwidgets.help.HelpIcon;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItemRegistry;
import com.mathworks.mlwidgets.help.HelpTreeItemVisitor;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ProductHelpTreeItem;
import com.mathworks.mlwidgets.util.productinfo.ProductIcon;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class ContentsData {
    private static final HelpDataWorker<ContentsDataHolder> sWorker = new HelpDataWorker();
    private static RootNode sRootNode;
    private static ContentsDataHolder sCurrentData;
    private static final ContentsInfoListener sListener;
    private static HelpInfoProvider sHelpInfo;
    private static Map<String, DemoTreeItem> sProductDemoItems;
    private static List<ContentsDataListener> sListeners;
    private static UserDemosNode sUserDemosNode;

    private ContentsData() {
    }

    private static synchronized void setCurrentData(ContentsDataHolder contentsDataHolder) {
        sCurrentData = contentsDataHolder;
    }

    private static synchronized ContentsDataHolder getCurrentData() {
        return sCurrentData;
    }

    private static synchronized void setUserDemosNode(UserDemosNode userDemosNode) {
        sUserDemosNode = userDemosNode;
    }

    private static synchronized UserDemosNode getUserDemosNode() {
        return sUserDemosNode;
    }

    private static void setupDemosDataListener() {
        DemosData.addDemosDataListener(new DemosDataListener(){

            @Override
            public void demosCleared() {
                ContentsData.addSearchingForDemosMessage();
            }

            @Override
            public void demosPopulated() {
                ContentsData.refreshDemosAndNotify();
            }
        }, true);
    }

    private static void addSearchingForDemosMessage() {
        if (SwingUtilities.isEventDispatchThread()) {
            ContentsData.createUserDemosNode(null);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContentsData.createUserDemosNode(null);
                }
            });
        }
    }

    private static void createUserDemosNode(List<DemoTreeItem> list) {
        ContentsData.removeUserDemosNode();
        ContentsData.setUserDemosNode(new UserDemosNode(list));
        if (ContentsData.isContentsDataPopulated()) {
            int[] nArray = new int[]{sRootNode.getChildCount() - 1};
            HelpTreeItem[] helpTreeItemArray = new HelpTreeItem[]{ContentsData.getUserDemosNode()};
            ContentsDataEvent contentsDataEvent = ContentsDataEvent.createItemsAddedEvent(sRootNode, nArray, helpTreeItemArray);
            ContentsData.notifyListeners(contentsDataEvent);
        } else if (ContentsData.getNumProducts() == 0) {
            ContentsData.notifyListeners();
        }
    }

    private static void removeUserDemosNode() {
        if (ContentsData.isUserDemosPopulated()) {
            HelpTreeItem[] helpTreeItemArray = new HelpTreeItem[]{ContentsData.getUserDemosNode()};
            int[] nArray = new int[]{sRootNode.getChildCount() - 1};
            ContentsData.setUserDemosNode(null);
            if (ContentsData.isContentsDataPopulated()) {
                ContentsDataEvent contentsDataEvent = ContentsDataEvent.createItemsRemovedEvent(sRootNode, nArray, helpTreeItemArray);
                ContentsData.notifyListeners(contentsDataEvent);
            } else if (ContentsData.getNumProducts() == 0) {
                ContentsData.notifyListeners();
            }
        }
    }

    private static void refreshDemosAndNotify() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!ContentsData.isProductDemoItemsEmpty()) {
                    ContentsData.refreshDemoItems();
                }
                ContentsData.populateUserDemos();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static void populateUserDemos() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List<DemoTreeItem> list = DemosData.getUserDemos();
                if (!list.isEmpty()) {
                    ContentsData.createUserDemosNode(list);
                } else if (ContentsData.isUserDemosPopulated()) {
                    ContentsData.removeUserDemosNode();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static TreeNode getRootNode() {
        return sRootNode;
    }

    public static synchronized boolean isPopulated() {
        return ContentsData.isContentsDataPopulated() || ContentsData.getNumProducts() == 0 && ContentsData.isUserDemosPopulated();
    }

    private static synchronized boolean isContentsDataPopulated() {
        return sCurrentData != null;
    }

    private static synchronized boolean isUserDemosPopulated() {
        return sUserDemosNode != null;
    }

    public static TreeNode getNodeForFileName(String string, String string2) {
        if (!ContentsData.isContentsDataPopulated()) {
            return null;
        }
        String string3 = ContentsData.getHelpInfoProvider().getProductNameForFile(string);
        if (string3 != null && !ContentsData.isProductLoaded(string3)) {
            ContentsData.loadProductNodeInfo(string3);
        }
        TreeNode treeNode = null;
        if (string2 != null) {
            treeNode = HelpTreeItemRegistry.getNode(string + "#" + string2);
        }
        if (treeNode == null) {
            treeNode = HelpTreeItemRegistry.getNode(string);
        }
        return treeNode;
    }

    public static boolean isProductLoaded(String string) {
        ContentsDataHolder contentsDataHolder = ContentsData.getCurrentData();
        if (contentsDataHolder == null) {
            return false;
        }
        List<ContainerHelpTreeItem> list = contentsDataHolder.getContainerItemsForProduct(string);
        return list != null && list.isEmpty();
    }

    public static void loadProductNodeInfo(String string) {
        ContentsDataHolder contentsDataHolder = ContentsData.getCurrentData();
        if (contentsDataHolder == null) {
            return;
        }
        List<ContainerHelpTreeItem> list = contentsDataHolder.getContainerItemsForProduct(string);
        if (list != null) {
            for (ContainerHelpTreeItem containerHelpTreeItem : list) {
                containerHelpTreeItem.populateIfNecessary();
            }
            list.clear();
        }
    }

    public static synchronized void addContentsDataListener(ContentsDataListener contentsDataListener) {
        ContentsData.addContentsDataListener(contentsDataListener, false);
    }

    public static synchronized void addContentsDataListener(final ContentsDataListener contentsDataListener, boolean bl) {
        if (sListeners == null) {
            sListeners = new ArrayList<ContentsDataListener>();
        }
        sListeners.add(contentsDataListener);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ContentsData.isPopulated()) {
                        contentsDataListener.contentsChanged(ContentsDataEvent.createPopulateEvent());
                    } else {
                        contentsDataListener.contentsChanged(ContentsDataEvent.createClearEvent());
                    }
                }
            });
        }
    }

    public static synchronized void removeContentsDataListener(ContentsDataListener contentsDataListener) {
        if (sListeners != null) {
            sListeners.remove(contentsDataListener);
        }
    }

    private static synchronized List<ContentsDataListener> getContentsDataListeners() {
        return sListeners;
    }

    private static void populate() {
        if (ContentsData.getNumProducts() > 0 || ContentsData.hasUserDemos()) {
            final boolean bl = ContentsData.isContentsDataPopulated();
            sWorker.populate(new HelpDataWorkerStrategy<ContentsDataHolder>(){

                @Override
                public void beforePopulateEdt() {
                    sRootNode.clear();
                    ContentsData.setCurrentData(null);
                    HelpTreeItemRegistry.clear();
                    if (bl) {
                        ContentsData.notifyListeners();
                    }
                }

                @Override
                public void populate(HelpDataObserver<ContentsDataHolder> helpDataObserver) {
                    ContentsDataHolder contentsDataHolder = ContentsData.populateRootNode();
                    helpDataObserver.dataPopulated(contentsDataHolder);
                }

                @Override
                public void afterPopulateEdt(ContentsDataHolder contentsDataHolder) {
                    for (ProductHelpTreeItem productHelpTreeItem : contentsDataHolder.getAllProductNodes()) {
                        if (!HelpInfo.shouldShowProduct(productHelpTreeItem.getProduct())) continue;
                        sRootNode.addProductItem(productHelpTreeItem);
                    }
                    ContentsData.setCurrentData(contentsDataHolder);
                    ContentsData.notifyListeners();
                }
            });
        }
    }

    private static ContentsDataHolder populateRootNode() {
        ContentsDataHolder contentsDataHolder = new ContentsDataHolder();
        HelpInfoItem[] helpInfoItemArray = ContentsData.getHelpInfoProvider().getInstalledHelpInfo();
        if (helpInfoItemArray != null) {
            for (HelpInfoItem helpInfoItem : helpInfoItemArray) {
                if (helpInfoItem == null || !helpInfoItem.isToplevel()) continue;
                String string = helpInfoItem.getProductName();
                String string2 = helpInfoItem.getHelpLoc();
                if (string2.length() <= 0) continue;
                String string3 = helpInfoItem.getHelpIconLoc();
                Icon icon = ProductIcon.getIcon(string3);
                ProductHelpTreeItem productHelpTreeItem = new ProductHelpTreeItem(helpInfoItem, icon, string);
                contentsDataHolder.addContainerItem(string, productHelpTreeItem);
                HelpInfoItem[] helpInfoItemArray2 = helpInfoItem.getHelpAddons();
                if (helpInfoItemArray2 != null) {
                    for (HelpInfoItem helpInfoItem2 : helpInfoItemArray2) {
                        if (helpInfoItem2.isToplevel()) continue;
                        String string4 = helpInfoItem2.getProductName();
                        Icon icon2 = HelpTreeUtils.getIcon("$toolbox/matlab/icons/pagesicon.gif");
                        ProductHelpTreeItem productHelpTreeItem2 = new ProductHelpTreeItem(helpInfoItem2, icon2, helpInfoItem2.getProductName());
                        productHelpTreeItem2.setParent(productHelpTreeItem);
                        productHelpTreeItem.addAddon(productHelpTreeItem2);
                        contentsDataHolder.addContainerItem(string4, productHelpTreeItem2);
                    }
                }
                contentsDataHolder.addProductNode(productHelpTreeItem);
            }
        }
        return contentsDataHolder;
    }

    public static int getNumProducts() {
        return ContentsData.getHelpInfoProvider().getNumProducts();
    }

    private static boolean hasUserDemos() {
        return DocCenterUtils.hasThirdPartyDemos();
    }

    private static void notifyListeners() {
        ContentsDataEvent contentsDataEvent = ContentsData.isPopulated() ? ContentsDataEvent.createPopulateEvent() : ContentsDataEvent.createClearEvent();
        ContentsData.notifyListeners(contentsDataEvent);
    }

    private static void notifyListeners(ContentsDataEvent contentsDataEvent) {
        List<ContentsDataListener> list = ContentsData.getContentsDataListeners();
        if (list != null) {
            ArrayList<ContentsDataListener> arrayList = new ArrayList<ContentsDataListener>(ContentsData.getContentsDataListeners());
            for (ContentsDataListener contentsDataListener : arrayList) {
                contentsDataListener.contentsChanged(contentsDataEvent);
            }
        }
    }

    public static HelpTreeItem getFirstProductOrDemo() {
        Object object;
        ContentsDataHolder contentsDataHolder = ContentsData.getCurrentData();
        if (contentsDataHolder != null) {
            object = contentsDataHolder.getAllProductNodes().iterator();
            while (object.hasNext()) {
                ProductHelpTreeItem productHelpTreeItem = (ProductHelpTreeItem)object.next();
                String string = productHelpTreeItem.getProduct();
                if (string == null || ProductInfoUtils.getProductByName(string) == null) continue;
                return productHelpTreeItem;
            }
        }
        if ((object = ContentsData.getUserDemosNode()) != null) {
            return object;
        }
        return null;
    }

    public static synchronized void setHelpInfoProvider(HelpInfoProvider helpInfoProvider) {
        boolean bl = false;
        if (sHelpInfo != null) {
            sHelpInfo.removeHelpInfoChangedListener(sListener);
            bl = true;
        }
        if (helpInfoProvider != null) {
            helpInfoProvider.addHelpInfoChangedListener(sListener);
        }
        sHelpInfo = helpInfoProvider;
        if (bl) {
            ContentsData.populate();
        }
    }

    static synchronized HelpInfoProvider getHelpInfoProvider() {
        if (sHelpInfo == null) {
            ContentsData.setHelpInfoProvider(new DefaultHelpInfoProvider());
        }
        return sHelpInfo;
    }

    private static synchronized boolean isProductDemoItemsEmpty() {
        return sProductDemoItems.isEmpty();
    }

    static synchronized void registerProductDemoItem(DemoTreeItem demoTreeItem) {
        assert (demoTreeItem.getParent() instanceof ProductHelpTreeItem) : "Only top-level demo items should be registered in the ContentsData class";
        sProductDemoItems.put(demoTreeItem.getXmlFilename(), demoTreeItem);
    }

    private static synchronized Collection<DemoTreeItem> resetProductDemoItems() {
        Collection<DemoTreeItem> collection = sProductDemoItems.values();
        sProductDemoItems = new HashMap<String, DemoTreeItem>();
        return collection;
    }

    private static void refreshDemoItems() {
        ArrayList<DemoTreeItem> arrayList = new ArrayList<DemoTreeItem>(ContentsData.resetProductDemoItems());
        for (DemoTreeItem demoTreeItem : arrayList) {
            String string = demoTreeItem.getXmlFilename();
            DemoTreeItem demoTreeItem2 = DemosData.getItemForXmlFile(string);
            HelpTreeItem helpTreeItem = HelpTreeUtils.getItemForTreeNode(demoTreeItem.getParent());
            ProductHelpTreeItem productHelpTreeItem = (ProductHelpTreeItem)helpTreeItem;
            int n = productHelpTreeItem.getIndex(demoTreeItem);
            int[] nArray = new int[]{n};
            HelpTreeItem[] helpTreeItemArray = new HelpTreeItem[]{demoTreeItem};
            if (demoTreeItem2 != null && !demoTreeItem2.equals(demoTreeItem)) {
                productHelpTreeItem.removeChild(n);
                ContentsData.notifyListeners(ContentsDataEvent.createItemsRemovedEvent(productHelpTreeItem.getTreeNode(), nArray, helpTreeItemArray));
                productHelpTreeItem.addChild(n, demoTreeItem2);
                demoTreeItem2.setParent(productHelpTreeItem);
                demoTreeItem2.setLabel(demoTreeItem.getLabel());
                ContentsData.registerProductDemoItem(demoTreeItem2);
                HelpTreeItem[] helpTreeItemArray2 = new HelpTreeItem[]{demoTreeItem2};
                ContentsData.notifyListeners(ContentsDataEvent.createItemsAddedEvent(productHelpTreeItem.getTreeNode(), nArray, helpTreeItemArray2));
                continue;
            }
            if (demoTreeItem2 != null) continue;
            productHelpTreeItem.removeChild(n);
            ContentsData.notifyListeners(ContentsDataEvent.createItemsRemovedEvent(productHelpTreeItem.getTreeNode(), nArray, helpTreeItemArray));
        }
    }

    static {
        sCurrentData = null;
        sListener = new ContentsInfoListener();
        sHelpInfo = null;
        sProductDemoItems = new HashMap<String, DemoTreeItem>();
        sListeners = null;
        sUserDemosNode = null;
        sRootNode = new RootNode();
        ContentsData.populate();
        HelpPrefs.addPrefsListeners(sListener, "HelpSelectedProducts", "HelpFilterEnabled");
        ContentsData.setupDemosDataListener();
    }

    private static class DefaultHelpInfoProvider
    implements HelpInfoProvider {
        private DefaultHelpInfoProvider() {
        }

        @Override
        public HelpInfoItem[] getInstalledHelpInfo() {
            return ClassicHelpDataAccessor.getInstalledProductHelpInfo();
        }

        @Override
        public String getProductNameForFile(String string) {
            return HelpInfo.getProductNameForFilename(string);
        }

        @Override
        public int getNumProducts() {
            return ClassicHelpDataAccessor.getNumProductsInstalled();
        }

        @Override
        public boolean shouldShowProduct(String string) {
            return HelpInfo.shouldShowProduct(string);
        }

        @Override
        public void addHelpInfoChangedListener(ActionListener actionListener) {
            HelpInfo.addHelpInfoChangedListener(actionListener);
        }

        @Override
        public void removeHelpInfoChangedListener(ActionListener actionListener) {
            HelpInfo.removeHelpInfoChangedListener(actionListener);
        }
    }

    public static interface HelpInfoProvider {
        public HelpInfoItem[] getInstalledHelpInfo();

        public String getProductNameForFile(String var1);

        public int getNumProducts();

        public boolean shouldShowProduct(String var1);

        public void addHelpInfoChangedListener(ActionListener var1);

        public void removeHelpInfoChangedListener(ActionListener var1);
    }

    private static class TreeNodeEnumeration
    implements Enumeration<TreeNode> {
        private Iterator<? extends TreeNode> iIterator;

        private TreeNodeEnumeration(Iterator<? extends TreeNode> iterator) {
            this.iIterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iIterator.hasNext();
        }

        @Override
        public TreeNode nextElement() {
            return this.iIterator.next();
        }
    }

    private static class RootNode
    implements TreeNode {
        private List<TreeNode> iProductNodes = new ArrayList<TreeNode>();

        private RootNode() {
        }

        @Override
        public TreeNode getChildAt(int n) {
            if (n < this.iProductNodes.size()) {
                return this.iProductNodes.get(n);
            }
            if (n == this.iProductNodes.size()) {
                return ContentsData.getUserDemosNode();
            }
            return null;
        }

        @Override
        public int getChildCount() {
            if (this.iProductNodes == null) {
                return 0;
            }
            int n = this.iProductNodes.size();
            return ContentsData.getUserDemosNode() == null ? n : n + 1;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            if (treeNode.equals(ContentsData.getUserDemosNode())) {
                return this.iProductNodes.size();
            }
            return this.iProductNodes.indexOf(treeNode);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public Enumeration<TreeNode> children() {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(this.iProductNodes);
            if (ContentsData.isUserDemosPopulated()) {
                arrayList.add(ContentsData.getUserDemosNode());
            }
            return new TreeNodeEnumeration(arrayList.iterator());
        }

        private void clear() {
            this.iProductNodes.clear();
        }

        private void addProductItem(ProductHelpTreeItem productHelpTreeItem) {
            this.iProductNodes.add(productHelpTreeItem);
            productHelpTreeItem.setParent(this);
        }

        public String toString() {
            return "";
        }
    }

    private static class ContentsInfoListener
    implements ActionListener,
    PrefListener {
        private ContentsInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ContentsData.populate();
        }

        public void prefChanged(PrefEvent prefEvent) {
            ContentsData.populate();
        }
    }

    private static class UserDemosNode
    implements HelpTreeItem,
    TreeNode {
        private final List<DemoTreeItem> iUserDemos;

        private UserDemosNode(List<DemoTreeItem> list) {
            if (list != null) {
                this.iUserDemos = new ArrayList<DemoTreeItem>(list);
                for (DemoTreeItem demoTreeItem : this.iUserDemos) {
                    demoTreeItem.setParent(this);
                }
            } else {
                this.iUserDemos = null;
            }
        }

        @Override
        public TreeNode getChildAt(int n) {
            return this.iUserDemos == null ? null : this.iUserDemos.get(n);
        }

        @Override
        public int getChildCount() {
            return this.iUserDemos == null ? 0 : this.iUserDemos.size();
        }

        @Override
        public TreeNode getParent() {
            return sRootNode;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            if (this.iUserDemos != null && treeNode instanceof DemoTreeItem) {
                DemoTreeItem demoTreeItem = (DemoTreeItem)treeNode;
                return this.iUserDemos.indexOf(demoTreeItem);
            }
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return this.iUserDemos != null;
        }

        @Override
        public boolean isLeaf() {
            return this.iUserDemos == null;
        }

        public Enumeration<TreeNode> children() {
            if (this.iUserDemos == null) {
                return null;
            }
            return new TreeNodeEnumeration(this.iUserDemos.iterator());
        }

        @Override
        public String getLabel() {
            if (this.iUserDemos == null) {
                return HelpUtils.getLocalizedString("status.scanning");
            }
            return HelpUtils.getLocalizedString("contents.other_demos_node");
        }

        @Override
        public String getShortLabel() {
            return this.getLabel();
        }

        @Override
        public Icon getIcon() {
            return HelpIcon.DEMOS.getIcon();
        }

        @Override
        public String getProduct() {
            return null;
        }

        @Override
        public TreeNode getTreeNode() {
            return this;
        }

        @Override
        public void addChild(TreeNode treeNode) {
        }

        @Override
        public void accept(HelpTreeItemVisitor helpTreeItemVisitor) {
        }

        public String toString() {
            return this.getShortLabel();
        }
    }
}

