/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.StateNode;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.xml.XMLUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class PlotPickerXMLParser {
    private static final ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.graphics.resources.RES_PlotPicker");

    PlotPickerXMLParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProductParseResults parseSavedLayout() {
        InputStream inputStream = null;
        try {
            String string = FileUtils.getPreferencesDirectory() + "/plotpickercache.xml";
            if (!FileUtils.fileExists((String)string)) {
                ProductParseResults productParseResults = null;
                return productParseResults;
            }
            inputStream = new FileInputStream(string);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            PlotPickerCacheHandler plotPickerCacheHandler = new PlotPickerCacheHandler();
            xMLReader.setContentHandler(plotPickerCacheHandler);
            xMLReader.parse(new InputSource(inputStream));
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.log((String)iOException.toString());
                }
            }
            PlotPickerCacheHandler plotPickerCacheHandler2 = plotPickerCacheHandler;
            return plotPickerCacheHandler2;
        }
        catch (Exception exception) {
            ProductParseResults productParseResults = null;
            return productParseResults;
        }
        catch (Error error) {
            ProductParseResults productParseResults = null;
            return productParseResults;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.log((String)iOException.toString());
                }
            }
        }
    }

    static ProductParseResults parseMATLAB() {
        InputStream inputStream;
        try {
            inputStream = PlotPickerXMLParser.class.getResourceAsStream("resources/plotpickerlayout.xml");
        }
        catch (Exception exception) {
            return null;
        }
        ProductParseResults productParseResults = PlotPickerXMLParser.parse(inputStream, "MATLAB");
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                Log.log((String)iOException.toString());
            }
        }
        return productParseResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProductParseResults parse(InputStream inputStream, String string) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            PlotPickerLayoutHandler plotPickerLayoutHandler = new PlotPickerLayoutHandler(string);
            xMLReader.setContentHandler(plotPickerLayoutHandler);
            xMLReader.parse(new InputSource(inputStream));
            PlotPickerLayoutHandler plotPickerLayoutHandler2 = plotPickerLayoutHandler;
            return plotPickerLayoutHandler2;
        }
        catch (Exception exception) {
            ProductParseResults productParseResults = null;
            return productParseResults;
        }
        catch (Error error) {
            ProductParseResults productParseResults = null;
            return productParseResults;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.log((String)iOException.toString());
                }
            }
        }
    }

    private static void addCategoryElement(Document document, Element element, StateNode stateNode) {
        Element element2 = document.createElement("category");
        element2.setAttribute("name", (String)stateNode.getUserObject());
        if (stateNode.isProductNode()) {
            element2.setAttribute("prodid", stateNode.getProductID());
            element2.setAttribute("version", stateNode.getProductVersion());
        }
        element.appendChild(element2);
        for (int i = 0; i < stateNode.getChildCount(); ++i) {
            StateNode stateNode2 = (StateNode)stateNode.getChildAt(i);
            if (stateNode2.getAllowsChildren()) {
                PlotPickerXMLParser.addCategoryElement(document, element2, stateNode2);
                continue;
            }
            PlotPickerXMLParser.addPlotActionElement(document, element2, stateNode2);
        }
    }

    private static void addPlotActionElement(Document document, Element element, StateNode stateNode) {
        Element element2 = document.createElement("plotaction");
        element2.setAttribute("ID", ((PlotAction)stateNode.getUserObject()).getID());
        element.appendChild(element2);
    }

    static void writeLayoutToXML(StateNode stateNode) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(FileUtils.getPreferencesDirectory() + "/plotpickercache.xml");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("plotpicker");
            element.setAttribute("version", "4.0");
            document.appendChild(element);
            for (int i = 0; i < stateNode.getChildCount(); ++i) {
                StateNode stateNode2 = (StateNode)stateNode.getChildAt(i);
                if (stateNode2.getAllowsChildren()) {
                    PlotPickerXMLParser.addCategoryElement(document, element, stateNode2);
                    continue;
                }
                PlotPickerXMLParser.addPlotActionElement(document, element, stateNode2);
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "utf-8");
            XMLUtils.serializeXML((Object)document, (Object)outputStreamWriter, (String)"utf-8");
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            Log.log((String)exception.toString());
        }
    }

    static class ObsoleteVersionException
    extends RuntimeException {
    }

    static interface ProductParseResults {
        public HashMap<String, PlotAction> getPlotActionHashMap();

        public HashMap<String, CategoryElement> getCategoryHashMap();

        public List<String> getCategoryList();
    }

    static class CategoryElement {
        private List<String> iPlotActionIDs;
        private String iProductID;
        private double iVersion;

        CategoryElement(List<String> list, String string, double d) {
            this.iPlotActionIDs = list;
            this.iProductID = string;
            this.iVersion = d;
        }

        List<String> getPlotActionIDs() {
            return this.iPlotActionIDs;
        }

        String getProductID() {
            return this.iProductID;
        }

        double getVersion() {
            return this.iVersion;
        }
    }

    private static class PlotActionElement {
        private String iPlotActionFunction;
        private String iPlotActionDescription;
        private String iPlotActionShortDescription;
        private String iPlotActionVisibilityFunction;
        private String iPlotActionRuleDescription;
        private String iPlotActionLabelFunc;
        private String iPlotActionIconPath;
        private String iSmallPlotActionIconPath;
        private String iExecString;
        private String iResourcePath;
        private String iPlotActionID;
        private String iMethodOf;
        private String iAllowSwap = "yes";
        private String iIsGUI;
        private String iProductHelp;
        private String iRefPagePath;

        private PlotActionElement() {
        }

        private void loadAttribute(Attributes attributes, int n) {
            if ("function".equals(attributes.getLocalName(n))) {
                this.iPlotActionFunction = attributes.getValue(n);
            } else if ("description".equals(attributes.getLocalName(n))) {
                this.iPlotActionDescription = attributes.getValue(n);
            } else if ("shortdescription".equals(attributes.getLocalName(n))) {
                this.iPlotActionShortDescription = attributes.getValue(n);
            } else if ("visibility".equals(attributes.getLocalName(n))) {
                this.iPlotActionVisibilityFunction = attributes.getValue(n);
            } else if ("rule".equals(attributes.getLocalName(n))) {
                this.iPlotActionRuleDescription = attributes.getValue(n);
            } else if ("labelfcn".equals(attributes.getLocalName(n))) {
                this.iPlotActionLabelFunc = attributes.getValue(n);
            } else if ("largeicon".equals(attributes.getLocalName(n))) {
                this.iPlotActionIconPath = attributes.getValue(n);
            } else if ("smallicon".equals(attributes.getLocalName(n))) {
                this.iSmallPlotActionIconPath = attributes.getValue(n);
            } else if ("action".equals(attributes.getLocalName(n))) {
                this.iExecString = attributes.getValue(n);
            } else if ("resourcepath".equals(attributes.getLocalName(n))) {
                this.iResourcePath = attributes.getValue(n);
            } else if ("ID".equals(attributes.getLocalName(n)) || "name".equals(attributes.getLocalName(n))) {
                this.iPlotActionID = attributes.getValue(n);
            } else if ("producthelp".equals(attributes.getLocalName(n))) {
                this.iProductHelp = attributes.getValue(n);
            } else if ("refpagepath".equals(attributes.getLocalName(n))) {
                this.iRefPagePath = attributes.getValue(n);
            } else if ("methodof".equals(attributes.getLocalName(n))) {
                this.iMethodOf = attributes.getValue(n);
            } else if ("allowswap".equals(attributes.getLocalName(n))) {
                this.iAllowSwap = attributes.getValue(n);
            } else if ("gui".equals(attributes.getLocalName(n))) {
                this.iIsGUI = attributes.getValue(n);
            }
        }

        private String getPlotActionFunction() {
            return this.iPlotActionFunction;
        }

        private String getPlotActionDescription() {
            return this.iPlotActionDescription;
        }

        private String getPlotActionShortDescription() {
            return this.iPlotActionShortDescription;
        }

        private String getPlotActionVisibilityFunction() {
            return this.iPlotActionVisibilityFunction;
        }

        private String getPlotActionRuleDescription() {
            return this.iPlotActionRuleDescription;
        }

        private String getPlotActionLabelFunc() {
            return this.iPlotActionLabelFunc;
        }

        private String getExecString() {
            return this.iExecString;
        }

        private String getSmallPlotActionIconPath() {
            return this.iSmallPlotActionIconPath;
        }

        private String getlargePlotActionIconPath() {
            return this.iPlotActionIconPath;
        }

        private String getResourcePath() {
            return this.iResourcePath;
        }

        private String getID() {
            return this.iPlotActionID;
        }

        private String getProductHelp() {
            return this.iProductHelp;
        }

        private String getRefPagePath() {
            return this.iRefPagePath;
        }

        private String getMethodOf() {
            return this.iMethodOf;
        }

        private String getAllowSwap() {
            return this.iAllowSwap;
        }

        private String isGUI() {
            return this.iIsGUI;
        }
    }

    private static abstract class BaseLayoutHandler
    extends DefaultHandler
    implements ProductParseResults {
        protected double fVersion = 0.0;
        protected String fProductID;
        protected HashMap<String, CategoryElement> fCategoryHashMap = new HashMap();
        protected String fCurrentCategoryName;
        protected List<String> fCurrentCategoryContents = new ArrayList<String>();
        protected List<String> fCategoryNameList = new ArrayList<String>();
        protected HashMap<String, PlotAction> fPlotActionHashMap = new HashMap();

        private BaseLayoutHandler() {
        }

        @Override
        public HashMap<String, PlotAction> getPlotActionHashMap() {
            return null;
        }

        @Override
        public HashMap<String, CategoryElement> getCategoryHashMap() {
            return this.fCategoryHashMap;
        }

        @Override
        public List<String> getCategoryList() {
            return this.fCategoryNameList;
        }
    }

    private static class PlotPickerCacheHandler
    extends BaseLayoutHandler
    implements ProductParseResults {
        PlotPickerCacheHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("plotaction".equals(string2)) {
                String string4 = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!"ID".equals(attributes.getLocalName(i))) continue;
                    string4 = attributes.getValue(i);
                    break;
                }
                if (string4 != null) {
                    this.fCurrentCategoryContents.add(string4);
                }
            } else if ("category".equals(string2)) {
                Object object;
                if (!this.fCurrentCategoryContents.isEmpty()) {
                    object = new CategoryElement(this.fCurrentCategoryContents, this.fProductID, this.fVersion);
                    this.fCategoryNameList.add(resources.getString("PlotPickerTableModel.Favs"));
                    this.fCategoryHashMap.put(resources.getString("PlotPickerTableModel.Favs"), object);
                }
                object = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if ("name".equals(attributes.getLocalName(i))) {
                        object = attributes.getValue(i);
                    }
                    if ("prodid".equals(attributes.getLocalName(i))) {
                        this.fProductID = attributes.getValue(i);
                    }
                    if (!"version".equals(attributes.getLocalName(i))) continue;
                    try {
                        this.fVersion = Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fVersion = 0.0;
                    }
                }
                if (object != null) {
                    this.fCurrentCategoryContents = new ArrayList();
                    this.fCurrentCategoryName = object;
                }
            } else if ("plotpicker".equals(string2)) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!"version".equals(attributes.getLocalName(i))) continue;
                    try {
                        this.fVersion = Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fVersion = 0.0;
                    }
                }
                if (this.fVersion < 4.0) {
                    throw new ObsoleteVersionException();
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("category".equals(string2) && !this.fCurrentCategoryContents.isEmpty()) {
                CategoryElement categoryElement = new CategoryElement(this.fCurrentCategoryContents, this.fProductID, this.fVersion);
                this.fCategoryHashMap.put(this.fCurrentCategoryName, categoryElement);
                this.fCategoryNameList.add(this.fCurrentCategoryName);
                this.fCurrentCategoryContents = new ArrayList();
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }
    }

    private static class PlotPickerLayoutHandler
    extends BaseLayoutHandler
    implements ProductParseResults {
        private String fLastResourcePath;
        private ResourceBundle fLastResourceBundle;
        private boolean fUsesGlobalResourceBundle = false;

        PlotPickerLayoutHandler(String string) {
            this.fProductID = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("plotaction".equals(string2)) {
                PlotActionElement plotActionElement = new PlotActionElement();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    plotActionElement.loadAttribute(attributes, i);
                }
                if (!this.fPlotActionHashMap.containsKey(plotActionElement.getID())) {
                    if (!this.fUsesGlobalResourceBundle && plotActionElement.getResourcePath() != null) {
                        if (plotActionElement.getResourcePath().equals(this.fLastResourcePath)) {
                            if (this.fLastResourceBundle == null) {
                                this.fLastResourceBundle = ResourceBundle.getBundle(this.fLastResourcePath);
                            }
                        } else {
                            this.fLastResourcePath = plotActionElement.getResourcePath();
                            this.fLastResourceBundle = ResourceBundle.getBundle(this.fLastResourcePath);
                        }
                    }
                    String string4 = plotActionElement.getPlotActionDescription();
                    if (this.fLastResourceBundle != null && string4 != null && string4.matches("^resources:.+")) {
                        string4 = this.fLastResourceBundle.getString(string4.replaceAll("^resources:", ""));
                    }
                    String string5 = plotActionElement.getPlotActionShortDescription();
                    if (this.fLastResourceBundle != null && string5 != null && string5.matches("^resources:.+")) {
                        string5 = this.fLastResourceBundle.getString(string5.replaceAll("^resources:", ""));
                    }
                    String string6 = plotActionElement.getPlotActionRuleDescription();
                    if (this.fLastResourceBundle != null && string6.matches("^resources:.+")) {
                        string6 = this.fLastResourceBundle.getString(string6.replaceAll("^resources:", ""));
                    }
                    PlotAction plotAction = new PlotAction(plotActionElement.getID(), string4, string5, plotActionElement.getPlotActionFunction(), plotActionElement.getPlotActionVisibilityFunction(), plotActionElement.getExecString(), string6, plotActionElement.getPlotActionLabelFunc(), plotActionElement.getlargePlotActionIconPath(), plotActionElement.getSmallPlotActionIconPath(), plotActionElement.getProductHelp(), plotActionElement.getRefPagePath(), plotActionElement.getMethodOf(), plotActionElement.getAllowSwap(), plotActionElement.isGUI());
                    this.fPlotActionHashMap.put(plotActionElement.getID(), plotAction);
                }
                this.fCurrentCategoryContents.add(plotActionElement.getID());
            } else if ("category".equals(string2)) {
                Object object;
                if (!this.fCurrentCategoryContents.isEmpty()) {
                    object = new CategoryElement(this.fCurrentCategoryContents, this.fProductID, this.fVersion);
                    this.fCategoryNameList.add(resources.getString("PlotPickerTableModel.Favs"));
                    this.fCategoryHashMap.put(resources.getString("PlotPickerTableModel.Favs"), object);
                    for (String string7 : this.fCurrentCategoryContents) {
                        PlotAction plotAction = (PlotAction)this.fPlotActionHashMap.get(string7);
                    }
                }
                object = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!"name".equals(attributes.getLocalName(i))) continue;
                    object = attributes.getValue(i);
                }
                if (this.fLastResourceBundle != null && object != null && ((String)object).matches("^resources:.+")) {
                    object = this.fLastResourceBundle.getString(((String)object).replaceAll("^resources:", ""));
                }
                if (object != null) {
                    this.fCurrentCategoryContents = new ArrayList();
                    this.fCurrentCategoryName = object;
                }
            } else if ("plotpicker".equals(string2)) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if ("resourcepath".equals(attributes.getLocalName(i))) {
                        this.fUsesGlobalResourceBundle = true;
                        this.fLastResourcePath = attributes.getValue(i);
                        this.fLastResourceBundle = ResourceBundle.getBundle(this.fLastResourcePath);
                    }
                    if (!"version".equals(attributes.getLocalName(i))) continue;
                    try {
                        this.fVersion = Double.parseDouble(attributes.getValue(i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.fVersion = 0.0;
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if ("category".equals(string2) && !this.fCurrentCategoryContents.isEmpty()) {
                CategoryElement categoryElement = new CategoryElement(this.fCurrentCategoryContents, this.fProductID, this.fVersion);
                this.fCategoryHashMap.put(this.fCurrentCategoryName, categoryElement);
                this.fCategoryNameList.add(this.fCurrentCategoryName);
                this.fCurrentCategoryContents = new ArrayList();
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public HashMap<String, PlotAction> getPlotActionHashMap() {
            return this.fPlotActionHashMap;
        }

        @Override
        public HashMap<String, CategoryElement> getCategoryHashMap() {
            return this.fCategoryHashMap;
        }

        @Override
        public List<String> getCategoryList() {
            return this.fCategoryNameList;
        }
    }
}

