/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.widgets.table;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.util.ReturnRunnable;
import com.mathworks.widgets.TextFieldWithBalloonTip;
import com.mathworks.widgets.ValidatableWithHelp;
import com.mathworks.widgets.ValidityWithHelp;
import com.mathworks.widgets.grouptable.CloseableEditor;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public final class FileNameEditor {
    private final TextFieldWithBalloonTip fEditorField;
    private final FileTable fTable;
    private final CloseableEditor fEditor;

    public FileNameEditor(FileTable fileTable) {
        this.fTable = fileTable;
        ValidatableWithHelp validatableWithHelp = new ValidatableWithHelp(){

            public ValidityWithHelp getValidity(String string) {
                if (FileNameEditor.this.fTable.getEditingRow() == -1) {
                    return new ValidityWithHelp(Validity.VALID, null);
                }
                String string2 = FileNameEditor.this.fEditor.getCellEditorValue().toString();
                FileSystemEntry fileSystemEntry = (FileSystemEntry)FileNameEditor.this.fTable.get(FileNameEditor.this.fTable.getEditingRow());
                GroupingTableColumn groupingTableColumn = FileNameEditor.this.fTable.getActualEditingColumn();
                return groupingTableColumn.getEditor().validateEdit((Object)fileSystemEntry, string2);
            }

            public ValidityWithHelp getValidityWhenBlank() {
                return this.getValidity("");
            }
        };
        this.fEditorField = new TextFieldWithBalloonTip((JComponent)((Object)this.fTable), validatableWithHelp, (ReturnRunnable)new ReturnRunnable<Point>(){

            public Point run() {
                if (FileNameEditor.this.fTable.getEditingRow() == -1) {
                    return null;
                }
                Rectangle rectangle = FileNameEditor.this.fTable.getCellRect(FileNameEditor.this.fTable.getEditingRow(), FileNameEditor.this.fTable.getEditingColumn(), true);
                return new Point((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)(rectangle.getY() + 6.0));
            }
        });
        this.fEditorField.setI18nComponentNameForFont(ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop").getString("title.CurrentDirectory"));
        this.fEditorField.getTextField().setName("Table.editor");
        this.fEditorField.getTextField().setSelectAllOnFocus(false);
        this.fEditorField.getTextField().setBorder((Border)new LineBorder(Color.BLACK));
        this.fEditor = new Editor();
    }

    public CloseableEditor getEditor() {
        return this.fEditor;
    }

    private class Editor
    extends DefaultCellEditor
    implements CloseableEditor {
        Editor() {
            super((JTextField)FileNameEditor.this.fEditorField.getTextField());
        }

        @Override
        public boolean stopCellEditing() {
            if (FileNameEditor.this.fTable.getEditingRow() == -1) {
                return super.stopCellEditing();
            }
            return (FileNameEditor.this.fEditorField.getTextField().getValidity() == Validity.VALID || FileNameEditor.this.fEditorField.getTextField().getValidity() == Validity.WARNING) && super.stopCellEditing();
        }

        public void close() {
            FileNameEditor.this.fEditorField.getTip().hide();
        }
    }
}

