/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.treefs;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.DefaultRecursiveSearchList;
import com.mathworks.mlwidgets.explorer.model.treefs.TreeModelFileList;
import com.mathworks.mwswing.TreeUtils;
import com.mathworks.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeModelFileSystem
implements FileSystem {
    private final TreeModel fModel;

    TreeModelFileSystem(TreeModel treeModel) {
        this.fModel = treeModel;
    }

    public TreeModel getModel() {
        return this.fModel;
    }

    public FileLocation getLocationByNode(TreeNode treeNode) {
        return this.getLocationByPath(TreeUtils.nodeToPath((TreeNode)treeNode));
    }

    public FileLocation getLocationByPath(TreePath treePath) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < treePath.getPathCount(); ++i) {
            stringBuilder.append(this.encodeName(treePath.getPathComponent(i).toString()));
            if (i >= treePath.getPathCount() - 1) continue;
            stringBuilder.append(File.separator);
        }
        return new FileLocation(stringBuilder.toString());
    }

    public TreePath getTreePath(FileLocation fileLocation) {
        if (fileLocation.equals((Object)FileLocation.ROOT)) {
            return new TreePath(this.fModel.getRoot());
        }
        Stack<String> stack = new Stack<String>();
        for (FileLocation fileLocation2 = fileLocation; fileLocation2 != null; fileLocation2 = fileLocation2.getParent()) {
            if (fileLocation2.equals((Object)FileLocation.ROOT)) continue;
            stack.push(this.decodeName(fileLocation2.getName()));
        }
        Object[] objectArray = new Object[stack.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)stack.pop();
            if (i == 0 && !this.fModel.getRoot().toString().equals(string)) {
                objectArray = new Object[stack.size() + 2];
                objectArray[0] = this.fModel.getRoot();
                stack.push(string);
                continue;
            }
            objectArray[i] = i > 0 ? this.findNode(objectArray[i - 1], string) : this.fModel.getRoot();
            if (objectArray[i] != null) continue;
            return null;
        }
        return new TreePath(objectArray);
    }

    private Object findNode(Object object, String string) {
        int n = this.fModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = this.fModel.getChild(object, i);
            if (!object2.toString().equals(string)) continue;
            return object2;
        }
        return null;
    }

    public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be used on the EDT.");
        }
        if (fileLocation == null) {
            boolean bl = false;
        }
        if (fileLocation.equals((Object)FileLocation.ROOT)) {
            return new FileSystemEntry((FileSystem)this, fileLocation, false, true, 0L, 0L, 0L);
        }
        TreePath treePath = this.getTreePath(fileLocation);
        if (treePath == null) {
            return new FileSystemEntry((FileSystem)this, fileLocation, false, false, 0L, 0L, 0L);
        }
        return new FileSystemEntry((FileSystem)this, fileLocation, false, true, 0L, 0L, 0L);
    }

    public InputStream getInputStream(FileLocation fileLocation) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean exists(FileLocation fileLocation) {
        return this.getTreePath(fileLocation) != null;
    }

    public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
        return fileSystemEntry;
    }

    public FileList getList(FileLocation fileLocation) throws IOException {
        return new TreeModelFileList(this, this.fModel, this.getTreePath(fileLocation), fileLocation);
    }

    public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
        return new DefaultRecursiveSearchList((FileSystem)this, fileLocation, searchCriteria, predicate);
    }

    public boolean isReadOnly(FileLocation fileLocation) {
        return true;
    }

    public FileSystemTransaction createTransaction() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String encodeName(String string) {
        try {
            return URLEncoder.encode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public String decodeName(String string) {
        try {
            return URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }
}

