/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.widgets.grouptable.Group;
import java.util.Comparator;
import java.util.List;

final class FileTypeComparator
implements Comparator<FileSystemEntry> {
    private final FileSystemExpansionProvider fProvider;

    FileTypeComparator(FileSystemExpansionProvider fileSystemExpansionProvider) {
        this.fProvider = fileSystemExpansionProvider;
    }

    @Override
    public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
        fileSystemEntry = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry);
        fileSystemEntry2 = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry2);
        if (fileSystemEntry.isFolder()) {
            return fileSystemEntry.getName().compareToIgnoreCase(fileSystemEntry2.getName());
        }
        String string = FileTypeComparator.getExtension(fileSystemEntry);
        String string2 = FileTypeComparator.getExtension(fileSystemEntry2);
        int n = string.compareTo(string2);
        String string3 = (String)this.fProvider.getDecoration(fileSystemEntry, false, CoreFileDecoration.TYPE_NAME);
        String string4 = (String)this.fProvider.getDecoration(fileSystemEntry2, false, CoreFileDecoration.TYPE_NAME);
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (n == 0) {
            n = string3.compareTo(string4);
        }
        if (n == 0) {
            n = fileSystemEntry.getName().compareToIgnoreCase(fileSystemEntry2.getName());
        }
        return n;
    }

    public Comparator<Group<FileSystemEntry>> toGroupComparator() {
        return new Comparator<Group<FileSystemEntry>>(){

            @Override
            public int compare(Group<FileSystemEntry> group, Group<FileSystemEntry> group2) {
                List list = group.getItems();
                List list2 = group2.getItems();
                if (list.isEmpty() ^ list2.isEmpty()) {
                    return list.isEmpty() ? -1 : 1;
                }
                if (list.isEmpty()) {
                    return 0;
                }
                return FileTypeComparator.this.compare((FileSystemEntry)group.getItems().get(0), (FileSystemEntry)group2.getItems().get(0));
            }
        };
    }

    private static String getExtension(FileSystemEntry fileSystemEntry) {
        int n = fileSystemEntry.getName().lastIndexOf(46);
        return n >= 0 ? fileSystemEntry.getName().substring(n).toLowerCase() : "";
    }
}

