/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.dialog;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJProgressBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ProgressBarDialog {
    private MJFrame fFrame;
    private JInternalFrame fInternalFrame;
    private JComponent fGlassPane;
    private Component fOldGlassPane;
    private RootPaneContainer fParent;
    private MJProgressBar fProgressBar;
    private MJLabel fStatusString;
    private MJLabel fSpinner;
    private MJButton fCancelButton;
    private CancellationListener fListener;
    private double fMin = 0.0;
    private double fMax = 1.0;
    private double fValue = 0.0;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.dialog.resources.RES_dialog");

    public static ProgressBarDialog createProgressBar(String string, CancellationListener cancellationListener) {
        return new ProgressBarDialog(string, false, cancellationListener);
    }

    public static ProgressBarDialog createInternalProgressBar(final RootPaneContainer rootPaneContainer, String string, CancellationListener cancellationListener) {
        final ProgressBarDialog progressBarDialog = new ProgressBarDialog(string, true, cancellationListener);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressBarDialog.initGlassPane(rootPaneContainer);
                    progressBarDialog.fGlassPane.add(progressBarDialog.fInternalFrame);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return progressBarDialog;
    }

    public static ProgressBarDialog createHeavyweightInternalProgressBar(final RootPaneContainer rootPaneContainer, String string, CancellationListener cancellationListener) {
        final ProgressBarDialog progressBarDialog = new ProgressBarDialog(string, true, cancellationListener);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    progressBarDialog.initGlassPane(rootPaneContainer);
                    Panel panel = new Panel();
                    panel.setLayout(new BorderLayout());
                    panel.add(progressBarDialog.fInternalFrame);
                    progressBarDialog.fGlassPane.add(panel);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return progressBarDialog;
    }

    private void initGlassPane(RootPaneContainer rootPaneContainer) {
        this.fParent = rootPaneContainer;
        this.fOldGlassPane = rootPaneContainer.getGlassPane();
        this.fGlassPane = new JComponent(){};
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){};
        this.fGlassPane.addMouseListener(mouseInputAdapter);
        this.fGlassPane.addMouseMotionListener(mouseInputAdapter);
        this.fGlassPane.setLayout(new GridBagLayout());
        this.fParent.setGlassPane(this.fGlassPane);
        this.fGlassPane.setVisible(true);
    }

    private ProgressBarDialog(String string, boolean bl, CancellationListener cancellationListener) {
        Object object;
        if (bl) {
            this.fInternalFrame = new JInternalFrame(string);
            this.fInternalFrame.setName("ProgressBarDialog");
            this.fInternalFrame.setFrameIcon(null);
            object = this.fInternalFrame;
        } else {
            this.fFrame = new MJFrame(string);
            this.fFrame.setName("ProgressBarDialog");
            object = this.fFrame;
            this.fFrame.setLocationRelativeTo(null);
        }
        this.fListener = cancellationListener;
        this.fProgressBar = new MJProgressBar(0, 0, Integer.MAX_VALUE);
        this.fProgressBar.setPreferredSize(new Dimension(380, 15));
        this.setValue(this.fMin);
        this.fStatusString = new MJLabel(sRes.getString("progressbar.PleaseWait"));
        this.fSpinner = new MJLabel();
        this.fSpinner.setIcon((Icon)new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/mathworks/mlwidgets/dialog/resources/spinner.gif"))));
        this.fCancelButton = new MJButton(sRes.getString("progressbar.Cancel"));
        MJPanel mJPanel = new MJPanel();
        mJPanel.add((Component)this.fCancelButton);
        this.fCancelButton.addActionListener((ActionListener)new CancelButtonListener());
        MJPanel mJPanel2 = new MJPanel(new BorderLayout(5, 5)){

            public Insets getInsets() {
                return new Insets(5, 5, 0, 5);
            }
        };
        mJPanel2.setLayout((LayoutManager)new BorderLayout(5, 5));
        mJPanel2.add((Component)this.fStatusString, (Object)"North");
        mJPanel2.add((Component)this.fProgressBar, (Object)"Center");
        mJPanel2.add((Component)mJPanel, (Object)"South");
        mJPanel2.add((Component)this.fSpinner, (Object)"East");
        object.setContentPane((Container)mJPanel2);
        if (bl) {
            this.fInternalFrame.pack();
        } else {
            this.fFrame.pack();
        }
    }

    public boolean isInternalProgressBar() {
        return this.fFrame == null;
    }

    public void setIcon(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (string != null) {
                        ProgressBarDialog.this.fFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/mathworks/mwswing/resources/matlabicon.gif")));
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setLocationRelativeTo(final Component component) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarDialog.this.fFrame.setLocationRelativeTo(component);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setProgressStatusLabel(final String string) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarDialog.this.fStatusString.setText(string);
                    ProgressBarDialog.this.fStatusString.repaint();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setCircularProgressBar(final boolean bl) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarDialog.this.fProgressBar.setIndeterminate(bl);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        this.fListener = null;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ProgressBarDialog.this.isInternalProgressBar()) {
                        ProgressBarDialog.this.fFrame.dispose();
                    } else {
                        ProgressBarDialog.this.fGlassPane.setVisible(false);
                        ProgressBarDialog.this.fParent.setGlassPane(ProgressBarDialog.this.fOldGlassPane);
                        ProgressBarDialog.this.fInternalFrame.dispose();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setVisible(final boolean bl) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ProgressBarDialog.this.isInternalProgressBar()) {
                        ProgressBarDialog.this.fFrame.setVisible(bl);
                    } else {
                        ProgressBarDialog.this.fInternalFrame.setVisible(bl);
                        ProgressBarDialog.this.fGlassPane.setVisible(bl);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSpinnerVisible(final boolean bl) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarDialog.this.fSpinner.setVisible(bl);
                    if (!ProgressBarDialog.this.isInternalProgressBar()) {
                        ProgressBarDialog.this.fFrame.pack();
                    } else {
                        ProgressBarDialog.this.fInternalFrame.pack();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setMinimum(double d) {
        this.fMin = d;
        this.setValue(this.fValue);
    }

    public double getMinimum() {
        return this.fMin;
    }

    public void setMaximum(double d) {
        this.fMax = d;
        this.setValue(this.fValue);
    }

    public double getMaximum() {
        return this.fMax;
    }

    public void setValue(double d) {
        this.fValue = d;
        final int n = (int)(2.147483647E9 * (this.fValue - this.fMin) / (this.fMax - this.fMin));
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarDialog.this.fProgressBar.setString(sRes.getString("progressbar.PleaseWait"));
                    ProgressBarDialog.this.fProgressBar.setValue(n);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getValue() {
        return (double)this.fProgressBar.getValue() / 2.147483647E9 * (this.fMax - this.fMin);
    }

    public void setCancelButtonVisible(final boolean bl) {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarDialog.this.fCancelButton.setVisible(bl);
                    if (!ProgressBarDialog.this.isInternalProgressBar()) {
                        ProgressBarDialog.this.fFrame.pack();
                    } else {
                        ProgressBarDialog.this.fInternalFrame.pack();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ProgressBarDialog.this.fListener != null) {
                ProgressBarDialog.this.fListener.cancel();
            }
            ProgressBarDialog.this.dispose();
        }
    }

    public static interface CancellationListener {
        public void cancel();
    }
}

