/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.ui.ValidateableAssociatedMFileText;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.ValidatableTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ValidateableTextFieldWithEllipsisButton {
    private ValidatableTextField fMFileName = new ValidatableTextField((Validatable)new ValidateableAssociatedMFileText());
    private MJButton fMFileNameEllipsis = new MJButton(ConfigurationUtils.lookup("choose.button"));

    public ValidateableTextFieldWithEllipsisButton() {
        this.init();
    }

    private void init() {
        this.initNames();
        this.initToolTips();
        this.initListeners();
    }

    private void initNames() {
        this.fMFileName.setName("MFileNameField");
        this.fMFileNameEllipsis.setName("MFileNameEllipsisButton");
    }

    private void initToolTips() {
        this.fMFileNameEllipsis.setToolTipText(ConfigurationUtils.lookup("choose.button.tooltip"));
    }

    private void initListeners() {
        this.fMFileNameEllipsis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(ValidateableTextFieldWithEllipsisButton.this.fMFileName.getText());
                MJFileChooserPerPlatform mJFileChooserPerPlatform = ConfigurationUtils.getFileChooser(file);
                mJFileChooserPerPlatform.showOpenDialog(SwingUtilities.getRoot((Component)ValidateableTextFieldWithEllipsisButton.this.getMFileNameEllipsis()), ValidateableTextFieldWithEllipsisButton.this.getChangeListener());
            }
        });
    }

    public ValidatableTextField getMFileName() {
        return this.fMFileName;
    }

    public MJButton getMFileNameEllipsis() {
        return this.fMFileNameEllipsis;
    }

    private ChangeListener getChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MJFileChooserPerPlatform mJFileChooserPerPlatform = (MJFileChooserPerPlatform)changeEvent.getSource();
                if (mJFileChooserPerPlatform.getState() == 0) {
                    final File file = mJFileChooserPerPlatform.getSelectedFile();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ValidateableTextFieldWithEllipsisButton.this.fMFileName.setText(file.getPath());
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
    }
}

