/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array.editors;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractTypedViewer;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ExtractVariableAction;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.editors.MatlabStructureModel;
import com.mathworks.mlwidgets.array.editors.MatlabWorkspaceLikeModel;
import com.mathworks.mlwidgets.array.editors.WorkspaceLikeEditorProvider;
import com.mathworks.mlwidgets.array.editors.WorkspaceLikePanel;
import com.mathworks.mlwidgets.array.editors.WorkspaceLikeTable;
import com.mathworks.mlwidgets.workspace.WorkspaceDialogs;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTable;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public final class StructureEditorProvider
extends WorkspaceLikeEditorProvider
implements IRegionOpProvider,
INewVariableProvider {
    private MatlabWorkspaceLikeModel fMatlabWorkspaceLikeModel = null;

    private StructureEditorProvider(WorkspaceLikeTable workspaceLikeTable, MatlabWorkspaceLikeModel matlabWorkspaceLikeModel, AbstractTypedViewer abstractTypedViewer) {
        super(workspaceLikeTable, abstractTypedViewer);
        this.fMatlabWorkspaceLikeModel = matlabWorkspaceLikeModel;
        this.setDefaultSelectionMode();
    }

    private void setDefaultSelectionMode() {
        this.fTable.setSelectionMode(2);
    }

    @Override
    public void rename(String string) {
        this.fMatlabWorkspaceLikeModel.rename(string);
        this.fTable.rename(string);
    }

    @Override
    public void setUseMinimalMenus(boolean bl) {
        this.fTable.setUseMinimalMenus(bl);
    }

    @Override
    public void setOpenActionListener(ActionListener actionListener) {
        this.fMatlabWorkspaceLikeModel.setOpenActionListener(actionListener);
        if (actionListener != null) {
            this.fTable.setSelectionMode(0);
        } else {
            this.setDefaultSelectionMode();
        }
    }

    public static StructureEditorProvider createProvider(WorkspaceVariable workspaceVariable) {
        MatlabStructureModel matlabStructureModel = new MatlabStructureModel(workspaceVariable);
        int[] nArray = new int[]{matlabStructureModel.NAME(), matlabStructureModel.VALUE(), matlabStructureModel.MIN(), matlabStructureModel.MAX()};
        RecordlistTable.setInitialShownColumns((String)"VE_2011a_1", (int[])nArray, (int)matlabStructureModel.getFieldCount());
        RecordlistTable.setInitialShownColumnWidths((String)"VE_2011a_1", (int[])new int[]{130, 130, 50, 50});
        WorkspaceLikeTable workspaceLikeTable = new WorkspaceLikeTable((IRecordlistModel)matlabStructureModel, workspaceVariable, "VE_2011a_1");
        WorkspaceLikePanel workspaceLikePanel = new WorkspaceLikePanel(workspaceLikeTable);
        workspaceLikePanel.setName("StructurePanel");
        workspaceLikeTable.getAccessibleContext().setAccessibleName("Table of fields in the structure named " + workspaceVariable.getVariableName());
        workspaceLikeTable.setDeletionObserver(WorkspaceDialogs.getDefaultDeletionObserver(matlabStructureModel, (Component)((Object)workspaceLikeTable)));
        workspaceLikeTable.setEditingObserver(WorkspaceDialogs.getDefaultEditingObserver(matlabStructureModel, (Component)((Object)workspaceLikeTable)));
        StructureEditorProvider structureEditorProvider = new StructureEditorProvider(workspaceLikeTable, matlabStructureModel, workspaceLikePanel);
        workspaceLikeTable.setProvider(structureEditorProvider);
        return structureEditorProvider;
    }

    public Action getInsertAction() {
        return null;
    }

    public Action getInsertAction(IRegionOpProvider.Scope scope, int n) {
        if (scope == IRegionOpProvider.Scope.ROWS) {
            return new InsertAction(ArrayUtils.getResource("insert.Field"));
        }
        return null;
    }

    public Action getDeleteAction() {
        return null;
    }

    public Action getDeleteAction(IRegionOpProvider.Scope scope, int n) {
        if (scope == IRegionOpProvider.Scope.ROWS) {
            return new DeleteAction(ArrayUtils.getResource("delete.Field"));
        }
        return null;
    }

    public Action getClearContentsAction() {
        return null;
    }

    public List<IRegionOpProvider.Scope> getScopeSupportedForSelection() {
        ArrayList<IRegionOpProvider.Scope> arrayList = new ArrayList<IRegionOpProvider.Scope>();
        arrayList.add(IRegionOpProvider.Scope.COLUMNS);
        return arrayList;
    }

    @Override
    public MJAbstractAction[] getCreationActions() {
        MJAbstractAction[] mJAbstractActionArray = new MJAbstractAction[]{new ExtractStructureFieldAction()};
        return mJAbstractActionArray;
    }

    @Override
    public String getCreationLabel() {
        return ArrayUtils.getResource("variable.new.label");
    }

    @Override
    public List<INewVariableProvider.CreationParams> getCreationParamsForSelection() {
        ArrayList<INewVariableProvider.CreationParams> arrayList = new ArrayList<INewVariableProvider.CreationParams>();
        arrayList.add(INewVariableProvider.CreationParams.ALL);
        return arrayList;
    }

    private String getFieldName(String string) {
        if (string != null) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return null;
    }

    private void setTable(WorkspaceLikeTable workspaceLikeTable) {
        if (this.fTable != null) {
            this.fTable.cleanup();
        }
        this.fTable = workspaceLikeTable;
    }

    private void setModel(MatlabWorkspaceLikeModel matlabWorkspaceLikeModel) {
        this.fMatlabWorkspaceLikeModel = matlabWorkspaceLikeModel;
    }

    private class ExtractStructureFieldAction
    extends MJAbstractAction {
        ExtractStructureFieldAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = StructureEditorProvider.this.fTable.getSelectedRows();
            final String[] stringArray = StructureEditorProvider.this.fMatlabWorkspaceLikeModel.getFullNamesFromIDs(StructureEditorProvider.this.fTable.convertRowIndicesToUnderlyingModel(nArray));
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean bl = true;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string : stringArray) {
                        String string2 = StructureEditorProvider.this.getFieldName(string);
                        String string3 = string2 + ExtractVariableAction.getUniqueVarNameSuffix(string2, arrayList);
                        try {
                            MatlabMCR.mtEval((String)(string3 + " = " + string + (bl ? "; openvar " + string3 : "")));
                            bl = false;
                            arrayList.add(string3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    private class DeleteAction
    extends MJAbstractAction {
        DeleteAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StructureEditorProvider.this.fTable.getAction(20).actionPerformed(actionEvent);
        }
    }

    private class InsertAction
    extends MJAbstractAction {
        InsertAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            if (StructureEditorProvider.this.fTable.getSelectedRowCount() > 0) {
                try {
                    int[] nArray = StructureEditorProvider.this.fTable.getSelectedRows();
                    int[] nArray2 = new int[]{nArray[0]};
                    if (StructureEditorProvider.this.fTable.getSortDirection() == 1) {
                        nArray2[0] = nArray2[0] - 1;
                    }
                    if (nArray2[0] >= 0) {
                        int[] nArray3 = StructureEditorProvider.this.fTable.convertRowIndicesToUnderlyingModel(nArray2);
                        String[] stringArray = StructureEditorProvider.this.fMatlabWorkspaceLikeModel.getFullNamesFromIDs(nArray3);
                        string = stringArray[0].substring(stringArray[0].lastIndexOf(46) + 1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((MatlabStructureModel)StructureEditorProvider.this.fMatlabWorkspaceLikeModel).setFieldToInsertAbove(string);
            if (StructureEditorProvider.this.fTable.getSelectedRowCount() > 0) {
                StructureEditorProvider.this.fTable.clearSelection();
            }
            StructureEditorProvider.this.fTable.getAction(10).actionPerformed(actionEvent);
        }
    }
}

