/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui.search.index;

import com.mathworks.help.helpui.LocalDocSetParser;
import com.mathworks.help.helpui.buildtools.DocSetBuildToolUtils;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.lucene.FileSystemIndexLocation;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneMultiIndexMerger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DocCenterIndexMergeTool {
    private static final String INDEX_DIR_NAME = "helpsearch";
    private final File fDocSetDir;
    private final DocLanguage fLanguage;

    public DocCenterIndexMergeTool(File file) {
        this(file, DocLanguage.getDefault());
    }

    public DocCenterIndexMergeTool(File file, DocLanguage docLanguage) {
        this.fDocSetDir = file;
        this.fLanguage = docLanguage;
    }

    public void doMerge() throws IOException {
        File file2;
        List<File> list = this.getSearchIndexDirectories();
        System.out.println("Found " + list.size() + " indexes to merge:");
        for (File file2 : list) {
            System.out.println("\t" + file2.getAbsolutePath());
        }
        List<IndexLocation> list2 = DocCenterIndexMergeTool.getIndexesToMerge(list);
        file2 = new File(this.fDocSetDir, INDEX_DIR_NAME);
        System.out.println("Creating merged index at: " + file2.getAbsolutePath());
        FileSystemIndexLocation fileSystemIndexLocation = new FileSystemIndexLocation(file2, true);
        LuceneMultiIndexMerger luceneMultiIndexMerger = new LuceneMultiIndexMerger((IndexLocation)fileSystemIndexLocation, (Collection)list2);
        long l = System.currentTimeMillis();
        luceneMultiIndexMerger.doMerge();
        long l2 = System.currentTimeMillis();
        System.out.println("Created merged index in " + String.valueOf(l2 - l) + " milliseconds");
    }

    private List<File> getSearchIndexDirectories() {
        LinkedList<File> linkedList = new LinkedList<File>();
        DocumentationSet documentationSet = this.getDocumentationSet();
        for (DocProduct docProduct : documentationSet.getAllProducts()) {
            File file = this.getProductSearchIndexDir(docProduct);
            if (file == null) continue;
            linkedList.add(file);
        }
        return Collections.unmodifiableList(linkedList);
    }

    private static List<IndexLocation> getIndexesToMerge(List<File> list) throws IOException {
        LinkedList<FileSystemIndexLocation> linkedList = new LinkedList<FileSystemIndexLocation>();
        for (File file : list) {
            linkedList.add(new FileSystemIndexLocation(file, false));
        }
        return Collections.unmodifiableList(linkedList);
    }

    private DocumentationSet getDocumentationSet() {
        LocalDocSetParser localDocSetParser = new LocalDocSetParser(this.fDocSetDir, this.fLanguage);
        return localDocSetParser.getDocSet();
    }

    private File getProductSearchIndexDir(DocProduct docProduct) {
        File file = new File(this.fDocSetDir, docProduct.getHelpLocation());
        File file2 = new File(file, INDEX_DIR_NAME);
        return file2.exists() && file2.isDirectory() ? file2 : null;
    }

    public static void main(String[] stringArray) {
        try {
            File file = DocSetBuildToolUtils.getDocSetDirectoryFromInputArgs(stringArray, 0);
            DocLanguage docLanguage = DocLanguage.getDefault();
            if (stringArray.length > 1) {
                docLanguage = DocSetBuildToolUtils.getDocLanguageFromInputArgs(stringArray, 1);
            }
            DocCenterIndexMergeTool docCenterIndexMergeTool = new DocCenterIndexMergeTool(file, docLanguage);
            docCenterIndexMergeTool.doMerge();
        }
        catch (Exception exception) {
            System.out.println("An error occurred while merging the indexes.");
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

