/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.help.helpui;

import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.SearchConfig;
import java.io.File;
import java.util.Locale;

public class HelpBrowserSearchConfig
implements SearchConfig {
    private static final String SEARCH_INDEX_DIR_BASE = "helpsearch";
    private final File fDocSetDirectory;
    private final String fIndexDirectoryName;
    private final DocLanguage fLanguage;

    public HelpBrowserSearchConfig(String string) {
        this(new File(string));
    }

    public HelpBrowserSearchConfig(File file) {
        this(file, DocLanguage.getDefault());
    }

    public HelpBrowserSearchConfig(String string, DocLanguage docLanguage) {
        this(new File(string), docLanguage);
    }

    public HelpBrowserSearchConfig(File file, DocLanguage docLanguage) {
        this.fDocSetDirectory = file != null && file.exists() && file.isDirectory() ? file : null;
        this.fLanguage = docLanguage;
        this.fIndexDirectoryName = HelpBrowserSearchConfig.getIndexDirectoryName(this.fDocSetDirectory, docLanguage);
    }

    private static String getIndexDirectoryName(File file, DocLanguage docLanguage) {
        if (docLanguage == DocLanguage.ENGLISH || file == null) {
            return SEARCH_INDEX_DIR_BASE;
        }
        Locale locale = docLanguage.getLocale();
        String string = "helpsearch_" + locale.getLanguage() + "_" + locale.getCountry();
        File file2 = new File(file, string);
        if (file2.exists() && file2.isDirectory()) {
            return string;
        }
        return SEARCH_INDEX_DIR_BASE;
    }

    protected File getDocSetDirectory() {
        return this.fDocSetDirectory;
    }

    protected DocLanguage getLanguage() {
        return this.fLanguage;
    }

    public File getIndexDirectory() {
        File file = this.getDocSetDirectory();
        return new File(file, this.fIndexDirectoryName);
    }

    public boolean getUseLocks() {
        return false;
    }
}

