/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.decorations;

import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.decorations.HiliteFilter;
import com.mathworks.mwt.decorations.PlatformDecorations;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ResLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.image.FilteredImageSource;

class WindowsXPDecorations
extends PlatformDecorations {
    private static final int kUp = 0;
    private static final int kLeft = 1;
    private static final int kDown = 2;
    private static final int kRight = 3;
    private static int RADIO_NORMAL = 0;
    private static int RADIO_HOT = 1;
    private static int RADIO_PRESSED = 2;
    private static int RADIO_DISABLED = 3;
    private static int RADIO_CHECKED = 4;
    private static int RADIO_CHECKED_DISABLED = 5;
    private static int RADIO_CHECKED_HOT = 6;
    private static int RADIO_CHECKED_PRESSED = 7;
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private static Color sWindow;
    private static Color sWindowText;
    private static Color sDialog;
    private static Color sControl;
    private static Color sControlText;
    private static Color sControlLtHilite;
    private static Color sControlHilite;
    private static Color sControlShadow;
    private static Color sControlDkShadow;
    private static Color sScrollbar;
    private static Color sTextHighlight;
    private static Color sTextHighlightText;
    private static Color sText;
    private static Color sTextText;
    private static Color sInactiveText;
    private static Color[][] sSliderThumbGreenColors;
    private static Color[][] sScrollThumbLightColors;
    private static Color[][] sScrollThumbDarkColors;
    private static Color[][] sScrollTrackTopBevels;
    private static final Color sDisabledThumb;
    private static final Color sDisabledThumbBevel;
    private static final Color[] sScrollTrackColors;
    private static final Color[] sScrollTrackPressedColors;
    private static final Color[] sButtonA;
    private static final Color[] sButtonB;
    private static final Color[] sButtonC;
    private static final Color[] sButtonD;
    private static final Color[] sButtonE;
    private static final Color[] sButtonF;
    private static final Color[] sButtonG;
    private static final Color[] sButtonH;
    private static final Color[] sButtonI;
    private static final Color[] sButtonJ;
    private static final Color[] sButtonX;
    private static final Color[] sButtonY;
    private static final Color[] sButtonHm1;
    private static final Color[] sButtonHm2;
    private static final Color[] sButtonHm3;
    private static final Color[] sSBBNormalFill;
    private static final Color[] sSBBPressedFill;
    private static final Color[] sSBBDisabledFill;
    private static final Color[] sSBBHotFill;
    private static final Color[] sSBBNormalInnerBorders;
    private static final Color[] sSBBPressedInnerBorders;
    private static final Color[] sSBBDisabledInnerBorders;
    private static final Color[] sSBBHotInnerBorders;
    private static final Color[] sSBBNormalCornerPixel;
    private static final Color[] sSBBPressedCornerPixel;
    private static final Color[] sSBBHotCornerPixel;
    private static final Color[] sSBBDisabledCornerPixel;
    private static final Color[] sSBBLeftmostOuterEdge;
    private static final Color[] sSANormalArrow;
    private static final Color sSADisabledArrow;
    private static final Color[] sBevelBorder;
    private static final Color sCBRBBorderNormal;
    private static final Color sCBRBBorderDisabled;
    private static final Color sCBRBInteriorNormal;
    private static final Color sCBRBInteriorPressed;
    private static final Color sCBRBInteriorDisabled;
    private static final Color sCBRBOrange;
    private static final Color sCBRBCheckNormal;
    private static final Color sCBRBCheckPressed;
    private static final Color sCBRBCheckDisabled;
    private static final Color[] sTBBBorderHot;
    private static final Color[] sTBBBorderPressed;
    private static Image[] sCheckboxImages;
    private static Image[] sRadioImages;
    private int fChecksize = 13;

    WindowsXPDecorations() {
    }

    @Override
    Font getFont(int n) {
        Font font = null;
        switch (n) {
            case 0: {
                font = DEFAULT_FONT;
            }
        }
        return font;
    }

    @Override
    Color getColor(int n) {
        Color color = null;
        switch (n) {
            case 0: 
            case 2: {
                color = sWindow;
                break;
            }
            case 1: {
                color = sControl;
                break;
            }
            case 3: {
                color = Color.gray;
                break;
            }
            case 4: {
                color = sTextHighlight;
                break;
            }
            case 5: {
                color = sTextHighlightText;
                break;
            }
            case 6: {
                color = sControl;
                break;
            }
            case 7: {
                color = sControlLtHilite;
                break;
            }
            case 8: {
                color = sControlHilite;
                break;
            }
            case 9: {
                color = sControlShadow;
                break;
            }
            case 10: {
                color = sControlDkShadow;
                break;
            }
            case 11: {
                color = sControlText;
                break;
            }
            case 12: {
                color = sWindowText;
                break;
            }
            case 13: {
                color = sText;
                break;
            }
            case 14: {
                color = sTextText;
                break;
            }
            case 15: {
                color = sInactiveText;
                break;
            }
            case 17: {
                color = SystemColor.activeCaptionText;
                break;
            }
            case 16: {
                color = SystemColor.activeCaption;
                break;
            }
            case 19: {
                color = SystemColor.inactiveCaptionText;
                break;
            }
            case 18: {
                color = SystemColor.inactiveCaption;
            }
        }
        return color;
    }

    @Override
    void drawLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        this.drawLabel(graphics, string, n, n2, bl, bl2, false, sWindowText);
    }

    @Override
    void drawButtonLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2) {
        this.drawLabel(graphics, string, n, n2, bl, bl2, false, sControlText);
    }

    private void drawLabel(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, Color color) {
        if (string != null) {
            if (bl2) {
                if (bl3) {
                    graphics.setColor(sTextHighlightText);
                } else {
                    graphics.setColor(color);
                }
                graphics.drawString(string, n, n2);
            } else {
                graphics.setColor(sControlLtHilite);
                graphics.setColor(sControlShadow);
                graphics.drawString(string, n, n2);
            }
        }
    }

    @Override
    void drawButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width - 1;
        int n2 = rectangle.height - 1;
        if (bl3) {
            int n3 = this.getSchemeConstant();
            Color[][] colorArray = new Color[4][5];
            colorArray[0][0] = sButtonA[n3];
            colorArray[0][1] = sButtonA[n3];
            colorArray[0][2] = sButtonB[n3];
            colorArray[0][3] = sButtonC[n3];
            colorArray[0][4] = sButtonC[n3];
            colorArray[1][0] = sButtonD[n3];
            colorArray[1][1] = sButtonH[n3];
            colorArray[1][2] = sButtonB[n3];
            colorArray[1][3] = sButtonA[n3];
            colorArray[1][4] = sButtonC[n3];
            colorArray[2][0] = sButtonG[n3];
            colorArray[2][1] = sButtonD[n3];
            colorArray[2][2] = sButtonE[n3];
            colorArray[2][3] = sButtonF[n3];
            colorArray[2][4] = sButtonA[n3];
            colorArray[3][0] = sButtonJ[n3];
            colorArray[3][1] = sButtonI[n3];
            colorArray[3][2] = sButtonE[n3];
            colorArray[3][3] = sButtonD[n3];
            colorArray[3][4] = sButtonD[n3];
            Color color = !bl ? new Color(239, 235, 231) : new Color(222, 214, 214);
            switch (n3) {
                case 1: {
                    color = !bl ? new Color(251, 250, 232) : new Color(222, 214, 214);
                    break;
                }
                case 2: {
                    color = !bl ? new Color(246, 247, 253) : new Color(222, 214, 214);
                }
            }
            Color color2 = new Color(247, 239, 206);
            Color color3 = new Color(247, 207, 115);
            Color color4 = new Color(247, 162, 16);
            Color color5 = new Color(231, 134, 0);
            graphics.setColor(sButtonY[n3]);
            graphics.drawLine(2, 0, n - 2, 0);
            graphics.setColor(sButtonX[n3]);
            graphics.drawLine(0, n2 - 2, 0, 2);
            graphics.drawLine(n, n2 - 2, n, 2);
            graphics.drawLine(2, n2, n - 2, n2);
            graphics.setColor(color);
            graphics.fillRect(1, 1, n - 1, n2 - 4);
            graphics.setColor(sButtonHm3[n3]);
            graphics.drawLine(1, n2 - 3, n - 1, n2 - 3);
            graphics.setColor(sButtonHm2[n3]);
            graphics.drawLine(1, n2 - 2, n - 1, n2 - 2);
            graphics.setColor(sButtonHm1[n3]);
            graphics.drawLine(1, n2 - 1, n - 1, n2 - 1);
            this.fillCorners(colorArray, n, n2, graphics);
            if (bl2 && !bl) {
                graphics.setColor(color2);
                graphics.drawLine(2, 1, n - 2, 1);
                graphics.setColor(color3);
                graphics.drawLine(1, 2, n - 1, 2);
                graphics.setColor(color4);
                graphics.drawLine(1, n2 - 2, n - 1, n2 - 2);
                graphics.setColor(color5);
                graphics.drawLine(2, n2 - 1, n - 2, n2 - 1);
                graphics.setColor(color3);
                graphics.drawLine(1, 3, 1, n2 - 3);
                graphics.drawLine(n - 1, 3, n - 1, n2 - 3);
                graphics.setColor(color4);
                graphics.drawLine(2, 3, 2, n2 - 3);
                graphics.drawLine(n - 2, 3, n - 2, n2 - 3);
            }
        } else {
            Color color = new Color(222, 215, 206);
            Color color6 = new Color(206, 203, 189);
            Color color7 = new Color(231, 227, 222);
            Color color8 = new Color(214, 207, 198);
            Color color9 = new Color(206, 203, 198);
            Color color10 = color7;
            Color color11 = new Color(231, 231, 222);
            Color color12 = color7;
            Color color13 = color7;
            Color color14 = color7;
            Color[][] colorArray = new Color[4][5];
            colorArray[0][0] = color;
            colorArray[0][1] = color;
            colorArray[0][2] = color6;
            colorArray[0][3] = color7;
            colorArray[0][4] = color7;
            colorArray[1][0] = color8;
            colorArray[1][1] = color12;
            colorArray[1][2] = color6;
            colorArray[1][3] = color;
            colorArray[1][4] = color7;
            colorArray[2][0] = color11;
            colorArray[2][1] = color8;
            colorArray[2][2] = color9;
            colorArray[2][3] = color10;
            colorArray[2][4] = color;
            colorArray[3][0] = color14;
            colorArray[3][1] = color13;
            colorArray[3][2] = color9;
            colorArray[3][3] = color8;
            colorArray[3][4] = color8;
            Color color15 = new Color(189, 186, 173);
            Color color16 = new Color(189, 182, 173);
            Color color17 = new Color(239, 235, 222);
            Color color18 = new Color(206, 199, 189);
            Color color19 = new Color(222, 215, 206);
            Color color20 = new Color(231, 227, 222);
            graphics.setColor(color16);
            graphics.drawLine(2, 0, n - 2, 0);
            graphics.setColor(color15);
            graphics.drawLine(0, n2 - 2, 0, 2);
            graphics.drawLine(n, n2 - 2, n, 2);
            graphics.drawLine(2, n2, n - 2, n2);
            graphics.setColor(color17);
            graphics.fillRect(1, 1, n - 1, n2 - 1);
            this.fillCorners(colorArray, n, n2, graphics);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private void fillCorners(Color[][] colorArray, int n, int n2, Graphics graphics) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 4; ++i) {
            if (i == 0) {
                n3 = 0;
                n4 = 0;
            } else if (i == 1) {
                n3 = n - 2;
                n4 = 0;
            } else if (i == 2) {
                n3 = 0;
                n4 = n2 - 2;
            } else {
                n3 = n - 2;
                n4 = n2 - 2;
            }
            graphics.setColor(colorArray[i][0]);
            graphics.drawLine(n3 + 1, n4, n3 + 1, n4);
            graphics.setColor(colorArray[i][1]);
            graphics.drawLine(n3, n4 + 1, n3, n4 + 1);
            graphics.setColor(colorArray[i][2]);
            graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 1);
            graphics.setColor(colorArray[i][3]);
            graphics.drawLine(n3 + 2, n4 + 1, n3 + 2, n4 + 1);
            graphics.setColor(colorArray[i][4]);
            graphics.drawLine(n3 + 1, n4 + 2, n3 + 1, n4 + 2);
        }
    }

    @Override
    void drawTBButtonBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        bl = bl || bl2;
        Color[] colorArray = bl ? sTBBBorderPressed : sTBBBorderHot;
        graphics.setColor(colorArray[0]);
        if (bl) {
            graphics.fillRect(1, 3, n - 2, n2 - 5);
        } else {
            graphics.fillRect(1, 1, n - 3, n2 - 4);
        }
        graphics.setColor(colorArray[1]);
        graphics.drawLine(3, 0, n - 4, 0);
        graphics.setColor(colorArray[7]);
        graphics.drawLine(1, 0, 1, 0);
        graphics.drawLine(n - 2, 0, n - 2, 0);
        graphics.setColor(colorArray[6]);
        graphics.drawLine(2, 0, 2, 0);
        graphics.drawLine(n - 3, 0, n - 3, 0);
        graphics.setColor(colorArray[7]);
        graphics.drawLine(0, 1, 0, 1);
        graphics.drawLine(n - 1, 1, n - 1, 1);
        graphics.setColor(colorArray[5]);
        graphics.drawLine(1, 1, 1, 1);
        graphics.drawLine(n - 2, 1, n - 2, 1);
        graphics.setColor(colorArray[8]);
        graphics.drawLine(2, 1, 2, 1);
        graphics.drawLine(n - 3, 1, n - 3, 1);
        if (bl) {
            graphics.setColor(colorArray[2]);
            graphics.drawLine(3, 1, n - 4, 1);
            graphics.setColor(colorArray[3]);
            graphics.drawLine(2, 2, n - 3, 2);
        }
        graphics.setColor(colorArray[6]);
        graphics.drawLine(0, 2, 0, 2);
        graphics.drawLine(n - 1, 2, n - 1, 2);
        graphics.setColor(colorArray[8]);
        graphics.drawLine(1, 2, 1, 2);
        graphics.drawLine(n - 2, 2, n - 2, 2);
        graphics.setColor(colorArray[1]);
        graphics.drawLine(0, 3, 0, n2 -= 4);
        graphics.drawLine(n - 1, 3, n - 1, n2);
        graphics.setColor(colorArray[2]);
        if (bl) {
            graphics.drawLine(1, 3, 1, n2);
        } else {
            graphics.drawLine(n - 2, 3, n - 2, n2);
            graphics.setColor(sTBBBorderHot[9]);
            graphics.drawLine(n - 3, 3, n - 3, n2);
        }
        ++n2;
        if (bl) {
            graphics.setColor(colorArray[6]);
            graphics.drawLine(0, n2, 0, n2);
            graphics.drawLine(n - 1, n2, n - 1, n2);
            graphics.setColor(colorArray[8]);
            graphics.drawLine(1, n2, 1, n2);
            graphics.drawLine(n - 2, n2, n - 2, n2);
        } else {
            graphics.setColor(colorArray[3]);
            graphics.drawLine(1, n2, n - 2, n2);
        }
        graphics.setColor(colorArray[7]);
        graphics.drawLine(0, ++n2, 0, n2);
        graphics.drawLine(n - 1, n2, n - 1, n2);
        graphics.setColor(colorArray[4]);
        if (bl) {
            graphics.drawLine(3, n2, n - 4, n2);
            graphics.setColor(colorArray[5]);
            graphics.drawLine(1, n2, 1, n2);
            graphics.drawLine(n - 2, n2, n - 2, n2);
            graphics.setColor(colorArray[8]);
            graphics.drawLine(2, n2, 2, n2);
            graphics.drawLine(n - 3, n2, n - 3, n2);
        } else {
            graphics.drawLine(1, n2, n - 2, n2);
        }
        graphics.setColor(colorArray[1]);
        graphics.drawLine(3, ++n2, n - 4, n2);
        graphics.setColor(colorArray[7]);
        graphics.drawLine(1, n2, 1, n2);
        graphics.drawLine(n - 2, n2, n - 2, n2);
        graphics.setColor(colorArray[6]);
        graphics.drawLine(2, n2, 2, n2);
        graphics.drawLine(n - 3, n2, n - 3, n2);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    MWImageResource[] drawButtonImage(MWImageResource[] mWImageResourceArray, Graphics graphics, MWImageResource mWImageResource, int n, int n2, boolean bl, boolean bl2) {
        MWImageResource[] mWImageResourceArray2 = mWImageResourceArray;
        if (mWImageResource != null) {
            if (bl) {
                graphics.drawImage(mWImageResource.getImage(), n + 1, n2 + 1, this);
            } else if (bl2) {
                graphics.drawImage(mWImageResource.getImage(), n, n2, this);
            } else {
                mWImageResourceArray2 = this.buildCache(mWImageResource, mWImageResourceArray2);
                graphics.drawImage(mWImageResourceArray2[0].getImage(), n + 1, n2 + 1, this);
                graphics.drawImage(mWImageResourceArray2[1].getImage(), n, n2, this);
            }
        }
        return mWImageResourceArray2;
    }

    @Override
    Image[] drawButtonImage(Image[] imageArray, Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        Image[] imageArray2 = imageArray;
        if (image != null) {
            if (bl) {
                graphics.drawImage(image, n + 1, n2 + 1, this);
            } else if (bl2) {
                graphics.drawImage(image, n, n2, this);
            } else {
                imageArray2 = this.buildCache(image, imageArray2);
                graphics.drawImage(imageArray2[0], n + 1, n2 + 1, this);
                graphics.drawImage(imageArray2[1], n, n2, this);
            }
        }
        return imageArray2;
    }

    private MWImageResource[] buildCache(MWImageResource mWImageResource, MWImageResource[] mWImageResourceArray) {
        FilteredImageSource filteredImageSource;
        if (mWImageResourceArray == null) {
            mWImageResourceArray = new MWImageResource[2];
        }
        if (mWImageResourceArray[0] == null) {
            filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(sControlLtHilite));
            mWImageResourceArray[0] = new MWImageResource(mWImageResource.getResourceName() + "0", filteredImageSource);
        }
        if (mWImageResourceArray[1] == null) {
            filteredImageSource = new FilteredImageSource(mWImageResource.getImage().getSource(), new HiliteFilter(sControlShadow));
            mWImageResourceArray[1] = new MWImageResource(mWImageResource.getResourceName() + "1", filteredImageSource);
        }
        return mWImageResourceArray;
    }

    private Image[] buildCache(Image image, Image[] imageArray) {
        FilteredImageSource filteredImageSource;
        if (imageArray == null) {
            imageArray = new Image[2];
        }
        if (imageArray[0] == null) {
            filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(sControlLtHilite));
            imageArray[0] = this.createImage(filteredImageSource);
            this.waitForImage(imageArray[0]);
        }
        if (imageArray[1] == null) {
            filteredImageSource = new FilteredImageSource(image.getSource(), new HiliteFilter(sControlShadow));
            imageArray[1] = this.createImage(filteredImageSource);
            this.waitForImage(imageArray[1]);
        }
        return imageArray;
    }

    @Override
    void drawButtonImage(Graphics graphics, Image image, int n, int n2, boolean bl, boolean bl2) {
        this.drawButtonImage(null, graphics, image, n, n2, bl, bl2);
    }

    private boolean waitForImage(Image image) {
        boolean bl = true;
        if (image != null) {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 2013);
            try {
                mediaTracker.waitForID(2013);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    int getChecksize() {
        return this.fChecksize;
    }

    @Override
    void drawCheckbox(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        graphics.translate(n, n2);
        if (bl4) {
            graphics.setColor(sCBRBBorderNormal);
        } else {
            graphics.setColor(sCBRBBorderDisabled);
        }
        graphics.drawLine(0, 0, this.fChecksize, 0);
        graphics.drawLine(0, 0, 0, this.fChecksize);
        graphics.drawLine(this.fChecksize, 0, this.fChecksize, this.fChecksize);
        graphics.drawLine(0, this.fChecksize, this.fChecksize, this.fChecksize);
        if (bl4) {
            if (sCheckboxImages == null) {
                ResLoader resLoader = new ResLoader((Component)this);
                sCheckboxImages = new Image[2];
                WindowsXPDecorations.sCheckboxImages[0] = resLoader.loadImage("resources/XPCheckboxNormal.gif");
                WindowsXPDecorations.sCheckboxImages[1] = resLoader.loadImage("resources/XPCheckboxPressed.gif");
                this.waitForImage(sCheckboxImages[0]);
                this.waitForImage(sCheckboxImages[1]);
            }
            if (bl) {
                graphics.drawImage(sCheckboxImages[1], 1, 1, this);
            } else {
                graphics.drawImage(sCheckboxImages[0], 1, 1, this);
            }
        } else {
            graphics.setColor(sCBRBInteriorDisabled);
            graphics.fillRect(1, 1, this.fChecksize - 1, this.fChecksize - 1);
        }
        if (bl5 && !bl) {
            int n3 = this.fChecksize - 2;
            graphics.setColor(sCBRBOrange);
            graphics.drawRect(1, 1, n3, n3);
            graphics.drawRect(2, 2, n3 -= 2, n3);
        }
        if (bl2 || bl3) {
            if (bl) {
                graphics.setColor(sCBRBCheckPressed);
            } else if (!bl4) {
                graphics.setColor(sCBRBCheckDisabled);
            } else {
                graphics.setColor(sCBRBCheckNormal);
            }
            if (bl2) {
                int n4 = this.fChecksize / 2;
                if (n4 * 2 != this.fChecksize) {
                    --n4;
                }
                int n5 = n4;
                int n6 = this.fChecksize - 3;
                int n7 = n5 - 3;
                int n8 = n6 - n7;
                graphics.drawLine(n5, n6, 3, n8);
                graphics.drawLine(n5, n6 - 1, 3, n8 - 1);
                graphics.drawLine(n5, n6 - 2, 3, n8 - 2);
                int n9 = this.fChecksize - 3 - n5;
                int n10 = n6 - n9;
                graphics.drawLine(n5, n6, this.fChecksize - 3, n10);
                graphics.drawLine(n5, n6 - 1, this.fChecksize - 3, n10 - 1);
                graphics.drawLine(n5, n6 - 2, this.fChecksize - 3, n10 - 2);
            } else {
                graphics.fillRect(3, 3, this.fChecksize - 3, this.fChecksize - 3);
            }
        }
        graphics.translate(-n, -n2);
    }

    @Override
    void drawRadiobutton(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (sRadioImages == null) {
            ResLoader resLoader = new ResLoader((Component)this);
            sRadioImages = new Image[8];
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_NORMAL] = resLoader.loadImage("resources/XPRadioNormal.gif");
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_HOT] = resLoader.loadImage("resources/XPRadioHot.gif");
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_PRESSED] = resLoader.loadImage("resources/XPRadioPressed.gif");
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_DISABLED] = resLoader.loadImage("resources/XPRadioDisabled.gif");
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_CHECKED] = resLoader.loadImage("resources/XPRadioChecked.gif");
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_CHECKED_HOT] = resLoader.loadImage("resources/XPRadioCheckedHot.gif");
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_CHECKED_PRESSED] = resLoader.loadImage("resources/XPRadioCheckedPressed.gif");
            WindowsXPDecorations.sRadioImages[WindowsXPDecorations.RADIO_CHECKED_DISABLED] = resLoader.loadImage("resources/XPRadioCheckedDisabled.gif");
            for (int i = 0; i < 8; ++i) {
                this.waitForImage(sRadioImages[i]);
            }
        }
        int n3 = bl4 ? (bl ? (bl2 || bl3 ? RADIO_CHECKED_PRESSED : RADIO_PRESSED) : (bl5 ? (bl2 || bl3 ? RADIO_CHECKED_HOT : RADIO_HOT) : (bl2 || bl3 ? RADIO_CHECKED : RADIO_NORMAL))) : (bl2 || bl3 ? RADIO_CHECKED_DISABLED : RADIO_DISABLED);
        graphics.drawImage(sRadioImages[n3], n, n2, this);
    }

    @Override
    void drawScrollTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2) {
        if (rectangle.isEmpty()) {
            return;
        }
        if (bl) {
            graphics.setColor(sScrollTrackPressedColors[this.getSchemeConstant()]);
        } else {
            graphics.setColor(sScrollTrackColors[this.getSchemeConstant()]);
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (n2 == 0) {
            if (n == 3) {
                graphics.setColor(sScrollTrackTopBevels[0][0]);
                graphics.drawLine(2, rectangle.y, rectangle.width - 3, rectangle.y);
            } else if (n == 1) {
                graphics.setColor(sScrollTrackTopBevels[0][0]);
                graphics.drawLine(2, rectangle.y - 1, rectangle.width - 3, rectangle.y - 1);
            } else if (n == 4) {
                graphics.setColor(Color.pink);
                graphics.drawLine(0, rectangle.y + rectangle.height, rectangle.width, rectangle.y + rectangle.height);
            }
        } else if (n == 3) {
            graphics.setColor(sScrollTrackTopBevels[0][0]);
            graphics.drawLine(rectangle.x, 2, rectangle.x, rectangle.height - 3);
        } else if (n == 1) {
            graphics.setColor(sScrollTrackTopBevels[0][0]);
            graphics.drawLine(rectangle.x - 1, 2, rectangle.x - 1, rectangle.height - 3);
        } else if (n == 4) {
            graphics.setColor(sScrollTrackTopBevels[0][0]);
            graphics.drawLine(rectangle.y + rectangle.height, 0, rectangle.x + rectangle.width, rectangle.height);
        }
    }

    @Override
    void drawScrollThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.setColor(sScrollbar);
        if (n == 0) {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height);
            rectangle.grow(-1, 0);
        } else {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.width, rectangle.y);
            rectangle.grow(0, -1);
        }
        this.drawScrollBevel(graphics, rectangle, bl, bl2, bl3, n == 0 ? 3 : 2);
        graphics.translate(rectangle.x, rectangle.y);
        int n2 = rectangle.width / 2;
        int n3 = rectangle.height / 2;
        int n4 = 0;
        int n5 = 0;
        if (bl) {
            n5 = 2;
        } else if (bl3) {
            n5 = 1;
        }
        if (!bl2) {
            n5 = 3;
        }
        n4 = this.getSchemeConstant();
        Color color = sScrollThumbLightColors[n4][n5];
        Color color2 = sScrollThumbDarkColors[n4][n5];
        if (n == 0) {
            int n6 = 5;
            int n7 = rectangle.width;
            if (PlatformInfo.getWindowsXPScheme() == 2) {
                --n7;
                n6 = 4;
            }
            if (rectangle.height > 10) {
                graphics.setColor(color);
                graphics.drawLine(n6, n3 - 3, n7 - 6, n3 - 3);
                graphics.drawLine(n6, n3 + 3, n7 - 6, n3 + 3);
                graphics.setColor(color2);
                graphics.drawLine(n6 + 1, n3 - 3 + 1, n7 - 6 + 1, n3 - 3 + 1);
                graphics.drawLine(n6 + 1, n3 + 3 + 1, n7 - 6 + 1, n3 + 3 + 1);
            }
            if (rectangle.height > 8) {
                graphics.setColor(color);
                graphics.drawLine(n6, n3 - 1, n7 - 6, n3 - 1);
                graphics.drawLine(n6, n3 + 1, n7 - 6, n3 + 1);
                graphics.setColor(color2);
                graphics.drawLine(n6 + 1, n3 - 1 + 1, n7 - 6 + 1, n3 - 1 + 1);
                graphics.drawLine(n6 + 1, n3 + 1 + 1, n7 - 6 + 1, n3 + 1 + 1);
            }
        } else {
            if (rectangle.width > 10) {
                graphics.setColor(color);
                graphics.drawLine(n2 - 3, 5, n2 - 3, rectangle.height - 6);
                graphics.drawLine(n2 + 3, 5, n2 + 3, rectangle.height - 6);
                graphics.setColor(color2);
                graphics.drawLine(n2 - 3 + 1, 6, n2 - 3 + 1, rectangle.height - 6 + 1);
                graphics.drawLine(n2 + 3 + 1, 6, n2 + 3 + 1, rectangle.height - 6 + 1);
            }
            if (rectangle.width > 8) {
                graphics.setColor(color);
                graphics.drawLine(n2 - 1, 5, n2 - 1, rectangle.height - 6);
                graphics.drawLine(n2 + 1, 5, n2 + 1, rectangle.height - 6);
                graphics.setColor(color2);
                graphics.drawLine(n2 - 1 + 1, 6, n2 - 1 + 1, rectangle.height - 6 + 1);
                graphics.drawLine(n2 + 1 + 1, 6, n2 + 1 + 1, rectangle.height - 6 + 1);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private int getSchemeConstant() {
        int n = 0;
        switch (PlatformInfo.getWindowsXPScheme()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
            }
        }
        return n;
    }

    @Override
    int sliderThumbLength() {
        return 11;
    }

    @Override
    void drawSliderThumb(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, boolean bl3) {
        Color color;
        Color color2;
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl4 = false;
        boolean bl5 = true;
        int n2 = rectangle.width;
        int n3 = rectangle.height - 2;
        Color color3 = color2 = new Color(181, 195, 206);
        Color color4 = new Color(140, 162, 173);
        Color color5 = new Color(107, 125, 132);
        Color color6 = new Color(115, 134, 148);
        Color color7 = sSliderThumbGreenColors[0][0];
        Color color8 = sSliderThumbGreenColors[0][1];
        Color color9 = color = sSliderThumbGreenColors[0][2];
        Color color10 = color7;
        Color color11 = new Color(74, 130, 90);
        Color color12 = sSliderThumbGreenColors[0][3];
        Color color13 = new Color(198, 190, 190);
        Color color14 = new Color(222, 219, 214);
        Color color15 = new Color(247, 243, 239);
        if (!bl2) {
            color3 = color2 = new Color(214, 207, 198);
            color4 = color2;
            color6 = color5 = new Color(189, 182, 165);
            color7 = color2;
            color8 = color2;
            color = color2;
            color9 = color15;
            color10 = color7;
            color11 = color5;
            color12 = color15;
            color13 = new Color(222, 223, 214);
            color14 = new Color(239, 235, 231);
        } else if (bl) {
            color7 = sSliderThumbGreenColors[1][0];
            color8 = sSliderThumbGreenColors[1][1];
            color9 = color = sSliderThumbGreenColors[1][2];
            color12 = sSliderThumbGreenColors[1][3];
        } else if (bl3) {
            color7 = sSliderThumbGreenColors[2][0];
            color8 = sSliderThumbGreenColors[2][1];
            color9 = color = sSliderThumbGreenColors[2][2];
            color12 = sSliderThumbGreenColors[2][3];
            color10 = new Color(189, 170, 123);
            color11 = new Color(140, 130, 99);
        }
        if (n == 0) {
            graphics.setColor(color15);
            graphics.fillRect(1, 2, 7, 14);
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(3 + i, 11 + i + 5, 7 - i, 11 + i + 5);
            }
            graphics.setColor(color2);
            graphics.drawLine(1, 0, 9, 0);
            graphics.setColor(color3);
            graphics.drawLine(0, 1, 0, 15);
            graphics.setColor(color4);
            graphics.drawLine(0, 15, 4, 19);
            graphics.setColor(color10);
            graphics.drawLine(1, 15, 4, 18);
            graphics.setColor(color9);
            graphics.drawLine(1, 14, 4, 17);
            graphics.setColor(color6);
            graphics.drawLine(10, 1, 10, 15);
            graphics.setColor(color5);
            graphics.drawLine(10, 15, 5, 20);
            graphics.setColor(color7);
            graphics.drawLine(1, 1, 9, 1);
            graphics.setColor(color8);
            graphics.drawLine(1, 2, 9, 2);
            graphics.setColor(color);
            graphics.drawLine(1, 3, 9, 3);
            graphics.setColor(color14);
            graphics.drawLine(8, 4, 8, 14);
            graphics.setColor(color13);
            graphics.drawLine(9, 4, 9, 14);
            graphics.setColor(color11);
            graphics.drawLine(9, 15, 5, 19);
            graphics.setColor(color12);
            graphics.drawLine(9, 14, 5, 18);
        } else {
            graphics.setColor(color15);
            graphics.fillRect(2, 1, 14, 7);
            for (int i = 0; i < 3; ++i) {
                graphics.drawLine(11 + i + 5, 3 + i, 11 + i + 5, 7 - i);
            }
            graphics.setColor(color2);
            graphics.drawLine(0, 1, 0, 9);
            graphics.setColor(color3);
            graphics.drawLine(1, 0, 15, 0);
            graphics.setColor(color4);
            graphics.drawLine(15, 0, 19, 4);
            graphics.setColor(color10);
            graphics.drawLine(15, 1, 18, 4);
            graphics.setColor(color9);
            graphics.drawLine(14, 1, 17, 4);
            graphics.setColor(color6);
            graphics.drawLine(1, 10, 15, 10);
            graphics.setColor(color5);
            graphics.drawLine(15, 10, 20, 5);
            graphics.setColor(color7);
            graphics.drawLine(1, 1, 1, 9);
            graphics.setColor(color8);
            graphics.drawLine(2, 1, 2, 9);
            graphics.setColor(color);
            graphics.drawLine(3, 1, 3, 9);
            graphics.setColor(color14);
            graphics.drawLine(4, 8, 14, 8);
            graphics.setColor(color13);
            graphics.drawLine(4, 9, 14, 9);
            graphics.setColor(color11);
            graphics.drawLine(15, 9, 19, 5);
            graphics.setColor(color12);
            graphics.drawLine(14, 9, 18, 5);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawSliderTrack(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        Color color;
        Color color2 = !PlatformInfo.useWindowsXPAppearance() ? this.getColor(9) : new Color(156, 156, 156);
        Color color3 = !PlatformInfo.useWindowsXPAppearance() ? this.getColor(10) : new Color(239, 239, 231);
        Color color4 = !PlatformInfo.useWindowsXPAppearance() ? this.getColor(8) : color3;
        Color color5 = color = !PlatformInfo.useWindowsXPAppearance() ? this.getColor(7) : Color.white;
        if (rectangle.isEmpty()) {
            return;
        }
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(Color.black);
        if (bl) {
            if (n == 2) {
                if (n2 == 0) {
                    graphics.setColor(color2);
                    graphics.drawLine(0, 7, rectangle.width - 1, 7);
                    graphics.setColor(color3);
                    graphics.drawLine(0, 8, rectangle.width - 1, 8);
                    graphics.setColor(color4);
                    graphics.drawLine(0, 9, rectangle.width - 1, 9);
                    graphics.setColor(color);
                    graphics.drawLine(0, 10, rectangle.width - 1, 10);
                } else {
                    graphics.setColor(color2);
                    graphics.drawLine(7, 0, 7, rectangle.height - 1);
                    graphics.setColor(color3);
                    graphics.drawLine(8, 0, 8, rectangle.height - 1);
                    graphics.setColor(color4);
                    graphics.drawLine(9, 0, 9, rectangle.height - 1);
                    graphics.setColor(color);
                    graphics.drawLine(10, 0, 10, rectangle.height - 1);
                }
            } else if (n2 == 0) {
                graphics.setColor(color2);
                graphics.drawLine(1, 7, rectangle.width, 7);
                graphics.setColor(color3);
                graphics.drawLine(1, 8, rectangle.width, 8);
                graphics.setColor(color4);
                graphics.drawLine(1, 9, rectangle.width, 9);
                graphics.setColor(color);
                graphics.drawLine(1, 10, rectangle.width, 10);
            } else {
                graphics.setColor(color2);
                graphics.drawLine(7, 1, 7, rectangle.height);
                graphics.setColor(color3);
                graphics.drawLine(8, 1, 8, rectangle.height);
                graphics.setColor(color4);
                graphics.drawLine(9, 1, 9, rectangle.height);
                graphics.setColor(color);
                graphics.drawLine(10, 1, 10, rectangle.height);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawScrollArrowButton(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        if (rectangle.isEmpty()) {
            return;
        }
        this.drawScrollBevel(graphics, rectangle, bl, bl2, bl3, 0);
        int n3 = n == 0 ? (n2 == 0 ? 0 : 2) : (n2 == 0 ? 1 : 3);
        this.drawScrollArrow(graphics, rectangle, n3, 0, bl2);
    }

    private void drawScrollBevel(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n) {
        int n2 = this.getSchemeConstant();
        int n3 = PlatformInfo.getWindowsXPScheme();
        int n4 = rectangle.height;
        int n5 = rectangle.width;
        graphics.translate(rectangle.x, rectangle.y);
        Color color = !bl2 ? sSBBDisabledFill[n2] : (bl ? sSBBPressedFill[n2] : (bl3 ? sSBBHotFill[n2] : sSBBNormalFill[n2]));
        graphics.setColor(color);
        graphics.fillRect(2, 2, n5 - 4, n4 - 4);
        Color color2 = !bl2 ? sSBBDisabledInnerBorders[n2] : (bl ? sSBBPressedInnerBorders[n2] : (bl3 ? sSBBHotInnerBorders[n2] : sSBBNormalInnerBorders[n2]));
        if (n3 == 2) {
            graphics.setColor(color2);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(0, 0, n5 - 1, 0);
        graphics.drawLine(n5 - 1, 0, n5 - 1, n4 - 1);
        graphics.drawLine(0, n4 - 1, n5 - 1, n4 - 1);
        if (n3 == 2 && bl2) {
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(color2);
        }
        graphics.drawLine(1, 1, 1, n4 - 2);
        graphics.drawLine(1, 1, n5 - 2, 1);
        graphics.drawLine(n5 - 2, 1, n5 - 2, n4 - 2);
        if (n3 == 2 && bl2) {
            graphics.setColor(color);
        }
        graphics.drawLine(1, n4 - 2, n5 - 2, n4 - 2);
        if (!bl2) {
            graphics.setColor(sSBBDisabledCornerPixel[n2]);
        } else if (bl) {
            graphics.setColor(sSBBPressedCornerPixel[n2]);
        } else if (bl3) {
            graphics.setColor(sSBBHotCornerPixel[n2]);
        } else {
            graphics.setColor(sSBBNormalCornerPixel[n2]);
        }
        graphics.drawLine(1, 1, 1, 1);
        graphics.drawLine(1, n4 - 2, 1, n4 - 2);
        graphics.drawLine(n5 - 2, 1, n5 - 2, 1);
        graphics.drawLine(n5 - 2, n4 - 2, n5 - 2, n4 - 2);
        if (n3 == 2) {
            graphics.drawLine(0, 0, 0, 0);
            if (n != 3) {
                graphics.drawLine(n5 - 1, 0, n5 - 1, 0);
            }
            if (n != 2) {
                graphics.drawLine(0, n4 - 1, 0, n4 - 1);
                if (n != 3) {
                    graphics.drawLine(n5 - 1, n4 - 1, n5 - 1, n4 - 1);
                }
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void drawScrollArrow(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (bl) {
            graphics.setColor(sSANormalArrow[this.getSchemeConstant()]);
        } else {
            graphics.setColor(sSADisabledArrow);
        }
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        graphics.translate(rectangle.x, rectangle.y);
        if (n == 1 || n == 3) {
            int n7 = n6 - 4;
            int n8 = n6;
            int n9 = n5 - 1;
            int n10 = n9 + 4;
            int n11 = n10 - 1;
            int n12 = n8;
            int n13 = n9;
            int n14 = n7 + 1;
            int n15 = n10 - 1;
            int n16 = n8 + 1;
            int n17 = n9 - 1;
            int n18 = n7 + 1;
            if (n == 1) {
                n10 = n4 - n10 - 1;
                n11 = n4 - n11 - 1;
                n15 = n4 - n15 - 1;
                n9 = n4 - n9 - 1;
                n13 = n4 - n13 - 1;
                n17 = n4 - n17 - 1;
            }
            graphics.drawLine(n10, n8, n9, n7);
            graphics.drawLine(n11, n12, n13, n14);
            graphics.drawLine(n15, n16, n17, n18);
            graphics.drawLine(n10, n4 - n8, n9, n4 - n7);
            graphics.drawLine(n11, n4 - n12, n13, n4 - n14);
            graphics.drawLine(n15, n4 - n16, n17, n4 - n18);
        } else {
            int n19;
            int n20 = Math.min(n4 < 12 ? 3 : 4, n4);
            int n21 = n4 < 12 ? 0 : 1;
            int n22 = n6 + 3;
            if (n4 < 12) {
                if (n == 0) {
                    ++n22;
                }
                if (n22 > n4 - 3) {
                    n22 = n4 - n22 + (n22 - n20);
                    n22 = n4 - (n22 + (n22 & 1)) / 2;
                    if (n == 0) {
                        n22 += 1 + (n4 & 1);
                    }
                }
            } else if (n == 0) {
                n22 = (n4 - 1) / 2 + 3;
            } else if (n22 > n4 - 4) {
                n22 = n4 - 4;
            }
            int n23 = n5 - n20;
            int n24 = n5;
            int n25 = n22 - n20;
            int n26 = n22 - 1;
            int n27 = n24;
            int n28 = n25;
            int n29 = n23 + 1;
            int n30 = n22 - 1;
            int n31 = n24 + 1;
            int n32 = n25 - n21;
            int n33 = n19 = n4 < 12 ? n29 + n21 : n23 + n21;
            if (n == 0) {
                n22 = n3 - n22 - 1;
                n26 = n3 - n26 - 1;
                n30 = n3 - n30 - 1;
                n25 = n3 - n25 - 1;
                n28 = n3 - n28 - 1;
                n32 = n3 - n32 - 1;
            }
            graphics.drawLine(n24, n22, n23, n25);
            graphics.drawLine(n27, n26, n29, n28);
            graphics.drawLine(n31, n30, n19, n32);
            int n34 = n3 & 1;
            graphics.drawLine(n3 - n24 - n34, n22, n3 - n23 - n34, n25);
            graphics.drawLine(n3 - n27 - n34, n26, n3 - n29 - n34, n28);
            graphics.drawLine(n3 - n31 - n34, n30, n3 - n19 - n34, n32);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawPopupControl(Graphics graphics, Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3) {
        this.drawPopupControl(graphics, rectangle, string, bl, bl2, bl3, false);
    }

    void drawPopupControl(Graphics graphics, Rectangle rectangle, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Rectangle rectangle2 = new Rectangle(n - n2 + 1, 1, n2 - 2, n2 - 2);
        if ((rectangle2.width & 1) == 0 && !PlatformInfo.useWindowsXPAppearance()) {
            ++rectangle2.y;
            --rectangle2.height;
        }
        graphics.translate(rectangle.x, rectangle.y);
        this.drawBevelFrame(graphics, 0, 0, n, n2);
        this.drawScrollArrowButton(graphics, rectangle2, bl, bl2, bl3, 0, 4);
        if (bl2) {
            if (bl4 || bl) {
                graphics.setColor(this.getColor(4));
            } else {
                graphics.setColor(this.getColor(2));
            }
        } else {
            graphics.setColor(this.getColor(6));
        }
        if (!PlatformInfo.useWindowsXPAppearance()) {
            graphics.fillRect(2, 2, rectangle2.x - 2, n2 - 4);
        } else {
            graphics.fillRect(1, 1, rectangle2.x - 1, n2 - 2);
        }
        if ((bl4 || bl) && bl2) {
            bl4 = true;
            graphics.setColor(this.getColor(2));
            graphics.drawRect(2, 2, rectangle2.x - 3, n2 - 5);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
        if (string != null) {
            graphics.setColor(sWindowText);
            string = this.shortenString(string, fontMetrics, rectangle.width - rectangle.height - 4);
            if (!PlatformInfo.useWindowsXPAppearance()) {
                this.drawLabel(graphics, string, rectangle.x + 4, rectangle.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 2, false, bl2, bl4, sWindowText);
            } else {
                this.drawLabel(graphics, string, rectangle.x + 3, rectangle.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 2 - 1, false, bl2, bl4, sWindowText);
            }
        }
    }

    @Override
    void drawComboControl(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        Rectangle rectangle2;
        graphics.translate(rectangle.x, rectangle.y);
        int n = rectangle.width;
        int n2 = rectangle.height;
        if (!PlatformInfo.isWindowsXP()) {
            rectangle2 = new Rectangle(n - n2 + 2, 2, n2 - 4, n2 - 4);
            if ((rectangle2.width & 1) != 0) {
                ++rectangle2.x;
                --rectangle2.width;
            }
        } else {
            rectangle2 = new Rectangle(n - n2 + 1, 1, n2 - 2, n2 - 2);
            if ((rectangle2.width & 1) == 0) {
                --rectangle2.x;
                ++rectangle2.width;
            }
        }
        this.drawBevelFrame(graphics, 0, 0, n, n2);
        this.drawScrollArrowButton(graphics, rectangle2, bl, bl2, bl3, 0, 4);
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    void drawBevelFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        graphics.setColor(sBevelBorder[this.getSchemeConstant()]);
        graphics.drawLine(0, 0, n3 - 1, 0);
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        graphics.translate(-n, -n2);
    }

    static {
        sSliderThumbGreenColors = new Color[3][4];
        sScrollThumbLightColors = new Color[3][4];
        sScrollThumbDarkColors = new Color[3][4];
        sScrollTrackTopBevels = new Color[3][4];
        sDisabledThumb = new Color(239, 235, 231);
        sDisabledThumbBevel = new Color(198, 195, 173);
        sScrollTrackColors = new Color[]{new Color(246, 245, 240), new Color(246, 245, 240), new Color(240, 241, 246)};
        sScrollTrackPressedColors = new Color[]{new Color(227, 222, 211), new Color(229, 222, 211), new Color(215, 216, 229)};
        sButtonA = new Color[]{new Color(107, 134, 165), new Color(117, 137, 91), new Color(120, 148, 169)};
        sButtonB = new Color[]{new Color(57, 101, 148), new Color(109, 138, 77), new Color(85, 125, 162)};
        sButtonC = new Color[]{new Color(181, 195, 214), new Color(229, 222, 180), new Color(192, 207, 121)};
        sButtonD = new Color[]{new Color(74, 109, 148), sButtonB[1], new Color(102, 134, 161)};
        sButtonE = new Color[]{new Color(41, 85, 132), new Color(97, 124, 66), new Color(74, 113, 147)};
        sButtonF = new Color[]{new Color(148, 158, 173), new Color(199, 178, 152), new Color(178, 189, 195)};
        sButtonG = new Color[]{new Color(181, 190, 198), new Color(215, 200, 189), new Color(191, 199, 202)};
        sButtonH = new Color[]{new Color(206, 215, 231), new Color(238, 235, 201), new Color(213, 223, 232)};
        sButtonI = new Color[]{new Color(165, 170, 173), new Color(201, 177, 164), sButtonG[2]};
        sButtonJ = new Color[]{new Color(173, 178, 165), new Color(205, 185, 170), new Color(198, 197, 215)};
        sButtonX = new Color[]{new Color(0, 20, 90), new Color(55, 98, 6), new Color(0, 60, 116)};
        sButtonY = new Color[]{new Color(2, 28, 99), sButtonX[1], sButtonX[2]};
        sButtonHm1 = new Color[]{new Color(206, 199, 189), new Color(227, 209, 184), new Color(198, 197, 215)};
        sButtonHm2 = new Color[]{new Color(222, 215, 206), new Color(236, 225, 201), new Color(210, 209, 228)};
        sButtonHm3 = new Color[]{new Color(231, 227, 222), new Color(243, 238, 219), new Color(222, 223, 236)};
        sSBBNormalFill = new Color[]{new Color(198, 211, 255), new Color(164, 180, 138), new Color(227, 227, 235)};
        sSBBPressedFill = new Color[]{new Color(161, 182, 239), new Color(153, 172, 124), new Color(217, 218, 228)};
        sSBBDisabledFill = new Color[]{new Color(239, 235, 231), new Color(239, 235, 231), new Color(239, 235, 231)};
        sSBBHotFill = new Color[]{new Color(214, 231, 255), new Color(198, 211, 155), new Color(236, 236, 241)};
        sSBBNormalInnerBorders = new Color[]{new Color(181, 199, 247), new Color(143, 161, 115), new Color(148, 149, 162)};
        sSBBPressedInnerBorders = new Color[]{new Color(148, 170, 122), new Color(127, 145, 102), new Color(67, 72, 72)};
        sSBBDisabledInnerBorders = new Color[]{new Color(231, 231, 222), new Color(231, 231, 222), new Color(231, 231, 222)};
        sSBBHotInnerBorders = new Color[]{new Color(172, 206, 255), new Color(218, 232, 235), new Color(91, 102, 101)};
        sSBBNormalCornerPixel = new Color[]{new Color(222, 227, 247), new Color(195, 200, 184), new Color(214, 214, 219)};
        sSBBPressedCornerPixel = new Color[]{new Color(181, 178, 214), new Color(155, 174, 226), new Color(196, 198, 210)};
        sSBBHotCornerPixel = new Color[]{new Color(222, 227, 247), new Color(207, 214, 190), new Color(214, 214, 219)};
        sSBBDisabledCornerPixel = sSBBDisabledFill;
        sSBBLeftmostOuterEdge = sSBBDisabledFill;
        sSANormalArrow = new Color[]{new Color(82, 101, 140), Color.white, new Color(63, 61, 61)};
        sSADisabledArrow = new Color(206, 203, 198);
        sBevelBorder = new Color[]{new Color(128, 154, 189), new Color(164, 185, 127), new Color(165, 172, 178)};
        sCBRBBorderNormal = new Color(0, 16, 90);
        sCBRBBorderDisabled = new Color(181, 178, 173);
        sCBRBInteriorNormal = new Color(247, 247, 247);
        sCBRBInteriorPressed = new Color(206, 203, 189);
        sCBRBInteriorDisabled = new Color(239, 235, 222);
        sCBRBOrange = new Color(247, 196, 61);
        sCBRBCheckNormal = new Color(34, 161, 34);
        sCBRBCheckPressed = new Color(0, 105, 0);
        sCBRBCheckDisabled = sCBRBBorderDisabled;
        sTBBBorderHot = new Color[10];
        sTBBBorderPressed = new Color[9];
        WindowsXPDecorations.sTBBBorderHot[0] = new Color(244, 244, 238);
        WindowsXPDecorations.sTBBBorderHot[1] = new Color(206, 206, 195);
        WindowsXPDecorations.sTBBBorderHot[2] = new Color(231, 231, 222);
        WindowsXPDecorations.sTBBBorderHot[3] = new Color(228, 225, 214);
        WindowsXPDecorations.sTBBBorderHot[4] = new Color(215, 210, 198);
        WindowsXPDecorations.sTBBBorderHot[5] = new Color(222, 222, 214);
        WindowsXPDecorations.sTBBBorderHot[6] = new Color(212, 212, 201);
        WindowsXPDecorations.sTBBBorderHot[7] = new Color(228, 228, 217);
        WindowsXPDecorations.sTBBBorderHot[8] = new Color(242, 242, 239);
        WindowsXPDecorations.sTBBBorderHot[9] = new Color(236, 236, 227);
        WindowsXPDecorations.sTBBBorderPressed[0] = new Color(225, 224, 216);
        WindowsXPDecorations.sTBBBorderPressed[1] = new Color(156, 156, 148);
        WindowsXPDecorations.sTBBBorderPressed[2] = new Color(220, 218, 209);
        WindowsXPDecorations.sTBBBorderPressed[3] = new Color(227, 225, 218);
        WindowsXPDecorations.sTBBBorderPressed[4] = new Color(235, 234, 229);
        WindowsXPDecorations.sTBBBorderPressed[5] = new Color(180, 180, 170);
        WindowsXPDecorations.sTBBBorderPressed[6] = new Color(171, 171, 160);
        WindowsXPDecorations.sTBBBorderPressed[7] = new Color(208, 208, 198);
        WindowsXPDecorations.sTBBBorderPressed[8] = new Color(214, 214, 202);
        WindowsXPDecorations.sSliderThumbGreenColors[0][0] = new Color(99, 203, 99);
        WindowsXPDecorations.sSliderThumbGreenColors[0][1] = new Color(74, 195, 74);
        WindowsXPDecorations.sSliderThumbGreenColors[0][2] = new Color(33, 182, 33);
        WindowsXPDecorations.sSliderThumbGreenColors[0][3] = new Color(24, 142, 24);
        WindowsXPDecorations.sSliderThumbGreenColors[1][0] = new Color(102, 182, 91);
        WindowsXPDecorations.sSliderThumbGreenColors[1][1] = new Color(72, 167, 59);
        WindowsXPDecorations.sSliderThumbGreenColors[1][2] = new Color(34, 149, 18);
        WindowsXPDecorations.sSliderThumbGreenColors[1][3] = new Color(27, 117, 14);
        WindowsXPDecorations.sSliderThumbGreenColors[2][0] = new Color(251, 203, 116);
        WindowsXPDecorations.sSliderThumbGreenColors[2][1] = new Color(250, 193, 88);
        WindowsXPDecorations.sSliderThumbGreenColors[2][2] = new Color(249, 180, 53);
        WindowsXPDecorations.sSliderThumbGreenColors[2][3] = new Color(196, 142, 42);
        WindowsXPDecorations.sScrollThumbLightColors[0][0] = new Color(239, 243, 255);
        WindowsXPDecorations.sScrollThumbLightColors[0][1] = new Color(255, 251, 255);
        WindowsXPDecorations.sScrollThumbLightColors[0][2] = new Color(206, 219, 255);
        WindowsXPDecorations.sScrollThumbLightColors[0][3] = sDisabledThumb;
        WindowsXPDecorations.sScrollThumbDarkColors[0][0] = new Color(140, 174, 247);
        WindowsXPDecorations.sScrollThumbDarkColors[0][1] = new Color(156, 195, 255);
        WindowsXPDecorations.sScrollThumbDarkColors[0][2] = new Color(132, 154, 222);
        WindowsXPDecorations.sScrollThumbDarkColors[0][3] = sDisabledThumb;
        WindowsXPDecorations.sScrollTrackTopBevels[0][0] = new Color(123, 158, 214);
        WindowsXPDecorations.sScrollTrackTopBevels[0][1] = new Color(99, 138, 206);
        WindowsXPDecorations.sScrollTrackTopBevels[0][2] = sScrollTrackTopBevels[0][0];
        WindowsXPDecorations.sScrollTrackTopBevels[0][3] = sDisabledThumbBevel;
        WindowsXPDecorations.sScrollThumbLightColors[1][0] = new Color(208, 223, 172);
        WindowsXPDecorations.sScrollThumbLightColors[1][1] = new Color(208, 223, 172);
        WindowsXPDecorations.sScrollThumbLightColors[1][2] = new Color(185, 208, 151);
        WindowsXPDecorations.sScrollThumbLightColors[1][3] = sDisabledThumb;
        WindowsXPDecorations.sScrollThumbDarkColors[1][0] = new Color(140, 157, 115);
        WindowsXPDecorations.sScrollThumbDarkColors[1][1] = new Color(140, 157, 115);
        WindowsXPDecorations.sScrollThumbDarkColors[1][2] = new Color(122, 139, 99);
        WindowsXPDecorations.sScrollThumbDarkColors[1][3] = sDisabledThumb;
        WindowsXPDecorations.sScrollTrackTopBevels[1][0] = new Color(131, 171, 90);
        WindowsXPDecorations.sScrollTrackTopBevels[1][1] = sScrollTrackTopBevels[1][0];
        WindowsXPDecorations.sScrollTrackTopBevels[1][2] = sScrollTrackTopBevels[1][0];
        WindowsXPDecorations.sScrollTrackTopBevels[1][3] = sDisabledThumbBevel;
        WindowsXPDecorations.sScrollThumbLightColors[2][0] = Color.white;
        WindowsXPDecorations.sScrollThumbLightColors[2][1] = sScrollThumbLightColors[2][0];
        WindowsXPDecorations.sScrollThumbLightColors[2][2] = sScrollThumbLightColors[2][0];
        WindowsXPDecorations.sScrollThumbLightColors[2][3] = sDisabledThumb;
        WindowsXPDecorations.sScrollThumbDarkColors[2][0] = new Color(142, 149, 162);
        WindowsXPDecorations.sScrollThumbDarkColors[2][1] = sScrollThumbDarkColors[2][0];
        WindowsXPDecorations.sScrollThumbDarkColors[2][2] = sScrollThumbDarkColors[2][0];
        WindowsXPDecorations.sScrollThumbDarkColors[2][3] = sDisabledThumb;
        WindowsXPDecorations.sScrollTrackTopBevels[2][0] = new Color(183, 183, 191);
        WindowsXPDecorations.sScrollTrackTopBevels[2][1] = new Color(183, 183, 191);
        WindowsXPDecorations.sScrollTrackTopBevels[2][2] = new Color(92, 102, 102);
        WindowsXPDecorations.sScrollTrackTopBevels[2][3] = sDisabledThumbBevel;
        boolean bl = PlatformInfo.getPlatform() == 1;
        sWindow = SystemColor.window;
        sWindowText = SystemColor.windowText;
        sDialog = SystemColor.control;
        sControl = SystemColor.control;
        sControlText = SystemColor.controlText;
        sControlLtHilite = SystemColor.controlLtHighlight;
        sControlHilite = SystemColor.controlHighlight;
        sControlShadow = SystemColor.controlShadow;
        sControlDkShadow = SystemColor.controlDkShadow;
        if (System.getProperty("os.name").indexOf("95") != -1) {
            sScrollbar = SystemColor.scrollbar;
        } else {
            int n = SystemColor.scrollbar.getRed();
            int n2 = SystemColor.scrollbar.getGreen();
            int n3 = SystemColor.scrollbar.getBlue();
            n += (255 - n) / 2;
            n2 += (255 - n2) / 2;
            n3 += (255 - n3) / 2;
            sScrollbar = new Color(n, n2, n3);
        }
        sTextHighlight = SystemColor.textHighlight;
        sTextHighlightText = SystemColor.textHighlightText;
        sText = SystemColor.window;
        sTextText = SystemColor.textText;
        sInactiveText = SystemColor.textInactiveText;
    }
}

